/*
 * Decompiled with CFR 0.152.
 */
package helma.objectmodel.db;

import helma.framework.core.Application;
import helma.framework.core.RequestEvaluator;
import helma.objectmodel.DatabaseException;
import helma.objectmodel.IDatabase;
import helma.objectmodel.ITransaction;
import helma.objectmodel.ObjectCache;
import helma.objectmodel.db.DbColumn;
import helma.objectmodel.db.DbKey;
import helma.objectmodel.db.DbMapping;
import helma.objectmodel.db.DbSource;
import helma.objectmodel.db.IDGenerator;
import helma.objectmodel.db.Key;
import helma.objectmodel.db.MultiKey;
import helma.objectmodel.db.Node;
import helma.objectmodel.db.NodeChangeListener;
import helma.objectmodel.db.NodeHandle;
import helma.objectmodel.db.Property;
import helma.objectmodel.db.Relation;
import helma.objectmodel.db.Replicator;
import helma.objectmodel.db.SubnodeList;
import helma.objectmodel.db.SyntheticKey;
import helma.objectmodel.db.Transactor;
import helma.objectmodel.db.UpdateableSubnodeList;
import helma.objectmodel.db.WrappedNodeManager;
import helma.objectmodel.dom.XmlDatabase;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigDecimal;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class NodeManager {
    protected Application app;
    private ObjectCache cache;
    protected IDatabase db;
    protected IDGenerator idgen;
    private boolean logSql;
    private Log sqlLog = null;
    protected boolean logReplication;
    private ArrayList listeners = new ArrayList();
    public final WrappedNodeManager safe;

    public NodeManager(Application app) {
        this.app = app;
        this.safe = new WrappedNodeManager(this);
    }

    public void init(File dbHome, Properties props) throws DatabaseException, ClassNotFoundException, IllegalAccessException, InstantiationException {
        String cacheImpl = props.getProperty("cacheimpl", "helma.util.CacheMap");
        this.cache = (ObjectCache)Class.forName(cacheImpl).newInstance();
        this.cache.init(this.app);
        String idgenImpl = props.getProperty("idGeneratorImpl");
        if (idgenImpl != null) {
            this.idgen = (IDGenerator)Class.forName(idgenImpl).newInstance();
            this.idgen.init(this.app);
        }
        this.logSql = "true".equalsIgnoreCase(props.getProperty("logsql"));
        this.logReplication = "true".equalsIgnoreCase(props.getProperty("logReplication"));
        String replicationUrl = props.getProperty("replicationUrl");
        if (replicationUrl != null) {
            if (this.logReplication) {
                this.app.logEvent("Setting up replication listener at " + replicationUrl);
            }
            Replicator replicator = new Replicator(this);
            replicator.addUrl(replicationUrl);
            this.addNodeChangeListener(replicator);
        }
        this.db = new XmlDatabase();
        this.db.init(dbHome, this.app);
    }

    public Node getRootNode() throws Exception {
        DbMapping rootMapping = this.app.getRootMapping();
        DbKey key = new DbKey(rootMapping, this.app.getRootId());
        Node node = this.getNode(key);
        if (node != null && rootMapping != null) {
            node.setDbMapping(rootMapping);
            node.setPrototype(rootMapping.getTypeName());
        }
        return node;
    }

    public boolean isRootNode(Node node) {
        return node.getState() != -3 && this.app.getRootId().equals(node.getID()) && DbMapping.areStorageCompatible(this.app.getRootMapping(), node.getDbMapping());
    }

    public void updateProperties(Properties props) {
        this.cache.updateProperties(props);
        this.logSql = "true".equalsIgnoreCase(props.getProperty("logsql"));
        this.logReplication = "true".equalsIgnoreCase(props.getProperty("logReplication"));
    }

    public void shutdown() throws DatabaseException {
        this.db.shutdown();
        if (this.cache != null) {
            this.cache.shutdown();
            this.cache = null;
        }
        if (this.idgen != null) {
            this.idgen.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteNode(Node node) throws Exception {
        if (node != null) {
            NodeManager nodeManager = this;
            synchronized (nodeManager) {
                Transactor tx = (Transactor)Thread.currentThread();
                node.setState(-1);
                this.deleteNode(this.db, tx.txn, node);
            }
        }
    }

    public Node getNode(Key key) throws Exception {
        Transactor tx = (Transactor)Thread.currentThread();
        Node node = tx.getVisitedNode(key);
        if (node != null && node.getState() != -1) {
            return node;
        }
        node = (Node)this.cache.get(key);
        if (node == null || node.getState() == -1) {
            if (key instanceof SyntheticKey) {
                Node parent = this.getNode(key.getParentKey());
                Relation rel = parent.dbmap.getPropertyRelation(key.getID());
                if (rel != null) {
                    return this.getNode(parent, key.getID(), rel);
                }
                return null;
            }
            if (key instanceof DbKey) {
                node = this.getNodeByKey(tx.txn, (DbKey)key);
            }
            if (node != null) {
                node = this.registerNewNode(node, null);
            }
        }
        if (node != null) {
            tx.visitCleanNode(key, node);
        }
        return node;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Node getNode(Node home, String kstr, Relation rel) throws Exception {
        Key key;
        DbMapping otherDbm;
        if (kstr == null) {
            return null;
        }
        Transactor tx = (Transactor)Thread.currentThread();
        DbMapping dbMapping = otherDbm = rel == null ? null : rel.otherType;
        if (rel.isComplexReference()) {
            key = new MultiKey(rel.otherType, rel.getKeyParts(home));
            otherDbm = this.app.getDbMapping(key.getStorageName());
        } else {
            if (!rel.createOnDemand()) {
                return null;
            }
            key = new SyntheticKey(home.getKey(), kstr);
        }
        Node node = tx.getVisitedNode(key);
        if (node != null && node.getState() != -1) {
            return node;
        }
        node = (Node)this.cache.get(key);
        if (node != null && node.getState() != -1) {
            if (node.isNullNode()) {
                if (node.created != home.getLastSubnodeChange(rel)) {
                    node = null;
                }
            } else if (!rel.virtual) {
                if (rel.groupby != null) {
                    if (home.contains(node) < 0) {
                        node = null;
                    }
                } else if (!rel.usesPrimaryKey() && !rel.checkConstraints(home, node)) {
                    node = null;
                }
            }
        }
        if (node == null || node.getState() == -1) {
            node = this.getNodeByRelation(tx.txn, home, kstr, rel, otherDbm);
            if (node == null) {
                ObjectCache objectCache = this.cache;
                synchronized (objectCache) {
                    this.cache.put(key, new Node(home.getLastSubnodeChange(rel)));
                    return null;
                }
            }
            Node newNode = node;
            if ((node = key.equals(node.getKey()) ? this.registerNewNode(node, null) : this.registerNewNode(node, key)) != newNode) {
                node.created = node.lastmodified;
            }
        } else {
            if (node.isNullNode()) {
                return null;
            }
            if (!rel.usesPrimaryKey()) {
                ObjectCache objectCache = this.cache;
                synchronized (objectCache) {
                    Node old = (Node)this.cache.put(node.getKey(), node);
                    if (old != node && old != null && !old.isNullNode() && old.getState() != -1) {
                        this.cache.put(node.getKey(), old);
                        this.cache.put(key, old);
                        node = old;
                    }
                }
            }
        }
        if (node != null) {
            tx.visitCleanNode(key, node);
        }
        return node;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Node registerNewNode(Node node, Key secondaryKey) {
        Key key = node.getKey();
        ObjectCache objectCache = this.cache;
        synchronized (objectCache) {
            Node old = (Node)this.cache.put(key, node);
            if (old != null && !old.isNullNode() && old.getState() != -1) {
                this.cache.put(key, old);
                if (secondaryKey != null) {
                    this.cache.put(secondaryKey, old);
                }
                return old;
            }
            if (secondaryKey != null) {
                this.cache.put(secondaryKey, node);
            }
        }
        try {
            RequestEvaluator reval = this.app.getCurrentRequestEvaluator();
            if (reval != null) {
                reval.invokeDirectFunction(node, "onInit", RequestEvaluator.EMPTY_ARGS);
            }
        }
        catch (Exception x) {
            this.app.logError("Error invoking onInit()", x);
        }
        return node;
    }

    public void registerNode(Node node) {
        this.cache.put(node.getKey(), node);
    }

    protected void registerNode(Node node, Key key) {
        this.cache.put(key, node);
    }

    public void evictNode(Node node) {
        node.setState(-1);
        this.cache.remove(node.getKey());
    }

    public void evictNodeByKey(Key key) {
        Node n = (Node)this.cache.remove(key);
        if (n != null) {
            n.setState(-1);
            if (!(key instanceof DbKey)) {
                this.cache.remove(n.getKey());
            }
        }
    }

    public void evictKey(Key key) {
        this.cache.remove(key);
    }

    public void insertNode(IDatabase db, ITransaction txn, Node node) throws IOException, SQLException, ClassNotFoundException {
        this.invokeOnPersist(node);
        DbMapping dbm = node.getDbMapping();
        if (dbm == null || !dbm.isRelational()) {
            db.insertNode(txn, node.getID(), node);
        } else {
            this.insertRelationalNode(node, dbm, dbm.getConnection());
        }
    }

    public void exportNode(Node node, DbSource dbs) throws SQLException, ClassNotFoundException {
        if (node == null) {
            throw new IllegalArgumentException("Node can't be null in exportNode");
        }
        DbMapping dbm = node.getDbMapping();
        if (dbs == null) {
            throw new IllegalArgumentException("DbSource can't be null in exportNode");
        }
        if (dbm == null || !dbm.isRelational()) {
            throw new IllegalArgumentException("Can't export into non-relational database");
        }
        this.insertRelationalNode(node, dbm, dbs.getConnection());
    }

    public void exportNode(Node node, DbMapping dbm) throws SQLException, ClassNotFoundException {
        if (node == null) {
            throw new IllegalArgumentException("Node can't be null in exportNode");
        }
        if (dbm == null) {
            throw new IllegalArgumentException("DbMapping can't be null in exportNode");
        }
        if (!dbm.isRelational()) {
            throw new IllegalArgumentException("Can't export into non-relational database");
        }
        this.insertRelationalNode(node, dbm, dbm.getConnection());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void insertRelationalNode(Node node, DbMapping dbm, Connection con) throws ClassNotFoundException, SQLException {
        if (con == null) {
            throw new NullPointerException("Error inserting relational node: Connection is null");
        }
        if (con.isReadOnly()) {
            con.setReadOnly(false);
        }
        String insertString = dbm.getInsert();
        PreparedStatement stmt = con.prepareStatement(insertString);
        DbColumn[] columns = dbm.getColumns();
        long logTimeStart = this.logSql ? System.currentTimeMillis() : 0L;
        try {
            int columnNumber = 1;
            for (int i = 0; i < columns.length; ++i) {
                DbColumn col = columns[i];
                if (!col.isMapped()) continue;
                if (col.isIdField()) {
                    this.setStatementValue(stmt, columnNumber, node.getID(), col);
                } else if (col.isPrototypeField()) {
                    this.setStatementValue(stmt, columnNumber, dbm.getExtensionId(), col);
                } else {
                    Property p;
                    Relation rel = col.getRelation();
                    Property property = p = rel == null ? null : node.getProperty(rel.getPropName());
                    if (p != null) {
                        this.setStatementValue(stmt, columnNumber, p, col.getType());
                    } else if (col.isNameField()) {
                        stmt.setString(columnNumber, node.getName());
                    } else {
                        stmt.setNull(columnNumber, col.getType());
                    }
                }
                ++columnNumber;
            }
            stmt.executeUpdate();
        }
        finally {
            if (this.logSql) {
                long logTimeStop = System.currentTimeMillis();
                this.logSqlStatement("SQL INSERT", dbm.getTableName(), logTimeStart, logTimeStop, insertString);
            }
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (Exception ignore) {}
            }
        }
    }

    private void invokeOnPersist(Node node) {
        try {
            RequestEvaluator reval = this.app.getCurrentRequestEvaluator();
            if (reval != null) {
                reval.invokeDirectFunction(node, "onPersist", RequestEvaluator.EMPTY_ARGS);
            }
        }
        catch (Exception x) {
            this.app.logError("Error invoking onPersist()", x);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean updateNode(IDatabase db, ITransaction txn, Node node) throws IOException, SQLException, ClassNotFoundException {
        Node parent;
        this.invokeOnPersist(node);
        DbMapping dbm = node.getDbMapping();
        boolean markMappingAsUpdated = false;
        if (dbm == null || !dbm.isRelational()) {
            db.updateNode(txn, node.getID(), node);
        } else {
            Property[] props;
            Hashtable propMap = node.getPropMap();
            if (propMap == null) {
                props = new Property[]{};
            } else {
                props = new Property[propMap.size()];
                propMap.values().toArray(props);
            }
            dbm.getColumns();
            StringBuffer b = dbm.getUpdate();
            boolean comma = false;
            for (int i = 0; i < props.length; ++i) {
                if (props[i] == null || !props[i].dirty) {
                    props[i] = null;
                    continue;
                }
                Relation rel = dbm.propertyToRelation(props[i].getName());
                if (rel == null || rel.readonly || rel.virtual || !rel.isPrimitiveOrReference()) {
                    props[i] = null;
                    continue;
                }
                if (comma) {
                    b.append(", ");
                } else {
                    comma = true;
                }
                b.append(rel.getDbField());
                b.append(" = ?");
            }
            if (!comma) {
                return false;
            }
            b.append(" WHERE ");
            dbm.appendCondition(b, dbm.getIDField(), node.getID());
            Connection con = dbm.getConnection();
            if (con.isReadOnly()) {
                con.setReadOnly(false);
            }
            PreparedStatement stmt = con.prepareStatement(b.toString());
            int stmtNumber = 0;
            long logTimeStart = this.logSql ? System.currentTimeMillis() : 0L;
            try {
                for (int i = 0; i < props.length; ++i) {
                    Property p = props[i];
                    if (p == null) continue;
                    Relation rel = dbm.propertyToRelation(p.getName());
                    this.setStatementValue(stmt, ++stmtNumber, p, rel.getColumnType());
                    p.dirty = false;
                    if (rel.isPrivate()) continue;
                    markMappingAsUpdated = true;
                }
                stmt.executeUpdate();
            }
            finally {
                if (this.logSql) {
                    long logTimeStop = System.currentTimeMillis();
                    this.logSqlStatement("SQL UPDATE", dbm.getTableName(), logTimeStart, logTimeStop, b.toString());
                }
                if (stmt != null) {
                    try {
                        stmt.close();
                    }
                    catch (Exception ignore) {}
                }
            }
        }
        if (markMappingAsUpdated && node.isAnonymous() && (parent = node.getCachedParent()) != null) {
            parent.markSubnodesChanged();
        }
        return markMappingAsUpdated;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteNode(IDatabase db, ITransaction txn, Node node) throws Exception {
        DbMapping dbm = node.getDbMapping();
        if (dbm == null || !dbm.isRelational()) {
            db.deleteNode(txn, node.getID());
        } else {
            Statement st = null;
            long logTimeStart = this.logSql ? System.currentTimeMillis() : 0L;
            String str = "DELETE FROM " + dbm.getTableName() + " WHERE " + dbm.getIDField() + " = " + node.getID();
            try {
                Connection con = dbm.getConnection();
                if (con.isReadOnly()) {
                    con.setReadOnly(false);
                }
                st = con.createStatement();
                st.executeUpdate(str);
            }
            finally {
                if (this.logSql) {
                    long logTimeStop = System.currentTimeMillis();
                    this.logSqlStatement("SQL DELETE", dbm.getTableName(), logTimeStart, logTimeStop, str);
                }
                if (st != null) {
                    try {
                        st.close();
                    }
                    catch (Exception ignore) {}
                }
            }
        }
        node.setState(-1);
    }

    public String generateID(DbMapping map) throws Exception {
        if (this.idgen != null) {
            return this.idgen.generateID(map);
        }
        return this.doGenerateID(map);
    }

    public String doGenerateID(DbMapping map) throws Exception {
        if (map == null || !map.isRelational()) {
            return this.generateEmbeddedID(map);
        }
        String idMethod = map.getIDgen();
        if (idMethod == null || "[max]".equalsIgnoreCase(idMethod) || map.isMySQL()) {
            return this.generateMaxID(map);
        }
        if ("[hop]".equalsIgnoreCase(idMethod)) {
            return this.generateEmbeddedID(map);
        }
        return this.generateSequenceID(map);
    }

    synchronized String generateEmbeddedID(DbMapping map) throws Exception {
        return this.db.nextID();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized String generateMaxID(DbMapping map) throws Exception {
        String retval = null;
        Statement stmt = null;
        long logTimeStart = this.logSql ? System.currentTimeMillis() : 0L;
        String q = "SELECT MAX(" + map.getIDField() + ") FROM " + map.getTableName();
        try {
            ResultSet rs;
            Connection con = map.getConnection();
            if (!con.isReadOnly()) {
                con.setReadOnly(true);
            }
            if (!(rs = (stmt = con.createStatement()).executeQuery(q)).next()) {
                long currMax = map.getNewID(0L);
                retval = Long.toString(currMax);
            } else {
                long currMax = rs.getLong(1);
                currMax = map.getNewID(currMax);
                retval = Long.toString(currMax);
            }
        }
        finally {
            if (this.logSql) {
                long logTimeStop = System.currentTimeMillis();
                this.logSqlStatement("SQL SELECT_MAX", map.getTableName(), logTimeStart, logTimeStop, q);
            }
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (Exception ignore) {}
            }
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String generateSequenceID(DbMapping map) throws Exception {
        String q;
        long logTimeStart;
        Statement stmt = null;
        String retval = null;
        long l = logTimeStart = this.logSql ? System.currentTimeMillis() : 0L;
        if (map.isOracle()) {
            q = "SELECT " + map.getIDgen() + ".nextval FROM dual";
        } else if (map.isPostgreSQL()) {
            q = "SELECT nextval('" + map.getIDgen() + "')";
        } else {
            throw new RuntimeException("Unable to generate sequence: unknown DB");
        }
        try {
            ResultSet rs;
            Connection con = map.getConnection();
            if (con.isReadOnly()) {
                con.setReadOnly(false);
            }
            if (!(rs = (stmt = con.createStatement()).executeQuery(q)).next()) {
                throw new SQLException("Error creating ID from Sequence: empty recordset");
            }
            retval = rs.getString(1);
        }
        finally {
            if (this.logSql) {
                long logTimeStop = System.currentTimeMillis();
                this.logSqlStatement("SQL SELECT_NEXTVAL", map.getTableName(), logTimeStart, logTimeStop, q);
            }
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (Exception ignore) {}
            }
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SubnodeList getNodeIDs(Node home, Relation rel) throws Exception {
        Statement stmt;
        SubnodeList retval;
        block15: {
            if (rel == null || rel.otherType == null || !rel.otherType.isRelational()) {
                throw new RuntimeException("NodeMgr.getNodeIDs called for non-relational node " + home);
            }
            retval = home.createSubnodeList();
            String idfield = rel.groupby == null ? rel.otherType.getIDField() : rel.groupby;
            Connection con = rel.otherType.getConnection();
            if (!con.isReadOnly()) {
                con.setReadOnly(true);
            }
            String table = rel.otherType.getTableName();
            stmt = null;
            long logTimeStart = this.logSql ? System.currentTimeMillis() : 0L;
            String query = null;
            try {
                Key k;
                StringBuffer b = new StringBuffer("SELECT ");
                if (rel.queryHints != null) {
                    b.append(rel.queryHints).append(" ");
                }
                if (idfield.indexOf(40) == -1 && idfield.indexOf(46) == -1) {
                    b.append(table).append('.');
                }
                b.append(idfield).append(" FROM ").append(table);
                rel.appendAdditionalTables(b);
                query = home.getSubnodeRelation() != null ? b.append(" ").append(home.getSubnodeRelation()).toString() : b.append(rel.buildQuery(home, home.getNonVirtualParent(), null, " WHERE ", true)).toString();
                stmt = con.createStatement();
                if (rel.maxSize > 0) {
                    stmt.setMaxRows(rel.maxSize);
                }
                ResultSet result = stmt.executeQuery(query);
                Key key = k = rel.groupby != null ? home.getKey() : null;
                while (result.next()) {
                    Node n;
                    String kstr = result.getString(1);
                    if (kstr == null) continue;
                    Key key2 = rel.groupby == null ? new DbKey(rel.otherType, kstr) : new SyntheticKey(k, kstr);
                    retval.addSorted(new NodeHandle(key2));
                    if (rel.groupby == null || (n = (Node)this.cache.get(key2)) == null || !n.isNullNode()) continue;
                    this.evictKey(key2);
                }
                if (!this.logSql) break block15;
            }
            catch (Throwable throwable) {
                if (this.logSql) {
                    long logTimeStop = System.currentTimeMillis();
                    this.logSqlStatement("SQL SELECT_IDS", table, logTimeStart, logTimeStop, query);
                }
                if (stmt != null) {
                    try {
                        stmt.close();
                    }
                    catch (Exception ignore) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
            long logTimeStop = System.currentTimeMillis();
            this.logSqlStatement("SQL SELECT_IDS", table, logTimeStart, logTimeStop, query);
        }
        if (stmt != null) {
            try {
                stmt.close();
            }
            catch (Exception ignore) {}
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SubnodeList getNodes(Node home, Relation rel) throws Exception {
        Statement stmt;
        SubnodeList retval;
        block16: {
            if (rel.groupby != null) {
                return this.getNodeIDs(home, rel);
            }
            if (rel == null || rel.otherType == null || !rel.otherType.isRelational()) {
                throw new RuntimeException("NodeMgr.getNodes called for non-relational node " + home);
            }
            retval = home.createSubnodeList();
            DbMapping dbm = rel.otherType;
            Connection con = dbm.getConnection();
            if (!con.isReadOnly()) {
                con.setReadOnly(true);
            }
            stmt = con.createStatement();
            DbColumn[] columns = dbm.getColumns();
            Relation[] joins = dbm.getJoins();
            String query = null;
            long logTimeStart = this.logSql ? System.currentTimeMillis() : 0L;
            try {
                StringBuffer b = dbm.getSelect(rel);
                if (home.getSubnodeRelation() != null) {
                    b.append(home.getSubnodeRelation());
                } else {
                    b.append(rel.buildQuery(home, home.getNonVirtualParent(), null, " WHERE ", true));
                }
                query = b.toString();
                if (rel.maxSize > 0) {
                    stmt.setMaxRows(rel.maxSize);
                }
                ResultSet rs = stmt.executeQuery(query);
                while (rs.next()) {
                    Node node = this.createNode(rel.otherType, rs, columns, 0);
                    if (node == null) continue;
                    Key primKey = node.getKey();
                    retval.addSorted(new NodeHandle(primKey));
                    this.registerNewNode(node, null);
                    this.fetchJoinedNodes(rs, joins, columns.length);
                }
                if (!this.logSql) break block16;
            }
            catch (Throwable throwable) {
                if (this.logSql) {
                    long logTimeStop = System.currentTimeMillis();
                    this.logSqlStatement("SQL SELECT_ALL", dbm.getTableName(), logTimeStart, logTimeStop, query);
                }
                if (stmt != null) {
                    try {
                        stmt.close();
                    }
                    catch (Exception ignore) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
            long logTimeStop = System.currentTimeMillis();
            this.logSqlStatement("SQL SELECT_ALL", dbm.getTableName(), logTimeStart, logTimeStop, query);
        }
        if (stmt != null) {
            try {
                stmt.close();
            }
            catch (Exception ignore) {}
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int updateSubnodeList(Node home, Relation rel) throws Exception {
        if (rel == null || rel.otherType == null || !rel.otherType.isRelational()) {
            throw new RuntimeException("NodeMgr.updateSubnodeList called for non-relational node " + home);
        }
        SubnodeList list = home.getSubnodeList();
        if (list == null) {
            list = home.createSubnodeList();
        }
        if (!(list instanceof UpdateableSubnodeList)) {
            throw new RuntimeException("unable to update SubnodeList not marked as updateable (" + rel.propName + ")");
        }
        UpdateableSubnodeList sublist = (UpdateableSubnodeList)list;
        if (rel.groupby != null) {
            throw new RuntimeException("update not yet supported on grouped collections");
        }
        String idfield = rel.otherType.getIDField();
        Connection con = rel.otherType.getConnection();
        String table = rel.otherType.getTableName();
        Statement stmt = null;
        try {
            String q = null;
            StringBuffer b = new StringBuffer();
            if (rel.loadAggressively()) {
                b.append(rel.otherType.getSelect(rel));
            } else {
                b.append("SELECT ");
                if (rel.queryHints != null) {
                    b.append(rel.queryHints).append(" ");
                }
                b.append(table).append('.').append(idfield).append(" FROM ").append(table);
                rel.appendAdditionalTables(b);
            }
            String updateCriteria = sublist.getUpdateCriteria();
            if (home.getSubnodeRelation() != null) {
                if (updateCriteria != null) {
                    b.append(" WHERE ");
                    b.append(sublist.getUpdateCriteria());
                    b.append(" AND ");
                    b.append(home.getSubnodeRelation());
                } else {
                    b.append(" WHERE ");
                    b.append(home.getSubnodeRelation());
                }
            } else {
                if (updateCriteria != null) {
                    b.append(" WHERE ");
                    b.append(updateCriteria);
                    b.append(rel.buildQuery(home, home.getNonVirtualParent(), null, " AND ", true));
                } else {
                    b.append(rel.buildQuery(home, home.getNonVirtualParent(), null, " WHERE ", true));
                }
                q = b.toString();
            }
            long logTimeStart = this.logSql ? System.currentTimeMillis() : 0L;
            stmt = con.createStatement();
            if (rel.maxSize > 0) {
                stmt.setMaxRows(rel.maxSize);
            }
            ResultSet result = stmt.executeQuery(q);
            if (this.logSql) {
                long logTimeStop = System.currentTimeMillis();
                this.logSqlStatement("SQL SELECT_UPDATE_SUBNODE_LIST", table, logTimeStart, logTimeStop, q);
            }
            DbColumn[] columns = rel.loadAggressively() ? rel.otherType.getColumns() : null;
            ArrayList<NodeHandle> newNodes = new ArrayList<NodeHandle>(rel.maxSize);
            while (result.next()) {
                Node n;
                Key key;
                String kstr = result.getString(1);
                if (kstr == null) continue;
                if (rel.loadAggressively()) {
                    Node node = this.createNode(rel.otherType, result, columns, 0);
                    if (node == null) continue;
                    key = node.getKey();
                    this.registerNewNode(node, null);
                } else {
                    key = new DbKey(rel.otherType, kstr);
                }
                newNodes.add(new NodeHandle(key));
                if (rel.groupby == null || (n = (Node)this.cache.get(key)) == null || !n.isNullNode()) continue;
                this.evictKey(key);
            }
            if (!newNodes.isEmpty()) {
                sublist.addAll(newNodes);
            }
            int n = newNodes.size();
            return n;
        }
        finally {
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (Exception ignore) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void prefetchNodes(Node home, Relation rel, Key[] keys) throws Exception {
        block30: {
            int missing;
            DbMapping dbm = rel.otherType;
            if (dbm != null && dbm.isRelational() && (missing = this.cache.containsKeys(keys)) > 0) {
                Statement stmt;
                block29: {
                    Connection con = dbm.getConnection();
                    if (!con.isReadOnly()) {
                        con.setReadOnly(true);
                    }
                    stmt = con.createStatement();
                    DbColumn[] columns = dbm.getColumns();
                    Relation[] joins = dbm.getJoins();
                    String query = null;
                    long logTimeStart = this.logSql ? System.currentTimeMillis() : 0L;
                    try {
                        StringBuffer b = dbm.getSelect(null).append(" WHERE ");
                        String idfield = rel.groupby != null ? rel.groupby : dbm.getIDField();
                        String[] ids = new String[missing];
                        int j = 0;
                        for (int k = 0; k < keys.length; ++k) {
                            if (keys[k] == null) continue;
                            ids[j++] = keys[k].getID();
                        }
                        dbm.appendCondition(b, idfield, ids);
                        dbm.addJoinConstraints(b, " AND ");
                        if (rel.groupby != null) {
                            rel.renderConstraints(b, home, home.getNonVirtualParent(), " AND ");
                            if (rel.order != null) {
                                b.append(" ORDER BY ");
                                b.append(rel.order);
                            }
                        }
                        query = b.toString();
                        ResultSet rs = stmt.executeQuery(query);
                        String groupbyProp = null;
                        HashMap<String, SubnodeList> groupbySubnodes = null;
                        if (rel.groupby != null) {
                            groupbyProp = dbm.columnNameToProperty(rel.groupby);
                            groupbySubnodes = new HashMap<String, SubnodeList>();
                        }
                        String accessProp = null;
                        if (rel.accessName != null && !rel.usesPrimaryKey()) {
                            accessProp = dbm.columnNameToProperty(rel.accessName);
                        }
                        while (rs.next()) {
                            String accessName;
                            Node node = this.createNode(dbm, rs, columns, 0);
                            if (node == null) continue;
                            Key key = node.getKey();
                            SyntheticKey secondaryKey = null;
                            String groupName = null;
                            if (groupbyProp != null) {
                                groupName = node.getString(groupbyProp);
                                SubnodeList sn = (SubnodeList)groupbySubnodes.get(groupName);
                                if (sn == null) {
                                    sn = new SubnodeList(this.safe, rel);
                                    groupbySubnodes.put(groupName, sn);
                                }
                                sn.addSorted(new NodeHandle(key));
                            }
                            if (accessProp != null && (accessName = node.getString(accessProp)) != null) {
                                if (groupName == null) {
                                    secondaryKey = new SyntheticKey(home.getKey(), accessName);
                                } else {
                                    SyntheticKey groupKey = new SyntheticKey(home.getKey(), groupName);
                                    secondaryKey = new SyntheticKey(groupKey, accessName);
                                }
                            }
                            this.registerNewNode(node, secondaryKey);
                            this.fetchJoinedNodes(rs, joins, columns.length);
                        }
                        if (groupbyProp != null) {
                            Iterator i = groupbySubnodes.keySet().iterator();
                            while (i.hasNext()) {
                                String groupname = (String)i.next();
                                if (groupname == null) continue;
                                Node groupnode = home.getGroupbySubnode(groupname, true);
                                groupnode.setSubnodes((SubnodeList)groupbySubnodes.get(groupname));
                                groupnode.lastSubnodeFetch = groupnode.getLastSubnodeChange(groupnode.dbmap.getSubnodeRelation());
                            }
                        }
                        if (!this.logSql) break block29;
                    }
                    catch (Exception x) {
                        this.app.logError("Error in prefetchNodes()", x);
                        break block30;
                    }
                    finally {
                        if (this.logSql) {
                            long logTimeStop = System.currentTimeMillis();
                            this.logSqlStatement("SQL SELECT_PREFETCH", dbm.getTableName(), logTimeStart, logTimeStop, query);
                        }
                        if (stmt != null) {
                            try {
                                stmt.close();
                            }
                            catch (Exception ignore) {}
                        }
                    }
                    long logTimeStop = System.currentTimeMillis();
                    this.logSqlStatement("SQL SELECT_PREFETCH", dbm.getTableName(), logTimeStart, logTimeStop, query);
                }
                if (stmt != null) {
                    try {
                        stmt.close();
                    }
                    catch (Exception ignore) {}
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int countNodes(Node home, Relation rel) throws Exception {
        Statement stmt;
        int retval;
        block11: {
            if (rel == null || rel.otherType == null || !rel.otherType.isRelational()) {
                throw new RuntimeException("NodeMgr.countNodes called for non-relational node " + home);
            }
            retval = 0;
            Connection con = rel.otherType.getConnection();
            if (!con.isReadOnly()) {
                con.setReadOnly(true);
            }
            String table = rel.otherType.getTableName();
            stmt = null;
            long logTimeStart = this.logSql ? System.currentTimeMillis() : 0L;
            String query = null;
            try {
                StringBuffer tables = new StringBuffer(table);
                rel.appendAdditionalTables(tables);
                StringBuffer b = new StringBuffer("SELECT count(*) FROM ").append(tables.toString());
                query = home.getSubnodeRelation() != null ? b.append(" ").append(home.getSubnodeRelation()).toString() : b.append(rel.buildQuery(home, home.getNonVirtualParent(), null, " WHERE ", false)).toString();
                stmt = con.createStatement();
                ResultSet rs = stmt.executeQuery(query);
                retval = !rs.next() ? 0 : rs.getInt(1);
                if (!this.logSql) break block11;
            }
            catch (Throwable throwable) {
                if (this.logSql) {
                    long logTimeStop = System.currentTimeMillis();
                    this.logSqlStatement("SQL SELECT_COUNT", table, logTimeStart, logTimeStop, query);
                }
                if (stmt != null) {
                    try {
                        stmt.close();
                    }
                    catch (Exception ignore) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
            long logTimeStop = System.currentTimeMillis();
            this.logSqlStatement("SQL SELECT_COUNT", table, logTimeStart, logTimeStop, query);
        }
        if (stmt != null) {
            try {
                stmt.close();
            }
            catch (Exception ignore) {}
        }
        return rel.maxSize > 0 ? Math.min(rel.maxSize, retval) : retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector getPropertyNames(Node home, Relation rel) throws Exception {
        Statement stmt;
        Vector<String> retval;
        block14: {
            if (rel == null || rel.otherType == null || !rel.otherType.isRelational()) {
                throw new RuntimeException("NodeMgr.getPropertyNames called for non-relational node " + home);
            }
            retval = new Vector<String>();
            String namefield = rel.groupby == null ? rel.accessName : rel.groupby;
            Connection con = rel.otherType.getConnection();
            if (!con.isReadOnly()) {
                con.setReadOnly(true);
            }
            String table = rel.otherType.getTableName();
            StringBuffer tables = new StringBuffer(table);
            rel.appendAdditionalTables(tables);
            stmt = null;
            long logTimeStart = this.logSql ? System.currentTimeMillis() : 0L;
            String query = null;
            try {
                StringBuffer b = new StringBuffer("SELECT ").append(namefield).append(" FROM ").append(tables.toString());
                if (home.getSubnodeRelation() != null) {
                    b.append(" ").append(home.getSubnodeRelation());
                } else {
                    b.append(rel.buildQuery(home, home.getNonVirtualParent(), null, " WHERE ", true));
                }
                stmt = con.createStatement();
                query = b.toString();
                ResultSet rs = stmt.executeQuery(query);
                while (rs.next()) {
                    String n = rs.getString(1);
                    if (n == null) continue;
                    retval.addElement(n);
                }
                if (!this.logSql) break block14;
            }
            catch (Throwable throwable) {
                if (this.logSql) {
                    long logTimeStop = System.currentTimeMillis();
                    this.logSqlStatement("SQL SELECT_ACCESSNAMES", table, logTimeStart, logTimeStop, query);
                }
                if (stmt != null) {
                    try {
                        stmt.close();
                    }
                    catch (Exception ignore) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
            long logTimeStop = System.currentTimeMillis();
            this.logSqlStatement("SQL SELECT_ACCESSNAMES", table, logTimeStart, logTimeStop, query);
        }
        if (stmt != null) {
            try {
                stmt.close();
            }
            catch (Exception ignore) {}
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Node getNodeByKey(ITransaction txn, DbKey key) throws Exception {
        Statement stmt;
        Node node;
        block15: {
            ResultSet rs;
            Relation[] joins;
            DbColumn[] columns;
            long logTimeStart;
            String query;
            DbMapping dbm;
            block13: {
                Node node2;
                block14: {
                    node = null;
                    dbm = this.app.getDbMapping(key.getStorageName());
                    String kstr = key.getID();
                    if (dbm == null || !dbm.isRelational()) {
                        node = (Node)this.db.getNode(txn, kstr);
                        node.nmgr = this.safe;
                        if (node == null || dbm == null) return node;
                        node.setDbMapping(dbm);
                        return node;
                    }
                    String idfield = dbm.getIDField();
                    stmt = null;
                    query = null;
                    logTimeStart = this.logSql ? System.currentTimeMillis() : 0L;
                    try {
                        Connection con = dbm.getConnection();
                        if (!con.isReadOnly()) {
                            con.setReadOnly(true);
                        }
                        stmt = con.createStatement();
                        columns = dbm.getColumns();
                        joins = dbm.getJoins();
                        StringBuffer b = dbm.getSelect(null).append("WHERE ");
                        dbm.appendCondition(b, idfield, kstr);
                        dbm.addJoinConstraints(b, " AND ");
                        query = b.toString();
                        rs = stmt.executeQuery(query);
                        if (rs.next()) break block13;
                        node2 = null;
                        if (!this.logSql) break block14;
                    }
                    catch (Throwable throwable) {
                        if (this.logSql) {
                            long logTimeStop = System.currentTimeMillis();
                            this.logSqlStatement("SQL SELECT_BYKEY", dbm.getTableName(), logTimeStart, logTimeStop, query);
                        }
                        if (stmt == null) throw throwable;
                        try {
                            stmt.close();
                            throw throwable;
                        }
                        catch (Exception ignore) {
                            // empty catch block
                        }
                        throw throwable;
                    }
                    long logTimeStop = System.currentTimeMillis();
                    this.logSqlStatement("SQL SELECT_BYKEY", dbm.getTableName(), logTimeStart, logTimeStop, query);
                }
                if (stmt == null) return node2;
                try {
                    stmt.close();
                    return node2;
                }
                catch (Exception ignore) {
                    // empty catch block
                }
                return node2;
            }
            node = this.createNode(dbm, rs, columns, 0);
            this.fetchJoinedNodes(rs, joins, columns.length);
            if (rs.next()) {
                this.app.logError("Warning: More than one value returned for query " + query);
            }
            if (!this.logSql) break block15;
            long logTimeStop = System.currentTimeMillis();
            this.logSqlStatement("SQL SELECT_BYKEY", dbm.getTableName(), logTimeStart, logTimeStop, query);
        }
        if (stmt == null) return node;
        try {
            stmt.close();
            return node;
        }
        catch (Exception ignore) {}
        return node;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Node getNodeByRelation(ITransaction txn, Node home, String kstr, Relation rel, DbMapping dbm) throws Exception {
        Statement stmt;
        Node node;
        block20: {
            ResultSet rs;
            Relation[] joins;
            DbColumn[] columns;
            long logTimeStart;
            String query;
            block18: {
                Node node2;
                block19: {
                    node = null;
                    if (rel != null && rel.virtual) {
                        node = rel.needsPersistence() ? (Node)home.createNode(kstr) : new Node(home, kstr, this.safe, rel.prototype);
                        node.setPrototype(rel.prototype);
                        node.setDbMapping(rel.getVirtualMapping());
                        return node;
                    }
                    if (rel != null && rel.groupby != null) {
                        node = home.getGroupbySubnode(kstr, false);
                        if (node != null || dbm != null && dbm.isRelational()) return node;
                        node = (Node)this.db.getNode(txn, kstr);
                        node.nmgr = this.safe;
                        return node;
                    }
                    if (rel == null || dbm == null || !dbm.isRelational()) {
                        node = (Node)this.db.getNode(txn, kstr);
                        node.nmgr = this.safe;
                        node.setDbMapping(dbm);
                        return node;
                    }
                    stmt = null;
                    query = null;
                    logTimeStart = this.logSql ? System.currentTimeMillis() : 0L;
                    try {
                        Connection con = dbm.getConnection();
                        if (!con.isReadOnly()) {
                            con.setReadOnly(true);
                        }
                        columns = dbm.getColumns();
                        joins = dbm.getJoins();
                        StringBuffer b = dbm.getSelect(rel);
                        if (home.getSubnodeRelation() != null && !rel.isComplexReference()) {
                            b.append(" WHERE ");
                            dbm.appendCondition(b, rel.accessName, kstr);
                            dbm.addJoinConstraints(b, " AND ");
                            String subrel = home.getSubnodeRelation().trim();
                            if (subrel.length() > 5) {
                                b.append(" AND (");
                                b.append(subrel.substring(5).trim());
                                b.append(")");
                            }
                        } else {
                            b.append(rel.buildQuery(home, home.getNonVirtualParent(), dbm, kstr, " WHERE ", false));
                        }
                        stmt = con.createStatement();
                        query = b.toString();
                        rs = stmt.executeQuery(query);
                        if (rs.next()) break block18;
                        node2 = null;
                        if (!this.logSql) break block19;
                    }
                    catch (Throwable throwable) {
                        if (this.logSql) {
                            long logTimeStop = System.currentTimeMillis();
                            this.logSqlStatement("SQL SELECT_BYRELATION", dbm.getTableName(), logTimeStart, logTimeStop, query);
                        }
                        if (stmt == null) throw throwable;
                        try {
                            stmt.close();
                            throw throwable;
                        }
                        catch (Exception ignore) {
                            // empty catch block
                        }
                        throw throwable;
                    }
                    long logTimeStop = System.currentTimeMillis();
                    this.logSqlStatement("SQL SELECT_BYRELATION", dbm.getTableName(), logTimeStart, logTimeStop, query);
                }
                if (stmt == null) return node2;
                try {
                    stmt.close();
                    return node2;
                }
                catch (Exception ignore) {
                    // empty catch block
                }
                return node2;
            }
            node = this.createNode(dbm, rs, columns, 0);
            this.fetchJoinedNodes(rs, joins, columns.length);
            if (rs.next()) {
                this.app.logError("Warning: More than one value returned for query " + query);
            }
            if (!this.logSql) break block20;
            long logTimeStop = System.currentTimeMillis();
            this.logSqlStatement("SQL SELECT_BYRELATION", dbm.getTableName(), logTimeStart, logTimeStop, query);
        }
        if (stmt == null) return node;
        try {
            stmt.close();
            return node;
        }
        catch (Exception ignore) {}
        return node;
    }

    public Node createNode(DbMapping dbm, ResultSet rs, DbColumn[] columns, int offset) throws SQLException, IOException, ClassNotFoundException {
        HashMap<String, Property> propBuffer = new HashMap<String, Property>();
        String id = null;
        String name = null;
        String protoName = dbm.getTypeName();
        DbMapping dbmap = dbm;
        Node node = new Node();
        for (int i = 0; i < columns.length; ++i) {
            String protoId;
            int columnNumber = i + 1 + offset;
            if (columns[i].isPrototypeField() && (protoName = dbm.getPrototypeName(protoId = rs.getString(columnNumber))) != null && (dbmap = this.getDbMapping(protoName)) == null) {
                this.app.logError("No prototype defined for prototype mapping \"" + protoName + "\" - Using default prototype \"" + dbm.getTypeName() + "\".");
                dbmap = dbm;
                protoName = dbmap.getTypeName();
            }
            if (columns[i].isIdField() && (id = rs.getString(columnNumber)) == null) {
                return null;
            }
            if (columns[i].isNameField()) {
                name = rs.getString(columnNumber);
            }
            Property newprop = new Property(node);
            switch (columns[i].getType()) {
                case -7: {
                    newprop.setBooleanValue(rs.getBoolean(columnNumber));
                    break;
                }
                case -6: 
                case -5: 
                case 4: 
                case 5: {
                    newprop.setIntegerValue(rs.getLong(columnNumber));
                    break;
                }
                case 6: 
                case 7: 
                case 8: {
                    newprop.setFloatValue(rs.getDouble(columnNumber));
                    break;
                }
                case 2: 
                case 3: {
                    BigDecimal num = rs.getBigDecimal(columnNumber);
                    if (num == null) break;
                    if (num.scale() > 0) {
                        newprop.setFloatValue(num.doubleValue());
                        break;
                    }
                    newprop.setIntegerValue(num.longValue());
                    break;
                }
                case -3: 
                case -2: {
                    newprop.setJavaObjectValue(rs.getBytes(columnNumber));
                    break;
                }
                case -4: 
                case 2004: {
                    int read;
                    InputStream in = rs.getBinaryStream(columnNumber);
                    if (in == null) break;
                    ByteArrayOutputStream bout = new ByteArrayOutputStream();
                    byte[] buffer = new byte[2048];
                    while ((read = in.read(buffer)) > -1) {
                        bout.write(buffer, 0, read);
                    }
                    newprop.setJavaObjectValue(bout.toByteArray());
                    break;
                }
                case -1: {
                    try {
                        newprop.setStringValue(rs.getString(columnNumber));
                    }
                    catch (SQLException x) {
                        int read;
                        Reader in = rs.getCharacterStream(columnNumber);
                        if (in == null) {
                            newprop.setStringValue(null);
                            break;
                        }
                        StringBuffer out = new StringBuffer();
                        char[] buffer = new char[2048];
                        while ((read = in.read(buffer)) > -1) {
                            out.append(buffer, 0, read);
                        }
                        newprop.setStringValue(out.toString());
                    }
                    break;
                }
                case 1: 
                case 12: 
                case 1111: {
                    newprop.setStringValue(rs.getString(columnNumber));
                    break;
                }
                case 91: 
                case 92: 
                case 93: {
                    newprop.setDateValue(rs.getTimestamp(columnNumber));
                    break;
                }
                case 0: {
                    newprop.setStringValue(null);
                    break;
                }
                case 2005: {
                    Clob cl = rs.getClob(columnNumber);
                    if (cl == null) {
                        newprop.setStringValue(null);
                        break;
                    }
                    char[] c = new char[(int)cl.length()];
                    Reader isr = cl.getCharacterStream();
                    isr.read(c);
                    newprop.setStringValue(String.copyValueOf(c));
                    break;
                }
                default: {
                    newprop.setStringValue(rs.getString(columnNumber));
                }
            }
            if (rs.wasNull()) {
                newprop.setStringValue(null);
            }
            propBuffer.put(columns[i].getName(), newprop);
            newprop.dirty = false;
        }
        if (id == null) {
            return null;
        }
        Hashtable<String, Property> propMap = new Hashtable<String, Property>();
        DbColumn[] columns2 = dbmap.getColumns();
        for (int i = 0; i < columns2.length; ++i) {
            Property prop;
            Relation rel = columns2[i].getRelation();
            if (rel == null || !rel.isPrimitiveOrReference() || (prop = (Property)propBuffer.get(columns2[i].getName())) == null) continue;
            prop.setName(rel.propName);
            if (rel.isReference() && rel.usesPrimaryKey()) {
                prop.convertToNodeReference(rel.otherType);
            }
            propMap.put(rel.propName.toLowerCase(), prop);
        }
        node.init(dbmap, id, name, protoName, propMap, this.safe);
        return node;
    }

    private void fetchJoinedNodes(ResultSet rs, Relation[] joins, int offset) throws ClassNotFoundException, SQLException, IOException {
        int resultSetOffset = offset;
        for (int i = 0; i < joins.length; ++i) {
            DbMapping jdbm = joins[i].otherType;
            Node node = this.createNode(jdbm, rs, jdbm.getColumns(), resultSetOffset);
            if (node != null) {
                this.registerNewNode(node, null);
            }
            resultSetOffset += jdbm.getColumns().length;
        }
    }

    public DbMapping getDbMapping(String protoname) {
        return this.app.getDbMapping(protoname);
    }

    public Object[] getCacheEntries() {
        return this.cache.getCachedObjects();
    }

    public int countCacheEntries() {
        return this.cache.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearCache() {
        ObjectCache objectCache = this.cache;
        synchronized (objectCache) {
            this.cache.clear();
        }
    }

    public void addNodeChangeListener(NodeChangeListener listener) {
        this.listeners.add(listener);
    }

    public void removeNodeChangeListener(NodeChangeListener listener) {
        this.listeners.remove(listener);
    }

    protected boolean hasNodeChangeListeners() {
        return this.listeners.size() > 0;
    }

    protected void fireNodeChangeEvent(List inserted, List updated, List deleted, List parents) {
        int l = this.listeners.size();
        for (int i = 0; i < l; ++i) {
            try {
                ((NodeChangeListener)this.listeners.get(i)).nodesChanged(inserted, updated, deleted, parents);
                continue;
            }
            catch (Error e) {
                e.printStackTrace();
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replicateCache(Vector add, Vector delete) {
        if (this.logReplication) {
            this.app.logEvent("Received cache replication event: " + add.size() + " added, " + delete.size() + " deleted");
        }
        ObjectCache objectCache = this.cache;
        synchronized (objectCache) {
            Node oldNode;
            DbMapping dbm;
            Node n;
            Enumeration en = add.elements();
            while (en.hasMoreElements()) {
                n = (Node)en.nextElement();
                dbm = this.app.getDbMapping(n.getPrototype());
                if (dbm != null) {
                    dbm.setLastDataChange();
                }
                n.setDbMapping(dbm);
                n.nmgr = this.safe;
                if (dbm != null && dbm.evictOnReplication()) {
                    oldNode = (Node)this.cache.get(n.getKey());
                    if (oldNode == null) continue;
                    this.evictNode(oldNode);
                    continue;
                }
                n.lastParentSet = -1L;
                this.cache.put(n.getKey(), n);
            }
            en = delete.elements();
            while (en.hasMoreElements()) {
                n = (Node)en.nextElement();
                dbm = this.app.getDbMapping(n.getPrototype());
                if (dbm != null) {
                    dbm.setLastDataChange();
                }
                n.setDbMapping(dbm);
                n.nmgr = this.safe;
                oldNode = (Node)this.cache.get(n.getKey());
                if (oldNode == null) continue;
                this.evictNode(oldNode);
            }
        }
    }

    private void setStatementValue(PreparedStatement stmt, int columnNumber, String value, DbColumn col) throws SQLException {
        if (value == null) {
            stmt.setNull(columnNumber, col.getType());
        } else if (col.needsQuotes()) {
            stmt.setString(columnNumber, value);
        } else {
            stmt.setLong(columnNumber, Long.parseLong(value));
        }
    }

    private void setStatementValue(PreparedStatement stmt, int stmtNumber, Property p, int columnType) throws SQLException {
        if (p.getValue() == null) {
            stmt.setNull(stmtNumber, columnType);
        } else {
            switch (columnType) {
                case -7: 
                case -6: 
                case -5: 
                case 4: 
                case 5: {
                    stmt.setLong(stmtNumber, p.getIntegerValue());
                    break;
                }
                case 2: 
                case 3: 
                case 6: 
                case 7: 
                case 8: {
                    stmt.setDouble(stmtNumber, p.getFloatValue());
                    break;
                }
                case -4: 
                case -3: 
                case -2: 
                case 2004: {
                    Object b = p.getJavaObjectValue();
                    if (b instanceof byte[]) {
                        byte[] buf = (byte[])b;
                        try {
                            stmt.setBytes(stmtNumber, buf);
                        }
                        catch (SQLException x) {
                            ByteArrayInputStream bout = new ByteArrayInputStream(buf);
                            stmt.setBinaryStream(stmtNumber, (InputStream)bout, buf.length);
                        }
                        break;
                    }
                    throw new SQLException("expected byte[] for binary column '" + p.getName() + "', found " + b.getClass());
                }
                case -1: {
                    try {
                        stmt.setString(stmtNumber, p.getStringValue());
                    }
                    catch (SQLException x) {
                        String str = p.getStringValue();
                        StringReader r = new StringReader(str);
                        stmt.setCharacterStream(stmtNumber, (Reader)r, str.length());
                    }
                    break;
                }
                case 2005: {
                    String val = p.getStringValue();
                    StringReader isr = new StringReader(val);
                    stmt.setCharacterStream(stmtNumber, (Reader)isr, val.length());
                    break;
                }
                case 1: 
                case 12: 
                case 1111: {
                    stmt.setString(stmtNumber, p.getStringValue());
                    break;
                }
                case 91: 
                case 92: 
                case 93: {
                    stmt.setTimestamp(stmtNumber, p.getTimestampValue());
                    break;
                }
                case 0: {
                    stmt.setNull(stmtNumber, 0);
                    break;
                }
                default: {
                    stmt.setString(stmtNumber, p.getStringValue());
                }
            }
        }
    }

    private void logSqlStatement(String type, String table, long logTimeStart, long logTimeStop, String statement) {
        if (this.sqlLog == null) {
            String sqlLogName = this.app.getProperty("sqlLog", "helma." + this.app.getName() + ".sql");
            this.sqlLog = LogFactory.getLog((String)sqlLogName);
        }
        this.sqlLog.info((Object)(type + " " + table + " " + (logTimeStop - logTimeStart) + ": " + statement));
    }
}

