/*
 * Decompiled with CFR 0.152.
 */
package helma.objectmodel.db;

import helma.objectmodel.INodeState;
import helma.objectmodel.db.Key;
import helma.objectmodel.db.Node;
import helma.objectmodel.db.WrappedNodeManager;
import java.io.Serializable;

public final class NodeHandle
implements INodeState,
Serializable {
    static final long serialVersionUID = 3067763116576910931L;
    private Node node;
    private Key key;

    public NodeHandle(Node node) {
        int state = node.getState();
        if (state == -3) {
            this.node = node;
            this.key = null;
        } else {
            this.node = null;
            this.key = node.getKey();
        }
    }

    public NodeHandle(Key key) {
        this.node = null;
        this.key = key;
    }

    public Node getNode(WrappedNodeManager nodemgr) {
        if (this.node != null) {
            return this.node;
        }
        return nodemgr.getNode(this.key);
    }

    public Key getKey() {
        if (this.key == null) {
            throw new RuntimeException("getKey called on transient Node");
        }
        return this.key;
    }

    public String getID() {
        if (this.key == null) {
            return this.node.getID();
        }
        return this.key.getID();
    }

    private Object getObject() {
        if (this.node != null) {
            return this.node;
        }
        return this.key;
    }

    public boolean equals(Object other) {
        try {
            return this.getObject().equals(((NodeHandle)other).getObject());
        }
        catch (Exception x) {
            return false;
        }
    }

    protected void becomePersistent() {
        if (this.node != null) {
            this.key = this.node.getKey();
            this.node = null;
        }
    }

    public String toString() {
        if (this.node != null) {
            return "NodeHandle[transient:" + this.node + "]";
        }
        return "NodeHandle[" + this.key + "]";
    }
}

