/*
 * Decompiled with CFR 0.152.
 */
package helma.objectmodel.db;

import helma.framework.IPathElement;
import helma.framework.TimeoutException;
import helma.framework.core.Application;
import helma.framework.core.RequestEvaluator;
import helma.objectmodel.ConcurrencyException;
import helma.objectmodel.INode;
import helma.objectmodel.IProperty;
import helma.objectmodel.TransientNode;
import helma.objectmodel.db.DbKey;
import helma.objectmodel.db.DbMapping;
import helma.objectmodel.db.Key;
import helma.objectmodel.db.MultiKey;
import helma.objectmodel.db.NodeHandle;
import helma.objectmodel.db.OrderedSubnodeList;
import helma.objectmodel.db.ParentInfo;
import helma.objectmodel.db.Property;
import helma.objectmodel.db.Relation;
import helma.objectmodel.db.SubnodeList;
import helma.objectmodel.db.SyntheticKey;
import helma.objectmodel.db.Transactor;
import helma.objectmodel.db.UpdateableSubnodeList;
import helma.objectmodel.db.WrappedNodeManager;
import helma.util.EmptyEnumeration;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public final class Node
implements INode,
Serializable {
    static final long serialVersionUID = -3740339688506633675L;
    protected NodeHandle parentHandle;
    private SubnodeList subnodes;
    private Hashtable propMap;
    protected long created;
    protected long lastmodified;
    private String id;
    private String name;
    protected boolean anonymous = false;
    protected short version = 0;
    private transient String prototype;
    private transient NodeHandle handle;
    private transient INode cacheNode;
    transient WrappedNodeManager nmgr;
    transient DbMapping dbmap;
    transient Key primaryKey = null;
    transient String subnodeRelation = null;
    transient long lastSubnodeFetch = 0L;
    transient long lastSubnodeChange = 0L;
    transient long lastNameCheck = 0L;
    transient long lastParentSet = 0L;
    transient long lastSubnodeCount = 0L;
    transient int subnodeCount = -1;
    private volatile transient Transactor lock;
    private volatile transient int state;

    protected Node() {
        this.created = this.lastmodified = System.currentTimeMillis();
    }

    protected Node(long timestamp) {
        this.created = this.lastmodified = timestamp;
    }

    public Node(String name, String id, String prototype, WrappedNodeManager nmgr) {
        if (prototype == null) {
            prototype = "HopObject";
        }
        this.init(nmgr.getDbMapping(prototype), id, name, prototype, null, nmgr);
    }

    public Node(String name, String id, String prototype, WrappedNodeManager nmgr, long created, long lastmodified) {
        this(name, id, prototype, nmgr);
        this.created = created;
        this.lastmodified = lastmodified;
    }

    public Node(Node home, String propname, WrappedNodeManager nmgr, String prototype) {
        this.nmgr = nmgr;
        this.setParent(home);
        this.primaryKey = new SyntheticKey(home.getKey(), propname);
        this.id = this.primaryKey.getID();
        this.name = propname;
        this.prototype = prototype;
        this.anonymous = false;
        this.state = home.state == 1 || home.state == -3 ? -3 : -2;
    }

    public Node(String name, String prototype, WrappedNodeManager nmgr) {
        String protoProperty;
        this.nmgr = nmgr;
        this.prototype = prototype;
        this.dbmap = nmgr.getDbMapping(prototype);
        this.id = null;
        this.name = name == null ? "" : name;
        this.created = this.lastmodified = System.currentTimeMillis();
        this.state = -3;
        if (prototype != null && this.dbmap != null && (protoProperty = this.dbmap.columnNameToProperty(this.dbmap.getPrototypeField())) != null) {
            this.setString(protoProperty, this.dbmap.getExtensionId());
        }
    }

    public synchronized void init(DbMapping dbm, String id, String name, String prototype, Hashtable propMap, WrappedNodeManager nmgr) {
        this.nmgr = nmgr;
        this.dbmap = dbm;
        this.prototype = prototype;
        this.id = id;
        this.name = name;
        if (name == null || name.length() == 0) {
            this.name = prototype + " " + id;
        }
        this.propMap = propMap;
        this.created = this.lastmodified = System.currentTimeMillis();
        if (this.state != 0) {
            this.markAs(0);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException {
        try {
            this.version = in.readShort();
            if (this.version < 9) {
                throw new IOException("Can't read pre 1.3.0 HopObject");
            }
            this.id = (String)in.readObject();
            this.name = (String)in.readObject();
            this.state = in.readInt();
            this.parentHandle = (NodeHandle)in.readObject();
            this.created = in.readLong();
            this.lastmodified = in.readLong();
            this.subnodes = (SubnodeList)in.readObject();
            in.readObject();
            this.propMap = (Hashtable)in.readObject();
            this.anonymous = in.readBoolean();
            this.prototype = (String)in.readObject();
        }
        catch (ClassNotFoundException x) {
            throw new IOException(x.toString());
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        DbMapping smap;
        out.writeShort(9);
        out.writeObject(this.id);
        out.writeObject(this.name);
        out.writeInt(this.state);
        out.writeObject(this.parentHandle);
        out.writeLong(this.created);
        out.writeLong(this.lastmodified);
        DbMapping dbMapping = smap = this.dbmap == null ? null : this.dbmap.getSubnodeMapping();
        if (smap != null && smap.isRelational()) {
            out.writeObject(null);
        } else {
            out.writeObject(this.subnodes);
        }
        out.writeObject(null);
        out.writeObject(this.propMap);
        out.writeBoolean(this.anonymous);
        out.writeObject(this.prototype);
    }

    public synchronized void setPropMap(Hashtable propMap) {
        this.propMap = propMap;
    }

    public synchronized void setSubnodes(SubnodeList subnodes) {
        this.subnodes = subnodes;
    }

    synchronized void checkWriteLock() {
        if (this.state == -3) {
            return;
        }
        Transactor current = (Transactor)Thread.currentThread();
        if (!current.isActive()) {
            throw new TimeoutException();
        }
        if (this.state == -1) {
            this.nmgr.logEvent("Got Invalid Node: " + this);
            Thread.dumpStack();
            throw new ConcurrencyException("Node " + this + " was invalidated by another thread.");
        }
        if (this.lock != null && this.lock != current && this.lock.isAlive() && this.lock.isActive()) {
            throw new ConcurrencyException("Tried to modify " + this + " from two threads at the same time.");
        }
        current.visitNode(this);
        this.lock = current;
    }

    synchronized void clearWriteLock() {
        this.lock = null;
    }

    void markAs(int s) {
        if (s == this.state || this.state == -1 || this.state == -2 || this.state == -3) {
            return;
        }
        this.state = s;
        if (Thread.currentThread() instanceof Transactor) {
            Transactor tx = (Transactor)Thread.currentThread();
            if (s == 0) {
                this.clearWriteLock();
                tx.dropNode(this);
            } else {
                tx.visitNode(this);
                if (s == 1) {
                    this.clearWriteLock();
                    tx.visitCleanNode(this);
                }
            }
        }
    }

    void registerSubnodeChange() {
        if ((this.state == -3 || this.state == 1) && this.subnodeRelation == null) {
            return;
        }
        if (Thread.currentThread() instanceof Transactor) {
            Transactor tx = (Transactor)Thread.currentThread();
            tx.visitParentNode(this);
        }
    }

    void notifyPropertyChange(String propname) {
        Node parent;
        Node node = parent = this.parentHandle == null ? null : (Node)this.getParent();
        if (parent != null && parent.getDbMapping() != null) {
            DbMapping parentmap = parent.getDbMapping();
            Relation subrel = parentmap.getSubnodeRelation();
            String dbcolumn = this.dbmap.propertyToColumnName(propname);
            if (subrel == null || dbcolumn == null) {
                return;
            }
            if (subrel.order != null && subrel.order.indexOf(dbcolumn) > -1) {
                parent.registerSubnodeChange();
            }
        }
    }

    public void markSubnodesChanged() {
        ++this.lastSubnodeChange;
    }

    public int getState() {
        return this.state;
    }

    public void setState(int s) {
        this.state = s;
    }

    public void invalidate() {
        if (this.state == -3 || this.state == 1) {
            return;
        }
        this.checkWriteLock();
        this.nmgr.evictNode(this);
    }

    public void invalidateNode(String key) {
        if (this.state == -3 || this.state == 1) {
            return;
        }
        Relation rel = this.getDbMapping().getSubnodeRelation();
        if (rel != null) {
            if (rel.usesPrimaryKey()) {
                this.nmgr.evictNodeByKey(new DbKey(this.getDbMapping().getSubnodeMapping(), key));
            } else {
                this.nmgr.evictNodeByKey(new SyntheticKey(this.getKey(), key));
            }
        }
    }

    public String getID() {
        if (this.state == -3 && this.id == null) {
            this.id = TransientNode.generateID();
        }
        return this.id;
    }

    public boolean isAnonymous() {
        return this.anonymous;
    }

    public String getName() {
        return this.name;
    }

    public String getElementName() {
        long lastmod = this.lastmodified;
        if (this.dbmap != null) {
            lastmod = Math.max(lastmod, this.dbmap.getLastTypeChange());
        }
        if (this.parentHandle != null && this.lastNameCheck <= lastmod) {
            try {
                Node p = this.parentHandle.getNode(this.nmgr);
                DbMapping parentmap = p.getDbMapping();
                Relation prel = parentmap.getSubnodeRelation();
                if (prel != null) {
                    if (prel.groupby != null) {
                        this.setName(this.getString("groupname"));
                        this.anonymous = false;
                    } else if (prel.accessName != null) {
                        String propname = this.dbmap.columnNameToProperty(prel.accessName);
                        String propvalue = this.getString(propname);
                        if (propvalue != null && propvalue.length() > 0) {
                            this.setName(propvalue);
                            this.anonymous = false;
                        } else if (!this.anonymous && p.isParentOf(this)) {
                            this.anonymous = true;
                        }
                    } else if (!this.anonymous && p.isParentOf(this)) {
                        this.anonymous = true;
                    }
                } else if (!this.anonymous && p.isParentOf(this)) {
                    this.anonymous = true;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.lastNameCheck = System.currentTimeMillis();
        }
        return this.anonymous || this.name == null || this.name.length() == 0 ? this.id : this.name;
    }

    public String getFullName() {
        return this.getFullName(null);
    }

    public String getFullName(INode root) {
        String divider = null;
        StringBuffer b = new StringBuffer();
        int loopWatch = 0;
        for (INode p = this; p != null && p.getParent() != null && p != root; p = p.getParent()) {
            if (divider != null) {
                b.insert(0, divider);
            } else {
                divider = "/";
            }
            b.insert(0, p.getElementName());
            if (++loopWatch <= 10) continue;
            b.insert(0, "...");
            break;
        }
        return b.toString();
    }

    public String getPrototype() {
        if (this.prototype == null) {
            return "HopObject";
        }
        return this.prototype;
    }

    public void setPrototype(String proto) {
        this.prototype = proto;
    }

    public void setDbMapping(DbMapping dbmap) {
        this.dbmap = dbmap;
    }

    public DbMapping getDbMapping() {
        return this.dbmap;
    }

    public void setWrappedNodeManager(WrappedNodeManager nmgr) {
        this.nmgr = nmgr;
    }

    public Key getKey() {
        if (this.primaryKey == null && this.state == -3) {
            throw new RuntimeException("getKey called on transient Node: " + this);
        }
        if (this.dbmap == null && this.prototype != null && this.nmgr != null) {
            this.dbmap = this.nmgr.getDbMapping(this.prototype);
        }
        if (this.primaryKey == null) {
            this.primaryKey = new DbKey(this.dbmap, this.id);
        }
        return this.primaryKey;
    }

    public NodeHandle getHandle() {
        if (this.handle == null) {
            this.handle = new NodeHandle(this);
        }
        return this.handle;
    }

    public synchronized void setSubnodeRelation(String rel) {
        DbMapping smap;
        if (rel == null && this.subnodeRelation == null || rel != null && rel.equalsIgnoreCase(this.subnodeRelation)) {
            return;
        }
        this.checkWriteLock();
        this.subnodeRelation = rel;
        DbMapping dbMapping = smap = this.dbmap == null ? null : this.dbmap.getSubnodeMapping();
        if (smap != null && smap.isRelational()) {
            this.subnodes = null;
            this.subnodeCount = -1;
        }
    }

    public synchronized String getSubnodeRelation() {
        return this.subnodeRelation;
    }

    public void setName(String name) {
        if (name == null || name.trim().length() == 0) {
            this.name = this.id;
        } else {
            if (name.indexOf(47) > -1) {
                return;
            }
            this.name = name;
        }
    }

    public void setParent(Node parent) {
        this.parentHandle = parent == null ? null : parent.getHandle();
    }

    public void setParentHandle(NodeHandle parent) {
        this.parentHandle = parent;
    }

    public void setParent(Node parent, String propertyName) {
        if (!this.isRelational()) {
            return;
        }
        NodeHandle oldParentHandle = this.parentHandle;
        this.parentHandle = parent == null ? null : parent.getHandle();
        this.lastParentSet = System.currentTimeMillis();
        if (this.parentHandle == null || this.parentHandle.equals(oldParentHandle)) {
            return;
        }
        if (parent != null && propertyName == null) {
            Relation proprel;
            Relation prel;
            String newname = null;
            DbMapping parentmap = parent.getDbMapping();
            if (parentmap != null && (prel = parentmap.getSubnodeRelation()) != null && prel.otherType == this.dbmap && prel.accessName != null && (proprel = this.dbmap.columnNameToRelation(prel.accessName)) != null && proprel.propName != null) {
                newname = this.getString(proprel.propName);
            }
            if (newname == null) {
                this.anonymous = true;
            } else {
                this.anonymous = false;
                this.name = newname;
            }
        } else {
            this.anonymous = false;
            this.name = propertyName;
        }
    }

    public INode getParent() {
        ParentInfo[] parentInfo = null;
        if (this.isRelational() && this.lastParentSet <= Math.max(this.dbmap.getLastTypeChange(), this.lastmodified)) {
            parentInfo = this.dbmap.getParentInfo();
        }
        if (parentInfo != null) {
            for (int i = 0; i < parentInfo.length; ++i) {
                void pinfo = parentInfo[i];
                Node pn = null;
                Relation rel = this.dbmap.propertyToRelation(pinfo.propname);
                if (rel != null && (rel.isReference() || rel.isComplexReference())) {
                    pn = (Node)this.getNode(pinfo.propname);
                }
                if (pn == null && pinfo.isroot) {
                    pn = this.nmgr.getRootNode();
                }
                if (pn != null) {
                    if (pinfo.virtualname != null) {
                        Node pn2 = (Node)pn.getNode(pinfo.virtualname);
                        if (pn2 == null) {
                            this.getApp().logError("Error: Can't retrieve parent node " + pinfo + " for " + this);
                        } else if (pn2.equals(this)) {
                            this.setParent(pn);
                            this.name = pinfo.virtualname;
                            this.anonymous = false;
                            return pn;
                        }
                        pn = pn2;
                    }
                    DbMapping dbm = pn == null ? null : pn.getDbMapping();
                    try {
                        if (dbm != null && dbm.getSubnodeGroupby() != null) {
                            rel = this.dbmap.columnNameToRelation(dbm.getSubnodeGroupby());
                            pn = (Node)pn.getChildElement(this.getString(rel.propName));
                        }
                        if (pn != null && pn.isParentOf(this)) {
                            this.setParent(pn);
                            this.lastParentSet = System.currentTimeMillis();
                            return pn;
                        }
                    }
                    catch (Exception x) {
                        this.getApp().logError("Error retrieving parent node " + pinfo + " for " + this, x);
                    }
                }
                if (i != parentInfo.length - 1) continue;
                this.setParent(null);
                this.lastParentSet = System.currentTimeMillis();
            }
            if (this.parentHandle == null && !this.nmgr.isRootNode(this) && this.state != -3) {
                this.getApp().logEvent("*** Couldn't resolve parent for " + this);
                this.getApp().logEvent("*** Please check _parent info in type.properties!");
            }
        }
        if (this.parentHandle == null) {
            return null;
        }
        return this.parentHandle.getNode(this.nmgr);
    }

    public Node getCachedParent() {
        if (this.parentHandle == null) {
            return null;
        }
        return this.parentHandle.getNode(this.nmgr);
    }

    public INode addNode(INode elem) {
        return this.addNode(elem, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public INode addNode(INode elem, int where) {
        Relation localrel;
        String propname;
        String prop;
        Object prel;
        Relation srel;
        Node node = null;
        if (!(elem instanceof Node)) {
            throw new RuntimeException("Can't add fixed-transient node to a persistent node");
        }
        node = (Node)elem;
        if (this.state != -3) {
            if (!this.ignoreSubnodeChange()) {
                this.checkWriteLock();
            }
            node.checkWriteLock();
        }
        if (this.dbmap != null && this.dbmap.getSubnodeRelation() != null) {
            this.dbmap.getSubnodeRelation().setConstraints(this, node);
        }
        if (this.state != -3 && node.state == -3) {
            node.makePersistable();
        }
        if (!(this.ignoreSubnodeChange() || this.state != 0 && this.state != 3)) {
            this.markAs(2);
        }
        if (node.state == 0 || node.state == 3) {
            node.markAs(2);
        }
        this.loadNodes();
        if (this.dbmap != null && (srel = this.dbmap.getSubnodeRelation()) != null && srel.groupby != null) {
            Relation groupbyRel = srel.otherType.columnNameToRelation(srel.groupby);
            String groupbyProp = groupbyRel != null ? groupbyRel.propName : srel.groupby;
            String groupbyValue = node.getString(groupbyProp);
            INode groupbyNode = (INode)this.getChildElement(groupbyValue);
            if (groupbyNode == null) {
                groupbyNode = this.getGroupbySubnode(groupbyValue, true);
            } else {
                groupbyNode.setDbMapping(this.dbmap.getGroupbyMapping());
            }
            groupbyNode.addNode(node);
            return node;
        }
        NodeHandle nhandle = node.getHandle();
        if (this.subnodes != null && this.subnodes.contains(nhandle)) {
            SubnodeList groupbyRel = this.subnodes;
            synchronized (groupbyRel) {
                this.subnodes.remove(nhandle);
                if (where < 0 || where > this.subnodes.size()) {
                    this.subnodes.add(nhandle);
                } else {
                    this.subnodes.add(where, nhandle);
                }
            }
        }
        if (this.subnodes == null) {
            this.subnodes = this.createSubnodeList();
        }
        if (this.dbmap != null && node.dbmap != null && (prel = this.dbmap.getSubnodeRelation()) != null && ((Relation)prel).accessName != null && (prop = node.getString(propname = (localrel = node.dbmap.columnNameToRelation(((Relation)prel).accessName)) == null ? ((Relation)prel).accessName : localrel.propName)) != null && prop.length() > 0) {
            INode old = (INode)this.getChildElement(prop);
            if (old != null && old != node) {
                old.remove();
                this.removeNode(old);
            }
            if (this.state != -3) {
                Transactor tx = (Transactor)Thread.currentThread();
                SyntheticKey key = new SyntheticKey(this.getKey(), prop);
                tx.visitCleanNode(key, node);
                this.nmgr.registerNode(node, key);
            }
        }
        prel = this.subnodes;
        synchronized (prel) {
            if (where < 0 || where > this.subnodes.size()) {
                this.subnodes.add(nhandle);
            } else {
                this.subnodes.add(where, nhandle);
            }
        }
        if (node != this && !this.nmgr.isRootNode(node)) {
            Node nparent;
            Node node2 = nparent = node.parentHandle == null ? null : node.parentHandle.getNode(this.nmgr);
            if (nparent == null || this.state != -3 && nparent.getState() == -3) {
                node.setParent(this);
                node.anonymous = true;
            }
        }
        this.lastmodified = System.currentTimeMillis();
        node.lastNameCheck = 0L;
        this.registerSubnodeChange();
        return node;
    }

    public INode createNode() {
        return this.createNode(null, -1);
    }

    public INode createNode(int where) {
        return this.createNode(null, where);
    }

    public INode createNode(String nm) {
        return this.createNode(nm, -1);
    }

    public INode createNode(String nm, int where) {
        boolean anon = false;
        if (nm == null || "".equals(nm.trim())) {
            anon = true;
        }
        String proto = null;
        if (this.dbmap != null) {
            DbMapping childmap;
            DbMapping dbMapping = childmap = anon ? this.dbmap.getSubnodeMapping() : this.dbmap.getPropertyMapping(nm);
            if (childmap != null) {
                proto = childmap.getTypeName();
            }
        }
        Node n = new Node(nm, proto, this.nmgr);
        if (anon) {
            this.addNode(n, where);
        } else {
            this.setNode(nm, n);
        }
        return n;
    }

    public IPathElement getChildElement(String name) {
        if (this.dbmap != null) {
            Relation rel = this.dbmap.getExactPropertyRelation(name);
            if (rel != null && !rel.isPrimitive()) {
                return this.getNode(name);
            }
            rel = this.dbmap.getSubnodeRelation();
            if (rel != null && (rel.groupby != null || rel.accessName != null)) {
                if (this.state != -3 && rel.otherType != null && rel.otherType.isRelational()) {
                    return this.nmgr.getNode(this, name, rel);
                }
                String propname = rel.groupby != null ? "groupname" : rel.accessName;
                INode node = null;
                Enumeration e = this.getSubnodes();
                while (e.hasMoreElements()) {
                    Node n = (Node)e.nextElement();
                    if (!name.equalsIgnoreCase(n.getString(propname))) continue;
                    node = n;
                    break;
                }
                if (node != null && rel.groupby != null) {
                    node.setDbMapping(this.dbmap.getGroupbyMapping());
                }
                return node;
            }
            return this.getSubnode(name);
        }
        INode child = this.getSubnode(name);
        if (child == null) {
            child = this.getNode(name);
        }
        return child;
    }

    public IPathElement getParentElement() {
        return this.getParent();
    }

    public INode getSubnode(String subid) {
        if (subid == null || subid.length() == 0) {
            return null;
        }
        Node retval = null;
        if (subid != null) {
            this.loadNodes();
            if (this.subnodes == null || this.subnodes.size() == 0) {
                return null;
            }
            NodeHandle nhandle = null;
            int l = this.subnodes.size();
            for (int i = 0; i < l; ++i) {
                try {
                    NodeHandle shandle = (NodeHandle)this.subnodes.get(i);
                    if (!subid.equals(shandle.getID())) continue;
                    nhandle = shandle;
                }
                catch (Exception x) {}
                break;
            }
            if (nhandle != null) {
                retval = nhandle.getNode(this.nmgr);
            }
            if (retval != null && retval.parentHandle == null && !this.nmgr.isRootNode(retval)) {
                retval.setParent(this);
                retval.anonymous = true;
            }
        }
        return retval;
    }

    public INode getSubnodeAt(int index) {
        this.loadNodes();
        if (this.subnodes == null) {
            return null;
        }
        Node retval = null;
        if (this.subnodes.size() > index && (retval = ((NodeHandle)this.subnodes.get(index)).getNode(this.nmgr)) != null && retval.parentHandle == null && !this.nmgr.isRootNode(retval)) {
            retval.setParent(this);
            retval.anonymous = true;
        }
        return retval;
    }

    protected Node getGroupbySubnode(String sid, boolean create) {
        if (sid == null) {
            throw new IllegalArgumentException("Can't create group by null");
        }
        if (this.state == -3) {
            throw new RuntimeException("Can't add grouped child on transient node. Make parent persistent before adding grouped nodes.");
        }
        this.loadNodes();
        if (this.subnodes == null) {
            this.subnodes = new SubnodeList(this.nmgr, this.dbmap.getSubnodeRelation());
        }
        if (create || this.subnodes.contains(new NodeHandle(new SyntheticKey(this.getKey(), sid)))) {
            try {
                DbMapping groupbyMapping = this.dbmap.getGroupbyMapping();
                boolean relational = groupbyMapping.getSubnodeMapping().isRelational();
                if (relational || create) {
                    Node node = relational ? new Node(this, sid, this.nmgr, null) : new Node(sid, null, this.nmgr);
                    node.setString("groupname", sid);
                    node.setDbMapping(groupbyMapping);
                    if (!relational) {
                        if (this.state != -3) {
                            node.makePersistable();
                            node.checkWriteLock();
                        }
                        this.subnodes.add(node.getHandle());
                    }
                    node.setPrototype(groupbyMapping.getTypeName());
                    if (create) {
                        Transactor tx = (Transactor)Thread.currentThread();
                        tx.visitCleanNode(node);
                        this.nmgr.registerNode(node);
                    } else {
                        this.nmgr.evictKey(node.getKey());
                    }
                    return node;
                }
            }
            catch (Exception noluck) {
                this.nmgr.logEvent("Error creating group-by node for " + sid + ": " + noluck);
                noluck.printStackTrace();
            }
        }
        return null;
    }

    public boolean remove() {
        INode parent = this.getParent();
        if (parent != null) {
            parent.removeNode(this);
        }
        this.deepRemoveNode();
        return true;
    }

    public void removeNode(INode node) {
        Node n = (Node)node;
        this.releaseNode(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void releaseNode(Node node) {
        Relation localrel;
        String propname;
        String prop;
        Relation prel;
        INode parent = node.getParent();
        this.checkWriteLock();
        node.checkWriteLock();
        this.loadNodes();
        if (this.subnodes != null) {
            boolean removed = false;
            SubnodeList subnodeList = this.subnodes;
            synchronized (subnodeList) {
                removed = this.subnodes.remove(node.getHandle());
            }
            if (removed) {
                this.registerSubnodeChange();
            }
        }
        if (this.dbmap != null && node.dbmap != null && (prel = this.dbmap.getSubnodeRelation()) != null && prel.accessName != null && (prop = node.getString(propname = (localrel = node.dbmap.columnNameToRelation(prel.accessName)) == null ? prel.accessName : localrel.propName)) != null && this.getNode(prop) == node) {
            this.unset(prop);
        }
        if (parent == this) {
            node.setParentHandle(null);
        }
        if (this.ignoreSubnodeChange()) {
            return;
        }
        this.lastmodified = System.currentTimeMillis();
        if (this.state == 0) {
            this.markAs(2);
        }
    }

    protected void deepRemoveNode() {
        if (this.propMap != null) {
            Enumeration en = this.propMap.elements();
            while (en.hasMoreElements()) {
                Node n;
                Property p = (Property)en.nextElement();
                if (p == null || p.getType() != 6 || (n = (Node)p.getNodeValue()) == null || n.isRelational() || n.getParent() != this) continue;
                n.deepRemoveNode();
            }
        }
        if (this.subnodes != null) {
            Vector v = new Vector();
            Enumeration en = this.getSubnodes();
            while (en.hasMoreElements()) {
                v.add(en.nextElement());
            }
            int m = v.size();
            for (int i = 0; i < m; ++i) {
                Node n = (Node)v.get(i);
                if (n.isRelational() || n.getParent() != this) continue;
                n.deepRemoveNode();
            }
        }
        this.setParent(null);
        this.markAs(3);
    }

    public int contains(INode n) {
        if (n == null) {
            return -1;
        }
        this.loadNodes();
        if (this.subnodes == null) {
            return -1;
        }
        if (!(n instanceof Node)) {
            return -1;
        }
        Node node = (Node)n;
        return this.subnodes.indexOf(node.getHandle());
    }

    public boolean isParentOf(Node n) {
        Relation subrel;
        if (this.dbmap != null && (subrel = this.dbmap.getSubnodeRelation()) != null && subrel.otherType != null && subrel.otherType.isRelational() && subrel.filter == null) {
            if (!subrel.otherType.isStorageCompatible(n.getDbMapping())) {
                return false;
            }
            return subrel.checkConstraints(this, n);
        }
        return this.contains(n) > -1;
    }

    public int numberOfNodes() {
        DbMapping subMap;
        DbMapping dbMapping = subMap = this.dbmap == null ? null : this.dbmap.getSubnodeMapping();
        if (subMap != null && subMap.isRelational()) {
            Relation subRel = this.dbmap.getSubnodeRelation();
            if (subRel.aggressiveLoading && subRel.getGroup() == null && (this.state != -3 && this.state != 1 || this.subnodeRelation != null)) {
                long lastChange = this.getLastSubnodeChange(subRel);
                if (lastChange == this.lastSubnodeFetch && this.subnodes != null) {
                    this.subnodeCount = this.subnodes.size();
                    this.lastSubnodeCount = lastChange;
                } else if (lastChange != this.lastSubnodeCount || this.subnodeCount < 0) {
                    this.subnodeCount = this.nmgr.countNodes(this, subRel);
                    this.lastSubnodeCount = lastChange;
                }
                return this.subnodeCount;
            }
        }
        this.loadNodes();
        return this.subnodes == null ? 0 : this.subnodes.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadNodes() {
        DbMapping subMap;
        if ((this.state == -3 || this.state == 1) && this.subnodeRelation == null) {
            return;
        }
        DbMapping dbMapping = subMap = this.dbmap == null ? null : this.dbmap.getSubnodeMapping();
        if (subMap != null && subMap.isRelational()) {
            Relation subRel = this.dbmap.getSubnodeRelation();
            Node node = this;
            synchronized (node) {
                long lastChange = this.getLastSubnodeChange(subRel);
                if (lastChange != this.lastSubnodeFetch && !subRel.autoSorted || this.subnodes == null) {
                    if (subRel.updateCriteria != null) {
                        this.nmgr.updateSubnodeList(this, subRel);
                    } else {
                        this.subnodes = subRel.aggressiveLoading ? this.nmgr.getNodes(this, subRel) : this.nmgr.getNodeIDs(this, subRel);
                    }
                    this.lastSubnodeFetch = lastChange;
                }
            }
        }
    }

    public SubnodeList createSubnodeList() {
        Relation rel;
        Relation relation = rel = this.dbmap == null ? null : this.dbmap.getSubnodeRelation();
        this.subnodes = rel != null && rel.updateCriteria != null ? new UpdateableSubnodeList(this.nmgr, rel) : (rel != null && rel.autoSorted ? new OrderedSubnodeList(this.nmgr, rel) : new SubnodeList(this.nmgr, rel));
        return this.subnodes;
    }

    long getLastSubnodeChange(Relation subRel) {
        return subRel.aggressiveCaching ? this.lastSubnodeChange + this.dbmap.getLastTypeChange() : subRel.otherType.getLastDataChange() + this.dbmap.getLastTypeChange();
    }

    public void prefetchChildren(int startIndex, int length) throws Exception {
        if (length < 1) {
            return;
        }
        if (startIndex < 0) {
            return;
        }
        this.loadNodes();
        if (this.subnodes == null) {
            return;
        }
        if (startIndex >= this.subnodes.size()) {
            return;
        }
        int l = Math.min(this.subnodes.size() - startIndex, length);
        if (l < 1) {
            return;
        }
        Key[] keys = new Key[l];
        for (int i = 0; i < l; ++i) {
            keys[i] = ((NodeHandle)this.subnodes.get(i + startIndex)).getKey();
        }
        this.prefetchChildren(keys);
    }

    public void prefetchChildren(Key[] keys) throws Exception {
        this.nmgr.nmgr.prefetchNodes(this, this.dbmap.getSubnodeRelation(), keys);
    }

    public Enumeration getSubnodes() {
        this.loadNodes();
        class Enum
        implements Enumeration {
            int count = 0;

            Enum() {
            }

            public boolean hasMoreElements() {
                return this.count < Node.this.numberOfNodes();
            }

            public Object nextElement() {
                return Node.this.getSubnodeAt(this.count++);
            }
        }
        return new Enum();
    }

    public SubnodeList getSubnodeList() {
        return this.subnodes;
    }

    private boolean ignoreSubnodeChange() {
        Relation rel = this.dbmap == null ? null : this.dbmap.getSubnodeRelation();
        return rel != null && rel.otherType != null && rel.otherType.isRelational();
    }

    public Enumeration properties() {
        Relation prel;
        if (this.dbmap != null && this.dbmap.isRelational()) {
            return this.dbmap.getPropertyEnumeration();
        }
        Relation relation = prel = this.dbmap == null ? null : this.dbmap.getSubnodeRelation();
        if (this.state != -3 && prel != null && prel.hasAccessName() && prel.otherType != null && prel.otherType.isRelational()) {
            return this.nmgr.getPropertyNames(this, prel).elements();
        }
        if (this.propMap != null) {
            return this.propMap.keys();
        }
        return new EmptyEnumeration();
    }

    public Hashtable getPropMap() {
        return this.propMap;
    }

    public IProperty get(String propname) {
        return this.getProperty(propname);
    }

    public String getParentInfo() {
        return "anonymous:" + this.anonymous + ",parentHandle" + this.parentHandle + ",parent:" + this.getParent();
    }

    protected Property getProperty(String propname) {
        Node n;
        Property prop;
        if (propname == null) {
            return null;
        }
        Relation rel = this.dbmap == null ? null : this.dbmap.getExactPropertyRelation(propname);
        Property property = prop = this.propMap == null ? null : (Property)this.propMap.get(propname.toLowerCase());
        if (prop != null) {
            if (rel != null) {
                Node n2;
                if (rel.otherType != null && prop.getType() != 6) {
                    prop.convertToNodeReference(rel.otherType);
                }
                if (rel.isVirtual() && (n2 = (Node)prop.getNodeValue()) != null) {
                    n2.setDbMapping(rel.getVirtualMapping());
                    n2.nmgr = this.nmgr;
                }
            }
            return prop;
        }
        if (this.state == -3 && rel != null && rel.isVirtual()) {
            Node n3 = new Node(propname, rel.getPrototype(), this.nmgr);
            n3.setDbMapping(rel.getVirtualMapping());
            n3.setParent(this);
            this.setNode(propname, n3);
            return (Property)this.propMap.get(propname.toLowerCase());
        }
        if (rel != null && (rel.isVirtual() || rel.isComplexReference()) && this.state != -3 && (n = this.nmgr.getNode(this, propname, rel)) != null) {
            if (n.parentHandle == null && !this.nmgr.isRootNode(n)) {
                n.setParent(this);
                n.name = propname;
                n.anonymous = false;
            }
            return new Property(propname, this, n);
        }
        return null;
    }

    public String getString(String propname) {
        Property prop = this.getProperty(propname);
        try {
            return prop.getStringValue();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public long getInteger(String propname) {
        Property prop = this.getProperty(propname);
        try {
            return prop.getIntegerValue();
        }
        catch (Exception exception) {
            return 0L;
        }
    }

    public double getFloat(String propname) {
        Property prop = this.getProperty(propname);
        try {
            return prop.getFloatValue();
        }
        catch (Exception exception) {
            return 0.0;
        }
    }

    public Date getDate(String propname) {
        Property prop = this.getProperty(propname);
        try {
            return prop.getDateValue();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public boolean getBoolean(String propname) {
        Property prop = this.getProperty(propname);
        try {
            return prop.getBooleanValue();
        }
        catch (Exception exception) {
            return false;
        }
    }

    public INode getNode(String propname) {
        Property prop = this.getProperty(propname);
        try {
            return prop.getNodeValue();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public Object getJavaObject(String propname) {
        Property prop = this.getProperty(propname);
        try {
            return prop.getJavaObjectValue();
        }
        catch (Exception exception) {
            return null;
        }
    }

    protected void set(String propname, Object value, int type) {
        String p2;
        Property prop;
        this.checkWriteLock();
        if (this.propMap == null) {
            this.propMap = new Hashtable();
        }
        if ((prop = (Property)this.propMap.get(p2 = (propname = propname.trim()).toLowerCase())) != null) {
            prop.setValue(value, type);
        } else {
            prop = new Property(propname, this);
            prop.setValue(value, type);
            this.propMap.put(p2, prop);
        }
        this.lastmodified = System.currentTimeMillis();
        if (this.state == 0 && this.isPersistableProperty(propname)) {
            this.markAs(2);
        }
    }

    public void setString(String propname, String value) {
        this.checkWriteLock();
        if (this.propMap == null) {
            this.propMap = new Hashtable();
        }
        propname = propname.trim();
        String p2 = propname.toLowerCase();
        Property prop = (Property)this.propMap.get(p2);
        String oldvalue = null;
        if (prop != null) {
            oldvalue = prop.getStringValue();
            if (value != null && value.equals(oldvalue)) {
                return;
            }
            prop.setStringValue(value);
        } else {
            prop = new Property(propname, this);
            prop.setStringValue(value);
            this.propMap.put(p2, prop);
        }
        if (this.dbmap != null) {
            DbMapping newmap;
            Node parent;
            Node node = parent = this.parentHandle == null ? null : (Node)this.getParent();
            if (parent != null && parent.getDbMapping() != null) {
                DbMapping parentmap = parent.getDbMapping();
                Relation subrel = parentmap.getSubnodeRelation();
                String dbcolumn = this.dbmap.propertyToColumnName(propname);
                if (subrel != null && dbcolumn != null) {
                    if (subrel.order != null && subrel.order.indexOf(dbcolumn) > -1) {
                        parent.registerSubnodeChange();
                    }
                    if (subrel.accessName != null && subrel.accessName.equals(dbcolumn)) {
                        INode n = (INode)parent.getChildElement(value);
                        if (n != null && n != this) {
                            parent.unset(value);
                            parent.removeNode(n);
                        }
                        if (oldvalue != null && (n = (INode)parent.getChildElement(oldvalue)) == this) {
                            parent.unset(oldvalue);
                            parent.addNode(this);
                            this.nmgr.evictKey(new SyntheticKey(parent.getKey(), oldvalue));
                        }
                        this.setName(value);
                    }
                }
            }
            if (this.dbmap.getPrototypeField() != null && propname.equals(this.dbmap.columnNameToProperty(this.dbmap.getPrototypeField())) && (newmap = this.nmgr.getDbMapping(value)) != null) {
                String oldStorage = this.dbmap.getStorageTypeName();
                String newStorage = newmap.getStorageTypeName();
                if (oldStorage == null && newStorage == null || oldStorage != null && oldStorage.equals(newStorage)) {
                    this.dbmap.setLastDataChange();
                    newmap.setLastDataChange();
                    this.dbmap = newmap;
                    this.prototype = value;
                }
            }
        }
        this.lastmodified = System.currentTimeMillis();
        if (this.state == 0 && this.isPersistableProperty(propname)) {
            this.markAs(2);
        }
    }

    public void setInteger(String propname, long value) {
        String p2;
        Property prop;
        this.checkWriteLock();
        if (this.propMap == null) {
            this.propMap = new Hashtable();
        }
        if ((prop = (Property)this.propMap.get(p2 = (propname = propname.trim()).toLowerCase())) != null) {
            prop.setIntegerValue(value);
        } else {
            prop = new Property(propname, this);
            prop.setIntegerValue(value);
            this.propMap.put(p2, prop);
        }
        this.notifyPropertyChange(propname);
        this.lastmodified = System.currentTimeMillis();
        if (this.state == 0 && this.isPersistableProperty(propname)) {
            this.markAs(2);
        }
    }

    public void setFloat(String propname, double value) {
        String p2;
        Property prop;
        this.checkWriteLock();
        if (this.propMap == null) {
            this.propMap = new Hashtable();
        }
        if ((prop = (Property)this.propMap.get(p2 = (propname = propname.trim()).toLowerCase())) != null) {
            prop.setFloatValue(value);
        } else {
            prop = new Property(propname, this);
            prop.setFloatValue(value);
            this.propMap.put(p2, prop);
        }
        this.notifyPropertyChange(propname);
        this.lastmodified = System.currentTimeMillis();
        if (this.state == 0 && this.isPersistableProperty(propname)) {
            this.markAs(2);
        }
    }

    public void setBoolean(String propname, boolean value) {
        String p2;
        Property prop;
        this.checkWriteLock();
        if (this.propMap == null) {
            this.propMap = new Hashtable();
        }
        if ((prop = (Property)this.propMap.get(p2 = (propname = propname.trim()).toLowerCase())) != null) {
            prop.setBooleanValue(value);
        } else {
            prop = new Property(propname, this);
            prop.setBooleanValue(value);
            this.propMap.put(p2, prop);
        }
        this.notifyPropertyChange(propname);
        this.lastmodified = System.currentTimeMillis();
        if (this.state == 0 && this.isPersistableProperty(propname)) {
            this.markAs(2);
        }
    }

    public void setDate(String propname, Date value) {
        String p2;
        Property prop;
        this.checkWriteLock();
        if (this.propMap == null) {
            this.propMap = new Hashtable();
        }
        if ((prop = (Property)this.propMap.get(p2 = (propname = propname.trim()).toLowerCase())) != null) {
            prop.setDateValue(value);
        } else {
            prop = new Property(propname, this);
            prop.setDateValue(value);
            this.propMap.put(p2, prop);
        }
        this.notifyPropertyChange(propname);
        this.lastmodified = System.currentTimeMillis();
        if (this.state == 0 && this.isPersistableProperty(propname)) {
            this.markAs(2);
        }
    }

    public void setJavaObject(String propname, Object value) {
        String p2;
        Property prop;
        this.checkWriteLock();
        if (this.propMap == null) {
            this.propMap = new Hashtable();
        }
        if ((prop = (Property)this.propMap.get(p2 = (propname = propname.trim()).toLowerCase())) != null) {
            prop.setJavaObjectValue(value);
        } else {
            prop = new Property(propname, this);
            prop.setJavaObjectValue(value);
            this.propMap.put(p2, prop);
        }
        this.notifyPropertyChange(propname);
        this.lastmodified = System.currentTimeMillis();
        if (this.state == 0 && this.isPersistableProperty(propname)) {
            this.markAs(2);
        }
    }

    public void setNode(String propname, INode value) {
        Property prop;
        Relation rel = this.dbmap == null ? null : this.dbmap.getExactPropertyRelation(propname);
        DbMapping nmap = rel == null ? null : rel.getPropertyMapping();
        DbMapping vmap = value.getDbMapping();
        if (nmap != null && nmap != vmap) {
            if (vmap == null) {
                value.setDbMapping(nmap);
            } else if (!nmap.isStorageCompatible(vmap) && !rel.isComplexReference()) {
                throw new RuntimeException("Can't set " + propname + " to object with prototype " + value.getPrototype() + ", was expecting " + nmap.getTypeName());
            }
        }
        if (this.state != -3) {
            this.checkWriteLock();
        }
        Node n = null;
        if (!(value instanceof Node)) {
            throw new RuntimeException("Can't add fixed-transient node to a persistent node");
        }
        n = (Node)value;
        boolean isPersistable = this.isPersistableProperty(propname);
        if (this.state != -3 && n.state == -3 && isPersistable) {
            n.makePersistable();
        }
        if (this.state != -3) {
            n.checkWriteLock();
        }
        if (n != this && !this.nmgr.isRootNode(n) && isPersistable) {
            Node nparent;
            Node node = nparent = n.parentHandle == null ? null : n.parentHandle.getNode(this.nmgr);
            if (nparent == null || this.state != -3 && nparent.getState() == -3) {
                n.setParent(this);
                n.name = propname;
                n.anonymous = false;
            }
        }
        propname = propname.trim();
        String p2 = propname.toLowerCase();
        if (rel == null && this.dbmap != null) {
            rel = this.dbmap.getPropertyRelation(propname);
        }
        if (rel != null && (rel.countConstraints() > 1 || rel.isComplexReference())) {
            rel.setConstraints(this, n);
            if (rel.isComplexReference()) {
                MultiKey key = new MultiKey(n.getDbMapping(), rel.getKeyParts(this));
                this.nmgr.nmgr.registerNode(n, key);
                return;
            }
        }
        Property property = prop = this.propMap == null ? null : (Property)this.propMap.get(p2);
        if (prop != null) {
            if (prop.getType() == 6 && n.getHandle().equals(prop.getNodeHandle())) {
                if (this.state == 0) {
                    this.clearWriteLock();
                }
                if (n.state == 0) {
                    n.clearWriteLock();
                }
                return;
            }
        } else {
            prop = new Property(propname, this);
        }
        prop.setNodeValue(n);
        if (rel == null || rel.isReference() || this.state == -3 || rel.otherType == null || !rel.otherType.isRelational()) {
            if (this.propMap == null) {
                this.propMap = new Hashtable();
            }
            this.propMap.put(p2, prop);
            if (this.state == 0 && isPersistable) {
                this.markAs(2);
            }
        }
        if (n.state != -3) {
            Transactor tx = (Transactor)Thread.currentThread();
            tx.visitCleanNode(n.getKey(), n);
            if (rel != null && rel.accessName != null && this.state != -3) {
                SyntheticKey secKey = new SyntheticKey(this.getKey(), propname);
                this.nmgr.registerNode(n, secKey);
                tx.visitCleanNode(secKey, n);
            }
        }
        this.lastmodified = System.currentTimeMillis();
        if (n.state == 3) {
            n.markAs(2);
        }
    }

    private boolean isPersistableProperty(String propname) {
        return propname.length() > 0 && propname.charAt(0) != '_';
    }

    public void unset(String propname) {
        try {
            Relation rel;
            boolean relational;
            Property p = null;
            boolean bl = relational = this.dbmap != null && this.dbmap.isRelational();
            if (this.propMap != null) {
                p = relational ? (Property)this.propMap.get(propname.toLowerCase()) : (Property)this.propMap.remove(propname.toLowerCase());
            }
            if (p != null) {
                this.checkWriteLock();
                if (relational) {
                    p.setStringValue(null);
                    this.notifyPropertyChange(propname);
                }
                this.lastmodified = System.currentTimeMillis();
                if (this.state == 0) {
                    this.markAs(2);
                }
            } else if (this.dbmap != null && (rel = this.dbmap.getExactPropertyRelation(propname)) != null && rel.isComplexReference()) {
                p = this.getProperty(propname);
                rel.unsetConstraints(this, p.getNodeValue());
            }
        }
        catch (Exception x) {
            this.getApp().logError("Error unsetting property", x);
        }
    }

    public long lastModified() {
        return this.lastmodified;
    }

    public long created() {
        return this.created;
    }

    public String toString() {
        try {
            Object str;
            RequestEvaluator reval = this.getApp().getCurrentRequestEvaluator();
            if (reval != null && (str = reval.invokeDirectFunction(this, "toString", RequestEvaluator.EMPTY_ARGS)) instanceof String) {
                return (String)str;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "HopObject " + this.name;
    }

    public boolean isRelational() {
        return this.dbmap != null && this.dbmap.isRelational();
    }

    public void persist() {
        this.makePersistable();
    }

    private void makePersistable() {
        if (this.state != -3) {
            return;
        }
        this.setState(1);
        this.id = this.nmgr.generateID(this.dbmap);
        this.getHandle().becomePersistent();
        Transactor current = (Transactor)Thread.currentThread();
        current.visitNode(this);
        current.visitCleanNode(this);
        this.makeChildrenPersistable();
    }

    private void makeChildrenPersistable() {
        Enumeration e = this.getSubnodes();
        while (e.hasMoreElements()) {
            Node n = (Node)e.nextElement();
            if (n.state != -3) continue;
            n.makePersistable();
        }
        e = this.properties();
        while (e.hasMoreElements()) {
            Relation rel;
            Node n;
            String propname = (String)e.nextElement();
            IProperty next = this.get(propname);
            if (next == null || next.getType() != 6 || (n = (Node)next.getNodeValue()) == null || n == this) continue;
            if (this.dbmap != null && (rel = this.dbmap.getExactPropertyRelation(next.getName())) != null && rel.isVirtual() && !rel.needsPersistence()) {
                n.setState(-3);
                n.makeChildrenPersistable();
                n.setState(-2);
                n.primaryKey = new SyntheticKey(this.getKey(), propname);
                n.id = propname;
                continue;
            }
            n.makePersistable();
        }
    }

    public synchronized INode getCacheNode() {
        if (this.cacheNode == null) {
            this.cacheNode = new TransientNode();
        }
        return this.cacheNode;
    }

    public synchronized void clearCacheNode() {
        this.cacheNode = null;
    }

    public Node getNonVirtualParent() {
        Node node = this;
        for (int i = 0; i < 5 && node != null; node = (Node)node.getParent(), ++i) {
            DbMapping map;
            if (!(node.getState() == -3 ? (map = node.getDbMapping()) == null || map.getTypeName() != null : node.getState() != -2)) continue;
            return node;
        }
        return null;
    }

    public boolean isNullNode() {
        return this.nmgr == null;
    }

    public int hashCode() {
        if (this.prototype == null) {
            return super.hashCode();
        }
        return super.hashCode() + this.prototype.hashCode();
    }

    public void dump() {
        System.err.println("subnodes: " + this.subnodes);
        System.err.println("properties: " + this.propMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int updateSubnodes() {
        if (this.dbmap == null) {
            throw new RuntimeException(this + " doesn't have a DbMapping");
        }
        Relation subRel = this.dbmap.getSubnodeRelation();
        Node node = this;
        synchronized (node) {
            this.lastSubnodeFetch = this.getLastSubnodeChange(subRel);
            return this.nmgr.updateSubnodeList(this, subRel);
        }
    }

    private Application getApp() {
        return this.nmgr.nmgr.app;
    }
}

