/*
 * Decompiled with CFR 0.152.
 */
package helma.objectmodel.db;

import helma.objectmodel.db.DbMapping;
import helma.objectmodel.db.Key;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Map;

public final class MultiKey
implements Key,
Serializable {
    private String storageName;
    private Map parts;
    private transient int hashcode = 0;
    static final long serialVersionUID = -9173409137561990089L;

    public MultiKey(DbMapping dbmap, Map parts) {
        this.parts = parts;
        this.storageName = this.getStorageNameFromParts(dbmap, parts);
    }

    private String getStorageNameFromParts(DbMapping dbmap, Map parts) {
        DbMapping dynamap;
        if (dbmap == null) {
            return null;
        }
        String protoName = (String)parts.get("$prototype");
        if (protoName != null && (dynamap = dbmap.app.getDbMapping(protoName)) != null) {
            return dynamap.getStorageTypeName();
        }
        return dbmap.getStorageTypeName();
    }

    public boolean equals(Object what) {
        if (what == this) {
            return true;
        }
        if (!(what instanceof MultiKey)) {
            return false;
        }
        MultiKey k = (MultiKey)what;
        return this.storageName == k.storageName && (this.parts == k.parts || ((Object)this.parts).equals(k.parts));
    }

    public int hashCode() {
        if (this.hashcode == 0) {
            this.hashcode = this.storageName == null ? 17 + 37 * ((Object)this.parts).hashCode() : 17 + 37 * this.storageName.hashCode() + 37 * ((Object)this.parts).hashCode();
        }
        return this.hashcode;
    }

    public Key getParentKey() {
        return null;
    }

    public String getStorageName() {
        return this.storageName;
    }

    public String getID() {
        return null;
    }

    public String toString() {
        return this.storageName == null ? "[" + this.parts + "]" : this.storageName + "[" + this.parts + "]";
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.writeObject(this.storageName);
        stream.writeObject(this.parts);
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        this.storageName = (String)stream.readObject();
        this.parts = (Map)stream.readObject();
        if (this.storageName != null) {
            this.storageName = this.storageName.intern();
        }
    }
}

