/*
 * Decompiled with CFR 0.152.
 */
package helma.objectmodel.db;

import helma.objectmodel.db.DbMapping;
import helma.objectmodel.db.Transactor;
import helma.util.ResourceProperties;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;

public class DbSource {
    private static ResourceProperties defaultProps = null;
    private Properties conProps;
    private String name;
    private ResourceProperties props;
    private ResourceProperties subProps;
    protected String url;
    private String driver;
    private boolean isOracle;
    private boolean isMySQL;
    private boolean isPostgreSQL;
    private long lastRead = 0L;
    private Hashtable dbmappings = new Hashtable();
    private int hashcode;

    public DbSource(String name, ResourceProperties props) throws ClassNotFoundException {
        this.name = name;
        this.props = props;
        this.init();
    }

    public synchronized Connection getConnection() throws ClassNotFoundException, SQLException {
        boolean fileUpdated;
        Connection con = null;
        Transactor tx = null;
        if (Thread.currentThread() instanceof Transactor) {
            tx = (Transactor)Thread.currentThread();
            con = tx.getConnection(this);
        }
        boolean bl = fileUpdated = this.props.lastModified() > this.lastRead || defaultProps != null && defaultProps.lastModified() > this.lastRead;
        if (con == null || con.isClosed() || fileUpdated) {
            this.init();
            con = DriverManager.getConnection(this.url, this.conProps);
            if (tx != null) {
                tx.registerConnection(this, con);
            }
        }
        return con;
    }

    public synchronized ResourceProperties switchProperties(ResourceProperties newProps) throws ClassNotFoundException {
        ResourceProperties oldProps = this.props;
        this.props = newProps;
        this.init();
        return oldProps;
    }

    private synchronized void init() throws ClassNotFoundException {
        this.lastRead = defaultProps == null ? this.props.lastModified() : Math.max(this.props.lastModified(), defaultProps.lastModified());
        this.subProps = this.props.getSubProperties(this.name + '.');
        this.hashcode = this.subProps.hashCode();
        this.url = this.subProps.getProperty("url");
        this.driver = this.subProps.getProperty("driver");
        if (this.url == null) {
            throw new NullPointerException(this.name + ".url is not defined in db.properties");
        }
        if (this.driver == null) {
            throw new NullPointerException(this.name + ".driver class not defined in db.properties");
        }
        this.isOracle = this.driver.startsWith("oracle.jdbc.driver");
        this.isMySQL = this.driver.startsWith("com.mysql.jdbc") || this.driver.startsWith("org.gjt.mm.mysql");
        this.isPostgreSQL = this.driver.equals("org.postgresql.Driver");
        Class.forName(this.driver);
        this.conProps = new Properties();
        String prop = this.subProps.getProperty("user");
        if (prop != null) {
            this.conProps.put("user", prop);
        }
        if ((prop = this.subProps.getProperty("password")) != null) {
            this.conProps.put("password", prop);
        }
        Enumeration e = this.subProps.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            if ("url".equalsIgnoreCase(key) || "driver".equalsIgnoreCase(key) || "user".equalsIgnoreCase(key) || "password".equalsIgnoreCase(key)) continue;
            this.conProps.setProperty(key, this.subProps.getProperty(key));
        }
    }

    public String getDriverName() {
        return this.driver;
    }

    public String getName() {
        return this.name;
    }

    public static void setDefaultProps(ResourceProperties props) {
        defaultProps = props;
    }

    public boolean isOracle() {
        return this.isOracle;
    }

    public boolean isMySQL() {
        return this.isMySQL;
    }

    public boolean isPostgreSQL() {
        return this.isPostgreSQL;
    }

    protected void registerDbMapping(DbMapping dbmap) {
        if (!dbmap.inheritsStorage() && dbmap.getTableName() != null) {
            this.dbmappings.put(dbmap.getTableName().toUpperCase(), dbmap);
        }
    }

    protected DbMapping getDbMapping(String tablename) {
        return (DbMapping)this.dbmappings.get(tablename.toUpperCase());
    }

    public int hashCode() {
        return this.hashcode;
    }

    public boolean equals(Object obj) {
        return obj instanceof DbSource && this.subProps.equals(((DbSource)obj).subProps);
    }
}

