/*
 * Decompiled with CFR 0.152.
 */
package helma.objectmodel.db;

import helma.framework.core.Application;
import helma.framework.core.Prototype;
import helma.objectmodel.db.DbColumn;
import helma.objectmodel.db.DbSource;
import helma.objectmodel.db.ParentInfo;
import helma.objectmodel.db.Relation;
import helma.objectmodel.db.WrappedNodeManager;
import helma.util.ResourceProperties;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.StringTokenizer;

public final class DbMapping {
    protected final Application app;
    private final String typename;
    private final ResourceProperties props;
    private DbSource dbSource;
    private String dbSourceName;
    private String tableName;
    private String parentSetting;
    private ParentInfo[] parentInfo;
    protected Relation subRelation;
    protected Relation propRelation;
    private DbMapping groupbyMapping;
    private HashMap prop2db;
    private HashMap db2prop;
    private DbColumn[] columns = null;
    private HashMap columnMap;
    private Relation[] joins;
    private String selectString = null;
    private String insertString = null;
    private String updateString = null;
    private String idField;
    private String nameField;
    private String protoField;
    private ResourceProperties extensionMap;
    private String extensionId;
    private DbMapping parentMapping;
    private String idgen;
    private long lastID;
    long lastTypeChange = -1L;
    long lastDataChange = 0L;
    private boolean evictOnReplication;
    HashSet dependentMappings = new HashSet();

    public DbMapping(Application app, String typename) {
        this(app, typename, null);
    }

    public DbMapping(Application app, String typename, ResourceProperties props) {
        this.app = app;
        this.typename = typename == null ? null : typename.intern();
        this.prop2db = new HashMap();
        this.db2prop = new HashMap();
        this.columnMap = new HashMap();
        this.parentInfo = null;
        this.idField = null;
        this.props = props;
        if (props != null) {
            this.readBasicProperties();
        }
    }

    public boolean needsUpdate() {
        return this.props.lastModified() != this.lastTypeChange;
    }

    private void readBasicProperties() {
        this.tableName = this.props.getProperty("_table");
        this.dbSourceName = this.props.getProperty("_db");
        if (this.dbSourceName != null) {
            this.dbSource = this.app.getDbSource(this.dbSourceName);
            if (this.dbSource == null) {
                this.app.logError("*** Data Source for prototype " + this.typename + " does not exist: " + this.dbSourceName);
                this.app.logError("*** accessing or storing a " + this.typename + " object will cause an error.");
            } else if (this.tableName == null) {
                this.app.logError("*** No table name specified for prototype " + this.typename);
                this.app.logError("*** accessing or storing a " + this.typename + " object will cause an error.");
                this.dbSource = null;
            } else {
                this.dbSource.registerDbMapping(this);
            }
        }
    }

    public synchronized void update() {
        block28: {
            Prototype proto;
            this.readBasicProperties();
            this.idgen = this.props.getProperty("_idgen");
            this.idField = this.props.getProperty("_id");
            this.nameField = this.props.getProperty("_name");
            this.protoField = this.props.getProperty("_prototype");
            this.evictOnReplication = "true".equals(this.props.getProperty("_evictOnReplication"));
            this.parentSetting = this.props.getProperty("_parent");
            if (this.parentSetting != null) {
                StringTokenizer st = new StringTokenizer(this.parentSetting, ",;");
                this.parentInfo = new ParentInfo[st.countTokens()];
                for (int i = 0; i < this.parentInfo.length; ++i) {
                    this.parentInfo[i] = new ParentInfo(st.nextToken().trim());
                }
            } else {
                this.parentInfo = null;
            }
            this.lastTypeChange = this.props.lastModified();
            String extendsProto = this.props.getProperty("_extends");
            if (extendsProto != null) {
                this.parentMapping = this.app.getDbMapping(extendsProto);
                if (this.parentMapping == null) {
                    this.app.logError("*** Parent mapping for prototype " + this.typename + " does not exist: " + extendsProto);
                } else {
                    if (this.parentMapping.needsUpdate()) {
                        this.parentMapping.update();
                    }
                    if (this.tableName != null && this.tableName.equals(this.parentMapping.getTableName())) {
                        this.tableName = null;
                    }
                    if (this.dbSourceName != null && this.dbSourceName.equals(this.parentMapping.getDbSourceName())) {
                        this.dbSourceName = null;
                        this.dbSource = null;
                    }
                }
            } else {
                this.parentMapping = null;
            }
            if (this.inheritsStorage() && this.getPrototypeField() == null) {
                this.app.logError("*** Prototype not stored for extended relational type " + this.typename);
                this.app.logError("*** objects fetched from db will have base prototype!");
            }
            this.extensionId = this.props.getProperty("_extensionId", this.typename);
            this.registerExtension(this.extensionId, this.typename);
            if (this.typename != null && !"global".equalsIgnoreCase(this.typename) && !"hopobject".equalsIgnoreCase(this.typename) && (proto = this.app.getPrototypeByName(this.typename)) != null) {
                if (extendsProto != null) {
                    proto.setParentPrototype(this.app.getPrototypeByName(extendsProto));
                } else if (!this.app.isJavaPrototype(this.typename)) {
                    proto.setParentPrototype(this.app.getPrototypeByName("hopobject"));
                }
            }
            this.columns = null;
            this.columnMap.clear();
            this.updateString = null;
            this.insertString = null;
            this.selectString = null;
            HashMap<String, Relation> p2d = new HashMap<String, Relation>();
            HashMap<String, Relation> d2p = new HashMap<String, Relation>();
            ArrayList<Relation> joinList = new ArrayList<Relation>();
            Enumeration e = this.props.keys();
            while (e.hasMoreElements()) {
                String propName = (String)e.nextElement();
                try {
                    Relation old;
                    if (propName.startsWith("_") || propName.indexOf(".") >= 0) continue;
                    String dbField = this.props.getProperty(propName);
                    Relation rel = (Relation)this.prop2db.get(propName.toLowerCase());
                    if (rel == null) {
                        rel = new Relation(propName, this);
                    }
                    rel.update(dbField, this.props);
                    p2d.put(propName.toLowerCase(), rel);
                    if (rel.columnName != null && rel.isPrimitiveOrReference() && (old = d2p.put(rel.columnName.toLowerCase(), rel)) != null) {
                        this.app.logEvent("*** Duplicate mapping for " + this.typename + "." + rel.columnName);
                        if (old.isPrimitive()) {
                            d2p.put(old.columnName.toLowerCase(), old);
                        }
                    }
                    if (!rel.aggressiveLoading || !rel.isReference() && !rel.isComplexReference()) continue;
                    joinList.add(rel);
                }
                catch (Exception x) {
                    this.app.logEvent("Error in type.properties: " + x.getMessage());
                }
            }
            this.prop2db = p2d;
            this.db2prop = d2p;
            this.joins = new Relation[joinList.size()];
            this.joins = joinList.toArray(this.joins);
            String subnodeMapping = this.props.getProperty("_children");
            if (subnodeMapping != null) {
                try {
                    if (this.subRelation == null) {
                        this.subRelation = new Relation("_children", this);
                    }
                    this.subRelation.update(subnodeMapping, this.props);
                    if (this.subRelation.accessName != null || this.subRelation.groupby != null) {
                        this.propRelation = this.subRelation;
                        break block28;
                    }
                    this.propRelation = null;
                }
                catch (Exception x) {
                    this.app.logEvent("Error reading _subnodes relation for " + this.typename + ": " + x.getMessage());
                }
            } else {
                this.propRelation = null;
                this.subRelation = null;
            }
        }
        if (this.groupbyMapping != null) {
            this.initGroupbyMapping();
            this.groupbyMapping.lastTypeChange = this.lastTypeChange;
        }
    }

    private void registerExtension(String extID, String extName) {
        if (this.extensionMap == null) {
            this.extensionMap = new ResourceProperties();
            this.extensionMap.setIgnoreCase(true);
        } else if (this.extensionMap.containsValue(extName)) {
            this.extensionMap.values().remove(extName);
        }
        this.extensionMap.setProperty(extID, extName);
        if (this.inheritsStorage()) {
            this.parentMapping.registerExtension(extID, extName);
        }
    }

    public String[] getExtensions() {
        String[] stringArray;
        if (this.extensionMap == null) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = this.extensionId;
        } else {
            stringArray = this.extensionMap.keySet().toArray(new String[0]);
        }
        return stringArray;
    }

    public String getPrototypeName(String id) {
        if (this.inheritsStorage()) {
            return this.parentMapping.getPrototypeName(id);
        }
        if (id == null) {
            return this.typename;
        }
        return this.extensionMap.getProperty(id, this.typename);
    }

    public String getExtensionId() {
        return this.extensionId;
    }

    public void remove() {
    }

    public Connection getConnection() throws ClassNotFoundException, SQLException {
        if (this.dbSourceName == null) {
            if (this.parentMapping != null) {
                return this.parentMapping.getConnection();
            }
            throw new SQLException("Tried to get Connection from non-relational embedded data source.");
        }
        if (this.tableName == null) {
            throw new SQLException("Invalid DbMapping, _table not specified: " + this);
        }
        if (this.dbSource == null) {
            this.dbSource = this.app.getDbSource(this.dbSourceName);
        }
        if (this.dbSource == null) {
            throw new SQLException("Datasource not defined or unable to load driver: " + this.dbSourceName + ".");
        }
        return this.dbSource.getConnection();
    }

    public DbSource getDbSource() {
        if (this.dbSource == null) {
            if (this.tableName != null && this.dbSourceName != null) {
                this.dbSource = this.app.getDbSource(this.dbSourceName);
            } else if (this.parentMapping != null) {
                return this.parentMapping.getDbSource();
            }
        }
        return this.dbSource;
    }

    public String getDbSourceName() {
        if (this.dbSourceName == null && this.parentMapping != null) {
            return this.parentMapping.getDbSourceName();
        }
        return this.dbSourceName;
    }

    public String getTableName() {
        if (this.tableName == null && this.parentMapping != null) {
            return this.parentMapping.getTableName();
        }
        return this.tableName;
    }

    public Application getApplication() {
        return this.app;
    }

    public String getAppName() {
        return this.app.getName();
    }

    public String getTypeName() {
        return this.typename;
    }

    public String getExtends() {
        return this.parentMapping == null ? null : this.parentMapping.getTypeName();
    }

    public String getIDField() {
        if (this.idField == null && this.parentMapping != null) {
            return this.parentMapping.getIDField();
        }
        return this.idField == null ? "ID" : this.idField;
    }

    public String getNameField() {
        if (this.nameField == null && this.parentMapping != null) {
            return this.parentMapping.getNameField();
        }
        return this.nameField;
    }

    public String getPrototypeField() {
        if (this.protoField == null && this.parentMapping != null) {
            return this.parentMapping.getPrototypeField();
        }
        return this.protoField;
    }

    public boolean evictOnReplication() {
        return this.evictOnReplication;
    }

    public String columnNameToProperty(String columnName) {
        if (columnName == null) {
            return null;
        }
        int open = columnName.indexOf(40);
        int close = columnName.indexOf(41);
        if (open > -1 && close > open) {
            columnName = columnName.substring(open + 1, close);
        }
        return this._columnNameToProperty(columnName.toLowerCase());
    }

    private String _columnNameToProperty(String columnName) {
        Relation rel = (Relation)this.db2prop.get(columnName);
        if (rel == null && this.parentMapping != null) {
            return this.parentMapping._columnNameToProperty(columnName);
        }
        if (rel != null && rel.isPrimitiveOrReference()) {
            return rel.propName;
        }
        return null;
    }

    public String propertyToColumnName(String propName) {
        if (propName == null) {
            return null;
        }
        return this._propertyToColumnName(propName.toLowerCase());
    }

    private String _propertyToColumnName(String propName) {
        Relation rel = (Relation)this.prop2db.get(propName);
        if (rel == null && this.parentMapping != null) {
            return this.parentMapping._propertyToColumnName(propName);
        }
        if (rel != null && rel.isPrimitiveOrReference()) {
            return rel.columnName;
        }
        return null;
    }

    public Relation columnNameToRelation(String columnName) {
        if (columnName == null) {
            return null;
        }
        return this._columnNameToRelation(columnName.toLowerCase());
    }

    private Relation _columnNameToRelation(String columnName) {
        Relation rel = (Relation)this.db2prop.get(columnName);
        if (rel == null && this.parentMapping != null) {
            return this.parentMapping._columnNameToRelation(columnName);
        }
        return rel;
    }

    public Relation propertyToRelation(String propName) {
        if (propName == null) {
            return null;
        }
        return this._propertyToRelation(propName.toLowerCase());
    }

    private Relation _propertyToRelation(String propName) {
        Relation rel = (Relation)this.prop2db.get(propName);
        if (rel == null && this.parentMapping != null) {
            return this.parentMapping._propertyToRelation(propName);
        }
        return rel;
    }

    public String getParentSetting() {
        if (this.parentSetting == null && this.parentMapping != null) {
            return this.parentMapping.getParentSetting();
        }
        return this.parentSetting;
    }

    public synchronized ParentInfo[] getParentInfo() {
        if (this.parentInfo == null && this.parentMapping != null) {
            return this.parentMapping.getParentInfo();
        }
        return this.parentInfo;
    }

    public DbMapping getSubnodeMapping() {
        if (this.subRelation != null) {
            return this.subRelation.otherType;
        }
        if (this.parentMapping != null) {
            return this.parentMapping.getSubnodeMapping();
        }
        return null;
    }

    public DbMapping getPropertyMapping(String propname) {
        Relation rel = this.getPropertyRelation(propname);
        if (rel != null) {
            if (rel.virtual && rel.prototype == null) {
                return null;
            }
            return rel.otherType;
        }
        return null;
    }

    public synchronized DbMapping getGroupbyMapping() {
        if (this.subRelation == null || this.subRelation.groupby == null) {
            return null;
        }
        if (this.groupbyMapping == null) {
            this.initGroupbyMapping();
        }
        return this.groupbyMapping;
    }

    private void initGroupbyMapping() {
        this.groupbyMapping = new DbMapping(this.app, this.subRelation.groupbyPrototype);
        if (this.subRelation.groupbyPrototype != null) {
            this.groupbyMapping.parentMapping = this.app.getDbMapping(this.subRelation.groupbyPrototype);
        }
        this.groupbyMapping.subRelation = this.subRelation.getGroupbySubnodeRelation();
        this.groupbyMapping.propRelation = this.propRelation != null ? this.propRelation.getGroupbyPropertyRelation() : this.subRelation.getGroupbyPropertyRelation();
    }

    public void setPropertyRelation(Relation rel) {
        this.propRelation = rel;
    }

    public Relation getSubnodeRelation() {
        if (this.subRelation == null && this.parentMapping != null) {
            return this.parentMapping.getSubnodeRelation();
        }
        return this.subRelation;
    }

    public String[] getPropertyNames() {
        return this.prop2db.keySet().toArray(new String[this.prop2db.size()]);
    }

    private Relation getPropertyRelation() {
        if (this.propRelation == null && this.parentMapping != null) {
            return this.parentMapping.getPropertyRelation();
        }
        return this.propRelation;
    }

    public Relation getPropertyRelation(String propname) {
        if (propname == null) {
            return this.getPropertyRelation();
        }
        Relation rel = this.getExactPropertyRelation(propname);
        if (rel == null) {
            rel = this.getPropertyRelation();
        }
        return rel;
    }

    public Relation getExactPropertyRelation(String propname) {
        if (propname == null) {
            return null;
        }
        Relation rel = (Relation)this.prop2db.get(propname.toLowerCase());
        if (rel == null && this.parentMapping != null) {
            rel = this.parentMapping.getExactPropertyRelation(propname);
        }
        return rel;
    }

    public String getSubnodeGroupby() {
        if (this.subRelation == null && this.parentMapping != null) {
            return this.parentMapping.getSubnodeGroupby();
        }
        return this.subRelation == null ? null : this.subRelation.groupby;
    }

    public String getIDgen() {
        if (this.idgen == null && this.parentMapping != null) {
            return this.parentMapping.getIDgen();
        }
        return this.idgen;
    }

    public WrappedNodeManager getWrappedNodeManager() {
        if (this.app == null) {
            throw new RuntimeException("Can't get node manager from internal db mapping");
        }
        return this.app.getWrappedNodeManager();
    }

    public boolean isRelational() {
        return this.dbSourceName != null || this.parentMapping != null && this.parentMapping.isRelational();
    }

    public synchronized DbColumn[] getColumns() throws ClassNotFoundException, SQLException {
        if (!this.isRelational()) {
            throw new SQLException("Can't get columns for non-relational data mapping " + this);
        }
        if (this.columns == null) {
            Connection con = this.getConnection();
            Statement stmt = con.createStatement();
            String table = this.getTableName();
            if (table == null) {
                throw new SQLException("Table name is null in getColumns() for " + this);
            }
            ResultSet rs = stmt.executeQuery("SELECT * FROM " + table + " WHERE 1 = 0");
            if (rs == null) {
                throw new SQLException("Error retrieving columns for " + this);
            }
            ResultSetMetaData meta = rs.getMetaData();
            int ncols = meta.getColumnCount();
            ArrayList<DbColumn> list = new ArrayList<DbColumn>(ncols);
            for (int i = 0; i < ncols; ++i) {
                String colName = meta.getColumnName(i + 1);
                Relation rel = this.columnNameToRelation(colName);
                DbColumn col = new DbColumn(colName, meta.getColumnType(i + 1), rel, this);
                list.add(col);
            }
            this.columns = list.toArray(new DbColumn[list.size()]);
        }
        return this.columns;
    }

    public Relation[] getJoins() {
        return this.joins;
    }

    public DbColumn getColumn(String columnName) throws ClassNotFoundException, SQLException {
        DbColumn col = (DbColumn)this.columnMap.get(columnName);
        if (col == null) {
            DbColumn[] cols = this.columns;
            if (cols == null) {
                cols = this.getColumns();
            }
            for (int i = 0; i < cols.length; ++i) {
                if (!columnName.equalsIgnoreCase(cols[i].getName())) continue;
                col = cols[i];
                break;
            }
            this.columnMap.put(columnName, col);
        }
        return col;
    }

    public StringBuffer getSelect(Relation rel) {
        int i;
        String sel = this.selectString;
        boolean isOracle = this.isOracle();
        if (rel == null && sel != null) {
            return new StringBuffer(sel);
        }
        StringBuffer s = new StringBuffer("SELECT ");
        if (rel != null && rel.queryHints != null) {
            s.append(rel.queryHints).append(" ");
        }
        String table = this.getTableName();
        s.append(table);
        s.append(".*");
        for (i = 0; i < this.joins.length; ++i) {
            if (!this.joins[i].otherType.isRelational()) continue;
            s.append(", ");
            s.append("JOIN_");
            s.append(this.joins[i].propName);
            s.append(".*");
        }
        s.append(" FROM ");
        s.append(table);
        if (rel != null) {
            rel.appendAdditionalTables(s);
        }
        s.append(" ");
        for (i = 0; i < this.joins.length; ++i) {
            if (!this.joins[i].otherType.isRelational()) continue;
            if (isOracle) {
                s.append(", ");
                s.append(this.joins[i].otherType.getTableName());
                s.append(" ");
                s.append("JOIN_");
                s.append(this.joins[i].propName);
                s.append(" ");
                continue;
            }
            s.append("LEFT OUTER JOIN ");
            s.append(this.joins[i].otherType.getTableName());
            s.append(" ");
            s.append("JOIN_");
            s.append(this.joins[i].propName);
            s.append(" ON ");
            this.joins[i].renderJoinConstraints(s, isOracle);
        }
        if (rel == null) {
            this.selectString = s.toString();
        }
        return s;
    }

    public String getInsert() throws ClassNotFoundException, SQLException {
        String ins = this.insertString;
        if (ins != null) {
            return ins;
        }
        StringBuffer b1 = new StringBuffer("INSERT INTO ");
        StringBuffer b2 = new StringBuffer(" ) VALUES ( ");
        b1.append(this.getTableName());
        b1.append(" ( ");
        DbColumn[] cols = this.getColumns();
        boolean needsComma = false;
        for (int i = 0; i < cols.length; ++i) {
            if (!cols[i].isMapped()) continue;
            if (needsComma) {
                b1.append(", ");
                b2.append(", ");
            }
            b1.append(cols[i].getName());
            b2.append("?");
            needsComma = true;
        }
        b1.append(b2.toString());
        b1.append(" )");
        ins = this.insertString = b1.toString();
        return ins;
    }

    public StringBuffer getUpdate() {
        String upd = this.updateString;
        if (upd != null) {
            return new StringBuffer(upd);
        }
        StringBuffer s = new StringBuffer("UPDATE ");
        s.append(this.getTableName());
        s.append(" SET ");
        this.updateString = s.toString();
        return s;
    }

    public boolean needsQuotes(String columnName) throws SQLException, ClassNotFoundException {
        if (this.tableName == null && this.parentMapping != null) {
            return this.parentMapping.needsQuotes(columnName);
        }
        DbColumn col = this.getColumn(columnName);
        if (col == null) {
            return true;
        }
        return col.needsQuotes();
    }

    public void addJoinConstraints(StringBuffer s, String pre) {
        boolean isOracle = this.isOracle();
        String prefix = pre;
        if (!isOracle) {
            return;
        }
        for (int i = 0; i < this.joins.length; ++i) {
            if (!this.joins[i].otherType.isRelational()) continue;
            s.append(prefix);
            this.joins[i].renderJoinConstraints(s, isOracle);
            prefix = " AND ";
        }
    }

    public boolean isOracle() {
        if (this.dbSource != null) {
            return this.dbSource.isOracle();
        }
        if (this.parentMapping != null) {
            return this.parentMapping.isOracle();
        }
        return false;
    }

    public boolean isMySQL() {
        if (this.dbSource != null) {
            return this.dbSource.isMySQL();
        }
        if (this.parentMapping != null) {
            return this.parentMapping.isMySQL();
        }
        return false;
    }

    public boolean isPostgreSQL() {
        if (this.dbSource != null) {
            return this.dbSource.isPostgreSQL();
        }
        if (this.parentMapping != null) {
            return this.parentMapping.isPostgreSQL();
        }
        return false;
    }

    public String toString() {
        if (this.typename == null) {
            return "[unspecified internal DbMapping]";
        }
        return "[" + this.app.getName() + "." + this.typename + "]";
    }

    public long getLastTypeChange() {
        return this.lastTypeChange;
    }

    public long getLastDataChange() {
        if (this.inheritsStorage()) {
            return this.parentMapping.getLastDataChange();
        }
        return this.lastDataChange;
    }

    public void setLastDataChange() {
        if (this.inheritsStorage()) {
            this.parentMapping.setLastDataChange();
        } else {
            ++this.lastDataChange;
            if (!this.dependentMappings.isEmpty()) {
                Iterator it = this.dependentMappings.iterator();
                while (it.hasNext()) {
                    DbMapping dbmap = (DbMapping)it.next();
                    dbmap.setIndirectDataChange();
                }
            }
        }
    }

    protected void setIndirectDataChange() {
        if (this.inheritsStorage()) {
            this.parentMapping.setIndirectDataChange();
        } else {
            ++this.lastDataChange;
        }
    }

    protected synchronized long getNewID(long dbmax) {
        if (this.inheritsStorage()) {
            return this.parentMapping.getNewID(dbmax);
        }
        this.lastID = Math.max(dbmax + 1L, this.lastID + 1L);
        return this.lastID;
    }

    public Enumeration getPropertyEnumeration() {
        HashSet set = new HashSet();
        this.collectPropertyNames(set);
        final Iterator it = set.iterator();
        return new Enumeration(){

            public boolean hasMoreElements() {
                return it.hasNext();
            }

            public Object nextElement() {
                return it.next();
            }
        };
    }

    private void collectPropertyNames(HashSet basket) {
        if (this.parentMapping != null) {
            this.parentMapping.collectPropertyNames(basket);
        }
        if (!this.prop2db.isEmpty()) {
            basket.addAll(this.prop2db.keySet());
        }
    }

    public String getStorageTypeName() {
        if (this.inheritsStorage()) {
            return this.parentMapping.getStorageTypeName();
        }
        return this.dbSourceName == null ? null : this.typename;
    }

    protected boolean inheritsStorage() {
        return this.isRelational() && this.parentMapping != null && this.tableName == null && this.dbSourceName == null;
    }

    public static boolean areStorageCompatible(DbMapping dbm1, DbMapping dbm2) {
        if (dbm1 == null) {
            return dbm2 == null || !dbm2.isRelational();
        }
        return dbm1.isStorageCompatible(dbm2);
    }

    public boolean isStorageCompatible(DbMapping other) {
        if (other == null) {
            return !this.isRelational();
        }
        if (other == this) {
            return true;
        }
        if (this.isRelational()) {
            return this.getTableName().equals(other.getTableName()) && this.getDbSource().equals(other.getDbSource());
        }
        return !other.isRelational();
    }

    public boolean isInstanceOf(String other) {
        if (this.typename != null && this.typename.equals(other)) {
            return true;
        }
        DbMapping p = this.parentMapping;
        while (p != null) {
            if (p.typename != null && p.typename.equals(other)) {
                return true;
            }
            p = p.parentMapping;
        }
        return false;
    }

    public DbMapping getParentMapping() {
        return this.parentMapping;
    }

    public ResourceProperties getProperties() {
        return this.props;
    }

    protected void addDependency(DbMapping dbmap) {
        this.dependentMappings.add(dbmap);
    }

    protected void appendCondition(StringBuffer q, String column, String[] values) throws SQLException, ClassNotFoundException {
        if (values.length == 1) {
            this.appendCondition(q, column, values[0]);
            return;
        }
        if (column.indexOf(40) == -1 && column.indexOf(46) == -1) {
            q.append(this.getTableName()).append(".");
        }
        q.append(column).append(" in (");
        if (this.needsQuotes(column)) {
            for (int i = 0; i < values.length; ++i) {
                if (i > 0) {
                    q.append(", ");
                }
                q.append("'").append(DbMapping.escape(values[i])).append("'");
            }
        } else {
            for (int i = 0; i < values.length; ++i) {
                if (i > 0) {
                    q.append(", ");
                }
                q.append(values[i]);
            }
        }
        q.append(")");
    }

    protected void appendCondition(StringBuffer q, String column, String val) throws SQLException, ClassNotFoundException {
        if (column.indexOf(40) == -1 && column.indexOf(46) == -1) {
            q.append(this.getTableName()).append(".");
        }
        q.append(column).append(" = ");
        if (this.needsQuotes(column)) {
            q.append("'").append(DbMapping.escape(val)).append("'");
        } else {
            q.append(val);
        }
    }

    static String escape(String str) {
        if (str == null) {
            return null;
        }
        if (str.indexOf("'") < 0) {
            return str;
        }
        int l = str.length();
        StringBuffer sbuf = new StringBuffer(l + 10);
        for (int i = 0; i < l; ++i) {
            char c = str.charAt(i);
            if (c == '\'') {
                sbuf.append('\'');
            }
            sbuf.append(c);
        }
        return sbuf.toString();
    }
}

