/*
 * Decompiled with CFR 0.152.
 */
package helma.objectmodel.db;

import helma.objectmodel.db.DbMapping;
import helma.objectmodel.db.Key;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public final class DbKey
implements Key,
Serializable {
    private String storageName;
    private String id;
    private transient int hashcode = 0;
    static final long serialVersionUID = 1618863960930966588L;

    public DbKey(DbMapping dbmap, String id) {
        this.id = id;
        this.storageName = dbmap == null ? null : dbmap.getStorageTypeName();
    }

    public boolean equals(Object what) {
        if (what == this) {
            return true;
        }
        if (!(what instanceof DbKey)) {
            return false;
        }
        DbKey k = (DbKey)what;
        return this.storageName == k.storageName && (this.id == k.id || this.id.equals(k.id));
    }

    public int hashCode() {
        if (this.hashcode == 0) {
            this.hashcode = this.storageName == null ? 17 + 37 * this.id.hashCode() : 17 + 37 * this.storageName.hashCode() + 37 * this.id.hashCode();
        }
        return this.hashcode;
    }

    public Key getParentKey() {
        return null;
    }

    public String getStorageName() {
        return this.storageName;
    }

    public String getID() {
        return this.id;
    }

    public String toString() {
        return this.storageName == null ? "[" + this.id + "]" : this.storageName + "[" + this.id + "]";
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.writeObject(this.storageName);
        stream.writeObject(this.id);
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        this.storageName = (String)stream.readObject();
        this.id = (String)stream.readObject();
        if (this.storageName != null) {
            this.storageName = this.storageName.intern();
        }
    }
}

