/*
 * Decompiled with CFR 0.152.
 */
package helma.objectmodel.db;

import helma.objectmodel.db.DbMapping;
import helma.objectmodel.db.Relation;

public final class DbColumn {
    private final String name;
    private final int type;
    private final Relation relation;
    private final boolean isId;
    private final boolean isPrototype;
    private final boolean isName;

    public DbColumn(String name, int type, Relation rel, DbMapping dbmap) {
        this.name = name;
        this.type = type;
        this.relation = rel;
        if (this.relation != null) {
            this.relation.setColumnType(type);
        }
        this.isId = name.equalsIgnoreCase(dbmap.getIDField());
        this.isPrototype = name.equalsIgnoreCase(dbmap.getPrototypeField());
        this.isName = name.equalsIgnoreCase(dbmap.getNameField());
    }

    public String getName() {
        return this.name;
    }

    public int getType() {
        return this.type;
    }

    public Relation getRelation() {
        return this.relation;
    }

    public boolean isIdField() {
        return this.isId;
    }

    public boolean isPrototypeField() {
        return this.isPrototype;
    }

    public boolean isNameField() {
        return this.isName;
    }

    public boolean isMapped() {
        return this.isId || this.isPrototype || this.isName || this.relation != null && this.relation.isPrimitiveOrReference();
    }

    public boolean needsQuotes() {
        switch (this.type) {
            case -4: 
            case -3: 
            case -2: 
            case -1: 
            case 1: 
            case 12: 
            case 91: 
            case 92: 
            case 93: {
                return true;
            }
        }
        return false;
    }
}

