/*
 * Decompiled with CFR 0.152.
 */
package helma.objectmodel;

import helma.framework.IPathElement;
import helma.objectmodel.INode;
import helma.objectmodel.IProperty;
import helma.objectmodel.Property;
import helma.objectmodel.db.DbMapping;
import helma.objectmodel.db.Node;
import helma.objectmodel.db.Relation;
import helma.util.EmptyEnumeration;
import java.io.Serializable;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

public class TransientNode
implements INode,
Serializable {
    private static long idgen = 0L;
    protected Hashtable propMap;
    protected Hashtable nodeMap;
    protected Vector nodes;
    protected TransientNode parent;
    protected Vector links;
    protected Vector proplinks;
    transient String prototype;
    protected long created;
    protected long lastmodified;
    protected String id;
    protected String name;
    protected boolean anonymous = false;
    transient DbMapping dbmap;
    INode cacheNode;

    public TransientNode() {
        this.name = this.id = TransientNode.generateID();
        this.created = this.lastmodified = System.currentTimeMillis();
    }

    public TransientNode(String n) {
        this.id = TransientNode.generateID();
        this.name = n == null || "".equals(n) ? this.id : n;
        this.created = this.lastmodified = System.currentTimeMillis();
    }

    public static String generateID() {
        return "t" + idgen++;
    }

    public void setDbMapping(DbMapping dbmap) {
        this.dbmap = dbmap;
    }

    public DbMapping getDbMapping() {
        return this.dbmap;
    }

    public String getID() {
        return this.id;
    }

    public boolean isAnonymous() {
        return this.anonymous;
    }

    public String getName() {
        return this.name;
    }

    public String getElementName() {
        return this.anonymous ? this.id : this.name;
    }

    public int getState() {
        return -3;
    }

    public void setState(int s) {
    }

    public String getFullName() {
        return this.getFullName(null);
    }

    public String getFullName(INode root) {
        String divider = null;
        StringBuffer b = new StringBuffer();
        TransientNode p = this;
        while (p != null && p.parent != null && p != root) {
            if (divider != null) {
                b.insert(0, divider);
            } else {
                divider = "/";
            }
            b.insert(0, p.getElementName());
            p = p.parent;
        }
        return b.toString();
    }

    public void setName(String name) {
        this.name = name == null || name.trim().length() == 0 ? this.id : name;
    }

    public String getPrototype() {
        if (this.prototype == null) {
            return "hopobject";
        }
        return this.prototype;
    }

    public void setPrototype(String proto) {
        this.prototype = proto;
    }

    public INode getParent() {
        return this.parent;
    }

    public void setSubnodeRelation(String rel) {
        throw new RuntimeException("Can't set subnode relation for non-persistent Node.");
    }

    public String getSubnodeRelation() {
        return null;
    }

    public int numberOfNodes() {
        return this.nodes == null ? 0 : this.nodes.size();
    }

    public INode addNode(INode elem) {
        return this.addNode(elem, this.numberOfNodes());
    }

    public INode addNode(INode elem, int where) {
        String n;
        if (where < 0 || where > this.numberOfNodes()) {
            where = this.numberOfNodes();
        }
        if ((n = elem.getName()).indexOf(47) > -1) {
            throw new RuntimeException("The name of a node must not contain \"/\" (slash).");
        }
        if (this.nodeMap != null && this.nodeMap.get(elem.getID()) != null) {
            this.nodes.removeElement(elem);
            where = Math.min(where, this.numberOfNodes());
            this.nodes.insertElementAt(elem, where);
            return elem;
        }
        if (this.nodeMap == null) {
            this.nodeMap = new Hashtable();
        }
        if (this.nodes == null) {
            this.nodes = new Vector();
        }
        this.nodeMap.put(elem.getID(), elem);
        this.nodes.insertElementAt(elem, where);
        if (elem instanceof TransientNode) {
            TransientNode node = (TransientNode)elem;
            if (node.parent == null) {
                node.parent = this;
                node.anonymous = true;
            }
        }
        this.lastmodified = System.currentTimeMillis();
        return elem;
    }

    public INode createNode() {
        return this.createNode(null, 0);
    }

    public INode createNode(int where) {
        return this.createNode(null, where);
    }

    public INode createNode(String nm) {
        return this.createNode(nm, this.numberOfNodes());
    }

    public INode createNode(String nm, int where) {
        boolean anon = false;
        if (nm == null || "".equals(nm.trim())) {
            anon = true;
        }
        TransientNode n = new TransientNode(nm);
        if (anon) {
            this.addNode(n, where);
        } else {
            this.setNode(nm, n);
        }
        return n;
    }

    public IPathElement getParentElement() {
        return this.getParent();
    }

    public IPathElement getChildElement(String name) {
        return this.getNode(name);
    }

    public INode getSubnode(String name) {
        StringTokenizer st = new StringTokenizer(name, "/");
        TransientNode retval = this;
        while (st.hasMoreTokens() && retval != null) {
            TransientNode runner = retval;
            String next = st.nextToken().trim().toLowerCase();
            if ("".equals(next)) {
                retval = this;
            } else {
                TransientNode transientNode = retval = runner.nodeMap == null ? null : (TransientNode)runner.nodeMap.get(next);
            }
            if (retval != null) continue;
            retval = (TransientNode)runner.getNode(next);
        }
        return retval;
    }

    public INode getSubnodeAt(int index) {
        return this.nodes == null ? null : (INode)this.nodes.elementAt(index);
    }

    public int contains(INode n) {
        if (n == null || this.nodes == null) {
            return -1;
        }
        return this.nodes.indexOf(n);
    }

    public boolean remove() {
        if (this.anonymous) {
            this.parent.unset(this.name);
        } else {
            this.parent.removeNode(this);
        }
        return true;
    }

    public void removeNode(INode node) {
        this.releaseNode(node);
        TransientNode n = (TransientNode)node;
        if (n.getParent() == this && n.anonymous) {
            int l = n.links == null ? 0 : n.links.size();
            for (int i = 0; i < l; ++i) {
                TransientNode link = (TransientNode)n.links.elementAt(i);
                link.releaseNode(n);
            }
            if (n.proplinks != null) {
                Enumeration e1 = n.proplinks.elements();
                while (e1.hasMoreElements()) {
                    try {
                        Property p = (Property)e1.nextElement();
                        p.node.propMap.remove(p.propname.toLowerCase());
                    }
                    catch (Exception ignore) {}
                }
            }
            Vector v = new Vector();
            Enumeration e3 = n.getSubnodes();
            while (e3.hasMoreElements()) {
                v.addElement(e3.nextElement());
            }
            int m = v.size();
            for (int i = 0; i < m; ++i) {
                n.removeNode((TransientNode)v.elementAt(i));
            }
        } else {
            n.links.removeElement(this);
        }
    }

    protected void releaseNode(INode node) {
        if (this.nodes == null || this.nodeMap == null) {
            return;
        }
        int runner = this.nodes.indexOf(node);
        while (runner > -1 && this.nodes.elementAt(runner) != node) {
            runner = this.nodes.indexOf(node, Math.min(this.nodes.size() - 1, runner + 1));
        }
        if (runner > -1) {
            this.nodes.removeElementAt(runner);
        }
        this.nodeMap.remove(node.getName().toLowerCase());
        this.lastmodified = System.currentTimeMillis();
    }

    public Enumeration getSubnodes() {
        return this.nodes == null ? new Vector().elements() : this.nodes.elements();
    }

    public Enumeration properties() {
        return this.propMap == null ? new EmptyEnumeration() : this.propMap.keys();
    }

    private Property getProperty(String propname) {
        Relation rel;
        Property prop;
        Property property = prop = this.propMap == null ? null : (Property)this.propMap.get(propname);
        if (prop == null && this.dbmap != null && (rel = this.dbmap.getPropertyRelation(propname)) != null && rel.isVirtual()) {
            prop = this.makeVirtualNode(propname, rel);
        }
        return prop;
    }

    private Property makeVirtualNode(String propname, Relation rel) {
        Node node = new Node(rel.getPropName(), rel.getPrototype(), this.dbmap.getWrappedNodeManager());
        node.setDbMapping(rel.getVirtualMapping());
        this.setNode(propname, node);
        return (Property)this.propMap.get(propname);
    }

    public IProperty get(String propname) {
        propname = propname.toLowerCase();
        return this.getProperty(propname);
    }

    public String getString(String propname, String defaultValue) {
        String propValue = this.getString(propname);
        return propValue == null ? defaultValue : propValue;
    }

    public String getString(String propname) {
        propname = propname.toLowerCase();
        Property prop = this.getProperty(propname);
        try {
            return prop.getStringValue();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public long getInteger(String propname) {
        propname = propname.toLowerCase();
        Property prop = this.getProperty(propname);
        try {
            return prop.getIntegerValue();
        }
        catch (Exception exception) {
            return 0L;
        }
    }

    public double getFloat(String propname) {
        propname = propname.toLowerCase();
        Property prop = this.getProperty(propname);
        try {
            return prop.getFloatValue();
        }
        catch (Exception exception) {
            return 0.0;
        }
    }

    public Date getDate(String propname) {
        propname = propname.toLowerCase();
        Property prop = this.getProperty(propname);
        try {
            return prop.getDateValue();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public boolean getBoolean(String propname) {
        propname = propname.toLowerCase();
        Property prop = this.getProperty(propname);
        try {
            return prop.getBooleanValue();
        }
        catch (Exception exception) {
            return false;
        }
    }

    public INode getNode(String propname) {
        propname = propname.toLowerCase();
        Property prop = this.getProperty(propname);
        try {
            return prop.getNodeValue();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public Object getJavaObject(String propname) {
        propname = propname.toLowerCase();
        Property prop = this.getProperty(propname);
        try {
            return prop.getJavaObjectValue();
        }
        catch (Exception exception) {
            return null;
        }
    }

    private Property initProperty(String propname) {
        String p2;
        Property prop;
        if (this.propMap == null) {
            this.propMap = new Hashtable();
        }
        if ((prop = (Property)this.propMap.get(p2 = (propname = propname.trim()).toLowerCase())) == null) {
            prop = new Property(propname, this);
            this.propMap.put(p2, prop);
        }
        return prop;
    }

    public void setString(String propname, String value) {
        Property prop = this.initProperty(propname);
        prop.setStringValue(value);
        this.lastmodified = System.currentTimeMillis();
    }

    public void setInteger(String propname, long value) {
        Property prop = this.initProperty(propname);
        prop.setIntegerValue(value);
        this.lastmodified = System.currentTimeMillis();
    }

    public void setFloat(String propname, double value) {
        Property prop = this.initProperty(propname);
        prop.setFloatValue(value);
        this.lastmodified = System.currentTimeMillis();
    }

    public void setBoolean(String propname, boolean value) {
        Property prop = this.initProperty(propname);
        prop.setBooleanValue(value);
        this.lastmodified = System.currentTimeMillis();
    }

    public void setDate(String propname, Date value) {
        Property prop = this.initProperty(propname);
        prop.setDateValue(value);
        this.lastmodified = System.currentTimeMillis();
    }

    public void setJavaObject(String propname, Object value) {
        Property prop = this.initProperty(propname);
        prop.setJavaObjectValue(value);
        this.lastmodified = System.currentTimeMillis();
    }

    public void setNode(String propname, INode value) {
        Property prop = this.initProperty(propname);
        prop.setNodeValue(value);
        if (value instanceof TransientNode) {
            TransientNode n = (TransientNode)value;
            if (n.parent == null) {
                n.name = propname;
                n.parent = this;
                n.anonymous = false;
            }
        }
        this.lastmodified = System.currentTimeMillis();
    }

    public void unset(String propname) {
        if (this.propMap == null) {
            return;
        }
        try {
            this.propMap.remove(propname.toLowerCase());
            this.lastmodified = System.currentTimeMillis();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public long lastModified() {
        return this.lastmodified;
    }

    public long created() {
        return this.created;
    }

    public String toString() {
        return "TransientNode " + this.name;
    }

    public synchronized INode getCacheNode() {
        if (this.cacheNode == null) {
            this.cacheNode = new TransientNode();
        }
        return this.cacheNode;
    }

    public synchronized void clearCacheNode() {
        this.cacheNode = null;
    }
}

