/*
 * Decompiled with CFR 0.152.
 */
package helma.objectmodel;

import helma.objectmodel.INode;
import helma.objectmodel.IProperty;
import helma.objectmodel.TransientNode;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;

public final class Property
implements IProperty,
Serializable {
    protected String propname;
    protected TransientNode node;
    public String svalue;
    public boolean bvalue;
    public long lvalue;
    public double dvalue;
    public INode nvalue;
    public Object jvalue;
    public int type;

    public Property(TransientNode node) {
        this.node = node;
    }

    public Property(String propname, TransientNode node) {
        this.propname = propname;
        this.node = node;
    }

    public String getName() {
        return this.propname;
    }

    public Object getValue() {
        switch (this.type) {
            case 1: {
                return this.svalue;
            }
            case 2: {
                return new Boolean(this.bvalue);
            }
            case 4: {
                return new Long(this.lvalue);
            }
            case 5: {
                return new Double(this.dvalue);
            }
            case 3: {
                return new Date(this.lvalue);
            }
            case 6: {
                return this.nvalue;
            }
            case 7: {
                return this.jvalue;
            }
        }
        return null;
    }

    public void setStringValue(String value) {
        if (this.type == 6) {
            this.nvalue = null;
        }
        if (this.type == 7) {
            this.jvalue = null;
        }
        this.type = 1;
        this.svalue = value;
    }

    public void setIntegerValue(long value) {
        if (this.type == 6) {
            this.nvalue = null;
        }
        if (this.type == 7) {
            this.jvalue = null;
        }
        this.type = 4;
        this.lvalue = value;
    }

    public void setFloatValue(double value) {
        if (this.type == 6) {
            this.nvalue = null;
        }
        if (this.type == 7) {
            this.jvalue = null;
        }
        this.type = 5;
        this.dvalue = value;
    }

    public void setDateValue(Date value) {
        if (this.type == 6) {
            this.nvalue = null;
        }
        if (this.type == 7) {
            this.jvalue = null;
        }
        this.type = 3;
        this.lvalue = value.getTime();
    }

    public void setBooleanValue(boolean value) {
        if (this.type == 6) {
            this.nvalue = null;
        }
        if (this.type == 7) {
            this.jvalue = null;
        }
        this.type = 2;
        this.bvalue = value;
    }

    public void setNodeValue(INode value) {
        if (this.type == 7) {
            this.jvalue = null;
        }
        this.type = 6;
        this.nvalue = value;
    }

    public void setJavaObjectValue(Object value) {
        if (this.type == 6) {
            this.nvalue = null;
        }
        this.type = 7;
        this.jvalue = value;
    }

    public String getStringValue() {
        switch (this.type) {
            case 1: {
                return this.svalue;
            }
            case 2: {
                return "" + this.bvalue;
            }
            case 3: {
                SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                return format.format(new Date(this.lvalue));
            }
            case 4: {
                return Long.toString(this.lvalue);
            }
            case 5: {
                return Double.toString(this.dvalue);
            }
            case 6: {
                return this.nvalue.getName();
            }
            case 7: {
                return this.jvalue == null ? null : this.jvalue.toString();
            }
        }
        return "";
    }

    public String toString() {
        return this.getStringValue();
    }

    public long getIntegerValue() {
        if (this.type == 4) {
            return this.lvalue;
        }
        return 0L;
    }

    public double getFloatValue() {
        if (this.type == 5) {
            return this.dvalue;
        }
        return 0.0;
    }

    public Date getDateValue() {
        if (this.type == 3) {
            return new Date(this.lvalue);
        }
        return null;
    }

    public boolean getBooleanValue() {
        if (this.type == 2) {
            return this.bvalue;
        }
        return false;
    }

    public INode getNodeValue() {
        if (this.type == 6) {
            return this.nvalue;
        }
        return null;
    }

    public Object getJavaObjectValue() {
        if (this.type == 7) {
            return this.jvalue;
        }
        return null;
    }

    public int getType() {
        return this.type;
    }
}

