/*
 * Decompiled with CFR 0.152.
 */
package helma.main;

import helma.extensions.HelmaExtension;
import helma.framework.core.Application;
import helma.framework.repository.FileResource;
import helma.main.ApplicationManager;
import helma.main.Config;
import helma.main.HelmaShutdownHook;
import helma.main.HelmaSocketFactory;
import helma.objectmodel.db.DbSource;
import helma.util.Logging;
import helma.util.ResourceProperties;
import java.io.File;
import java.io.IOException;
import java.rmi.registry.LocateRegistry;
import java.rmi.server.RMISocketFactory;
import java.util.Hashtable;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.TimeZone;
import java.util.Vector;
import org.apache.commons.logging.LogFactory;
import org.apache.xmlrpc.WebServer;
import org.apache.xmlrpc.XmlRpc;
import org.mortbay.http.HttpServer;
import org.mortbay.http.ajp.AJP13Listener;
import org.mortbay.util.Frame;
import org.mortbay.util.InetAddrPort;
import org.mortbay.util.Log;
import org.mortbay.util.LogSink;
import org.mortbay.util.MultiException;

public class Server
implements Runnable {
    public static final String version = "1.6.0 (June 21 2007)";
    private static Server server;
    protected File hopHome;
    ResourceProperties appsProps;
    ResourceProperties dbProps;
    ResourceProperties sysProps;
    private org.apache.commons.logging.Log logger;
    private boolean helmaLogging;
    public final long starttime;
    public boolean paranoid;
    private ApplicationManager appManager;
    private Vector extensions;
    private Thread mainThread;
    InetAddrPort rmiPort = null;
    InetAddrPort xmlrpcPort = null;
    InetAddrPort websrvPort = null;
    InetAddrPort ajp13Port = null;
    Hashtable dbSources;
    protected HttpServer http;
    protected AJP13Listener ajp13;
    protected WebServer xmlrpc;
    Thread shutdownhook;

    public Server(Config config) {
        server = this;
        this.starttime = System.currentTimeMillis();
        this.rmiPort = config.rmiPort;
        this.xmlrpcPort = config.xmlrpcPort;
        this.websrvPort = config.websrvPort;
        this.ajp13Port = config.ajp13Port;
        this.hopHome = config.homeDir;
        this.sysProps = new ResourceProperties();
        this.sysProps.addResource(new FileResource(config.propFile));
    }

    public static void main(String[] args) {
        Server.checkJavaVersion();
        Config config = null;
        try {
            config = Server.getConfig(args);
        }
        catch (Exception cex) {
            Server.printUsageError("error reading configuration: " + cex.getMessage());
            System.exit(1);
        }
        Server.checkRunning(config);
        server = new Server(config);
        server.init();
        server.start();
    }

    public static void checkJavaVersion() {
        String javaVersion = System.getProperty("java.version");
        if (javaVersion == null || javaVersion.startsWith("1.3") || javaVersion.startsWith("1.2") || javaVersion.startsWith("1.1") || javaVersion.startsWith("1.0")) {
            System.err.println("This version of Helma requires Java 1.4 or greater.");
            if (javaVersion == null) {
                System.err.println("Your Java Runtime did not provide a version number. Please update to a more recent version.");
            } else {
                System.err.println("Your Java Runtime is version " + javaVersion + ". Please update to a more recent version.");
            }
            System.exit(1);
        }
    }

    public static Config getConfig(String[] args) throws Exception {
        Config config = new Config();
        if (System.getProperty("helma.home") != null) {
            config.homeDir = new File(System.getProperty("helma.home"));
        }
        Server.parseArgs(config, args);
        Server.guessConfig(config);
        ResourceProperties sysProps = new ResourceProperties();
        sysProps.addResource(new FileResource(config.propFile));
        if (config.websrvPort == null && sysProps.getProperty("webPort") != null) {
            try {
                config.websrvPort = new InetAddrPort(sysProps.getProperty("webPort"));
            }
            catch (Exception portx) {
                throw new Exception("Error parsing web server port property from server.properties: " + portx);
            }
        }
        if (config.ajp13Port == null && sysProps.getProperty("ajp13Port") != null) {
            try {
                config.ajp13Port = new InetAddrPort(sysProps.getProperty("ajp13Port"));
            }
            catch (Exception portx) {
                throw new Exception("Error parsing AJP1.3 server port property from server.properties: " + portx);
            }
        }
        if (config.rmiPort == null && sysProps.getProperty("rmiPort") != null) {
            try {
                config.rmiPort = new InetAddrPort(sysProps.getProperty("rmiPort"));
            }
            catch (Exception portx) {
                throw new Exception("Error parsing RMI server port property from server.properties: " + portx);
            }
        }
        if (config.xmlrpcPort == null && sysProps.getProperty("xmlrpcPort") != null) {
            try {
                config.xmlrpcPort = new InetAddrPort(sysProps.getProperty("xmlrpcPort"));
            }
            catch (Exception portx) {
                throw new Exception("Error parsing XML-RPC server port property from server.properties: " + portx);
            }
        }
        return config;
    }

    public static void parseArgs(Config config, String[] args) throws Exception {
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-h") && i + 1 < args.length) {
                config.homeDir = new File(args[++i]);
                continue;
            }
            if (args[i].equals("-f") && i + 1 < args.length) {
                config.propFile = new File(args[++i]);
                continue;
            }
            if (args[i].equals("-p") && i + 1 < args.length) {
                try {
                    config.rmiPort = new InetAddrPort(args[++i]);
                    continue;
                }
                catch (Exception portx) {
                    throw new Exception("Error parsing RMI server port property: " + portx);
                }
            }
            if (args[i].equals("-x") && i + 1 < args.length) {
                try {
                    config.xmlrpcPort = new InetAddrPort(args[++i]);
                    continue;
                }
                catch (Exception portx) {
                    throw new Exception("Error parsing XML-RPC server port property: " + portx);
                }
            }
            if (args[i].equals("-w") && i + 1 < args.length) {
                try {
                    config.websrvPort = new InetAddrPort(args[++i]);
                    continue;
                }
                catch (Exception portx) {
                    throw new Exception("Error parsing web server port property: " + portx);
                }
            }
            if (args[i].equals("-jk") && i + 1 < args.length) {
                try {
                    config.ajp13Port = new InetAddrPort(args[++i]);
                    continue;
                }
                catch (Exception portx) {
                    throw new Exception("Error parsing AJP1.3 server port property: " + portx);
                }
            }
            if (args[i].equals("-i") && i + 1 < args.length) {
                ++i;
                continue;
            }
            throw new Exception("Unknown command line token: " + args[i]);
        }
    }

    public static void guessConfig(Config config) throws Exception {
        if (config.propFile == null) {
            config.propFile = config.homeDir != null ? new File(config.homeDir, "server.properties") : new File("server.properties");
        }
        ResourceProperties sysProps = new ResourceProperties();
        sysProps.addResource(new FileResource(config.propFile));
        if (config.homeDir == null && sysProps.getProperty("hophome") != null) {
            config.homeDir = new File(sysProps.getProperty("hophome"));
        }
        if (config.homeDir == null && config.propFile != null) {
            config.homeDir = config.propFile.getAbsoluteFile().getParentFile();
        }
        if (!config.hasPropFile()) {
            throw new Exception("no server.properties found");
        }
        if (!config.hasHomeDir()) {
            throw new Exception("couldn't determine helma directory");
        }
        try {
            config.homeDir = config.homeDir.getCanonicalFile();
        }
        catch (IOException iox) {
            config.homeDir = config.homeDir.getAbsoluteFile();
        }
    }

    public static void printUsageError(String msg) {
        System.out.println(msg);
        Server.printUsageError();
    }

    public static void printUsageError() {
        System.out.println("");
        System.out.println("Usage: java helma.main.Server [options]");
        System.out.println("Possible options:");
        System.out.println("  -h dir       Specify hop home directory");
        System.out.println("  -f file      Specify server.properties file");
        System.out.println("  -w [ip:]port      Specify embedded web server address/port");
        System.out.println("  -x [ip:]port      Specify XML-RPC address/port");
        System.out.println("  -jk [ip:]port     Specify AJP13 address/port");
        System.out.println("  -p [ip:]port      Specify RMI address/port");
        System.out.println("");
        System.out.println("Supported formats for server ports:");
        System.out.println("   <port-number>");
        System.out.println("   <ip-address>:<port-number>");
        System.out.println("   <hostname>:<port-number>");
        System.out.println("");
        System.err.println("Usage Error - exiting");
        System.out.println("");
    }

    public static void checkRunning(Config config) {
        try {
            if (config.websrvPort != null) {
                Server.checkPort(config.websrvPort);
            }
            if (config.rmiPort != null) {
                Server.checkPort(config.rmiPort);
            }
            if (config.xmlrpcPort != null) {
                Server.checkPort(config.xmlrpcPort);
            }
            if (config.ajp13Port != null) {
                Server.checkPort(config.ajp13Port);
            }
        }
        catch (Exception running) {
            System.out.println(running.getMessage());
            System.exit(1);
        }
    }

    private static void checkPort(InetAddrPort addrPort) throws Exception {
    }

    public void init() {
        String logFactory = this.sysProps.getProperty("loggerFactory", "helma.util.Logging");
        this.helmaLogging = "helma.util.Logging".equals(logFactory);
        System.setProperty("org.apache.commons.logging.LogFactory", logFactory);
        System.setProperty("user.dir", this.hopHome.getPath());
        this.getLogger();
        String startMessage = "Starting Helma 1.6.0 (June 21 2007) on Java " + System.getProperty("java.version");
        this.logger.info((Object)startMessage);
        System.out.println(startMessage);
        this.logger.info((Object)("Setting Helma Home to " + this.hopHome));
        this.dbProps = new ResourceProperties();
        this.dbProps.setIgnoreCase(false);
        this.dbProps.addResource(new FileResource(new File(this.hopHome, "db.properties")));
        DbSource.setDefaultProps(this.dbProps);
        String appsPropfile = this.sysProps.getProperty("appsPropFile");
        File file = appsPropfile != null && !"".equals(appsPropfile.trim()) ? new File(appsPropfile) : new File(this.hopHome, "apps.properties");
        this.appsProps = new ResourceProperties();
        this.appsProps.setIgnoreCase(true);
        this.appsProps.addResource(new FileResource(file));
        this.paranoid = "true".equalsIgnoreCase(this.sysProps.getProperty("paranoid"));
        String language = this.sysProps.getProperty("language");
        String country = this.sysProps.getProperty("country");
        String timezone = this.sysProps.getProperty("timezone");
        if (language != null && country != null) {
            Locale.setDefault(new Locale(language, country));
        }
        if (timezone != null) {
            TimeZone.setDefault(TimeZone.getTimeZone(timezone));
        }
        this.dbSources = new Hashtable();
        this.extensions = new Vector();
        if (this.sysProps.getProperty("extensions") != null) {
            this.initExtensions();
        }
    }

    private void initExtensions() {
        StringTokenizer tok = new StringTokenizer(this.sysProps.getProperty("extensions"), ",");
        while (tok.hasMoreTokens()) {
            String extClassName = tok.nextToken().trim();
            try {
                Class<?> extClass = Class.forName(extClassName);
                HelmaExtension ext = (HelmaExtension)extClass.newInstance();
                ext.init(this);
                this.extensions.add(ext);
                this.logger.info((Object)("Loaded: " + extClassName));
            }
            catch (Throwable e) {
                this.logger.error((Object)("Error loading extension " + extClassName + ": " + e.toString()));
            }
        }
    }

    public void start() {
        this.mainThread = new Thread(this);
        this.mainThread.start();
    }

    public void stop() {
        this.mainThread = null;
        this.getLogger().info((Object)"Shutting down Helma");
        this.appManager.stopAll();
        if (this.http != null) {
            try {
                this.http.stop();
                this.http.destroy();
            }
            catch (InterruptedException irx) {
                // empty catch block
            }
        }
        if (this.xmlrpc != null) {
            try {
                this.xmlrpc.shutdown();
            }
            catch (Exception x) {
                // empty catch block
            }
        }
        if (this.helmaLogging) {
            Logging.shutdown();
        }
        server = null;
        try {
            Runtime.getRuntime().removeShutdownHook(this.shutdownhook);
            this.shutdownhook.start();
            this.shutdownhook = null;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void run() {
        try {
            StringTokenizer st;
            if (this.websrvPort != null || this.ajp13Port != null) {
                this.http = new HttpServer();
                Log.instance().add((LogSink)new HelmaLogSink());
            }
            if (this.websrvPort != null) {
                this.http.addListener(this.websrvPort);
            }
            if (this.ajp13Port != null) {
                this.ajp13 = new AJP13Listener(this.ajp13Port);
                this.ajp13.setHttpServer(this.http);
                String jkallow = this.sysProps.getProperty("allowAJP13");
                if (jkallow == null) {
                    jkallow = "127.0.0.1";
                }
                StringTokenizer st2 = new StringTokenizer(jkallow, " ,;");
                String[] jkallowarr = new String[st2.countTokens()];
                int cnt = 0;
                while (st2.hasMoreTokens()) {
                    jkallowarr[cnt] = st2.nextToken();
                    ++cnt;
                }
                this.ajp13.setRemoteServers(jkallowarr);
                this.logger.info((Object)("Starting AJP13-Listener on port " + this.ajp13Port));
            }
            if (this.xmlrpcPort != null) {
                String xmlparser = this.sysProps.getProperty("xmlparser");
                if (xmlparser != null) {
                    XmlRpc.setDriver((String)xmlparser);
                }
                this.xmlrpc = this.xmlrpcPort.getInetAddress() != null ? new WebServer(this.xmlrpcPort.getPort(), this.xmlrpcPort.getInetAddress()) : new WebServer(this.xmlrpcPort.getPort());
                if (this.paranoid) {
                    this.xmlrpc.setParanoid(true);
                    String xallow = this.sysProps.getProperty("allowXmlRpc");
                    if (xallow != null) {
                        st = new StringTokenizer(xallow, " ,;");
                        while (st.hasMoreTokens()) {
                            this.xmlrpc.acceptClient(st.nextToken());
                        }
                    }
                }
                this.xmlrpc.start();
                this.logger.info((Object)("Starting XML-RPC server on port " + this.xmlrpcPort));
            }
            if (this.rmiPort != null) {
                if (this.paranoid) {
                    HelmaSocketFactory factory = new HelmaSocketFactory();
                    String rallow = this.sysProps.getProperty("allowWeb");
                    if (rallow == null) {
                        rallow = this.sysProps.getProperty("allowRMI");
                    }
                    if (rallow != null) {
                        st = new StringTokenizer(rallow, " ,;");
                        while (st.hasMoreTokens()) {
                            factory.addAddress(st.nextToken());
                        }
                    }
                    RMISocketFactory.setSocketFactory(factory);
                }
                this.logger.info((Object)("Starting RMI server on port " + this.rmiPort));
                LocateRegistry.createRegistry(this.rmiPort.getPort());
                this.appManager = new ApplicationManager(this.appsProps, this, this.rmiPort.getPort());
            } else {
                this.appManager = new ApplicationManager(this.appsProps, this, 0);
            }
            if (this.xmlrpc != null) {
                this.xmlrpc.addHandler("$default", (Object)this.appManager);
            }
            this.shutdownhook = new HelmaShutdownHook();
            Runtime.getRuntime().addShutdownHook(this.shutdownhook);
        }
        catch (Exception x) {
            throw new RuntimeException("Error setting up Server", x);
        }
        try {
            String secManClass = this.sysProps.getProperty("securityManager");
            if (secManClass != null) {
                SecurityManager secMan = (SecurityManager)Class.forName(secManClass).newInstance();
                System.setSecurityManager(secMan);
                this.logger.info((Object)("Setting security manager to " + secManClass));
            }
        }
        catch (Exception x) {
            this.logger.error((Object)"Error setting security manager", (Throwable)x);
        }
        if (this.http != null) {
            try {
                this.http.start();
            }
            catch (MultiException m) {
                throw new RuntimeException("Error starting embedded web server", m);
            }
        }
        if (this.ajp13 != null) {
            try {
                this.ajp13.start();
            }
            catch (Exception m) {
                throw new RuntimeException("Error starting AJP13 listener: " + m);
            }
        }
        this.appManager.startAll();
        while (Thread.currentThread() == this.mainThread) {
            try {
                Thread.sleep(3000L);
            }
            catch (InterruptedException ie) {
                // empty catch block
            }
            try {
                this.appManager.checkForChanges();
            }
            catch (Exception x) {
                this.logger.warn((Object)("Caught in app manager loop: " + x));
            }
        }
    }

    public void checkAppManager(int port) {
        if (this.appManager == null) {
            this.appManager = new ApplicationManager(this.appsProps, this, port);
        }
    }

    public Object[] getApplications() {
        return this.appManager.getApplications();
    }

    public Application getApplication(String name) {
        return this.appManager.getApplication(name);
    }

    public org.apache.commons.logging.Log getLogger() {
        if (this.logger == null) {
            if (this.helmaLogging) {
                String logDir = this.sysProps.getProperty("logdir", "log");
                if (!"console".equals(logDir)) {
                    File dir = new File(logDir);
                    if (!dir.isAbsolute()) {
                        dir = new File(this.hopHome, logDir);
                    }
                    logDir = dir.getAbsolutePath();
                }
                System.setProperty("helma.logdir", logDir);
            }
            this.logger = LogFactory.getLog((String)"helma.server");
        }
        return this.logger;
    }

    public File getHopHome() {
        return this.hopHome;
    }

    public static Server getServer() {
        return server;
    }

    public static WebServer getXmlRpcServer() {
        return Server.server.xmlrpc;
    }

    public String getProperty(String key) {
        return (String)this.sysProps.get(key);
    }

    public ResourceProperties getProperties() {
        return this.sysProps;
    }

    public ResourceProperties getDbProperties() {
        return this.dbProps;
    }

    public ResourceProperties getAppsProperties(String appName) {
        return this.appsProps.getSubProperties(appName + ".");
    }

    public File getAppsHome() {
        String appHome = this.sysProps.getProperty("appHome", "");
        if (appHome.trim().length() != 0) {
            return new File(appHome);
        }
        return new File(this.hopHome, "apps");
    }

    public File getDbHome() {
        String dbHome = this.sysProps.getProperty("dbHome", "");
        if (dbHome.trim().length() != 0) {
            return new File(dbHome);
        }
        return new File(this.hopHome, "db");
    }

    public Vector getExtensions() {
        return this.extensions;
    }

    public void startApplication(String name) {
        this.appManager.start(name);
        this.appManager.register(name);
    }

    public void stopApplication(String name) {
        this.appManager.stop(name);
    }

    class HelmaLogSink
    implements LogSink {
        HelmaLogSink() {
        }

        public String getOptions() {
            return null;
        }

        public void log(String formattedLog) {
            Server.this.getLogger().info((Object)formattedLog);
        }

        public void log(String tag, Object msg, Frame frame, long time) {
            Server.this.getLogger().info(msg);
        }

        public void setOptions(String options) {
        }

        public boolean isStarted() {
            return true;
        }

        public void start() {
        }

        public void stop() {
        }
    }
}

