/*
 * Decompiled with CFR 0.152.
 */
package helma.main;

import helma.framework.core.Application;
import helma.main.Config;
import helma.main.Server;
import java.io.File;
import java.util.Vector;

public class CommandlineRunner {
    public static void main(String[] args) throws Exception {
        Server server;
        block12: {
            Config config = new Config();
            String commandStr = null;
            Vector<String> funcArgs = new Vector<String>();
            if (System.getProperty("helma.home") != null) {
                config.homeDir = new File(System.getProperty("helma.home"));
            }
            for (int i = 0; i < args.length; ++i) {
                if (args[i].equals("-h") && i + 1 < args.length) {
                    config.homeDir = new File(args[++i]);
                    continue;
                }
                if (args[i].equals("-f") && i + 1 < args.length) {
                    config.propFile = new File(args[++i]);
                    continue;
                }
                if (commandStr != null) {
                    funcArgs.add(args[i]);
                    continue;
                }
                if (i % 2 != 0 || args[i].startsWith("-")) continue;
                commandStr = args[i];
            }
            try {
                Server.guessConfig(config);
            }
            catch (Exception ex) {
                CommandlineRunner.printUsageError(ex.toString());
                System.exit(1);
            }
            String appName = null;
            String function = null;
            try {
                int pos1 = commandStr.indexOf(".");
                appName = commandStr.substring(0, pos1);
                function = commandStr.substring(pos1 + 1);
            }
            catch (Exception ex) {
                CommandlineRunner.printUsageError();
                System.exit(1);
            }
            server = new Server(config);
            server.init();
            server.checkAppManager(0);
            server.startApplication(appName);
            Application app = server.getApplication(appName);
            try {
                Object result = app.executeExternal(function, funcArgs);
                if (result != null) {
                    System.out.println(result.toString());
                }
            }
            catch (Exception ex) {
                System.out.println("Error in application " + appName + ":");
                System.out.println(ex.getMessage());
                if (!"true".equals(server.getProperty("debug"))) break block12;
                System.out.println("");
                ex.printStackTrace();
            }
        }
        server.stop();
    }

    public static void printUsageError(String msg) {
        System.out.println(msg);
        CommandlineRunner.printUsageError();
    }

    public static void printUsageError() {
        System.out.println("");
        System.out.println("Error parsing command");
        System.out.println("");
        System.out.println("Usage: java helma.main.launcher.Commandline [options] [appname].[function] [argument-list]");
        System.out.println("");
        System.out.println("Possible options:");
        System.out.println("  -h dir       Specify hop home directory");
        System.out.println("  -f file      Specify server.properties file");
        System.out.println("");
    }
}

