/*
 * Decompiled with CFR 0.152.
 */
package helma.main;

import helma.framework.core.Application;
import helma.framework.core.RemoteApplication;
import helma.framework.repository.FileRepository;
import helma.framework.repository.Repository;
import helma.main.Server;
import helma.util.ResourceProperties;
import helma.util.StringUtils;
import java.io.File;
import java.rmi.Naming;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.xmlrpc.XmlRpcHandler;
import org.mortbay.http.HttpContext;
import org.mortbay.http.HttpHandler;
import org.mortbay.http.handler.ResourceHandler;
import org.mortbay.jetty.servlet.ServletHandler;
import org.mortbay.jetty.servlet.ServletHolder;

public class ApplicationManager
implements XmlRpcHandler {
    private Hashtable descriptors;
    private Hashtable applications;
    private Hashtable xmlrpcHandlers;
    private int rmiPort;
    private ResourceProperties props;
    private Server server;
    private long lastModified;
    static /* synthetic */ Class class$java$lang$String;

    public ApplicationManager(ResourceProperties props, Server server, int port) {
        this.props = props;
        this.server = server;
        this.rmiPort = port;
        this.descriptors = new Hashtable();
        this.applications = new Hashtable();
        this.xmlrpcHandlers = new Hashtable();
        this.lastModified = 0L;
    }

    protected void checkForChanges() {
        if (this.props.lastModified() > this.lastModified) {
            try {
                Enumeration e = this.props.keys();
                while (e.hasMoreElements()) {
                    String appName = (String)e.nextElement();
                    if (appName.indexOf(".") != -1 || this.applications.get(appName) != null) continue;
                    AppDescriptor appDesc = new AppDescriptor(appName);
                    appDesc.start();
                    appDesc.bind();
                }
                e = this.descriptors.elements();
                while (e.hasMoreElements()) {
                    AppDescriptor appDesc = (AppDescriptor)e.nextElement();
                    if (!this.props.containsKey(appDesc.appName)) {
                        appDesc.stop();
                        continue;
                    }
                    if (this.server.http == null) continue;
                    appDesc.unbind();
                    AppDescriptor ndesc = new AppDescriptor(appDesc.appName);
                    ndesc.app = appDesc.app;
                    ndesc.bind();
                    this.descriptors.put(ndesc.appName, ndesc);
                }
            }
            catch (Exception mx) {
                this.server.getLogger().error((Object)"Error checking applications", (Throwable)mx);
            }
            this.lastModified = System.currentTimeMillis();
        }
    }

    public void start(String appName) {
        AppDescriptor desc = new AppDescriptor(appName);
        desc.start();
    }

    public void register(String appName) {
        AppDescriptor desc = (AppDescriptor)this.descriptors.get(appName);
        if (desc != null) {
            desc.bind();
        }
    }

    public void stop(String appName) {
        AppDescriptor desc = (AppDescriptor)this.descriptors.get(appName);
        if (desc != null) {
            desc.stop();
        }
    }

    public void startAll() {
        try {
            Enumeration e = this.props.keys();
            while (e.hasMoreElements()) {
                String appName = (String)e.nextElement();
                if (appName.indexOf(".") != -1) continue;
                String appValue = this.props.getProperty(appName);
                if (appValue != null && appValue.length() > 0) {
                    appName = appValue;
                }
                AppDescriptor desc = new AppDescriptor(appName);
                desc.start();
            }
            e = this.descriptors.elements();
            while (e.hasMoreElements()) {
                AppDescriptor appDesc = (AppDescriptor)e.nextElement();
                appDesc.bind();
            }
            this.lastModified = System.currentTimeMillis();
        }
        catch (Exception mx) {
            this.server.getLogger().error((Object)"Error starting applications", (Throwable)mx);
            mx.printStackTrace();
        }
    }

    public void stopAll() {
        Enumeration en = this.descriptors.elements();
        while (en.hasMoreElements()) {
            try {
                AppDescriptor appDesc = (AppDescriptor)en.nextElement();
                appDesc.stop();
            }
            catch (Exception exception) {}
        }
    }

    public Object[] getApplications() {
        return this.applications.values().toArray();
    }

    public Application getApplication(String name) {
        return (Application)this.applications.get(name);
    }

    public Object execute(String method, Vector params) throws Exception {
        int dot = method.indexOf(".");
        if (dot == -1) {
            throw new Exception("Method name \"" + method + "\" does not specify a handler application");
        }
        if (dot == 0 || dot == method.length() - 1) {
            throw new Exception("\"" + method + "\" is not a valid XML-RPC method name");
        }
        String handler = method.substring(0, dot);
        String method2 = method.substring(dot + 1);
        Application app = (Application)this.xmlrpcHandlers.get(handler);
        if (app == null) {
            app = (Application)this.xmlrpcHandlers.get("*");
            method2 = method;
        }
        if (app == null) {
            throw new Exception("Handler \"" + handler + "\" not found for " + method);
        }
        return app.executeXmlRpc(method2, params);
    }

    private String getMountpoint(String mountpoint) {
        if ("".equals(mountpoint = mountpoint.trim())) {
            return "/";
        }
        if (!mountpoint.startsWith("/")) {
            return "/" + mountpoint;
        }
        return mountpoint;
    }

    private String joinMountpoint(String prefix, String suffix) {
        if (prefix.endsWith("/") || suffix.startsWith("/")) {
            return prefix + suffix;
        }
        return prefix + "/" + suffix;
    }

    private String getPathPattern(String mountpoint) {
        if (!mountpoint.startsWith("/")) {
            mountpoint = "/" + mountpoint;
        }
        if ("/".equals(mountpoint)) {
            return "/";
        }
        if (mountpoint.endsWith("/")) {
            return mountpoint + "*";
        }
        return mountpoint + "/*";
    }

    private File getAbsoluteFile(String path) {
        File file = new File(path);
        if (file.isAbsolute()) {
            return file;
        }
        return file.getAbsoluteFile();
    }

    class AppDescriptor {
        Application app;
        String appName;
        File appDir;
        File dbDir;
        String mountpoint;
        String pathPattern;
        String staticDir;
        String protectedStaticDir;
        String staticMountpoint;
        boolean staticIndex;
        String[] staticHome;
        String xmlrpcHandlerName;
        String cookieDomain;
        String sessionCookieName;
        String protectedSessionCookie;
        String uploadLimit;
        String uploadSoftfail;
        String debug;
        boolean encode;
        Repository[] repositories;
        String ignoreDirs;

        AppDescriptor(String name) {
            ResourceProperties conf = ApplicationManager.this.props.getSubProperties(name + '.');
            this.appName = name;
            this.mountpoint = ApplicationManager.this.getMountpoint(conf.getProperty("mountpoint", this.appName));
            this.pathPattern = ApplicationManager.this.getPathPattern(this.mountpoint);
            this.staticDir = conf.getProperty("static");
            this.staticMountpoint = ApplicationManager.this.getPathPattern(conf.getProperty("staticMountpoint", ApplicationManager.this.joinMountpoint(this.mountpoint, "static")));
            this.staticIndex = "true".equalsIgnoreCase(conf.getProperty("staticIndex"));
            String home = conf.getProperty("staticHome");
            this.staticHome = home == null ? new String[]{"index.html", "index.htm"} : StringUtils.split(home, ",");
            this.protectedStaticDir = conf.getProperty("protectedStatic");
            this.cookieDomain = conf.getProperty("cookieDomain");
            this.sessionCookieName = conf.getProperty("sessionCookieName");
            this.protectedSessionCookie = conf.getProperty("protectedSessionCookie");
            this.uploadLimit = conf.getProperty("uploadLimit");
            this.uploadSoftfail = conf.getProperty("uploadSoftfail");
            this.debug = conf.getProperty("debug");
            this.encode = "true".equalsIgnoreCase(conf.getProperty("responseEncoding"));
            String appDirName = conf.getProperty("appdir");
            this.appDir = appDirName == null ? null : ApplicationManager.this.getAbsoluteFile(appDirName);
            String dbDirName = conf.getProperty("dbdir");
            this.dbDir = dbDirName == null ? null : ApplicationManager.this.getAbsoluteFile(dbDirName);
            this.ignoreDirs = conf.getProperty("ignore");
            ArrayList<Repository> repositoryList = new ArrayList<Repository>();
            Class[] parameters = new Class[]{class$java$lang$String == null ? (class$java$lang$String = ApplicationManager.class$("java.lang.String")) : class$java$lang$String};
            int i = 0;
            while (true) {
                String repositoryArgs;
                if ((repositoryArgs = conf.getProperty("repository." + i)) != null) {
                    String repositoryImpl = conf.getProperty("repository." + i + ".implementation");
                    if (repositoryImpl == null) {
                        repositoryImpl = repositoryArgs.endsWith(".zip") ? "helma.framework.repository.ZipRepository" : (repositoryArgs.endsWith(".js") ? "helma.framework.repository.SingleFileRepository" : "helma.framework.repository.FileRepository");
                    }
                    try {
                        Repository newRepository = (Repository)Class.forName(repositoryImpl).getConstructor(parameters).newInstance(repositoryArgs);
                        repositoryList.add(newRepository);
                    }
                    catch (Exception ex) {
                        ApplicationManager.this.server.getLogger().error((Object)("Adding repository " + repositoryArgs + " failed. " + "Will not use that repository. Check your initArgs!"), (Throwable)ex);
                    }
                } else if (i > 9) break;
                ++i;
            }
            if (this.appDir != null) {
                FileRepository appRep = new FileRepository(this.appDir);
                if (!repositoryList.contains(appRep)) {
                    repositoryList.add(appRep);
                }
            } else if (repositoryList.isEmpty()) {
                repositoryList.add(new FileRepository(new File(ApplicationManager.this.server.getAppsHome(), this.appName)));
            }
            this.repositories = new Repository[repositoryList.size()];
            repositoryList.toArray(this.repositories);
        }

        void start() {
            ApplicationManager.this.server.getLogger().info((Object)("Building application " + this.appName));
            try {
                this.app = new Application(this.appName, ApplicationManager.this.server, this.repositories, this.appDir, this.dbDir);
                ApplicationManager.this.descriptors.put(this.appName, this);
                ApplicationManager.this.applications.put(this.appName, this.app);
                this.app.init(this.ignoreDirs);
                if (!this.app.hasExplicitBaseURI()) {
                    this.app.setBaseURI(this.mountpoint);
                }
                this.app.start();
            }
            catch (Exception x) {
                ApplicationManager.this.server.getLogger().error((Object)("Error creating application " + this.appName), (Throwable)x);
                x.printStackTrace();
            }
        }

        void stop() {
            ApplicationManager.this.server.getLogger().info((Object)("Stopping application " + this.appName));
            this.unbind();
            try {
                this.app.stop();
                ApplicationManager.this.server.getLogger().info((Object)("Stopped application " + this.appName));
            }
            catch (Exception x) {
                ApplicationManager.this.server.getLogger().error((Object)"Couldn't stop app", (Throwable)x);
            }
            ApplicationManager.this.descriptors.remove(this.appName);
            ApplicationManager.this.applications.remove(this.appName);
        }

        void bind() {
            try {
                ApplicationManager.this.server.getLogger().info((Object)("Binding application " + this.appName));
                if (ApplicationManager.this.rmiPort > 0) {
                    Naming.rebind("//:" + ApplicationManager.this.rmiPort + "/" + this.appName, new RemoteApplication(this.app));
                }
                if (!this.app.hasExplicitBaseURI()) {
                    this.app.setBaseURI(this.mountpoint);
                }
                if (((ApplicationManager)ApplicationManager.this).server.http != null) {
                    HttpContext context = ((ApplicationManager)ApplicationManager.this).server.http.addContext(this.pathPattern);
                    if (this.encode) {
                        ApplicationManager.this.server.getLogger().warn((Object)"Warning: disabling response encoding for Jetty 4.2 compatibility");
                    }
                    ServletHandler handler = new ServletHandler();
                    ServletHolder holder = handler.addServlet(this.appName, "/*", "helma.servlet.EmbeddedServletClient");
                    holder.setInitParameter("application", this.appName);
                    if (this.cookieDomain != null) {
                        holder.setInitParameter("cookieDomain", this.cookieDomain);
                    }
                    if (this.sessionCookieName != null) {
                        holder.setInitParameter("sessionCookieName", this.sessionCookieName);
                    }
                    if (this.protectedSessionCookie != null) {
                        holder.setInitParameter("protectedSessionCookie", this.protectedSessionCookie);
                    }
                    if (this.uploadLimit != null) {
                        holder.setInitParameter("uploadLimit", this.uploadLimit);
                    }
                    if (this.uploadSoftfail != null) {
                        holder.setInitParameter("uploadSoftfail", this.uploadSoftfail);
                    }
                    if (this.debug != null) {
                        holder.setInitParameter("debug", this.debug);
                    }
                    context.addHandler((HttpHandler)handler);
                    if (this.protectedStaticDir != null) {
                        File protectedContent = ApplicationManager.this.getAbsoluteFile(this.protectedStaticDir);
                        context.setResourceBase(protectedContent.getPath());
                        ApplicationManager.this.server.getLogger().info((Object)("Serving protected static from " + protectedContent.getPath()));
                        context.addHandler((HttpHandler)new ResourceHandler());
                    }
                    context.start();
                    if (this.staticDir != null) {
                        File staticContent = ApplicationManager.this.getAbsoluteFile(this.staticDir);
                        ApplicationManager.this.server.getLogger().info((Object)("Serving static from " + staticContent.getPath()));
                        ApplicationManager.this.server.getLogger().info((Object)("Mounting static at " + this.staticMountpoint));
                        context = ((ApplicationManager)ApplicationManager.this).server.http.addContext(this.staticMountpoint);
                        context.setWelcomeFiles(this.staticHome);
                        context.setResourceBase(staticContent.getPath());
                        ResourceHandler rhandler = new ResourceHandler();
                        rhandler.setDirAllowed(this.staticIndex);
                        context.addHandler((HttpHandler)rhandler);
                        context.start();
                    }
                }
                this.xmlrpcHandlerName = this.app.getXmlRpcHandlerName();
                ApplicationManager.this.xmlrpcHandlers.put(this.xmlrpcHandlerName, this.app);
            }
            catch (Exception x) {
                ApplicationManager.this.server.getLogger().error((Object)"Couldn't bind app", (Throwable)x);
                x.printStackTrace();
            }
        }

        void unbind() {
            ApplicationManager.this.server.getLogger().info((Object)("Unbinding application " + this.appName));
            try {
                if (ApplicationManager.this.rmiPort > 0) {
                    Naming.unbind("//:" + ApplicationManager.this.rmiPort + "/" + this.appName);
                }
                if (((ApplicationManager)ApplicationManager.this).server.http != null) {
                    HttpContext context = ((ApplicationManager)ApplicationManager.this).server.http.getContext(null, this.pathPattern);
                    if (context != null) {
                        context.stop();
                        context.destroy();
                    }
                    if (this.staticDir != null && (context = ((ApplicationManager)ApplicationManager.this).server.http.getContext(null, this.staticMountpoint)) != null) {
                        context.stop();
                        context.destroy();
                    }
                }
                if (this.xmlrpcHandlerName != null) {
                    ApplicationManager.this.xmlrpcHandlers.remove(this.xmlrpcHandlerName);
                }
            }
            catch (Exception x) {
                ApplicationManager.this.server.getLogger().error((Object)"Couldn't unbind app", (Throwable)x);
            }
        }

        public String toString() {
            return "[AppDescriptor " + this.app + "]";
        }
    }
}

