/*
 * Decompiled with CFR 0.152.
 */
package helma.image.jimi;

import com.sun.jimi.core.Jimi;
import com.sun.jimi.core.JimiException;
import com.sun.jimi.core.JimiImage;
import com.sun.jimi.core.JimiImageEnumeration;
import com.sun.jimi.core.encoder.jpg.JPGEncoder;
import com.sun.jimi.core.encoder.png.PNGEncoder;
import com.sun.jimi.core.options.FormatOptionSet;
import com.sun.jimi.core.options.JPGOptions;
import com.sun.jimi.core.options.PNGOptions;
import com.sun.jimi.core.raster.JimiRasterImage;
import helma.image.GIFEncoder;
import helma.image.ImageGenerator;
import helma.image.ImageWrapper;
import java.awt.Image;
import java.awt.image.ImageProducer;
import java.io.DataOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class JimiGenerator
extends ImageGenerator {
    protected boolean write(ImageWrapper wrapper, String type, OutputStream out, float quality, boolean alpha) throws IOException {
        try {
            if ("gif".equals(type)) {
                DataOutputStream dataOut = new DataOutputStream(out);
                GIFEncoder encoder = new GIFEncoder();
                encoder.encode(wrapper.getBufferedImage(), dataOut);
            } else {
                JimiRasterImage source = Jimi.createRasterImage((ImageProducer)wrapper.getSource());
                JPGEncoder encoder = null;
                if ("jpg".equals(type) || "jpeg".equals(type)) {
                    encoder = new JPGEncoder();
                    if ((double)quality >= 0.0 && (double)quality <= 1.0) {
                        JPGOptions options = new JPGOptions();
                        options.setQuality(Math.round(quality * 100.0f));
                        source.setOptions((FormatOptionSet)options);
                    }
                } else if ("png".equals(type)) {
                    encoder = new PNGEncoder();
                    ((PNGEncoder)encoder).setAlpha(new Boolean(alpha));
                    PNGOptions options = new PNGOptions();
                    options.setCompressionType(3);
                    source.setOptions((FormatOptionSet)options);
                }
                if (encoder == null) {
                    return false;
                }
                encoder.encodeImages(new JimiImageEnumeration((JimiImage)source), out);
            }
            return true;
        }
        catch (JimiException e) {
            throw new IOException(e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(ImageWrapper wrapper, String filename, float quality, boolean alpha) throws IOException {
        int pos = filename.lastIndexOf(46);
        if (pos != -1) {
            String extension = filename.substring(pos + 1, filename.length()).toLowerCase();
            FileOutputStream out = new FileOutputStream(filename);
            boolean written = false;
            try {
                written = this.write(wrapper, extension, out, quality, alpha);
            }
            finally {
                out.close();
            }
            if (!written) {
                try {
                    Jimi.putImage((Image)wrapper.getImage(), (String)filename);
                }
                catch (JimiException e) {
                    throw new IOException(e.getMessage());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(ImageWrapper wrapper, OutputStream out, String mimeType, float quality, boolean alpha) throws IOException {
        if (mimeType.startsWith("image/")) {
            String type = mimeType.substring(6);
            if (type.startsWith("x-")) {
                type = type.substring(2);
            }
            boolean written = false;
            try {
                written = this.write(wrapper, type, out, quality, alpha);
            }
            finally {
                out.close();
            }
            if (!written) {
                try {
                    Jimi.putImage((String)mimeType, (Image)wrapper.getImage(), (OutputStream)out);
                }
                catch (JimiException e) {
                    throw new IOException(e.getMessage());
                }
            }
        }
    }
}

