/*
 * Decompiled with CFR 0.152.
 */
package helma.image.imageio.gif;

import helma.image.GIFEncoder;
import helma.image.imageio.gif.GIFImageWriteParam;
import helma.image.imageio.gif.GIFImageWriterSpi;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.DataOutput;
import java.io.IOException;
import javax.imageio.IIOImage;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.metadata.IIOMetadata;

public class GIFImageWriter
extends ImageWriter {
    GIFEncoder encoder = new GIFEncoder();

    public GIFImageWriter(GIFImageWriterSpi originatingProvider) {
        super(originatingProvider);
    }

    public void write(IIOMetadata streamMetadata, IIOImage image, ImageWriteParam param) throws IOException {
        RenderedImage ri;
        if (image == null) {
            throw new IllegalArgumentException("image == null");
        }
        if (image.hasRaster()) {
            throw new UnsupportedOperationException("Cannot write rasters");
        }
        Object output = this.getOutput();
        if (output == null) {
            throw new IllegalStateException("output was not set");
        }
        if (param == null) {
            param = this.getDefaultWriteParam();
        }
        if (!((ri = image.getRenderedImage()) instanceof BufferedImage)) {
            throw new IOException("RenderedImage is not a BufferedImage");
        }
        if (!(output instanceof DataOutput)) {
            throw new IOException("output is not a DataOutput");
        }
        this.encoder.encode((BufferedImage)ri, (DataOutput)output, param.getProgressiveMode() != 0, null);
    }

    public IIOMetadata convertStreamMetadata(IIOMetadata inData, ImageWriteParam param) {
        return null;
    }

    public IIOMetadata convertImageMetadata(IIOMetadata inData, ImageTypeSpecifier imageType, ImageWriteParam param) {
        return null;
    }

    public IIOMetadata getDefaultImageMetadata(ImageTypeSpecifier imageType, ImageWriteParam param) {
        return null;
    }

    public IIOMetadata getDefaultStreamMetadata(ImageWriteParam param) {
        return null;
    }

    public ImageWriteParam getDefaultWriteParam() {
        return new GIFImageWriteParam(this.getLocale());
    }
}

