/*
 * Decompiled with CFR 0.152.
 */
package helma.image.imageio;

import helma.image.ImageGenerator;
import helma.image.ImageWrapper;
import java.awt.image.BufferedImage;
import java.awt.image.DirectColorModel;
import java.awt.image.WritableRaster;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.ImageOutputStream;

public class ImageIOGenerator
extends ImageGenerator {
    protected void write(ImageWrapper wrapper, ImageWriter writer, float quality, boolean alpha) throws IOException {
        BufferedImage bi = wrapper.getBufferedImage();
        ImageWriteParam param = writer.getDefaultWriteParam();
        if (param.canWriteCompressed() && (double)quality >= 0.0 && (double)quality <= 1.0) {
            param.setCompressionMode(2);
            param.setCompressionQuality(quality);
        }
        if (param.canWriteProgressive()) {
            param.setProgressiveMode(0);
        }
        if (bi.getType() == 2 && !alpha) {
            WritableRaster raster = bi.getRaster();
            WritableRaster newRaster = raster.createWritableChild(0, 0, raster.getWidth(), raster.getHeight(), 0, 0, new int[]{0, 1, 2});
            DirectColorModel cm = (DirectColorModel)bi.getColorModel();
            DirectColorModel newCM = new DirectColorModel(cm.getPixelSize(), cm.getRedMask(), cm.getGreenMask(), cm.getBlueMask());
            BufferedImage rgbBuffer = new BufferedImage(newCM, newRaster, false, null);
            writer.write(null, new IIOImage(rgbBuffer, null, null), param);
        } else {
            writer.write(null, new IIOImage(bi, null, null), param);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(ImageWrapper wrapper, String filename, float quality, boolean alpha) throws IOException {
        int pos = filename.lastIndexOf(46);
        if (pos != -1) {
            String extension = filename.substring(pos + 1, filename.length()).toLowerCase();
            ImageWriter writer = null;
            Iterator<ImageWriter> iter = ImageIO.getImageWritersBySuffix(extension);
            if (iter.hasNext()) {
                writer = iter.next();
            }
            if (writer != null) {
                ImageInputStream ios = null;
                try {
                    File file = new File(filename);
                    if (file.exists()) {
                        file.delete();
                    }
                    ios = ImageIO.createImageOutputStream(file);
                    writer.setOutput(ios);
                    this.write(wrapper, writer, quality, alpha);
                }
                finally {
                    if (ios != null) {
                        ios.close();
                    }
                    writer.dispose();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(ImageWrapper wrapper, OutputStream out, String mimeType, float quality, boolean alpha) throws IOException {
        ImageWriter writer = null;
        Iterator<ImageWriter> iter = ImageIO.getImageWritersByMIMEType(mimeType);
        if (iter.hasNext()) {
            writer = iter.next();
        }
        if (writer != null) {
            ImageOutputStream ios = null;
            try {
                ios = ImageIO.createImageOutputStream(out);
                writer.setOutput(ios);
                this.write(wrapper, writer, quality, alpha);
            }
            finally {
                if (ios != null) {
                    ios.close();
                }
                writer.dispose();
            }
        }
    }
}

