/*
 * Decompiled with CFR 0.152.
 */
package helma.image;

import helma.image.ColorQuantizer;
import helma.image.ImageFilterOp;
import helma.image.ImageGenerator;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.AreaAveragingScaleFilter;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DataBufferInt;
import java.awt.image.ImageProducer;
import java.awt.image.IndexColorModel;
import java.io.IOException;
import java.io.OutputStream;

public class ImageWrapper {
    protected Image image;
    protected int width;
    protected int height;
    protected ImageGenerator generator;
    private Graphics2D graphics;

    public ImageWrapper(Image image, int width, int height, ImageGenerator generator) {
        this.image = image;
        this.width = width;
        this.height = height;
        this.generator = generator;
        this.graphics = null;
    }

    public ImageWrapper(Image image, ImageGenerator generator) {
        this(image, image.getWidth(null), image.getHeight(null), generator);
    }

    public BufferedImage getBufferedImage() {
        if (!(this.image instanceof BufferedImage)) {
            BufferedImage buffered = new BufferedImage(this.width, this.height, 2);
            Graphics2D g2d = buffered.createGraphics();
            g2d.drawImage(this.image, 0, 0, null);
            g2d.dispose();
            this.setImage(buffered);
        }
        return (BufferedImage)this.image;
    }

    public Graphics2D getGraphics() {
        if (this.graphics == null) {
            BufferedImage img = this.getBufferedImage();
            this.graphics = img.createGraphics();
        }
        return this.graphics;
    }

    protected void setImage(Image img) {
        if (this.graphics != null) {
            this.graphics.dispose();
            this.graphics = null;
        }
        if (this.image != null) {
            this.image.flush();
        }
        this.image = img;
        this.width = this.image.getWidth(null);
        this.height = this.image.getHeight(null);
    }

    public Object clone() {
        ImageWrapper wrapper = this.generator.createImage(this.width, this.height);
        wrapper.getGraphics().drawImage(this.image, 0, 0, null);
        return wrapper;
    }

    public Image getImage() {
        return this.image;
    }

    public ImageProducer getSource() {
        return this.image.getSource();
    }

    public void dispose() {
        if (this.image != null) {
            this.image.flush();
            this.image = null;
        }
        if (this.graphics != null) {
            this.graphics.dispose();
            this.graphics = null;
        }
    }

    public void setFont(String name, int style, int size) {
        this.getGraphics().setFont(new Font(name, style, size));
    }

    public void setColor(int red, int green, int blue) {
        this.getGraphics().setColor(new Color(red, green, blue));
    }

    public void setColor(int color) {
        this.getGraphics().setColor(new Color(color));
    }

    public void setColor(Color color) {
        this.getGraphics().setColor(color);
    }

    public void setColor(String color) {
        this.getGraphics().setColor(Color.decode(color));
    }

    public void drawString(String str, int x, int y) {
        this.getGraphics().drawString(str, x, y);
    }

    public void drawLine(int x1, int y1, int x2, int y2) {
        this.getGraphics().drawLine(x1, y1, x2, y2);
    }

    public void drawRect(int x, int y, int w, int h) {
        this.getGraphics().drawRect(x, y, w, h);
    }

    public void drawImage(String filename, int x, int y) throws IOException {
        Image img = this.generator.read(filename);
        if (img != null) {
            this.getGraphics().drawImage(img, x, y, null);
        }
    }

    public void drawImage(ImageWrapper image, int x, int y) throws IOException {
        this.getGraphics().drawImage(image.getImage(), x, y, null);
    }

    public void drawImage(ImageWrapper image, AffineTransform at) throws IOException {
        this.getGraphics().drawImage(image.getImage(), at, null);
    }

    public void fillRect(int x, int y, int w, int h) {
        this.getGraphics().fillRect(x, y, w, h);
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public void crop(int x, int y, int w, int h) {
        if (this.image instanceof BufferedImage && x + w <= this.width && y + h <= this.height) {
            this.setImage(((BufferedImage)this.image).getSubimage(x, y, w, h));
        } else {
            BufferedImage buffered = new BufferedImage(w, h, 2);
            Graphics2D g2d = buffered.createGraphics();
            g2d.drawImage(this.image, -x, -y, null);
            g2d.dispose();
            this.setImage(buffered);
        }
    }

    public void trim(int x, int y) {
        this.trim(x, y, true, true, true, true);
    }

    public void trim(int x, int y, boolean trimLeft, boolean trimTop, boolean trimRight, boolean trimBottom) {
        int[] pixels;
        Graphics2D g2d;
        BufferedImage bi = this.getBufferedImage();
        int color = bi.getRGB(x, y);
        int left = 0;
        int top = 0;
        int right = this.width - 1;
        int bottom = this.height - 1;
        if (trimTop || trimBottom) {
            BufferedImage row = new BufferedImage(this.width, 1, 2);
            g2d = row.createGraphics();
            pixels = ((DataBufferInt)row.getRaster().getDataBuffer()).getData();
            g2d.setComposite(AlphaComposite.Src);
            if (trimTop) {
                for (top = 0; top < this.height; ++top) {
                    g2d.drawImage(bi, null, 0, -top);
                    for (x = 0; x < this.width && pixels[x] == color; ++x) {
                    }
                    if (x < this.width) break;
                }
            }
            if (trimBottom) {
                for (bottom = this.height - 1; bottom > top; --bottom) {
                    g2d.drawImage(bi, null, 0, -bottom);
                    for (x = 0; x < this.width && pixels[x] == color; ++x) {
                    }
                    if (x < this.width) break;
                }
            }
            g2d.dispose();
        }
        if (trimLeft || trimRight) {
            BufferedImage column = new BufferedImage(1, this.height, 2);
            g2d = column.createGraphics();
            pixels = ((DataBufferInt)column.getRaster().getDataBuffer()).getData();
            g2d.setComposite(AlphaComposite.Src);
            if (trimLeft) {
                for (left = 0; left < this.width; ++left) {
                    g2d.drawImage(bi, null, -left, 0);
                    for (y = 0; y < this.height && pixels[y] == color; ++y) {
                    }
                    if (y < this.height) break;
                }
            }
            if (trimRight) {
                for (right = this.width - 1; right > left; --right) {
                    g2d.drawImage(bi, null, -right, 0);
                    for (y = 0; y < this.height && pixels[y] == color; ++y) {
                    }
                    if (y < this.height) break;
                }
            }
            g2d.dispose();
        }
        this.crop(left, top, right - left + 1, bottom - top + 1);
    }

    protected void resize(int w, int h, boolean smooth) {
        BufferedImage buffered = new BufferedImage(w, h, 2);
        Graphics2D g2d = buffered.createGraphics();
        g2d.setRenderingHint(RenderingHints.KEY_INTERPOLATION, smooth ? RenderingHints.VALUE_INTERPOLATION_BICUBIC : RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);
        g2d.setRenderingHint(RenderingHints.KEY_RENDERING, smooth ? RenderingHints.VALUE_RENDER_QUALITY : RenderingHints.VALUE_RENDER_SPEED);
        AffineTransform at = AffineTransform.getScaleInstance((double)w / (double)this.width, (double)h / (double)this.height);
        g2d.drawImage(this.image, at, null);
        g2d.dispose();
        this.setImage(buffered);
    }

    public void resize(int w, int h) {
        double factor = Math.max((double)w / (double)this.width, (double)h / (double)this.height);
        if (factor > 1.0) {
            this.resize(w, h, true);
        } else {
            ImageFilterOp filter = new ImageFilterOp(new AreaAveragingScaleFilter(w, h));
            this.setImage(filter.filter(this.getBufferedImage(), null));
        }
    }

    public void resizeFast(int w, int h) {
        this.resize(w, h, false);
    }

    public void reduceColors(int colors) {
        this.reduceColors(colors, false);
    }

    public void reduceColors(int colors, boolean dither) {
        this.reduceColors(colors, dither, true);
    }

    public void reduceColors(int colors, boolean dither, boolean alphaToBitmask) {
        this.setImage(ColorQuantizer.quantizeImage(this.getBufferedImage(), colors, dither, alphaToBitmask));
    }

    public void saveAs(String filename) throws IOException {
        this.saveAs(filename, -1.0f, false);
    }

    public void saveAs(String filename, float quality) throws IOException {
        this.saveAs(filename, quality, false);
    }

    public void saveAs(String filename, float quality, boolean alpha) throws IOException {
        this.generator.write(this, filename, quality, alpha);
    }

    public void saveAs(OutputStream out, String mimeType) throws IOException {
        this.generator.write(this, out, mimeType, -1.0f, false);
    }

    public void saveAs(OutputStream out, String mimeType, float quality) throws IOException {
        this.generator.write(this, out, mimeType, quality, false);
    }

    public void saveAs(OutputStream out, String mimeType, float quality, boolean alpha) throws IOException {
        this.generator.write(this, out, mimeType, quality, alpha);
    }

    public void setTransparentPixel(int trans) {
        BufferedImage bi = this.getBufferedImage();
        ColorModel cm = bi.getColorModel();
        if (!(cm instanceof IndexColorModel)) {
            throw new RuntimeException("Image is not indexed!");
        }
        IndexColorModel icm = (IndexColorModel)cm;
        int mapSize = icm.getMapSize();
        byte[] reds = new byte[mapSize];
        byte[] greens = new byte[mapSize];
        byte[] blues = new byte[mapSize];
        icm.getReds(reds);
        icm.getGreens(greens);
        icm.getBlues(blues);
        icm = new IndexColorModel(icm.getPixelSize(), mapSize, reds, greens, blues, trans);
        this.setImage(new BufferedImage(icm, bi.getRaster(), false, null));
    }

    public int getPixel(int x, int y) {
        BufferedImage bi = this.getBufferedImage();
        if (bi.getColorModel() instanceof IndexColorModel) {
            return bi.getRaster().getSample(x, y, 0);
        }
        return bi.getRGB(x, y);
    }
}

