/*
 * Decompiled with CFR 0.152.
 */
package helma.image;

import java.awt.Image;
import java.awt.image.ImageObserver;

public class ImageWaiter
implements ImageObserver {
    Image image;
    int width;
    int height;
    boolean waiting;
    boolean firstFrameLoaded;

    private ImageWaiter(Image image) {
        this.image = image;
        this.waiting = true;
        this.firstFrameLoaded = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Image waitForImage(Image image) {
        ImageWaiter waiter = new ImageWaiter(image);
        try {
            waiter.waitForImage();
        }
        finally {
            waiter.done();
        }
        return waiter.width == -1 || waiter.height == -1 ? null : image;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void waitForImage() {
        this.width = this.image.getWidth(this);
        this.height = this.image.getHeight(this);
        if (this.width == -1 || this.height == -1) {
            try {
                this.wait(45000L);
            }
            catch (InterruptedException x) {
                this.waiting = false;
                return;
            }
            finally {
                this.waiting = false;
            }
        }
        if (this.width == -1 || this.height == -1) {
            throw new RuntimeException("Error loading image");
        }
    }

    private synchronized void done() {
        this.waiting = false;
        this.notifyAll();
    }

    public synchronized boolean imageUpdate(Image img, int infoflags, int x, int y, int w, int h) {
        if (!this.waiting || (infoflags & 0x40) > 0 || (infoflags & 0x80) > 0) {
            this.notifyAll();
            return false;
        }
        if ((infoflags & 1) > 0 || (infoflags & 2) > 0) {
            if ((infoflags & 1) > 0) {
                this.width = w;
            }
            if ((infoflags & 2) > 0) {
                this.height = h;
            }
            if (this.width > -1 && h > -1 && this.firstFrameLoaded) {
                this.notifyAll();
                return false;
            }
        }
        if ((infoflags & 0x20) > 0 || (infoflags & 0x10) > 0) {
            this.firstFrameLoaded = true;
            this.notifyAll();
            return false;
        }
        return true;
    }
}

