/*
 * Decompiled with CFR 0.152.
 */
package helma.image;

import helma.image.ImageFilterOp;
import helma.image.ImageWrapper;
import helma.main.Server;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ImageFilter;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import javax.imageio.ImageIO;

public abstract class ImageGenerator {
    protected static ImageGenerator generator = null;

    public static ImageGenerator getInstance() {
        if (generator == null) {
            String className = null;
            if (Server.getServer() != null) {
                className = Server.getServer().getProperty("imageGenerator");
            }
            Class<?> generatorClass = null;
            if (className == null) {
                try {
                    Class.forName("javax.imageio.ImageIO");
                    className = "helma.image.imageio.ImageIOGenerator";
                }
                catch (ClassNotFoundException e1) {
                    try {
                        Class.forName("com.sun.jimi.core.Jimi");
                        className = "helma.image.jimi.JimiGenerator";
                    }
                    catch (ClassNotFoundException e2) {
                        throw new RuntimeException("JimiGenerator canot be used. Please make sure you placed jimi.jar in helma/lib/ext");
                    }
                }
            }
            try {
                generatorClass = Class.forName(className);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException("The imageGenerator class cannot be found: " + className);
            }
            try {
                generator = (ImageGenerator)generatorClass.newInstance();
            }
            catch (Exception e) {
                throw new RuntimeException("The ImageGenerator instance could not be created: " + className);
            }
        }
        return generator;
    }

    public ImageWrapper createImage(int w, int h) {
        BufferedImage img = new BufferedImage(w, h, 2);
        return new ImageWrapper(img, w, h, this);
    }

    public ImageWrapper createImage(byte[] src) throws IOException {
        Image img = this.read(src);
        return img != null ? new ImageWrapper(img, this) : null;
    }

    public ImageWrapper createImage(String filenamne) throws IOException {
        Image img = this.read(filenamne);
        return img != null ? new ImageWrapper(img, this) : null;
    }

    public ImageWrapper createImage(URL url) throws MalformedURLException, IOException {
        Image img = this.read(url);
        return img != null ? new ImageWrapper(img, this) : null;
    }

    public ImageWrapper createImage(InputStream input) throws IOException {
        Image img = this.read(input);
        return img != null ? new ImageWrapper(img, this) : null;
    }

    public ImageWrapper createImage(ImageWrapper iw, ImageFilter filter) {
        return this.createImage(iw, new ImageFilterOp(filter));
    }

    public ImageWrapper createImage(ImageWrapper iw, BufferedImageOp imageOp) {
        BufferedImage img = imageOp.filter(iw.getBufferedImage(), null);
        return img != null ? new ImageWrapper(img, this) : null;
    }

    public Image read(String filename) throws IOException {
        return ImageIO.read(new File(filename));
    }

    public Image read(URL url) throws IOException {
        return ImageIO.read(url);
    }

    public Image read(byte[] src) throws IOException {
        return ImageIO.read(new ByteArrayInputStream(src));
    }

    public Image read(InputStream input) throws IOException {
        return ImageIO.read(input);
    }

    public abstract void write(ImageWrapper var1, String var2, float var3, boolean var4) throws IOException;

    public abstract void write(ImageWrapper var1, OutputStream var2, String var3, float var4, boolean var5) throws IOException;
}

