/*
 * Decompiled with CFR 0.152.
 */
package helma.image;

import java.awt.AlphaComposite;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ColorModel;
import java.awt.image.DataBufferInt;
import java.awt.image.ImageConsumer;
import java.awt.image.ImageFilter;
import java.util.Hashtable;

public class ImageFilterOp
implements BufferedImageOp {
    ImageFilter filter;

    public ImageFilterOp(ImageFilter filter) {
        this.filter = filter;
    }

    public BufferedImage filter(BufferedImage src, BufferedImage dst) {
        int width = src.getWidth();
        int height = src.getHeight();
        BufferedImageConsumer consumer = new BufferedImageConsumer(dst);
        ImageFilter fltr = this.filter.getFilterInstance(consumer);
        fltr.setDimensions(width, height);
        SimpleColorModel cm = new SimpleColorModel();
        BufferedImage row = new BufferedImage(width, 1, 2);
        Graphics2D g2d = row.createGraphics();
        int[] pixels = ((DataBufferInt)row.getRaster().getDataBuffer()).getData();
        g2d.setComposite(AlphaComposite.Src);
        for (int y = 0; y < height; ++y) {
            g2d.drawImage(src, null, 0, -y);
            fltr.setPixels(0, y, width, 1, (ColorModel)cm, pixels, 0, width);
        }
        g2d.dispose();
        return consumer.getImage();
    }

    public BufferedImage createCompatibleDestImage(BufferedImage src, ColorModel destCM) {
        return null;
    }

    public RenderingHints getRenderingHints() {
        return null;
    }

    public Point2D getPoint2D(Point2D srcPt, Point2D dstPt) {
        return null;
    }

    public Rectangle2D getBounds2D(BufferedImage src) {
        return null;
    }

    class BufferedImageConsumer
    implements ImageConsumer {
        BufferedImage image;
        BufferedImage compatible;
        int width;
        int height;
        boolean first = true;

        public BufferedImageConsumer(BufferedImage image) {
            this(image, null);
        }

        public BufferedImageConsumer(BufferedImage image, BufferedImage compatible) {
            this.image = image;
            this.compatible = compatible;
        }

        public BufferedImage getImage() {
            return this.image;
        }

        public void setDimensions(int w, int h) {
            if (this.image == null) {
                this.image = this.compatible != null ? new BufferedImage(this.compatible.getColorModel(), this.compatible.getRaster().createCompatibleWritableRaster(w, h), this.compatible.isAlphaPremultiplied(), null) : new BufferedImage(w, h, 2);
            }
            this.width = this.image.getWidth();
            this.height = this.image.getHeight();
        }

        public void setPixels(int x, int y, int w, int h, ColorModel model, int[] pixels, int off, int scansize) {
            if (x < this.width && y < this.height) {
                if (x + w > this.width) {
                    w = this.width - x;
                }
                if (y + h > this.height) {
                    h = this.height - y;
                }
                if (w > 0 && h > 0) {
                    this.image.setRGB(x, y, w, h, pixels, off, scansize);
                }
            }
        }

        public void setPixels(int x, int y, int w, int h, ColorModel model, byte[] pixels, int off, int scansize) {
            if (x < this.width && y < this.height) {
                if (x + w > this.width) {
                    w = this.width - x;
                }
                if (y + h > this.height) {
                    h = this.height - y;
                }
                if (w > 0 && h > 0) {
                    this.image.getRaster().setDataElements(x, y, w, h, pixels);
                }
            }
        }

        public void setProperties(Hashtable props) {
        }

        public void setColorModel(ColorModel model) {
        }

        public void setHints(int hintflags) {
        }

        public void imageComplete(int status) {
        }
    }

    class SimpleColorModel
    extends ColorModel {
        public SimpleColorModel() {
            this(32);
        }

        public SimpleColorModel(int bits) {
            super(bits);
        }

        public int getRGB(int rgb) {
            return rgb;
        }

        public int getAlpha(int pixel) {
            return pixel >> 24;
        }

        public int getRed(int pixel) {
            return pixel >> 16 & 0xFF;
        }

        public int getGreen(int pixel) {
            return pixel >> 8 & 0xFF;
        }

        public int getBlue(int pixel) {
            return pixel & 0xFF;
        }
    }
}

