/*
 * Decompiled with CFR 0.152.
 */
package helma.image;

import helma.image.ColorQuantizer;
import java.awt.image.BufferedImage;
import java.awt.image.IndexColorModel;
import java.awt.image.Raster;
import java.io.DataOutput;
import java.io.IOException;

public class GIFEncoder {
    private boolean interlace = false;
    private int width;
    private int height;
    private Raster raster;
    private DataOutput out;
    private int curx;
    private int cury;
    private int countdown;
    private int pass;
    private int[] row;
    static final int BITS = 12;
    static final int HASH_SIZE = 5003;
    private int numBits;
    private int maxBits = 12;
    private int maxCode;
    private int maxMaxCode = 4096;
    private int[] hashTable = new int[5003];
    private int[] codeTable = new int[5003];
    private int freeEntry = 0;
    private boolean clearFlag = false;
    private int initBits;
    private int clearCode;
    private int EOFCode;
    int curAccum = 0;
    int curBits = 0;
    int[] masks = new int[]{0, 1, 3, 7, 15, 31, 63, 127, 255, 511, 1023, 2047, 4095, 8191, 16383, Short.MAX_VALUE, 65535};
    private int a_count;
    private byte[] accum = new byte[256];

    public void encode(BufferedImage bi, DataOutput out) throws IOException {
        this.encode(bi, out, false, null);
    }

    public void encode(BufferedImage bi, DataOutput out, boolean interlace, String comment) throws IOException {
        this.out = out;
        this.interlace = interlace;
        if (bi.getType() != 13) {
            bi = ColorQuantizer.quantizeImage(bi, 256, false, true);
        }
        this.raster = bi.getRaster();
        this.width = bi.getWidth();
        this.height = bi.getHeight();
        int numPixels = this.width * this.height;
        IndexColorModel icm = (IndexColorModel)bi.getColorModel();
        int transparentIndex = icm.getTransparentPixel();
        int numColors = icm.getMapSize();
        int bitsPerPixel = numColors <= 2 ? 1 : (numColors <= 4 ? 2 : (numColors <= 16 ? 4 : 8));
        this.countdown = numPixels;
        this.pass = 0;
        int initCodeSize = bitsPerPixel <= 1 ? 2 : bitsPerPixel;
        this.curx = 0;
        this.cury = 0;
        this.row = new int[this.width];
        this.writeString("GIF89a");
        this.writeWord(this.width);
        this.writeWord(this.height);
        int flags = -128;
        flags = (byte)(flags | 0x70);
        flags = (byte)(flags | (byte)(bitsPerPixel - 1));
        out.write(flags);
        out.write(0);
        out.write(0);
        int mapSize = 1 << bitsPerPixel;
        byte[] reds = new byte[mapSize];
        byte[] greens = new byte[mapSize];
        byte[] blues = new byte[mapSize];
        icm.getReds(reds);
        icm.getGreens(greens);
        icm.getBlues(blues);
        for (int i = 0; i < mapSize; ++i) {
            out.write(reds[i]);
            out.write(greens[i]);
            out.write(blues[i]);
        }
        if (transparentIndex != -1) {
            out.write(33);
            out.write(-7);
            out.write(4);
            out.write(1);
            out.write(0);
            out.write(0);
            out.write((byte)transparentIndex);
            out.write(0);
        }
        out.write(44);
        this.writeWord(0);
        this.writeWord(0);
        this.writeWord(this.width);
        this.writeWord(this.height);
        if (interlace) {
            out.write(64);
        } else {
            out.write(0);
        }
        out.write((byte)initCodeSize);
        this.compress(initCodeSize + 1);
        out.write(0);
        if (comment != null && comment.length() > 0) {
            out.write(33);
            out.write(-2);
            out.write((byte)comment.length());
            this.writeString(comment);
            out.write(0);
        }
        out.write(59);
    }

    int getNextPixel() throws IOException {
        if (this.countdown == 0) {
            return -1;
        }
        --this.countdown;
        if (this.curx == 0) {
            this.row = this.raster.getSamples(0, this.cury, this.width, 1, 0, this.row);
        }
        int index = this.row[this.curx];
        ++this.curx;
        if (this.curx == this.width) {
            this.curx = 0;
            if (!this.interlace) {
                ++this.cury;
            } else {
                switch (this.pass) {
                    case 0: {
                        this.cury += 8;
                        if (this.cury < this.height) break;
                        ++this.pass;
                        this.cury = 4;
                        break;
                    }
                    case 1: {
                        this.cury += 8;
                        if (this.cury < this.height) break;
                        ++this.pass;
                        this.cury = 2;
                        break;
                    }
                    case 2: {
                        this.cury += 4;
                        if (this.cury < this.height) break;
                        ++this.pass;
                        this.cury = 1;
                        break;
                    }
                    case 3: {
                        this.cury += 2;
                    }
                }
            }
        }
        return index;
    }

    void writeString(String str) throws IOException {
        byte[] buf = str.getBytes();
        this.out.write(buf);
    }

    void writeWord(int w) throws IOException {
        this.out.write((byte)(w & 0xFF));
        this.out.write((byte)(w >> 8 & 0xFF));
    }

    final int getMaxCode(int numBits) {
        return (1 << numBits) - 1;
    }

    void compress(int initBits) throws IOException {
        int c;
        this.initBits = initBits;
        this.clearFlag = false;
        this.numBits = initBits;
        this.maxCode = this.getMaxCode(this.numBits);
        this.clearCode = 1 << initBits - 1;
        this.EOFCode = this.clearCode + 1;
        this.freeEntry = this.clearCode + 2;
        this.charInit();
        int ent = this.getNextPixel();
        int hashShift = 0;
        for (int fcode = 5003; fcode < 65536; fcode *= 2) {
            ++hashShift;
        }
        hashShift = 8 - hashShift;
        this.clearHash();
        this.output(this.clearCode);
        block1: while ((c = this.getNextPixel()) != -1) {
            int i = c << hashShift ^ ent;
            int fcode = (c << this.maxBits) + ent;
            if (this.hashTable[i] == fcode) {
                ent = this.codeTable[i];
                continue;
            }
            if (this.hashTable[i] >= 0) {
                int disp = 5003 - i;
                if (i == 0) {
                    disp = 1;
                }
                do {
                    if ((i -= disp) < 0) {
                        i += 5003;
                    }
                    if (this.hashTable[i] != fcode) continue;
                    ent = this.codeTable[i];
                    continue block1;
                } while (this.hashTable[i] >= 0);
            }
            this.output(ent);
            ent = c;
            if (this.freeEntry < this.maxMaxCode) {
                ++this.freeEntry;
                this.hashTable[i] = fcode;
                continue;
            }
            this.clearBlock();
        }
        this.output(ent);
        this.output(this.EOFCode);
    }

    void output(int code) throws IOException {
        this.curAccum &= this.masks[this.curBits];
        this.curAccum = this.curBits > 0 ? (this.curAccum |= code << this.curBits) : code;
        this.curBits += this.numBits;
        while (this.curBits >= 8) {
            this.charOut((byte)(this.curAccum & 0xFF));
            this.curAccum >>= 8;
            this.curBits -= 8;
        }
        if (this.freeEntry > this.maxCode || this.clearFlag) {
            if (this.clearFlag) {
                this.numBits = this.initBits;
                this.maxCode = this.getMaxCode(this.numBits);
                this.clearFlag = false;
            } else {
                ++this.numBits;
                this.maxCode = this.numBits == this.maxBits ? this.maxMaxCode : this.getMaxCode(this.numBits);
            }
        }
        if (code == this.EOFCode) {
            while (this.curBits > 0) {
                this.charOut((byte)(this.curAccum & 0xFF));
                this.curAccum >>= 8;
                this.curBits -= 8;
            }
            this.charFlush();
        }
    }

    void clearBlock() throws IOException {
        this.clearHash();
        this.freeEntry = this.clearCode + 2;
        this.clearFlag = true;
        this.output(this.clearCode);
    }

    void clearHash() {
        for (int i = 0; i < 5003; ++i) {
            this.hashTable[i] = -1;
        }
    }

    void charInit() {
        this.a_count = 0;
    }

    void charOut(byte c) throws IOException {
        this.accum[this.a_count++] = c;
        if (this.a_count >= 254) {
            this.charFlush();
        }
    }

    void charFlush() throws IOException {
        if (this.a_count > 0) {
            this.out.write(this.a_count);
            this.out.write(this.accum, 0, this.a_count);
            this.a_count = 0;
        }
    }
}

