/*
 * Decompiled with CFR 0.152.
 */
package helma.image;

import helma.image.DiffusionFilterOp;
import java.awt.AlphaComposite;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.IndexColorModel;

public class ColorQuantizer {
    public static final int MAX_NODES = 266817;
    public static final int MAX_TREE_DEPTH = 8;
    public static final int MAX_CHILDREN = 16;
    public static final int MAX_RGB = 255;

    static BufferedImage quantizeImage(BufferedImage image, int maxColors, boolean dither, boolean alphaToBitmask) {
        Cube cube = new Cube(maxColors);
        cube.classifyImageColors(image, alphaToBitmask);
        cube.reduceImageColors(maxColors);
        return cube.assignImageColors(image, dither, alphaToBitmask);
    }

    static class Cube {
        Node root;
        int numColors;
        boolean addTransparency;
        int firstColor;
        byte[][] colorMap;
        long nextThreshold;
        int numNodes;
        int depth;

        Cube(int maxColors) {
            this.depth = this.getDepth(maxColors);
            this.numColors = 0;
            this.root = new Node(this);
        }

        int getDepth(int numColors) {
            int depth = 1;
            while (numColors != 0) {
                numColors >>= 2;
                ++depth;
            }
            if (depth > 8) {
                depth = 8;
            }
            if (depth < 2) {
                depth = 2;
            }
            return depth;
        }

        void classifyImageColors(BufferedImage image, boolean alphaToBitmask) {
            this.addTransparency = false;
            this.firstColor = 0;
            int width = image.getWidth();
            int height = image.getHeight();
            int levelThreshold = 8;
            BufferedImage row = new BufferedImage(width, 1, 2);
            Graphics2D g2d = row.createGraphics();
            int[] pixels = ((DataBufferInt)row.getRaster().getDataBuffer()).getData();
            g2d.setComposite(AlphaComposite.Src);
            for (int y = 0; y < height; ++y) {
                g2d.drawImage(image, null, 0, -y);
                if (this.numNodes > 266817) {
                    this.root.pruneLevel();
                    --this.depth;
                }
                int x = 0;
                while (x < width) {
                    int pixel = pixels[x];
                    int red = pixel >> 16 & 0xFF;
                    int green = pixel >> 8 & 0xFF;
                    int blue = pixel >> 0 & 0xFF;
                    int alpha = pixel >> 24 & 0xFF;
                    if (alphaToBitmask) {
                        alpha = alpha < 128 ? 0 : 255;
                    }
                    int px = x++;
                    while (x < width && pixels[x] == pixel) {
                        ++x;
                    }
                    int count = x - px;
                    if (alpha > 0) {
                        int bisect;
                        int index = 7;
                        int midRed = bisect = 128;
                        int midGreen = bisect;
                        int midBlue = bisect;
                        int midAlpha = bisect;
                        Node node = this.root;
                        for (int level = 1; level <= levelThreshold; ++level) {
                            int id = (red >> index & 1) << 3 | (green >> index & 1) << 2 | (blue >> index & 1) << 1 | alpha >> index & 1;
                            midRed += (id & 8) != 0 ? bisect : -(bisect >>= 1);
                            midGreen += (id & 4) != 0 ? bisect : -bisect;
                            midBlue += (id & 2) != 0 ? bisect : -bisect;
                            midAlpha += (id & 1) != 0 ? bisect : -bisect;
                            Node child = node.children[id];
                            if (child == null) {
                                child = new Node(this, id, level, node);
                                if (level == levelThreshold) {
                                    ++this.numColors;
                                    if (this.numColors == 256) {
                                        levelThreshold = this.depth;
                                        this.root.pruneToCubeDepth();
                                    }
                                }
                            }
                            node = child;
                            int r = red - midRed;
                            int g = green - midGreen;
                            int b = blue - midBlue;
                            int a = alpha - midAlpha;
                            node.quantizeError += (long)(count * (r * r + g * g + b * b + a * a));
                            this.root.quantizeError += node.quantizeError;
                            --index;
                        }
                        node.uniqueCount += count;
                        node.totalRed += count * red;
                        node.totalGreen += count * green;
                        node.totalBlue += count * blue;
                        node.totalAlpha += count * alpha;
                        continue;
                    }
                    if (this.addTransparency) continue;
                    this.addTransparency = true;
                    ++this.numColors;
                    this.firstColor = 1;
                }
            }
        }

        void reduceImageColors(int maxColors) {
            this.nextThreshold = 0L;
            while (this.numColors > maxColors) {
                long pruningThreshold = this.nextThreshold;
                this.nextThreshold = this.root.quantizeError - 1L;
                this.numColors = this.firstColor;
                this.root.reduce(pruningThreshold);
            }
        }

        BufferedImage assignImageColors(BufferedImage image, boolean dither, boolean alphaToBitmask) {
            this.colorMap = new byte[4][this.numColors];
            this.root.fillColorMap(this.colorMap, this.firstColor);
            int colorDepth = this.getDepth(this.numColors);
            int width = image.getWidth();
            int height = image.getHeight();
            IndexColorModel icm = alphaToBitmask ? (this.addTransparency ? new IndexColorModel(this.depth, this.numColors, this.colorMap[0], this.colorMap[1], this.colorMap[2], 0) : new IndexColorModel(this.depth, this.numColors, this.colorMap[0], this.colorMap[1], this.colorMap[2])) : new IndexColorModel(this.depth, this.numColors, this.colorMap[0], this.colorMap[1], this.colorMap[2], this.colorMap[3]);
            BufferedImage dest = new BufferedImage(width, height, 13, icm);
            boolean firstOut = true;
            if (dither) {
                new DiffusionFilterOp().filter(image, dest);
            } else {
                ClosestColor closest = new ClosestColor();
                byte[] dst = ((DataBufferByte)dest.getRaster().getDataBuffer()).getData();
                BufferedImage row = new BufferedImage(width, 1, 2);
                Graphics2D g2d = row.createGraphics();
                int[] pixels = ((DataBufferInt)row.getRaster().getDataBuffer()).getData();
                g2d.setComposite(AlphaComposite.Src);
                int pos = 0;
                for (int y = 0; y < height; ++y) {
                    g2d.drawImage(image, null, 0, -y);
                    int x = 0;
                    while (x < width) {
                        byte col;
                        int pixel = pixels[x];
                        int red = pixel >> 16 & 0xFF;
                        int green = pixel >> 8 & 0xFF;
                        int blue = pixel >> 0 & 0xFF;
                        int alpha = pixel >> 24 & 0xFF;
                        if (alphaToBitmask) {
                            int n = alpha = alpha < 128 ? 0 : 255;
                        }
                        if (alpha == 0 && this.addTransparency) {
                            col = 0;
                        } else {
                            int id;
                            Node node = this.root;
                            for (int i = 7; i > 0 && node.children[id = (red >> i & 1) << 3 | (green >> i & 1) << 2 | (blue >> i & 1) << 1 | alpha >> i & 1] != null; --i) {
                                node = node.children[id];
                            }
                            closest.distance = Integer.MAX_VALUE;
                            node.parent.findClosestColor(red, green, blue, alpha, closest);
                            col = (byte)closest.colorIndex;
                        }
                        dst[pos++] = col;
                        ++x;
                        while (x < width && pixels[x] == pixel) {
                            dst[pos++] = col;
                            ++x;
                        }
                    }
                }
            }
            return dest;
        }
    }

    static class Node {
        Cube cube;
        Node parent;
        Node[] children;
        int numChildren;
        int id;
        int level;
        int uniqueCount;
        int totalRed;
        int totalGreen;
        int totalBlue;
        int totalAlpha;
        long quantizeError;
        int colorIndex;

        Node(Cube cube) {
            this(cube, 0, 0, null);
            this.parent = this;
        }

        Node(Cube cube, int id, int level, Node parent) {
            this.cube = cube;
            this.parent = parent;
            this.id = id;
            this.level = level;
            this.children = new Node[16];
            this.numChildren = 0;
            if (parent != null) {
                parent.children[id] = this;
                ++parent.numChildren;
            }
            ++cube.numNodes;
        }

        void pruneLevel() {
            if (this.numChildren > 0) {
                for (int id = 0; id < 16; ++id) {
                    if (this.children[id] == null) continue;
                    this.children[id].pruneLevel();
                }
            }
            if (this.level == this.cube.depth) {
                this.prune();
            }
        }

        void pruneToCubeDepth() {
            if (this.numChildren > 0) {
                for (int id = 0; id < 16; ++id) {
                    if (this.children[id] == null) continue;
                    this.children[id].pruneToCubeDepth();
                }
            }
            if (this.level > this.cube.depth) {
                this.prune();
            }
        }

        void prune() {
            if (this.numChildren > 0) {
                for (int id = 0; id < 16; ++id) {
                    if (this.children[id] == null) continue;
                    this.children[id].prune();
                }
            }
            this.parent.uniqueCount += this.uniqueCount;
            this.parent.totalRed += this.totalRed;
            this.parent.totalGreen += this.totalGreen;
            this.parent.totalBlue += this.totalBlue;
            this.parent.totalAlpha += this.totalAlpha;
            this.parent.children[this.id] = null;
            --this.parent.numChildren;
            --this.cube.numNodes;
        }

        void reduce(long pruningThreshold) {
            if (this.numChildren > 0) {
                for (int id = 0; id < 16; ++id) {
                    if (this.children[id] == null) continue;
                    this.children[id].reduce(pruningThreshold);
                }
            }
            if (this.quantizeError <= pruningThreshold) {
                this.prune();
            } else {
                if (this.uniqueCount > 0) {
                    ++this.cube.numColors;
                }
                if (this.quantizeError < this.cube.nextThreshold) {
                    this.cube.nextThreshold = this.quantizeError;
                }
            }
        }

        void findClosestColor(int red, int green, int blue, int alpha, ClosestColor closest) {
            int db;
            int dg;
            int dr;
            int da;
            int distance;
            if (this.numChildren > 0) {
                for (int id = 0; id < 16; ++id) {
                    if (this.children[id] == null) continue;
                    this.children[id].findClosestColor(red, green, blue, alpha, closest);
                }
            }
            if (this.uniqueCount != 0 && (distance = (da = (this.cube.colorMap[3][this.colorIndex] & 0xFF) - alpha) * da + (dr = (this.cube.colorMap[0][this.colorIndex] & 0xFF) - red) * dr + (dg = (this.cube.colorMap[1][this.colorIndex] & 0xFF) - green) * dg + (db = (this.cube.colorMap[2][this.colorIndex] & 0xFF) - blue) * db) < closest.distance) {
                closest.distance = distance;
                closest.colorIndex = this.colorIndex;
            }
        }

        int fillColorMap(byte[][] colorMap, int index) {
            if (this.numChildren > 0) {
                for (int id = 0; id < 16; ++id) {
                    if (this.children[id] == null) continue;
                    index = this.children[id].fillColorMap(colorMap, index);
                }
            }
            if (this.uniqueCount != 0) {
                colorMap[0][index] = (byte)((double)(this.totalRed / this.uniqueCount) + 0.5);
                colorMap[1][index] = (byte)((double)(this.totalGreen / this.uniqueCount) + 0.5);
                colorMap[2][index] = (byte)((double)(this.totalBlue / this.uniqueCount) + 0.5);
                colorMap[3][index] = (byte)((double)(this.totalAlpha / this.uniqueCount) + 0.5);
                this.colorIndex = index++;
            }
            return index;
        }
    }

    static class ClosestColor {
        int distance;
        int colorIndex;

        ClosestColor() {
        }
    }
}

