/*
 * Decompiled with CFR 0.152.
 */
package helma.framework.repository;

import helma.framework.repository.AbstractResource;
import helma.framework.repository.Repository;
import helma.framework.repository.ZipRepository;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public final class ZipResource
extends AbstractResource {
    private String entryName;
    private ZipRepository repository;
    private String name;
    private String shortName;
    private String baseName;

    protected ZipResource(String zipentryName, ZipRepository repository) {
        this.entryName = zipentryName;
        this.repository = repository;
        int lastSlash = this.entryName.lastIndexOf(47);
        this.shortName = this.entryName.substring(lastSlash + 1);
        this.name = repository.getName() + '/' + this.shortName;
        int lastDot = this.shortName.lastIndexOf(".");
        this.baseName = lastDot == -1 ? this.shortName : this.shortName.substring(0, lastDot);
    }

    public long lastModified() {
        return this.repository.lastModified();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream getInputStream() throws IOException {
        ZipFile zipfile = null;
        try {
            int r;
            zipfile = this.repository.getZipFile();
            ZipEntry entry = zipfile.getEntry(this.entryName);
            if (entry == null) {
                throw new IOException("Zip resource " + this + " does not exist");
            }
            int size = (int)entry.getSize();
            byte[] buf = new byte[size];
            InputStream in = zipfile.getInputStream(entry);
            for (int read = 0; read < size && (r = in.read(buf, read, size - read)) != -1; read += r) {
            }
            in.close();
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(buf);
            return byteArrayInputStream;
        }
        finally {
            zipfile.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean exists() {
        ZipFile zipfile = null;
        try {
            zipfile = this.repository.getZipFile();
            boolean bl = zipfile.getEntry(this.entryName) != null;
            return bl;
        }
        catch (Exception ex) {
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                zipfile.close();
            }
            catch (Exception ex) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getContent(String encoding) throws IOException {
        ZipFile zipfile = null;
        try {
            int r;
            zipfile = this.repository.getZipFile();
            ZipEntry entry = zipfile.getEntry(this.entryName);
            if (entry == null) {
                throw new IOException("Zip resource " + this + " does not exist");
            }
            InputStream in = zipfile.getInputStream(entry);
            int size = (int)entry.getSize();
            byte[] buf = new byte[size];
            for (int read = 0; read < size && (r = in.read(buf, read, size - read)) != -1; read += r) {
            }
            in.close();
            String string = encoding == null ? new String(buf) : new String(buf, encoding);
            return string;
        }
        finally {
            if (zipfile != null) {
                zipfile.close();
            }
        }
    }

    public String getContent() throws IOException {
        return this.getContent(null);
    }

    public String getName() {
        return this.name;
    }

    public String getShortName() {
        return this.shortName;
    }

    public String getBaseName() {
        return this.baseName;
    }

    public URL getUrl() {
        throw new UnsupportedOperationException("getUrl() not implemented for ZipResource");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getLength() {
        ZipFile zipfile = null;
        try {
            zipfile = this.repository.getZipFile();
            long l = zipfile.getEntry(this.entryName).getSize();
            return l;
        }
        catch (Exception ex) {
            long l = 0L;
            return l;
        }
        finally {
            try {
                zipfile.close();
            }
            catch (Exception ex) {}
        }
    }

    public Repository getRepository() {
        return this.repository;
    }

    public int hashCode() {
        return 17 + this.name.hashCode();
    }

    public boolean equals(Object obj) {
        return obj instanceof ZipResource && this.name.equals(((ZipResource)obj).name);
    }

    public String toString() {
        return this.getName();
    }
}

