/*
 * Decompiled with CFR 0.152.
 */
package helma.framework.repository;

import helma.framework.repository.AbstractRepository;
import helma.framework.repository.Repository;
import helma.framework.repository.Resource;
import helma.framework.repository.ZipResource;
import helma.util.StringUtils;
import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public final class ZipRepository
extends AbstractRepository {
    private File file;
    private int depth;
    String entryPath;
    private long lastModified = -1L;

    public ZipRepository(String initArgs) {
        this(new File(initArgs), null, null);
    }

    public ZipRepository(File file) {
        this(file, null, null);
    }

    public ZipRepository(File file, Repository parent) {
        this(file, parent, null);
    }

    private ZipRepository(File file, Repository parent, ZipEntry zipentry) {
        this.file = file.isAbsolute() ? file : file.getAbsoluteFile();
        this.parent = parent;
        if (zipentry == null) {
            this.name = this.shortName = file.getName();
            this.depth = 0;
            this.entryPath = "";
        } else {
            String[] pathArray = StringUtils.split(zipentry.getName(), "/");
            this.depth = pathArray.length;
            this.shortName = pathArray[this.depth - 1];
            this.entryPath = zipentry.getName();
            this.name = parent.getName() + '/' + this.shortName;
        }
    }

    protected ZipFile getZipFile() throws IOException {
        return new ZipFile(this.file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void update() {
        if (this.file.lastModified() != this.lastModified || this.repositories == null || this.resources == null) {
            this.lastModified = this.file.lastModified();
            ZipFile zipfile = null;
            try {
                zipfile = this.getZipFile();
                Enumeration<? extends ZipEntry> en = zipfile.entries();
                HashMap<String, ZipRepository> newRepositories = new HashMap<String, ZipRepository>();
                HashMap<String, ZipResource> newResources = new HashMap<String, ZipResource>();
                while (en.hasMoreElements()) {
                    ZipEntry entry = en.nextElement();
                    String eName = entry.getName();
                    if (!eName.regionMatches(0, this.entryPath, 0, this.entryPath.length())) continue;
                    String[] entrypath = StringUtils.split(eName, "/");
                    if (this.depth > 0 && !this.shortName.equals(entrypath[this.depth - 1])) continue;
                    if (entrypath.length == this.depth + 1 && !entry.isDirectory()) {
                        ZipResource resource = new ZipResource(entry.getName(), this);
                        newResources.put(resource.getShortName(), resource);
                        continue;
                    }
                    if (entrypath.length <= this.depth || newRepositories.containsKey(entrypath[this.depth])) continue;
                    ZipEntry child = this.composeChildEntry(entrypath[this.depth]);
                    ZipRepository rep = new ZipRepository(this.file, this, child);
                    newRepositories.put(entrypath[this.depth], rep);
                }
                this.repositories = newRepositories.values().toArray(new Repository[newRepositories.size()]);
                this.resources = newResources;
            }
            catch (Exception ex) {
                ex.printStackTrace();
                this.repositories = emptyRepositories;
                if (this.resources == null) {
                    this.resources = new HashMap();
                } else {
                    this.resources.clear();
                }
            }
            finally {
                try {
                    zipfile.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    private ZipEntry composeChildEntry(String name) {
        if (this.entryPath == null || this.entryPath.length() == 0) {
            return new ZipEntry(name);
        }
        if (this.entryPath.endsWith("/")) {
            return new ZipEntry(this.entryPath + name);
        }
        return new ZipEntry(this.entryPath + "/" + name);
    }

    protected Resource createResource(String name) {
        return new ZipResource(this.entryPath + "/" + name, this);
    }

    public long getChecksum() {
        return this.file.lastModified();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean exists() {
        ZipFile zipfile = null;
        try {
            zipfile = this.getZipFile();
            boolean bl = true;
            return bl;
        }
        catch (IOException ex) {
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                zipfile.close();
            }
            catch (Exception ex) {
                return false;
            }
        }
    }

    public void create() {
        throw new UnsupportedOperationException("create() not implemented for ZipRepository");
    }

    public boolean isScriptRoot() {
        return this.depth == 0;
    }

    public long lastModified() {
        return this.file.lastModified();
    }

    public int hashCode() {
        return 17 + 37 * this.file.hashCode() + 37 * this.name.hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ZipRepository)) {
            return false;
        }
        ZipRepository rep = (ZipRepository)obj;
        return this.file.equals(rep.file) && this.name.equals(rep.name);
    }

    public String toString() {
        return "ZipRepository[" + this.name + "]";
    }
}

