/*
 * Decompiled with CFR 0.152.
 */
package helma.framework.repository;

import helma.framework.repository.AbstractRepository;
import helma.framework.repository.FileResource;
import helma.framework.repository.Repository;
import helma.framework.repository.Resource;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class SingleFileRepository
implements Repository {
    final Resource res;
    final Repository parent;
    final Repository[] repositories;
    final LinkedList resources = new LinkedList();
    final LinkedList allResources = new LinkedList();
    final boolean isScriptFile;

    public SingleFileRepository(String initArgs) {
        this(new File(initArgs), null);
    }

    public SingleFileRepository(File file) {
        this(file, null);
    }

    public SingleFileRepository(File file, Repository parent) {
        this.parent = parent;
        this.res = new FileResource(file, this);
        this.allResources.add(this.res);
        this.isScriptFile = file.getName().endsWith(".js");
        if (this.isScriptFile) {
            this.repositories = new Repository[]{new FakeGlobal()};
        } else {
            this.repositories = AbstractRepository.emptyRepositories;
            this.resources.add(this.res);
        }
    }

    public long getChecksum() throws IOException {
        return this.res.lastModified();
    }

    public String getShortName() {
        return this.res.getShortName();
    }

    public String getName() {
        return this.res.getName();
    }

    public Repository getRootRepository() {
        return this;
    }

    public Repository getParentRepository() {
        return this.parent;
    }

    public boolean isScriptRoot() {
        return false;
    }

    public void create() throws IOException {
    }

    public boolean exists() throws IOException {
        return this.res.exists();
    }

    public Repository[] getRepositories() throws IOException {
        return this.repositories;
    }

    public List getAllResources() throws IOException {
        return this.resources;
    }

    public Iterator getResources() throws IOException {
        return this.resources.iterator();
    }

    public Resource getResource(String resourceName) {
        if (!this.isScriptFile && this.res.getName().equals(resourceName)) {
            return this.res;
        }
        return null;
    }

    public long lastModified() throws IOException {
        return this.res.lastModified();
    }

    protected Resource getResource() {
        return this.res;
    }

    public boolean equals(Object obj) {
        return obj instanceof SingleFileRepository && this.res.equals(((SingleFileRepository)obj).res);
    }

    public int hashCode() {
        return this.res.hashCode();
    }

    public String toString() {
        return "SingleFileRepository[" + this.res.getName() + "]";
    }

    class FakeGlobal
    implements Repository {
        FakeGlobal() {
        }

        public long getChecksum() throws IOException {
            return SingleFileRepository.this.res.lastModified();
        }

        public String getShortName() {
            return "Global";
        }

        public String getName() {
            return SingleFileRepository.this.res.getName();
        }

        public Repository getRootRepository() {
            return SingleFileRepository.this;
        }

        public Repository getParentRepository() {
            return SingleFileRepository.this;
        }

        public boolean isScriptRoot() {
            return false;
        }

        public void create() throws IOException {
        }

        public boolean exists() throws IOException {
            return SingleFileRepository.this.res.exists();
        }

        public Repository[] getRepositories() throws IOException {
            return AbstractRepository.emptyRepositories;
        }

        public List getAllResources() throws IOException {
            return SingleFileRepository.this.allResources;
        }

        public Iterator getResources() throws IOException {
            return SingleFileRepository.this.allResources.iterator();
        }

        public Resource getResource(String resourceName) {
            if (SingleFileRepository.this.res.getName().equals(resourceName)) {
                return SingleFileRepository.this.res;
            }
            return null;
        }

        public long lastModified() throws IOException {
            return SingleFileRepository.this.res.lastModified();
        }
    }
}

