/*
 * Decompiled with CFR 0.152.
 */
package helma.framework.repository;

import helma.framework.core.Application;
import helma.framework.repository.Repository;
import helma.framework.repository.Resource;
import java.util.Comparator;

public class ResourceComparator
implements Comparator {
    protected Application app;

    public ResourceComparator(Application app) {
        this.app = app;
    }

    public int compare(Object obj1, Object obj2) {
        if (obj1.equals(obj2)) {
            return 0;
        }
        Repository rep1 = this.getRootRepository(obj1);
        Repository rep2 = this.getRootRepository(obj2);
        int pos1 = this.app.getRepositoryIndex(rep1);
        int pos2 = this.app.getRepositoryIndex(rep2);
        if (rep1 == rep2 || pos1 == -1 && pos2 == -1) {
            return this.getFullName(obj1).compareTo(this.getFullName(obj2));
        }
        return pos1 - pos2;
    }

    public boolean equals(Object obj) {
        return obj instanceof ResourceComparator && this.app == ((ResourceComparator)obj).getApplication();
    }

    public Application getApplication() {
        return this.app;
    }

    private Repository getRootRepository(Object obj) {
        if (obj instanceof Resource) {
            return ((Resource)obj).getRepository().getRootRepository();
        }
        if (obj instanceof Repository) {
            return ((Repository)obj).getRootRepository();
        }
        throw new IllegalArgumentException("Can't compare " + obj);
    }

    private String getFullName(Object obj) {
        if (obj instanceof Resource) {
            return ((Resource)obj).getName();
        }
        if (obj instanceof Repository) {
            return ((Repository)obj).getName();
        }
        throw new IllegalArgumentException("Can't compare " + obj);
    }
}

