/*
 * Decompiled with CFR 0.152.
 */
package helma.framework.repository;

import helma.framework.repository.AbstractRepository;
import helma.framework.repository.FileRepository;
import helma.framework.repository.Repository;
import helma.framework.repository.ZipRepository;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;

public class MultiFileRepository
extends FileRepository {
    public MultiFileRepository(String initArgs) {
        this(new File(initArgs));
    }

    public MultiFileRepository(File dir) {
        super(dir, null);
    }

    public synchronized void update() {
        if (!this.directory.exists()) {
            this.repositories = emptyRepositories;
            if (this.resources != null) {
                this.resources.clear();
            }
            this.lastModified = 0L;
            return;
        }
        if (this.directory.lastModified() != this.lastModified) {
            this.lastModified = this.directory.lastModified();
            File[] list = this.directory.listFiles();
            ArrayList<AbstractRepository> newRepositories = new ArrayList<AbstractRepository>(list.length);
            HashMap newResources = new HashMap(list.length);
            for (int i = 0; i < list.length; ++i) {
                if (list[i].isDirectory()) {
                    newRepositories.add(new FileRepository(list[i], this));
                    continue;
                }
                if (!list[i].getName().endsWith(".zip")) continue;
                newRepositories.add(new ZipRepository(list[i], this));
            }
            this.repositories = newRepositories.toArray(new Repository[newRepositories.size()]);
            this.resources = newResources;
        }
    }

    public int hashCode() {
        return 37 + 37 * this.directory.hashCode();
    }

    public boolean equals(Object obj) {
        return obj instanceof MultiFileRepository && this.directory.equals(((MultiFileRepository)obj).directory);
    }

    public String toString() {
        return "MultiFileRepository[" + this.name + "]";
    }
}

