/*
 * Decompiled with CFR 0.152.
 */
package helma.framework.repository;

import helma.framework.repository.AbstractResource;
import helma.framework.repository.Repository;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;

public class FileResource
extends AbstractResource {
    File file;
    Repository repository;
    String name;
    String shortName;
    String baseName;

    public FileResource(File file) {
        this(file, null);
    }

    protected FileResource(File file, Repository repository) {
        this.file = file;
        this.repository = repository;
        this.name = file.getAbsolutePath();
        this.shortName = file.getName();
        int lastDot = this.shortName.lastIndexOf(".");
        this.baseName = lastDot == -1 ? this.shortName : this.shortName.substring(0, lastDot);
    }

    public String getName() {
        return this.name;
    }

    public String getShortName() {
        return this.shortName;
    }

    public String getBaseName() {
        return this.baseName;
    }

    public InputStream getInputStream() {
        try {
            return new FileInputStream(this.file);
        }
        catch (FileNotFoundException ex) {
            return null;
        }
    }

    public URL getUrl() {
        try {
            return new URL("file:" + this.file.getAbsolutePath());
        }
        catch (MalformedURLException ex) {
            return null;
        }
    }

    public long lastModified() {
        return this.file.lastModified();
    }

    public String getContent(String encoding) throws IOException {
        int r;
        InputStream in = this.getInputStream();
        int size = (int)this.file.length();
        byte[] buf = new byte[size];
        for (int read = 0; read < size && (r = in.read(buf, read, size - read)) != -1; read += r) {
        }
        in.close();
        return encoding == null ? new String(buf) : new String(buf, encoding);
    }

    public String getContent() throws IOException {
        return this.getContent(null);
    }

    public long getLength() {
        return this.file.length();
    }

    public boolean exists() {
        return this.file.exists();
    }

    public Repository getRepository() {
        return this.repository;
    }

    public int hashCode() {
        return 17 + this.name.hashCode();
    }

    public boolean equals(Object obj) {
        return obj instanceof FileResource && this.name.equals(((FileResource)obj).name);
    }

    public String toString() {
        return this.getName();
    }
}

