/*
 * Decompiled with CFR 0.152.
 */
package helma.framework.repository;

import helma.framework.repository.AbstractRepository;
import helma.framework.repository.FileResource;
import helma.framework.repository.MultiFileRepository;
import helma.framework.repository.Repository;
import helma.framework.repository.Resource;
import helma.framework.repository.ZipRepository;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;

public class FileRepository
extends AbstractRepository {
    protected File directory;
    protected long lastModified = -1L;
    protected long lastChecksum = 0L;
    protected long lastChecksumTime = 0L;
    final long cacheTime = 1000L;

    public FileRepository(String initArgs) {
        this(new File(initArgs), null);
    }

    public FileRepository(File dir) {
        this(dir, null);
    }

    public FileRepository(File dir, Repository parent) {
        this.directory = dir.isAbsolute() ? dir : dir.getAbsoluteFile();
        if (!this.directory.exists()) {
            this.create();
        } else if (!this.directory.isDirectory()) {
            throw new IllegalArgumentException("File " + this.directory + " is not a directory");
        }
        if (parent == null) {
            this.name = this.shortName = this.directory.getAbsolutePath();
        } else {
            this.parent = parent;
            this.shortName = this.directory.getName();
            this.name = this.directory.getAbsolutePath();
        }
    }

    public boolean exists() {
        return this.directory.exists() && this.directory.isDirectory();
    }

    public void create() {
        if (!this.directory.exists() || !this.directory.isDirectory()) {
            this.directory.mkdirs();
        }
    }

    public boolean isScriptRoot() {
        return this.parent == null || this.parent instanceof MultiFileRepository;
    }

    public long lastModified() {
        return this.directory.lastModified();
    }

    public synchronized long getChecksum() throws IOException {
        if (System.currentTimeMillis() > this.lastChecksumTime + 1000L) {
            this.update();
            long checksum = this.lastModified;
            for (int i = 0; i < this.repositories.length; ++i) {
                checksum += this.repositories[i].getChecksum();
            }
            this.lastChecksum = checksum;
            this.lastChecksumTime = System.currentTimeMillis();
        }
        return this.lastChecksum;
    }

    public synchronized void update() {
        if (!this.directory.exists()) {
            this.repositories = emptyRepositories;
            if (this.resources == null) {
                this.resources = new HashMap();
            } else {
                this.resources.clear();
            }
            this.lastModified = 0L;
            return;
        }
        if (this.directory.lastModified() != this.lastModified) {
            this.lastModified = this.directory.lastModified();
            File[] list = this.directory.listFiles();
            ArrayList<AbstractRepository> newRepositories = new ArrayList<AbstractRepository>(list.length);
            HashMap<String, FileResource> newResources = new HashMap<String, FileResource>(list.length);
            for (int i = 0; i < list.length; ++i) {
                if (list[i].isDirectory()) {
                    newRepositories.add(new FileRepository(list[i], this));
                    continue;
                }
                if (list[i].getName().endsWith(".zip")) {
                    newRepositories.add(new ZipRepository(list[i], this));
                    continue;
                }
                if (!list[i].isFile()) continue;
                FileResource resource = new FileResource(list[i], this);
                newResources.put(resource.getShortName(), resource);
            }
            this.repositories = newRepositories.toArray(new Repository[newRepositories.size()]);
            this.resources = newResources;
        }
    }

    protected Resource createResource(String name) {
        return new FileResource(new File(this.directory, name), this);
    }

    public File getDirectory() {
        return this.directory;
    }

    public int hashCode() {
        return 17 + 37 * this.directory.hashCode();
    }

    public boolean equals(Object obj) {
        return obj instanceof FileRepository && this.directory.equals(((FileRepository)obj).directory);
    }

    public String toString() {
        return "FileRepository[" + this.name + "]";
    }
}

