/*
 * Decompiled with CFR 0.152.
 */
package helma.framework.repository;

import helma.framework.repository.Repository;
import helma.framework.repository.Resource;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public abstract class AbstractRepository
implements Repository {
    Repository parent;
    Repository[] repositories;
    HashMap resources;
    String name;
    String shortName;
    static final Repository[] emptyRepositories = new Repository[0];

    public abstract void update();

    protected abstract Resource createResource(String var1);

    public String getName() {
        return this.name;
    }

    public String getShortName() {
        return this.shortName;
    }

    public Repository getRootRepository() {
        if (this.parent == null || this.isScriptRoot()) {
            return this;
        }
        return this.parent.getRootRepository();
    }

    public synchronized Resource getResource(String name) {
        this.update();
        Resource res = (Resource)this.resources.get(name);
        if (res == null) {
            res = this.createResource(name);
            this.resources.put(name, res);
        }
        return res;
    }

    public synchronized Iterator getResources() {
        this.update();
        return this.resources.values().iterator();
    }

    public synchronized Repository[] getRepositories() {
        this.update();
        return this.repositories;
    }

    public Repository getParentRepository() {
        return this.parent;
    }

    public synchronized List getAllResources() throws IOException {
        this.update();
        ArrayList allResources = new ArrayList();
        allResources.addAll(this.resources.values());
        for (int i = 0; i < this.repositories.length; ++i) {
            allResources.addAll(this.repositories[i].getAllResources());
        }
        return allResources;
    }

    public String toString() {
        return this.getName();
    }
}

