/*
 * Decompiled with CFR 0.152.
 */
package helma.framework.core;

import helma.framework.core.AppClassLoader;
import helma.framework.core.Application;
import helma.framework.core.Prototype;
import helma.framework.repository.Repository;
import helma.framework.repository.Resource;
import helma.objectmodel.db.DbMapping;
import helma.util.StringUtils;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public final class TypeManager {
    static final String[] standardTypes = new String[]{"User", "Global", "Root", "HopObject"};
    static final String templateExtension = ".hsp";
    static final String scriptExtension = ".js";
    static final String actionExtension = ".hac";
    static final String skinExtension = ".skin";
    private Application app;
    private HashMap prototypes;
    private HashSet jarfiles;
    private HashSet ignoreDirs;
    private long lastCheck = 0L;
    private long lastCodeUpdate;
    private HashMap lastRepoScan;
    private AppClassLoader loader;

    public TypeManager(Application app, String ignore) {
        URL helmajar;
        this.app = app;
        this.prototypes = new HashMap();
        this.jarfiles = new HashSet();
        this.ignoreDirs = new HashSet();
        this.lastRepoScan = new HashMap();
        if (ignore != null) {
            String[] arr = StringUtils.split(ignore, ",");
            for (int i = 0; i < arr.length; ++i) {
                this.ignoreDirs.add(arr[i].trim());
            }
        }
        if ((helmajar = TypeManager.class.getResource("/")) == null) {
            URL[] urls = ((URLClassLoader)TypeManager.class.getClassLoader()).getURLs();
            for (int i = 0; i < urls.length; ++i) {
                String url = urls[i].toString().toLowerCase();
                if (!url.endsWith("helma.jar")) continue;
                helmajar = urls[i];
                break;
            }
        }
        this.loader = helmajar == null ? new AppClassLoader(app.getName(), new URL[0]) : new AppClassLoader(app.getName(), new URL[]{helmajar});
    }

    public void createPrototypes() throws IOException {
        for (int i = 0; i < standardTypes.length; ++i) {
            this.createPrototype(standardTypes[i], null);
        }
        this.checkRepositories();
    }

    public synchronized void checkPrototypes() throws IOException {
        if (System.currentTimeMillis() - this.lastCheck < 1000L) {
            return;
        }
        this.checkRepositories();
        this.lastCheck = System.currentTimeMillis();
    }

    protected void checkRepository(Repository repository, boolean update) throws IOException {
        Repository[] list = repository.getRepositories();
        for (int i = 0; i < list.length; ++i) {
            if (this.ignoreDirs.contains(list[i].getShortName())) {
                if (!this.app.debug) continue;
                this.app.logEvent("Repository " + list[i].getName() + " ignored");
                continue;
            }
            if (list[i].isScriptRoot()) {
                if (!this.app.addRepository(list[i])) continue;
                this.checkRepository(list[i], update);
                continue;
            }
            String name = list[i].getShortName();
            Prototype proto = this.getPrototype(name);
            if (proto == null) {
                if (!this.isValidTypeName(name)) continue;
                this.createPrototype(name, list[i]);
                continue;
            }
            proto.addRepository(list[i], update);
        }
        Iterator resources = repository.getResources();
        while (resources.hasNext()) {
            Resource resource = (Resource)resources.next();
            String name = resource.getName();
            if (!name.endsWith(".jar") || this.jarfiles.contains(name)) continue;
            this.jarfiles.add(name);
            try {
                this.loader.addURL(resource.getUrl());
            }
            catch (UnsupportedOperationException x) {}
        }
    }

    private void checkRepositories() throws IOException {
        List list = this.app.getRepositories();
        for (int i = 0; i < list.size(); ++i) {
            long lastScan;
            Repository repository = (Repository)list.get(i);
            long l = lastScan = this.lastRepoScan.containsKey(repository) ? (Long)this.lastRepoScan.get(repository) : 0L;
            if (repository.lastModified() == lastScan) continue;
            this.lastRepoScan.put(repository, new Long(repository.lastModified()));
            this.checkRepository(repository, false);
        }
        Iterator i = this.prototypes.values().iterator();
        while (i.hasNext()) {
            Prototype proto = (Prototype)i.next();
            DbMapping dbmap = proto.getDbMapping();
            if (dbmap == null || !dbmap.needsUpdate()) continue;
            proto.props.update();
            dbmap.update();
        }
    }

    private boolean isValidTypeName(String str) {
        if (str == null) {
            return false;
        }
        char[] c = str.toCharArray();
        for (int i = 0; i < c.length; ++i) {
            if (Character.isJavaIdentifierPart(c[i])) continue;
            return false;
        }
        return true;
    }

    public long getLastCodeUpdate() {
        return this.lastCodeUpdate;
    }

    public void setLastCodeUpdate(long update) {
        this.lastCodeUpdate = update;
    }

    public ClassLoader getClassLoader() {
        return this.loader;
    }

    public Collection getPrototypes() {
        return Collections.unmodifiableCollection(this.prototypes.values());
    }

    public Prototype getPrototype(String typename) {
        if (typename == null) {
            return null;
        }
        return (Prototype)this.prototypes.get(typename.toLowerCase());
    }

    public Prototype createPrototype(String typename, Repository repository) {
        Prototype proto = new Prototype(typename, repository, this.app);
        this.prototypes.put(proto.getLowerCaseName(), proto);
        return proto;
    }
}

