/*
 * Decompiled with CFR 0.152.
 */
package helma.framework.core;

import helma.framework.core.Application;
import helma.framework.core.Prototype;
import helma.framework.core.Skin;
import helma.framework.repository.FileResource;
import helma.objectmodel.INode;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;

public final class SkinManager
implements FilenameFilter {
    Application app;
    final String skinProperty;
    final String skinExtension;

    public SkinManager(Application app) {
        this.app = app;
        this.skinProperty = app.getProperty("skinProperty", "skin");
        this.skinExtension = ".skin";
    }

    protected Skin getSkin(Prototype prototype, String skinname, Object[] skinpath) throws IOException {
        if (prototype == null) {
            return null;
        }
        Prototype proto = prototype;
        String parentName = null;
        String subskinName = null;
        int hash = skinname.indexOf(35);
        if (hash > -1) {
            parentName = skinname.substring(0, hash);
            subskinName = skinname.substring(hash + 1);
        }
        do {
            Skin skin;
            if (skinpath != null) {
                for (int i = 0; i < skinpath.length; ++i) {
                    skin = this.getSkinInPath(skinpath[i], proto.getName(), skinname);
                    if (skin != null && skin.hasMainskin()) {
                        return skin;
                    }
                    if (parentName == null || (skin = this.getSkinInPath(skinpath[i], proto.getName(), parentName)) == null || !skin.hasSubskin(subskinName)) continue;
                    return skin.getSubskin(subskinName);
                }
            }
            if ((skin = proto.getSkin(skinname, parentName, subskinName)) == null) continue;
            return skin;
        } while ((proto = proto.getParentPrototype()) != null);
        return null;
    }

    private Skin getSkinInPath(Object skinset, String prototype, String skinname) throws IOException {
        if (prototype == null || skinset == null) {
            return null;
        }
        if (skinset instanceof INode) {
            String skin;
            INode n = (INode)((INode)skinset).getChildElement(prototype);
            if (n != null && (n = (INode)n.getChildElement(skinname)) != null && (skin = n.getString(this.skinProperty)) != null) {
                return new Skin(skin, this.app);
            }
        } else {
            StringBuffer b = new StringBuffer(skinset.toString());
            b.append(File.separatorChar).append(prototype).append(File.separatorChar).append(skinname).append(this.skinExtension);
            File f = new File(b.toString());
            if (f.exists() && f.canRead()) {
                return Skin.getSkin(new FileResource(f), this.app);
            }
        }
        return null;
    }

    public boolean accept(File d, String n) {
        return n.endsWith(this.skinExtension);
    }
}

