/*
 * Decompiled with CFR 0.152.
 */
package helma.framework.core;

import helma.framework.RedirectException;
import helma.framework.ResponseTrans;
import helma.framework.TimeoutException;
import helma.framework.core.Application;
import helma.framework.core.Prototype;
import helma.framework.core.RequestEvaluator;
import helma.framework.repository.Resource;
import helma.objectmodel.ConcurrencyException;
import helma.scripting.ScriptingEngine;
import helma.util.CopyOnWriteMap;
import helma.util.HtmlEncoder;
import helma.util.StringUtils;
import helma.util.SystemMap;
import helma.util.UrlEncoded;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public final class Skin {
    private Macro[] macros;
    private Application app;
    private char[] source;
    private int offset;
    private int length;
    private HashSet sandbox;
    private HashMap subskins;
    private Skin parentSkin = this;
    private static final int PARSE_MACRONAME = 0;
    private static final int PARSE_PARAM = 1;
    private static final int PARSE_DONE = 2;
    private static final int ENCODE_NONE = 0;
    private static final int ENCODE_HTML = 1;
    private static final int ENCODE_XML = 2;
    private static final int ENCODE_FORM = 3;
    private static final int ENCODE_URL = 4;
    private static final int ENCODE_ALL = 5;
    private static final int HANDLER_RESPONSE = 0;
    private static final int HANDLER_REQUEST = 1;
    private static final int HANDLER_SESSION = 2;
    private static final int HANDLER_PARAM = 3;
    private static final int HANDLER_GLOBAL = 4;
    private static final int HANDLER_THIS = 5;
    private static final int HANDLER_OTHER = 6;
    private static final int FAIL_DEFAULT = 0;
    private static final int FAIL_SILENT = 1;
    private static final int FAIL_VERBOSE = 2;

    public Skin(String content, Application app) {
        this.app = app;
        this.sandbox = null;
        this.source = content.toCharArray();
        this.offset = 0;
        this.length = this.source.length;
        this.parse();
    }

    public Skin(String content, Application app, HashSet sandbox) {
        this.app = app;
        this.sandbox = sandbox;
        this.source = content.toCharArray();
        this.offset = 0;
        this.length = this.source.length;
        this.parse();
    }

    public Skin(char[] content, int length, Application app) {
        this.app = app;
        this.sandbox = null;
        this.source = content;
        this.offset = 0;
        this.length = length;
        this.parse();
    }

    private Skin(Skin parentSkin, Macro anchorMacro) {
        this.parentSkin = parentSkin;
        this.app = parentSkin.app;
        this.sandbox = parentSkin.sandbox;
        this.source = parentSkin.source;
        this.offset = anchorMacro.end;
        this.length = parentSkin.length;
        parentSkin.addSubskin(anchorMacro.name, this);
        this.parse();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Skin getSkin(Resource res, Application app) throws IOException {
        int read;
        String encoding = app.getProperty("skinCharset");
        InputStreamReader reader = encoding == null ? new InputStreamReader(res.getInputStream()) : new InputStreamReader(res.getInputStream(), encoding);
        int length = (int)res.getLength();
        char[] characterBuffer = new char[length];
        try {
            int r;
            for (read = 0; read < length; read += r) {
                r = ((Reader)reader).read(characterBuffer, read, length - read);
                if (r != -1) continue;
                break;
            }
        }
        finally {
            ((Reader)reader).close();
        }
        return new Skin(characterBuffer, read, app);
    }

    private void parse() {
        ArrayList<Macro> partBuffer = new ArrayList<Macro>();
        boolean escape = false;
        for (int i = this.offset; i < this.length - 1; ++i) {
            if (this.source[i] == '<' && this.source[i + 1] == '%' && !escape) {
                Macro macro = new Macro(i, 2);
                if (macro.isSubskinMacro) {
                    new Skin(this.parentSkin, macro);
                    this.length = i;
                    break;
                }
                partBuffer.add(macro);
                i = macro.end - 1;
                continue;
            }
            escape = this.source[i] == '\\' && !escape;
        }
        this.macros = new Macro[partBuffer.size()];
        partBuffer.toArray(this.macros);
    }

    private void addSubskin(String name, Skin subskin) {
        if (this.subskins == null) {
            this.subskins = new HashMap();
        }
        this.subskins.put(name, subskin);
    }

    public boolean hasMainskin() {
        return this.length - this.offset > 0 || this.subskins == null;
    }

    public boolean hasSubskin(String name) {
        return this.subskins != null && this.subskins.containsKey(name);
    }

    public Skin getSubskin(String name) {
        return this.subskins == null ? null : (Skin)this.subskins.get(name);
    }

    public String[] getSubskinNames() {
        return this.subskins == null ? new String[]{} : this.subskins.keySet().toArray(new String[0]);
    }

    public String getSource() {
        return new String(this.source, this.offset, this.length - this.offset);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String renderAsString(RequestEvaluator reval, Object thisObject, Object paramObject) throws RedirectException, UnsupportedEncodingException {
        String result = "";
        ResponseTrans res = reval.getResponse();
        res.pushBuffer(null);
        try {
            this.render(reval, thisObject, paramObject);
        }
        finally {
            result = res.popString();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void render(RequestEvaluator reval, Object thisObject, Object paramObject) throws RedirectException, UnsupportedEncodingException {
        if (++reval.skinDepth > 50) {
            throw new RuntimeException("Recursive skin invocation suspected");
        }
        ResponseTrans res = reval.getResponse();
        if (this.macros == null) {
            res.write(this.source, this.offset, this.length - this.offset);
            --reval.skinDepth;
            return;
        }
        Map handlers = res.getMacroHandlers();
        Object previousParam = handlers.put("param", paramObject);
        Skin previousSkin = res.switchActiveSkin(this.parentSkin);
        try {
            int written = this.offset;
            HashMap handlerCache = null;
            if (this.macros.length > 3) {
                handlerCache = new HashMap();
            }
            RenderContext cx = new RenderContext(reval, thisObject, handlerCache);
            for (int i = 0; i < this.macros.length; ++i) {
                if (this.macros[i].start > written) {
                    res.write(this.source, written, this.macros[i].start - written);
                }
                this.macros[i].render(cx);
                written = this.macros[i].end;
            }
            if (written < this.length) {
                res.write(this.source, written, this.length - written);
            }
        }
        finally {
            --reval.skinDepth;
            res.switchActiveSkin(previousSkin);
            if (previousParam == null) {
                handlers.remove("param");
            } else {
                handlers.put("param", previousParam);
            }
        }
    }

    public boolean containsMacro(String macroname) {
        for (int i = 0; i < this.macros.length; ++i) {
            if (!(this.macros[i] instanceof Macro)) continue;
            Macro m = this.macros[i];
            if (!macroname.equals(m.name)) continue;
            return true;
        }
        return false;
    }

    public void allowMacro(String macroname) {
        if (this.sandbox == null) {
            this.sandbox = new HashSet();
        }
        this.sandbox.add(macroname);
    }

    private Object processParameter(Object value, RenderContext cx) throws Exception {
        if (value instanceof Macro) {
            return ((Macro)value).invokeAsParameter(cx);
        }
        return value;
    }

    class UnhandledMacroException
    extends Exception {
        UnhandledMacroException(String name) {
            super(name);
        }
    }

    class RenderContext {
        final RequestEvaluator reval;
        final Object thisObject;
        final Map handlerCache;

        RenderContext(RequestEvaluator reval, Object thisObject, Map handlerCache) {
            this.reval = reval;
            this.thisObject = thisObject;
            this.handlerCache = handlerCache;
        }

        private Object resolveHandler(String handlerName, int handlerType) {
            switch (handlerType) {
                case 5: {
                    return this.thisObject;
                }
                case 0: {
                    return this.reval.getResponse().getResponseData();
                }
                case 1: {
                    return this.reval.getRequest().getRequestData();
                }
                case 2: {
                    return this.reval.getSession().getCacheNode();
                }
            }
            if (this.handlerCache != null && this.handlerCache.containsKey(handlerName)) {
                return this.handlerCache.get(handlerName);
            }
            if (this.thisObject != null) {
                if (handlerName.equalsIgnoreCase(Skin.this.app.getPrototypeName(this.thisObject))) {
                    if (this.handlerCache != null) {
                        this.handlerCache.put(handlerName, this.thisObject);
                    }
                    return this.thisObject;
                }
                Object obj = this.thisObject;
                while (obj != null) {
                    Prototype proto = Skin.this.app.getPrototype(obj);
                    if (proto != null && proto.isInstanceOf(handlerName)) {
                        if (this.handlerCache != null) {
                            this.handlerCache.put(handlerName, obj);
                        }
                        return obj;
                    }
                    obj = Skin.this.app.getParentElement(obj);
                }
            }
            Map macroHandlers = this.reval.getResponse().getMacroHandlers();
            Object obj = macroHandlers.get(handlerName);
            if (this.handlerCache != null && obj != null) {
                this.handlerCache.put(handlerName, obj);
            }
            return obj;
        }
    }

    class StandardParams {
        Object prefix = null;
        Object suffix = null;
        Object defaultValue = null;
        int failmode = 0;

        StandardParams() {
        }

        StandardParams(Map map) {
            this.readFrom(map);
        }

        void readFrom(Map map) {
            this.prefix = map.get("prefix");
            this.suffix = map.get("suffix");
            this.defaultValue = map.get("default");
        }

        boolean containsMacros() {
            return !(this.prefix instanceof String) || !(this.suffix instanceof String) || !(this.defaultValue instanceof String);
        }

        void setFailMode(Object value) {
            if ("silent".equals(value)) {
                this.failmode = 1;
            } else if ("verbose".equals(value)) {
                this.failmode = 2;
            } else if (value != null) {
                Skin.this.app.logEvent("unrecognized failmode value: " + value);
            }
        }

        boolean verboseFailmode(Object handler, ScriptingEngine engine) {
            return this.failmode == 2 || this.failmode == 0 && (handler == null || engine.isTypedObject(handler));
        }

        StandardParams render(RenderContext cx) throws Exception {
            if (!this.containsMacros()) {
                return this;
            }
            StandardParams stdParams = new StandardParams();
            stdParams.prefix = this.renderToString(this.prefix, cx);
            stdParams.suffix = this.renderToString(this.suffix, cx);
            stdParams.defaultValue = this.renderToString(this.defaultValue, cx);
            return stdParams;
        }

        String renderToString(Object obj, RenderContext cx) throws Exception {
            Object value = Skin.this.processParameter(obj, cx);
            if (value == null) {
                return null;
            }
            if (value instanceof String) {
                return (String)value;
            }
            return cx.reval.scriptingEngine.toString(value);
        }
    }

    class Macro {
        final int start;
        final int end;
        String name;
        String[] path;
        int handlerType = 6;
        int encoding = 0;
        boolean hasNestedMacros = false;
        StandardParams standardParams = new StandardParams();
        Map namedParams = null;
        List positionalParams = null;
        Macro filterChain;
        boolean isCommentMacro = false;
        boolean isSubskinMacro = false;

        Macro(int start, int macroOffset) {
            this.start = start;
            int i = this.parse(macroOffset, false);
            this.end = this.isSubskinMacro ? (i + 1 < Skin.this.length && Skin.this.source[i] == '\r' && Skin.this.source[i + 1] == '\n' ? Math.min(Skin.this.length, i + 2) : (i < Skin.this.length && (Skin.this.source[i] == '\r' || Skin.this.source[i] == '\n') ? Math.min(Skin.this.length, i + 1) : Math.min(Skin.this.length, i))) : Math.min(Skin.this.length, i);
            this.path = StringUtils.split(this.name, ".");
            if (this.path.length <= 1) {
                this.handlerType = 4;
            } else {
                String handlerName = this.path[0];
                if ("this".equalsIgnoreCase(handlerName)) {
                    this.handlerType = 5;
                } else if ("response".equalsIgnoreCase(handlerName)) {
                    this.handlerType = 0;
                } else if ("request".equalsIgnoreCase(handlerName)) {
                    this.handlerType = 1;
                } else if ("session".equalsIgnoreCase(handlerName)) {
                    this.handlerType = 2;
                } else if ("param".equalsIgnoreCase(handlerName)) {
                    this.handlerType = 3;
                }
            }
        }

        private int parse(int macroOffset, boolean lenient) {
            int i;
            int state = 0;
            boolean escape = false;
            char quotechar = '\u0000';
            String lastParamName = null;
            StringBuffer b = new StringBuffer();
            block11: for (i = this.start + macroOffset; i < Skin.this.length - 1; ++i) {
                switch (Skin.this.source[i]) {
                    case '<': {
                        if (state == 1 && quotechar == '\u0000' && b.length() == 0 && Skin.this.source[i + 1] == '%') {
                            Macro macro = new Macro(i, 2);
                            this.addParameter(lastParamName, macro);
                            lastParamName = null;
                            b.setLength(0);
                            i = macro.end - 1;
                            break;
                        }
                        b.append(Skin.this.source[i]);
                        escape = false;
                        break;
                    }
                    case '%': {
                        if ((state != 1 || quotechar == '\u0000' || lenient) && Skin.this.source[i + 1] == '>') {
                            state = 2;
                            break block11;
                        }
                        b.append(Skin.this.source[i]);
                        escape = false;
                        break;
                    }
                    case '/': {
                        b.append(Skin.this.source[i]);
                        escape = false;
                        if (state != 0 || !"//".equals(b.toString())) break;
                        this.isCommentMacro = true;
                        while (i < Skin.this.length - 1 && (Skin.this.source[i] != '%' || Skin.this.source[i + 1] != '>')) {
                            ++i;
                        }
                        state = 2;
                        break block11;
                    }
                    case '#': {
                        if (state == 0 && b.length() == 0) {
                            this.isSubskinMacro = true;
                            break;
                        }
                        b.append(Skin.this.source[i]);
                        escape = false;
                        break;
                    }
                    case '|': {
                        if (!escape && quotechar == '\u0000') {
                            this.filterChain = new Macro(i, 1);
                            i = this.filterChain.end - 2;
                            lastParamName = null;
                            b.setLength(0);
                            state = 2;
                            break block11;
                        }
                        b.append(Skin.this.source[i]);
                        escape = false;
                        break;
                    }
                    case '\\': {
                        if (escape) {
                            b.append(Skin.this.source[i]);
                        }
                        escape = !escape;
                        break;
                    }
                    case '\"': 
                    case '\'': {
                        if (!escape && state == 1) {
                            if (quotechar == Skin.this.source[i]) {
                                if (Skin.this.source[i + 1] != '%' && !Character.isWhitespace(Skin.this.source[i + 1]) && !lenient) {
                                    this.reset();
                                    return this.parse(macroOffset, true);
                                }
                                this.addParameter(lastParamName, b.toString());
                                lastParamName = null;
                                b.setLength(0);
                                quotechar = '\u0000';
                            } else if (quotechar == '\u0000') {
                                quotechar = Skin.this.source[i];
                                b.setLength(0);
                            } else {
                                b.append(Skin.this.source[i]);
                            }
                        } else {
                            b.append(Skin.this.source[i]);
                        }
                        escape = false;
                        break;
                    }
                    case '\t': 
                    case '\n': 
                    case '\f': 
                    case '\r': 
                    case ' ': {
                        if (state == 0 && b.length() > 0) {
                            this.name = b.toString().trim();
                            b.setLength(0);
                            state = 1;
                            break;
                        }
                        if (state != 1) break;
                        if (quotechar == '\u0000') {
                            if (b.length() <= 0) break;
                            this.addParameter(lastParamName, b.toString());
                            lastParamName = null;
                            b.setLength(0);
                            break;
                        }
                        b.append(Skin.this.source[i]);
                        escape = false;
                        break;
                    }
                    case '=': {
                        if (!escape && quotechar == '\u0000' && state == 1 && lastParamName == null) {
                            lastParamName = b.toString().trim();
                            b.setLength(0);
                            break;
                        }
                        b.append(Skin.this.source[i]);
                        escape = false;
                        break;
                    }
                    default: {
                        b.append(Skin.this.source[i]);
                        escape = false;
                    }
                }
                if (i != Skin.this.length - 2 || lenient || state == 2 && quotechar == '\u0000') continue;
                this.reset();
                return this.parse(macroOffset, true);
            }
            if (b.length() > 0) {
                if (this.name == null) {
                    this.name = b.toString().trim();
                } else {
                    this.addParameter(lastParamName, b.toString());
                }
            }
            if (state != 2) {
                Skin.this.app.logError("Unterminated Macro Tag: " + this);
            }
            return i + 2;
        }

        private void reset() {
            this.filterChain = null;
            this.name = null;
            this.standardParams = new StandardParams();
            this.namedParams = null;
            this.positionalParams = null;
        }

        private void addParameter(String name, Object value) {
            if (!(value instanceof String)) {
                this.hasNestedMacros = true;
            }
            if (name == null) {
                if (this.positionalParams == null) {
                    this.positionalParams = new ArrayList();
                }
                this.positionalParams.add(value);
                return;
            }
            if ("prefix".equals(name)) {
                this.standardParams.prefix = value;
            } else if ("suffix".equals(name)) {
                this.standardParams.suffix = value;
            } else if ("encoding".equals(name)) {
                if ("html".equals(value)) {
                    this.encoding = 1;
                } else if ("xml".equals(value)) {
                    this.encoding = 2;
                } else if ("form".equals(value)) {
                    this.encoding = 3;
                } else if ("url".equals(value)) {
                    this.encoding = 4;
                } else if ("all".equals(value)) {
                    this.encoding = 5;
                } else {
                    Skin.this.app.logEvent("Unrecognized encoding in skin macro: " + value);
                }
            } else if ("default".equals(name)) {
                this.standardParams.defaultValue = value;
            } else if ("failmode".equals(name)) {
                this.standardParams.setFailMode(value);
            }
            if (this.namedParams == null) {
                this.namedParams = new HashMap();
            }
            this.namedParams.put(name, value);
        }

        private Object invokeAsMacro(RenderContext cx, StandardParams stdParams, boolean asObject) throws Exception {
            if (this.isCommentMacro || this.name == null) {
                return null;
            }
            if (Skin.this.sandbox != null && !Skin.this.sandbox.contains(this.name)) {
                throw new RuntimeException("Macro " + this.name + " not allowed in sandbox");
            }
            Object handler = null;
            Object value = null;
            ScriptingEngine engine = cx.reval.scriptingEngine;
            if (this.handlerType != 4) {
                handler = cx.resolveHandler(this.path[0], this.handlerType);
                handler = this.resolvePath(handler, cx.reval);
            }
            if (this.handlerType == 4 || handler != null) {
                String propName = this.path[this.path.length - 1];
                String funcName = this.resolveFunctionName(handler, propName + "_macro", engine);
                StringBuffer buffer = cx.reval.getResponse().getBuffer();
                int bufLength = buffer.length();
                if (funcName != null) {
                    Object[] arguments = this.prepareArguments(0, cx);
                    Map params = (Map)arguments[0];
                    value = cx.reval.invokeDirectFunction(handler, funcName, arguments);
                    if (stdParams != null) {
                        stdParams.readFrom(params);
                    }
                    if (asObject && value == null && buffer.length() > bufLength) {
                        value = buffer.substring(bufLength);
                        buffer.setLength(bufLength);
                    }
                    return this.filter(value, cx);
                }
                if (this.handlerType == 0) {
                    if ("message".equals(propName)) {
                        value = cx.reval.getResponse().getMessage();
                    } else if ("error".equals(propName)) {
                        value = cx.reval.getResponse().getError();
                    }
                    if (value != null) {
                        return this.filter(value, cx);
                    }
                }
                if (!engine.hasProperty(handler, propName)) {
                    if (engine.hasFunction(handler, "onUnhandledMacro", false)) {
                        Object[] arguments = this.prepareArguments(1, cx);
                        arguments[0] = propName;
                        value = cx.reval.invokeDirectFunction(handler, "onUnhandledMacro", arguments);
                        if (asObject && value == null && buffer.length() > bufLength) {
                            value = buffer.substring(bufLength);
                            buffer.setLength(bufLength);
                        }
                    } else if (this.standardParams.verboseFailmode(handler, engine)) {
                        throw new UnhandledMacroException(this.name);
                    }
                } else {
                    value = engine.getProperty(handler, propName);
                }
                return this.filter(value, cx);
            }
            if (this.standardParams.verboseFailmode(handler, engine)) {
                throw new UnhandledMacroException(this.name);
            }
            return this.filter(null, cx);
        }

        Object invokeAsParameter(RenderContext cx) throws Exception {
            StandardParams stdParams = this.standardParams.render(cx);
            Object value = this.invokeAsMacro(cx, stdParams, true);
            if (stdParams.prefix != null || stdParams.suffix != null) {
                ResponseTrans res = cx.reval.getResponse();
                res.pushBuffer(null);
                this.writeResponse(value, cx.reval, stdParams, true);
                return res.popString();
            }
            if (stdParams.defaultValue != null && (value == null || "".equals(value))) {
                return stdParams.defaultValue;
            }
            return value;
        }

        void render(RenderContext cx) throws RedirectException, UnsupportedEncodingException {
            StringBuffer buffer = cx.reval.getResponse().getBuffer();
            int bufLength = buffer.length();
            try {
                StandardParams stdParams = this.standardParams.render(cx);
                boolean asObject = this.filterChain != null;
                Object value = this.invokeAsMacro(cx, stdParams, asObject);
                if (buffer.length() == bufLength) {
                    this.writeResponse(value, cx.reval, stdParams, true);
                } else {
                    if (this.encoding != 0) {
                        String output = buffer.substring(bufLength);
                        buffer.setLength(bufLength);
                        this.writeResponse(output, cx.reval, stdParams, false);
                    } else {
                        if (stdParams.prefix != null) {
                            buffer.insert(bufLength, stdParams.prefix);
                        }
                        if (stdParams.suffix != null) {
                            buffer.append(stdParams.suffix);
                        }
                    }
                    this.writeResponse(value, cx.reval, stdParams, false);
                }
            }
            catch (RedirectException redir) {
                throw redir;
            }
            catch (ConcurrencyException concur) {
                throw concur;
            }
            catch (TimeoutException timeout) {
                throw timeout;
            }
            catch (UnhandledMacroException unhandled) {
                String msg = "Unhandled Macro: " + unhandled.getMessage();
                cx.reval.getResponse().write(" [" + msg + "] ");
                Skin.this.app.logError(msg);
            }
            catch (Exception x) {
                String msg = x.getMessage();
                if (msg == null || msg.length() < 10) {
                    msg = x.toString();
                }
                msg = "Macro error in " + this.name + ": " + msg;
                cx.reval.getResponse().write(" [" + msg + "] ");
                Skin.this.app.logError(msg, x);
            }
        }

        private Object filter(Object returnValue, RenderContext cx) throws Exception {
            if (this.filterChain != null) {
                return this.filterChain.invokeAsFilter(returnValue, cx);
            }
            return returnValue;
        }

        private Object invokeAsFilter(Object returnValue, RenderContext cx) throws Exception {
            String propName;
            String funcName;
            if (this.name == null) {
                throw new RuntimeException("Empty macro filter");
            }
            if (Skin.this.sandbox != null && !Skin.this.sandbox.contains(this.name)) {
                throw new RuntimeException("Macro " + this.name + " not allowed in sandbox");
            }
            Object handlerObject = null;
            if (this.handlerType != 4) {
                handlerObject = cx.resolveHandler(this.path[0], this.handlerType);
                handlerObject = this.resolvePath(handlerObject, cx.reval);
            }
            if ((funcName = this.resolveFunctionName(handlerObject, propName = this.path[this.path.length - 1] + "_filter", cx.reval.scriptingEngine)) != null) {
                Object[] arguments = this.prepareArguments(1, cx);
                arguments[0] = returnValue;
                Object retval = cx.reval.invokeDirectFunction(handlerObject, funcName, arguments);
                return this.filter(retval, cx);
            }
            throw new RuntimeException("Undefined Filter " + this.name);
        }

        private Object[] prepareArguments(int offset, RenderContext cx) throws Exception {
            int nPosArgs = this.positionalParams == null ? 0 : this.positionalParams.size();
            Object[] arguments = new Object[offset + 1 + nPosArgs];
            if (this.namedParams == null) {
                arguments[offset] = new SystemMap(4);
            } else if (this.hasNestedMacros) {
                SystemMap map = new SystemMap((int)((double)this.namedParams.size() * 1.5));
                Iterator it = this.namedParams.entrySet().iterator();
                while (it.hasNext()) {
                    Map.Entry entry = it.next();
                    Object value = entry.getValue();
                    if (!(value instanceof String)) {
                        value = Skin.this.processParameter(value, cx);
                    }
                    map.put(entry.getKey(), value);
                }
                arguments[offset] = map;
            } else {
                arguments[offset] = new CopyOnWriteMap(this.namedParams);
            }
            if (this.positionalParams != null) {
                for (int i = 0; i < nPosArgs; ++i) {
                    Object value = this.positionalParams.get(i);
                    if (!(value instanceof String)) {
                        value = Skin.this.processParameter(value, cx);
                    }
                    arguments[offset + 1 + i] = value;
                }
            }
            return arguments;
        }

        private Object resolvePath(Object handler, RequestEvaluator reval) throws Exception {
            for (int i = 1; i < this.path.length - 1; ++i) {
                Object[] arguments = new Object[]{this.path[i]};
                Object next = reval.invokeDirectFunction(handler, "getMacroHandler", arguments);
                if (next != null) {
                    handler = next;
                    continue;
                }
                if (!reval.scriptingEngine.isTypedObject(handler)) {
                    if ((handler = reval.scriptingEngine.getProperty(handler, this.path[i])) != null) continue;
                    return null;
                }
                return null;
            }
            return handler;
        }

        private String resolveFunctionName(Object handler, String functionName, ScriptingEngine engine) {
            if (this.handlerType == 4) {
                String[] macroPath = ((Skin)Skin.this).app.globalMacroPath;
                if (macroPath == null || macroPath.length == 0) {
                    if (engine.hasFunction(null, functionName, false)) {
                        return functionName;
                    }
                } else {
                    for (int i = 0; i < macroPath.length; ++i) {
                        String funcName;
                        String path = macroPath[i];
                        String string = funcName = path == null || path.length() == 0 ? functionName : path + "." + functionName;
                        if (!engine.hasFunction(null, funcName, true)) continue;
                        return funcName;
                    }
                }
            } else if (engine.hasFunction(handler, functionName, false)) {
                return functionName;
            }
            return null;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        void writeResponse(Object value, RequestEvaluator reval, StandardParams stdParams, boolean useDefault) throws Exception {
            String text;
            StringBuffer buffer = reval.getResponse().getBuffer();
            if (value == null || "".equals(value)) {
                if (!useDefault) return;
                text = (String)stdParams.defaultValue;
            } else {
                text = reval.scriptingEngine.toString(value);
            }
            if (text == null || text.length() <= 0) return;
            if (stdParams.prefix != null && value != null) {
                buffer.append(stdParams.prefix);
            }
            switch (this.encoding) {
                case 0: {
                    buffer.append(text);
                    break;
                }
                case 1: {
                    HtmlEncoder.encode(text, buffer);
                    break;
                }
                case 2: {
                    HtmlEncoder.encodeXml(text, buffer);
                    break;
                }
                case 3: {
                    HtmlEncoder.encodeFormValue(text, buffer);
                    break;
                }
                case 4: {
                    buffer.append(UrlEncoded.encode(text, ((Skin)Skin.this).app.charset));
                    break;
                }
                case 5: {
                    HtmlEncoder.encodeAll(text, buffer);
                }
            }
            if (stdParams.suffix == null || value == null) return;
            buffer.append(stdParams.suffix);
        }

        public String toString() {
            return "[Macro: " + this.name + "]";
        }

        String getName() {
            return this.name;
        }
    }
}

