/*
 * Decompiled with CFR 0.152.
 */
package helma.framework.core;

import helma.framework.core.Application;
import helma.framework.core.Session;
import helma.framework.core.SessionBean;
import helma.objectmodel.INode;
import helma.objectmodel.db.Node;
import helma.scripting.ScriptingEngine;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;

public class SessionManager {
    protected Hashtable sessions = new Hashtable();
    protected Application app;

    public void init(Application app) {
        this.app = app;
    }

    public void shutdown() {
        this.sessions.clear();
    }

    public Session createSession(String sessionId) {
        Session session = this.getSession(sessionId);
        if (session == null) {
            session = new Session(sessionId, this.app);
            this.sessions.put(sessionId, session);
        }
        return session;
    }

    public Session getSession(String sessionId) {
        if (sessionId == null) {
            return null;
        }
        return (Session)this.sessions.get(sessionId);
    }

    public Map getSessions() {
        return (Map)this.sessions.clone();
    }

    public int countSessions() {
        return this.sessions.size();
    }

    public void discardSession(Session session) {
        this.logoutSession(session);
        this.sessions.remove(session.getSessionId());
    }

    public boolean loginSession(String uname, String password, Session session) {
        if (uname == null) {
            return false;
        }
        if ("".equals(uname = uname.toLowerCase().trim())) {
            return false;
        }
        try {
            INode users = this.app.getUserRoot();
            Node unode = (Node)users.getChildElement(uname);
            String pw = unode.getString("password");
            if (pw != null && pw.equals(password)) {
                this.logoutSession(session);
                session.login(unode);
                return true;
            }
        }
        catch (Exception x) {
            return false;
        }
        return false;
    }

    public void logoutSession(Session session) {
        session.logout();
    }

    public List getSessionsForUsername(String username) {
        ArrayList<SessionBean> list = new ArrayList<SessionBean>();
        if (username == null) {
            return list;
        }
        Enumeration e = this.sessions.elements();
        while (e.hasMoreElements()) {
            Session s = (Session)e.nextElement();
            if (s == null || !username.equals(s.getUID())) continue;
            list.add(new SessionBean(s));
        }
        return list;
    }

    public List getActiveUsers() {
        ArrayList<INode> list = new ArrayList<INode>();
        Enumeration e = this.sessions.elements();
        while (e.hasMoreElements()) {
            INode node;
            Session s = (Session)e.nextElement();
            if (s == null || !s.isLoggedIn() || (node = s.getUserNode()) == null || list.contains(node)) continue;
            list.add(node);
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void storeSessionData(File f, ScriptingEngine engine) {
        if (f == null) {
            f = new File(this.app.dbDir, "sessions");
        }
        try {
            BufferedOutputStream ostream = new BufferedOutputStream(new FileOutputStream(f));
            ObjectOutputStream p = new ObjectOutputStream(ostream);
            Hashtable hashtable = this.sessions;
            synchronized (hashtable) {
                p.writeInt(this.sessions.size());
                Enumeration e = this.sessions.elements();
                while (e.hasMoreElements()) {
                    try {
                        engine.serialize(e.nextElement(), p);
                    }
                    catch (NotSerializableException nsx) {
                        this.app.logError("Error serializing session.", nsx);
                    }
                }
            }
            p.flush();
            ((OutputStream)ostream).close();
            this.app.logEvent("stored " + this.sessions.size() + " sessions in file");
        }
        catch (Exception e) {
            this.app.logError("error storing session data.", e);
        }
    }

    public void loadSessionData(File f, ScriptingEngine engine) {
        if (f == null) {
            f = new File(this.app.dbDir, "sessions");
        }
        int sessionTimeout = 30;
        try {
            sessionTimeout = Math.max(0, Integer.parseInt(this.app.getProperty("sessionTimeout", "30")));
        }
        catch (Exception ignore) {
            System.out.println(ignore.toString());
        }
        long now = System.currentTimeMillis();
        try {
            BufferedInputStream istream = new BufferedInputStream(new FileInputStream(f));
            ObjectInputStream p = new ObjectInputStream(istream);
            int size = p.readInt();
            Hashtable<String, Session> newSessions = new Hashtable<String, Session>();
            for (int ct = 0; ct < size; ++ct) {
                Session session = (Session)engine.deserialize(p);
                if (now - session.lastTouched() >= (long)(sessionTimeout * 60000)) continue;
                session.setApp(this.app);
                newSessions.put(session.getSessionId(), session);
            }
            p.close();
            ((InputStream)istream).close();
            this.sessions = newSessions;
            this.app.logEvent("loaded " + newSessions.size() + " sessions from file");
        }
        catch (FileNotFoundException fnf) {
        }
        catch (Exception e) {
            this.app.logError("error loading session data.", e);
        }
    }
}

