/*
 * Decompiled with CFR 0.152.
 */
package helma.framework.core;

import helma.framework.ResponseTrans;
import helma.framework.UploadStatus;
import helma.framework.core.Application;
import helma.framework.core.RequestEvaluator;
import helma.objectmodel.INode;
import helma.objectmodel.TransientNode;
import helma.objectmodel.db.Node;
import helma.objectmodel.db.NodeHandle;
import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;

public class Session
implements Serializable {
    protected transient Application app;
    protected String sessionId;
    protected String uid;
    protected NodeHandle userHandle;
    protected TransientNode cacheNode;
    protected long onSince;
    protected long lastTouched;
    protected long lastModified;
    protected String message;
    protected StringBuffer debugBuffer;
    protected HashMap uploads = null;

    public Session(String sessionId, Application app) {
        this.sessionId = sessionId;
        this.app = app;
        this.uid = null;
        this.userHandle = null;
        this.cacheNode = new TransientNode("session");
        this.lastTouched = this.lastModified = (this.onSince = System.currentTimeMillis());
    }

    public void login(INode usernode) {
        if (usernode == null) {
            this.userHandle = null;
            this.uid = null;
        } else {
            this.userHandle = ((Node)usernode).getHandle();
            this.uid = usernode.getElementName();
        }
        this.lastModified = System.currentTimeMillis();
    }

    public boolean login(String userName, String password) {
        return this.app.loginSession(userName, password, this);
    }

    public void logout() {
        this.userHandle = null;
        this.uid = null;
        this.lastModified = System.currentTimeMillis();
    }

    public boolean isLoggedIn() {
        return this.userHandle != null && this.uid != null;
    }

    public void setUserHandle(NodeHandle handle) {
        this.userHandle = handle;
    }

    public NodeHandle getUserHandle() {
        return this.userHandle;
    }

    public INode getUserNode() {
        if (this.userHandle != null) {
            return this.userHandle.getNode(this.app.getWrappedNodeManager());
        }
        return null;
    }

    public void setCacheNode(TransientNode node) {
        this.cacheNode = node;
    }

    public INode getCacheNode() {
        return this.cacheNode;
    }

    public Application getApp() {
        return this.app;
    }

    public void setApp(Application app) {
        this.app = app;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public void touch() {
        this.lastTouched = System.currentTimeMillis();
    }

    public void commit(RequestEvaluator reval) {
    }

    public long lastTouched() {
        return this.lastTouched;
    }

    public long lastModified() {
        return this.lastModified;
    }

    public void setLastModified(Date date) {
        if (date != null) {
            this.lastModified = date.getTime();
        }
    }

    public long onSince() {
        return this.onSince;
    }

    public String toString() {
        if (this.uid != null) {
            return "[Session for user " + this.uid + "]";
        }
        return "[Anonymous Session]";
    }

    public String getUID() {
        return this.uid;
    }

    public synchronized void recoverResponseMessages(ResponseTrans res) {
        if (this.message != null || this.debugBuffer != null) {
            res.setMessage(this.message);
            res.setDebugBuffer(this.debugBuffer);
            this.message = null;
            this.debugBuffer = null;
        }
    }

    public synchronized void storeResponseMessages(ResponseTrans res) {
        this.message = res.getMessage();
        this.debugBuffer = res.getDebugBuffer();
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String msg) {
        this.message = msg;
    }

    public StringBuffer getDebugBuffer() {
        return this.debugBuffer;
    }

    public void setDebugBuffer(StringBuffer buffer) {
        this.debugBuffer = buffer;
    }

    protected UploadStatus createUpload(String uploadId) {
        if (this.uploads == null) {
            this.uploads = new HashMap();
        }
        UploadStatus status = new UploadStatus();
        this.uploads.put(uploadId, status);
        return status;
    }

    protected UploadStatus getUpload(String uploadId) {
        if (this.uploads == null) {
            return null;
        }
        return (UploadStatus)this.uploads.get(uploadId);
    }

    protected void pruneUploads() {
        if (this.uploads == null || this.uploads.isEmpty()) {
            return;
        }
        Iterator it = this.uploads.values().iterator();
        while (it.hasNext()) {
            UploadStatus status = (UploadStatus)it.next();
            if (!status.isDisposable()) continue;
            it.remove();
        }
    }
}

