/*
 * Decompiled with CFR 0.152.
 */
package helma.framework.core;

import helma.framework.core.Application;
import helma.framework.core.Prototype;
import helma.util.UrlEncoded;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class RequestPath {
    Application app;
    List objects;
    List ids;
    Map primaryProtos;
    Map secondaryProtos;

    public RequestPath(Application app) {
        this.app = app;
        this.objects = new ArrayList();
        this.ids = new ArrayList();
        this.primaryProtos = new HashMap();
        this.secondaryProtos = new HashMap();
    }

    public void add(String id, Object obj) {
        this.ids.add(id);
        this.objects.add(obj);
        Prototype proto = this.app.getPrototype(obj);
        if (proto != null) {
            this.primaryProtos.put(proto.getName(), obj);
            this.primaryProtos.put(proto.getLowerCaseName(), obj);
            proto.registerParents(this.secondaryProtos, obj);
        }
    }

    public int size() {
        return this.objects.size();
    }

    public Object get(int idx) {
        if (idx < 0 || idx >= this.objects.size()) {
            return null;
        }
        return this.objects.get(idx);
    }

    public Object getByPrototypeName(String typeName) {
        Object obj = this.primaryProtos.get(typeName);
        if (obj != null) {
            return obj;
        }
        return this.secondaryProtos.get(typeName);
    }

    public String href(String action) throws UnsupportedEncodingException {
        Object rootObject;
        StringBuffer buffer = new StringBuffer(this.app.getBaseURI());
        int start = 1;
        String hrefRootPrototype = this.app.getHrefRootPrototype();
        if (hrefRootPrototype != null && (rootObject = this.getByPrototypeName(hrefRootPrototype)) != null) {
            start = this.objects.indexOf(rootObject) + 1;
        }
        for (int i = start; i < this.ids.size(); ++i) {
            buffer.append(UrlEncoded.encode(this.ids.get(i).toString(), this.app.charset));
            buffer.append("/");
        }
        if (action != null) {
            buffer.append(UrlEncoded.encode(action, this.app.charset));
        }
        return buffer.toString();
    }

    public int contains(Object obj) {
        return this.objects.indexOf(obj);
    }

    public int indexOf(Object obj) {
        return this.objects.indexOf(obj);
    }

    public String toString() {
        if (this.ids.size() <= 1) {
            return "/";
        }
        StringBuffer buffer = new StringBuffer();
        for (int i = 1; i < this.ids.size(); ++i) {
            buffer.append('/');
            buffer.append(this.ids.get(i));
        }
        return buffer.toString();
    }
}

