/*
 * Decompiled with CFR 0.152.
 */
package helma.framework.core;

import helma.framework.ApplicationStoppedException;
import helma.framework.IPathElement;
import helma.framework.RequestBean;
import helma.framework.RequestTrans;
import helma.framework.ResponseBean;
import helma.framework.ResponseTrans;
import helma.framework.TimeoutException;
import helma.framework.core.Application;
import helma.framework.core.ApplicationBean;
import helma.framework.core.Session;
import helma.framework.core.SessionBean;
import helma.objectmodel.db.Transactor;
import helma.scripting.ScriptingEngine;
import helma.scripting.ScriptingException;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;

public final class RequestEvaluator
implements Runnable {
    static final int NONE = 0;
    static final int HTTP = 1;
    static final int XMLRPC = 2;
    static final int INTERNAL = 3;
    static final int EXTERNAL = 4;
    public static final Object[] EMPTY_ARGS = new Object[0];
    public final Application app;
    protected ScriptingEngine scriptingEngine;
    protected int skinDepth;
    private volatile RequestTrans req;
    private volatile ResponseTrans res;
    private volatile Transactor rtx;
    private volatile int reqtype;
    private volatile Object thisObject;
    private volatile Object function;
    private volatile Session session;
    private volatile Object[] args;
    private volatile Object result;
    private volatile Exception exception;

    public RequestEvaluator(Application app) {
        this.app = app;
    }

    protected synchronized void initScriptingEngine() {
        if (this.scriptingEngine == null) {
            String engineClassName = this.app.getProperty("scriptingEngine", "helma.scripting.rhino.RhinoEngine");
            try {
                this.app.setCurrentRequestEvaluator(this);
                Class<?> clazz = this.app.getClassLoader().loadClass(engineClassName);
                this.scriptingEngine = (ScriptingEngine)clazz.newInstance();
                this.scriptingEngine.init(this.app, this);
            }
            catch (Exception x) {
                Throwable t = x;
                if (x instanceof InvocationTargetException) {
                    t = ((InvocationTargetException)x).getTargetException();
                }
                this.app.logEvent("******************************************");
                this.app.logEvent("*** Error creating scripting engine: ");
                this.app.logEvent("*** " + t.toString());
                this.app.logEvent("******************************************");
                this.app.logError("Error creating scripting engine", t);
                this.scriptingEngine = null;
                if (t instanceof RuntimeException) {
                    throw (RuntimeException)t;
                }
                throw new RuntimeException(t.toString(), t);
            }
            finally {
                this.app.setCurrentRequestEvaluator(null);
            }
        }
    }

    /*
     * Exception decompiling
     */
    public void run() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[TRYBLOCK], 0[TRYBLOCK]], but top level block is 39[CASE]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    synchronized void commitTransaction() throws Exception {
        Transactor localrtx = (Transactor)Thread.currentThread();
        if (localrtx != this.rtx) {
            throw new TimeoutException();
        }
        localrtx.commit();
    }

    synchronized void abortTransaction() {
        Transactor localrtx = (Transactor)Thread.currentThread();
        localrtx.abort();
    }

    private synchronized void startTransactor() {
        if (!this.app.isRunning()) {
            throw new ApplicationStoppedException();
        }
        if (this.rtx == null || !this.rtx.isAlive()) {
            this.rtx = new Transactor(this, this.app.threadgroup, this.app.nmgr);
            this.rtx.setContextClassLoader(this.app.getClassLoader());
            this.rtx.start();
        } else {
            this.notifyAll();
        }
    }

    synchronized void notifyAndWait() {
        Transactor localrtx = (Transactor)Thread.currentThread();
        if (localrtx != this.rtx) {
            localrtx.closeConnections();
            return;
        }
        this.reqtype = 0;
        this.notifyAll();
        try {
            this.wait(600000L);
        }
        catch (InterruptedException ix) {
            this.rtx = null;
        }
        if (this.reqtype == 0 && this.rtx == localrtx) {
            this.rtx = null;
        }
    }

    synchronized boolean stopTransactor() {
        Transactor t = this.rtx;
        this.rtx = null;
        boolean stopped = false;
        if (t != null && t.isActive()) {
            if (this.scriptingEngine != null) {
                this.scriptingEngine.abort();
            }
            this.app.logEvent("Request timeout for thread " + t);
            this.reqtype = 0;
            t.kill();
            t.abort();
            t.closeConnections();
            stopped = true;
        }
        this.notifyAll();
        return stopped;
    }

    public synchronized ResponseTrans invokeHttp(RequestTrans req, Session session) throws Exception {
        this.initObjects(req, session);
        this.app.activeRequests.put(req, this);
        this.startTransactor();
        this.wait(this.app.requestTimeout);
        if (this.reqtype != 0 && this.stopTransactor()) {
            this.res.reset();
            this.res.reportError(this.app.getName(), "Request timed out");
        }
        session.commit(this);
        return this.res;
    }

    public synchronized ResponseTrans attachHttpRequest(RequestTrans req) throws Exception {
        ResponseTrans localRes = this.res;
        if (localRes == null || !req.equals(this.req)) {
            return null;
        }
        if (this.reqtype != 0) {
            this.wait(this.app.requestTimeout);
        }
        return localRes;
    }

    public synchronized Object invokeXmlRpc(String functionName, Object[] args) throws Exception {
        this.initObjects(functionName, 2, "XMLRPC");
        this.function = functionName;
        this.args = args;
        this.startTransactor();
        this.wait(this.app.requestTimeout);
        if (this.reqtype != 0 && this.stopTransactor()) {
            this.exception = new RuntimeException("Request timed out");
        }
        this.res = null;
        if (this.exception != null) {
            throw this.exception;
        }
        return this.result;
    }

    public synchronized Object invokeExternal(String functionName, Object[] args) throws Exception {
        this.initObjects(functionName, 4, "EXTERNAL");
        this.function = functionName;
        this.args = args;
        this.startTransactor();
        this.wait();
        if (this.reqtype != 0 && this.stopTransactor()) {
            this.exception = new RuntimeException("Request timed out");
        }
        this.res = null;
        if (this.exception != null) {
            throw this.exception;
        }
        return this.result;
    }

    public Object invokeDirectFunction(Object obj, Object function, Object[] args) throws Exception {
        return this.scriptingEngine.invoke(obj, function, args, 1, true);
    }

    public synchronized Object invokeInternal(Object object, Object function, Object[] args) throws Exception {
        return this.invokeInternal(object, function, args, 900000L);
    }

    public synchronized Object invokeInternal(Object object, Object function, Object[] args, long timeout) throws Exception {
        this.initObjects(function, 3, "INTERNAL");
        this.thisObject = object;
        this.function = function;
        this.args = args;
        this.startTransactor();
        if (timeout < 0L) {
            this.wait();
        } else {
            this.wait(timeout);
        }
        if (this.reqtype != 0 && this.stopTransactor()) {
            this.exception = new RuntimeException("Request timed out");
        }
        this.res = null;
        if (this.exception != null) {
            throw this.exception;
        }
        return this.result;
    }

    private synchronized void initObjects(RequestTrans req, Session session) {
        this.req = req;
        this.reqtype = 1;
        this.session = session;
        this.res = new ResponseTrans(this.app, req);
        this.result = null;
        this.exception = null;
    }

    private synchronized void initObjects(Object function, int reqtype, String reqtypeName) {
        this.reqtype = reqtype;
        String functionName = function instanceof String ? (String)function : "<function>";
        this.req = new RequestTrans(reqtypeName, functionName);
        this.session = new Session(functionName, this.app);
        this.res = new ResponseTrans(this.app, this.req);
        this.result = null;
        this.exception = null;
    }

    private synchronized void initGlobals(Object root, Object requestPath) throws ScriptingException {
        HashMap<String, Object> globals = new HashMap<String, Object>();
        globals.put("root", root);
        globals.put("session", new SessionBean(this.session));
        globals.put("req", new RequestBean(this.req));
        globals.put("res", new ResponseBean(this.res));
        globals.put("app", new ApplicationBean(this.app));
        globals.put("path", requestPath);
        this.scriptingEngine.enterContext(globals);
    }

    private Object getChildElement(Object obj, String name) throws ScriptingException {
        if (this.scriptingEngine.hasFunction(obj, "getChildElement", false)) {
            return this.scriptingEngine.invoke(obj, "getChildElement", new Object[]{name}, 1, false);
        }
        if (obj instanceof IPathElement) {
            return ((IPathElement)obj).getChildElement(name);
        }
        return null;
    }

    synchronized void recycle() {
        this.res = null;
        this.req = null;
        this.session = null;
        this.function = null;
        this.args = null;
        this.result = null;
        this.exception = null;
    }

    public String getAction(Object obj, String action, RequestTrans req) {
        String method;
        if (obj == null) {
            return null;
        }
        if (action == null) {
            action = "main";
        }
        StringBuffer buffer = new StringBuffer(action).append("_action");
        int length = buffer.length();
        if (req.checkXmlRpc()) {
            buffer.append("_xmlrpc");
            if (this.scriptingEngine.hasFunction(obj, buffer.toString(), false)) {
                req.setMethod("XMLRPC");
                return buffer.toString();
            }
            buffer.setLength(length);
        }
        if ((method = req.getMethod()) != null) {
            buffer.append('_').append(method.toLowerCase());
            if (this.scriptingEngine.hasFunction(obj, buffer.toString(), false)) {
                return buffer.toString();
            }
            buffer.setLength(length);
        }
        if ((method == null || "GET".equalsIgnoreCase(method) || "POST".equalsIgnoreCase(method) || "HEAD".equalsIgnoreCase(method)) && this.scriptingEngine.hasFunction(obj, buffer.toString(), false)) {
            return buffer.toString();
        }
        return null;
    }

    public ScriptingEngine getScriptingEngine() {
        if (this.scriptingEngine == null) {
            this.initScriptingEngine();
        }
        return this.scriptingEngine;
    }

    public synchronized RequestTrans getRequest() {
        return this.req;
    }

    public synchronized ResponseTrans getResponse() {
        return this.res;
    }

    public synchronized Transactor getThread() {
        return this.rtx;
    }

    public synchronized Session getSession() {
        return this.session;
    }

    private String missingFunctionMessage(Object obj, String funcName) {
        if (obj == null) {
            return "Function " + funcName + " not defined in global scope";
        }
        return "Function " + funcName + " not defined for " + obj;
    }
}

