/*
 * Decompiled with CFR 0.152.
 */
package helma.framework.core;

import helma.framework.core.Application;
import helma.framework.core.RequestEvaluator;
import helma.framework.core.Skin;
import helma.framework.repository.FileResource;
import helma.framework.repository.Repository;
import helma.framework.repository.Resource;
import helma.framework.repository.ResourceTracker;
import helma.objectmodel.db.DbMapping;
import helma.scripting.ScriptingEngine;
import helma.util.ResourceProperties;
import helma.util.WrappedMap;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public final class Prototype {
    Application app;
    String name;
    String lowerCaseName;
    Resource[] resources;
    long lastChecksum = -1L;
    volatile long lastCodeUpdate = 0L;
    TreeSet code;
    TreeSet skins;
    HashMap trackers;
    TreeSet repositories;
    SkinMap skinMap;
    DbMapping dbmap;
    private Prototype parent;
    ResourceProperties props;

    public Prototype(String name, Repository repository, Application app) {
        this.app = app;
        this.name = name;
        this.repositories = new TreeSet(app.getResourceComparator());
        if (repository != null) {
            this.repositories.add(repository);
        }
        this.lowerCaseName = name.toLowerCase();
        this.props = new ResourceProperties(app);
        if (repository != null) {
            this.props.addResource(repository.getResource("type.properties"));
        }
        this.dbmap = new DbMapping(app, name, this.props);
        this.code = new TreeSet(app.getResourceComparator());
        this.skins = new TreeSet(app.getResourceComparator());
        this.trackers = new HashMap();
        this.skinMap = new SkinMap();
    }

    public Application getApplication() {
        return this.app;
    }

    public void addRepository(Repository repository, boolean update) throws IOException {
        if (!this.repositories.contains(repository)) {
            this.repositories.add(repository);
            this.props.addResource(repository.getResource("type.properties"));
            if (update) {
                RequestEvaluator eval = this.app.getCurrentRequestEvaluator();
                ScriptingEngine engine = eval == null ? null : eval.scriptingEngine;
                Iterator it = repository.getAllResources().iterator();
                while (it.hasNext()) {
                    this.checkResource((Resource)it.next(), engine);
                }
            }
        }
    }

    public synchronized void checkForUpdates() {
        boolean updatedResources = false;
        Iterator i = this.trackers.values().iterator();
        while (i.hasNext()) {
            ResourceTracker tracker = (ResourceTracker)i.next();
            try {
                if (!tracker.hasChanged()) continue;
                updatedResources = true;
                tracker.markClean();
                if (tracker.getResource().exists()) continue;
                i.remove();
                String name = tracker.getResource().getName();
                if (name.endsWith(".skin")) {
                    this.skins.remove(tracker.getResource());
                    continue;
                }
                this.code.remove(tracker.getResource());
            }
            catch (IOException iox) {
                iox.printStackTrace();
            }
        }
        Resource[] resources = this.getResources();
        for (int i2 = 0; i2 < resources.length; ++i2) {
            updatedResources |= this.checkResource(resources[i2], null);
        }
        if (updatedResources) {
            this.lastCodeUpdate = System.currentTimeMillis();
            this.app.typemgr.setLastCodeUpdate(this.lastCodeUpdate);
        }
    }

    private boolean checkResource(Resource res, ScriptingEngine engine) {
        String name = res.getName();
        boolean updated = false;
        if (!this.trackers.containsKey(name) && (name.endsWith(".hsp") || name.endsWith(".js") || name.endsWith(".hac") || name.endsWith(".skin"))) {
            updated = true;
            if (name.endsWith(".skin")) {
                this.skins.add(res);
            } else {
                if (engine != null) {
                    engine.injectCodeResource(this.lowerCaseName, res);
                }
                this.code.add(res);
            }
            this.trackers.put(res.getName(), new ResourceTracker(res));
        }
        return updated;
    }

    public Resource[] getResources() {
        long checksum = this.getRepositoryChecksum();
        if (checksum != this.lastChecksum) {
            ArrayList list = new ArrayList();
            Iterator iterator = this.repositories.iterator();
            while (iterator.hasNext()) {
                try {
                    list.addAll(((Repository)iterator.next()).getAllResources());
                }
                catch (IOException iox) {
                    iox.printStackTrace();
                }
            }
            this.resources = list.toArray(new Resource[list.size()]);
            this.lastChecksum = checksum;
        }
        return this.resources;
    }

    public Repository[] getRepositories() {
        return this.repositories.toArray(new Repository[this.repositories.size()]);
    }

    long getRepositoryChecksum() {
        long checksum = 0L;
        Iterator iterator = this.repositories.iterator();
        while (iterator.hasNext()) {
            try {
                checksum += ((Repository)iterator.next()).getChecksum();
            }
            catch (IOException iox) {
                iox.printStackTrace();
            }
        }
        return checksum;
    }

    public void setParentPrototype(Prototype parent) {
        if ("hopobject".equals(this.lowerCaseName) || "global".equals(this.lowerCaseName)) {
            return;
        }
        this.parent = parent;
    }

    public Prototype getParentPrototype() {
        return this.parent;
    }

    public final boolean isInstanceOf(String pname) {
        if (this.name.equalsIgnoreCase(pname)) {
            return true;
        }
        if (this.parent != null) {
            return this.parent.isInstanceOf(pname);
        }
        return false;
    }

    public final void registerParents(Map handlers, Object obj) {
        Prototype p = this.parent;
        while (p != null && !"hopobject".equals(p.getLowerCaseName())) {
            Object old = handlers.put(p.name, obj);
            if (old != null) {
                handlers.put(p.name, old);
            }
            if ((old = handlers.put(p.lowerCaseName, obj)) != null) {
                handlers.put(p.lowerCaseName, old);
            }
            p = p.parent;
        }
    }

    public DbMapping getDbMapping() {
        return this.dbmap;
    }

    public Skin getSkin(String skinName, String parentName, String subName) throws IOException {
        Resource res;
        Skin skin = null;
        for (res = this.skinMap.getResource(skinName); res != null && !(skin = Skin.getSkin(res, this.app)).hasMainskin(); res = res.getOverloadedResource()) {
        }
        if (parentName != null) {
            Resource parent;
            Skin parentSkin = null;
            for (parent = this.skinMap.getResource(parentName); parent != null && !(parentSkin = Skin.getSkin(parent, this.app)).hasSubskin(subName); parent = parent.getOverloadedResource()) {
            }
            if (parent != null) {
                if (res != null && this.app.getResourceComparator().compare(res, parent) > 0) {
                    return skin;
                }
                return parentSkin.getSubskin(subName);
            }
        }
        return skin;
    }

    public String getName() {
        return this.name;
    }

    public String getLowerCaseName() {
        return this.lowerCaseName;
    }

    public long lastCodeUpdate() {
        return this.lastCodeUpdate;
    }

    public void markUpdated() {
        this.lastCodeUpdate = System.currentTimeMillis();
    }

    public ResourceProperties getTypeProperties() {
        return this.props;
    }

    public synchronized Iterator getCodeResources() {
        return new ArrayList(this.code).iterator();
    }

    public Iterator getSkinResources() {
        return this.skins.iterator();
    }

    public String toString() {
        return "[Prototype " + this.app.getName() + "/" + this.name + "]";
    }

    public Map getScriptableSkinMap() {
        return new ScriptableSkinMap(new SkinMap());
    }

    public Map getScriptableSkinMap(Object[] skinpath) {
        return new ScriptableSkinMap(new SkinMap(skinpath));
    }

    class SkinMap
    extends HashMap {
        volatile long lastSkinmapLoad = -1L;
        Object[] skinpath;

        SkinMap() {
            this.skinpath = null;
        }

        SkinMap(Object[] path) {
            this.skinpath = path;
        }

        public boolean containsKey(Object key) {
            this.checkForUpdates();
            return super.containsKey(key);
        }

        public boolean containsValue(Object value) {
            this.checkForUpdates();
            return super.containsValue(value);
        }

        public Set entrySet() {
            this.checkForUpdates();
            return super.entrySet();
        }

        public boolean equals(Object obj) {
            this.checkForUpdates();
            return super.equals(obj);
        }

        public Skin getSkin(Object key) throws IOException {
            Resource res = (Resource)this.get(key);
            if (res != null) {
                return Skin.getSkin(res, Prototype.this.app);
            }
            return null;
        }

        public Resource getResource(Object key) {
            return (Resource)this.get(key);
        }

        public Object get(Object key) {
            this.checkForUpdates();
            return super.get(key);
        }

        public int hashCode() {
            this.checkForUpdates();
            return super.hashCode();
        }

        public boolean isEmpty() {
            this.checkForUpdates();
            return super.isEmpty();
        }

        public Set keySet() {
            this.checkForUpdates();
            return super.keySet();
        }

        public Object put(Object key, Object value) {
            return super.put(key, value);
        }

        public void putAll(Map t) {
            super.putAll(t);
        }

        public Object remove(Object key) {
            this.checkForUpdates();
            return super.remove(key);
        }

        public int size() {
            this.checkForUpdates();
            return super.size();
        }

        public Collection values() {
            this.checkForUpdates();
            return super.values();
        }

        private void checkForUpdates() {
            if (Prototype.this.lastCodeUpdate > this.lastSkinmapLoad) {
                if (Prototype.this.lastCodeUpdate == 0L) {
                    Prototype.this.checkForUpdates();
                }
                this.loadSkins();
            }
        }

        private synchronized void loadSkins() {
            if (Prototype.this.lastCodeUpdate == this.lastSkinmapLoad) {
                return;
            }
            super.clear();
            Iterator i = Prototype.this.skins.iterator();
            while (i.hasNext()) {
                Resource res = (Resource)i.next();
                Resource prev = super.put(res.getBaseName(), res);
                res.setOverloadedResource(prev);
            }
            if (this.skinpath != null) {
                for (int i2 = this.skinpath.length - 1; i2 >= 0; --i2) {
                    if (this.skinpath[i2] == null || !(this.skinpath[i2] instanceof String)) continue;
                    this.loadSkinFiles((String)this.skinpath[i2]);
                }
            }
            this.lastSkinmapLoad = Prototype.this.lastCodeUpdate;
        }

        private void loadSkinFiles(String skinDir) {
            File dir = new File(skinDir, Prototype.this.getName());
            if (!dir.isDirectory() && !(dir = new File(skinDir, Prototype.this.getLowerCaseName())).isDirectory()) {
                return;
            }
            String[] skinNames = dir.list(Prototype.this.app.skinmgr);
            if (skinNames == null || skinNames.length == 0) {
                return;
            }
            for (int i = 0; i < skinNames.length; ++i) {
                String name = skinNames[i].substring(0, skinNames[i].length() - 5);
                File file = new File(dir, skinNames[i]);
                FileResource res = new FileResource(file);
                Resource prev = super.put(name, res);
                res.setOverloadedResource(prev);
            }
        }

        public String toString() {
            return "[SkinMap " + Prototype.this.name + "]";
        }
    }

    class ScriptableSkinMap
    extends WrappedMap {
        public ScriptableSkinMap(Map wrapped) {
            super(wrapped);
        }

        public Object get(Object key) {
            Resource res = (Resource)super.get(key);
            if (res == null || !res.exists()) {
                return null;
            }
            try {
                return res.getContent();
            }
            catch (IOException iox) {
                return null;
            }
        }
    }
}

