/*
 * Decompiled with CFR 0.152.
 */
package helma.framework.core;

import helma.framework.FutureResult;
import helma.framework.core.Application;
import helma.framework.core.Prototype;
import helma.framework.core.RequestEvaluator;
import helma.framework.core.Session;
import helma.framework.core.SessionBean;
import helma.framework.core.Skin;
import helma.framework.repository.FileRepository;
import helma.framework.repository.Repository;
import helma.framework.repository.Resource;
import helma.framework.repository.SingleFileRepository;
import helma.framework.repository.ZipRepository;
import helma.main.Server;
import helma.objectmodel.INode;
import helma.objectmodel.db.DbSource;
import helma.util.CronJob;
import helma.util.SystemMap;
import helma.util.WrappedMap;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ApplicationBean
implements Serializable {
    Application app;
    WrappedMap properties = null;

    public ApplicationBean(Application app) {
        this.app = app;
    }

    public void clearCache() {
        this.app.clearCache();
    }

    public Log getLogger() {
        return this.app.getEventLog();
    }

    public Log getLogger(String logname) {
        return LogFactory.getLog((String)logname);
    }

    public void log(Object msg) {
        this.getLogger().info(msg);
    }

    public void log(String logname, Object msg) {
        this.getLogger(logname).info(msg);
    }

    public void debug(Object msg) {
        if (this.app.debug()) {
            this.getLogger().debug(msg);
        }
    }

    public void debug(String logname, Object msg) {
        if (this.app.debug()) {
            this.getLogger(logname).debug(msg);
        }
    }

    public Object[] getRepositories() {
        return this.app.getRepositories().toArray();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void addRepository(Object obj) {
        Repository rep;
        Repository parent;
        Resource current = this.app.getCurrentCodeResource();
        Repository repository = parent = current == null ? null : current.getRepository().getRootRepository();
        if (obj instanceof String) {
            String path = (String)obj;
            File file = new File(path).getAbsoluteFile();
            if (!file.exists()) {
                file = new File(path + ".zip").getAbsoluteFile();
            }
            if (!file.exists()) {
                file = new File(path + ".js").getAbsoluteFile();
            }
            if (!file.exists()) {
                throw new RuntimeException("Repository path does not exist: " + obj);
            }
            if (file.isDirectory()) {
                rep = new FileRepository(file, parent);
            } else {
                if (!file.isFile()) throw new RuntimeException("Unrecognized file type in addRepository: " + obj);
                rep = file.getName().endsWith(".zip") ? new ZipRepository(file, parent) : new SingleFileRepository(file, parent);
            }
        } else {
            if (!(obj instanceof Repository)) throw new RuntimeException("Invalid argument to addRepository: " + obj);
            rep = (Repository)obj;
        }
        this.app.addRepository(rep);
        try {
            this.app.typemgr.checkRepository(rep, true);
            return;
        }
        catch (IOException iox) {
            this.getLogger().error((Object)("Error checking repository " + rep), (Throwable)iox);
        }
    }

    public ClassLoader getClassLoader() {
        return this.app.getClassLoader();
    }

    public int countSessions() {
        return this.app.countSessions();
    }

    public SessionBean getSession(String sessionID) {
        if (sessionID == null) {
            return null;
        }
        Session session = this.app.getSession(sessionID.trim());
        if (session == null) {
            return null;
        }
        return new SessionBean(session);
    }

    public SessionBean createSession(String sessionID) {
        if (sessionID == null) {
            return null;
        }
        Session session = this.app.createSession(sessionID.trim());
        if (session == null) {
            return null;
        }
        return new SessionBean(session);
    }

    public SessionBean[] getSessions() {
        Map sessions = this.app.getSessions();
        SessionBean[] array = new SessionBean[sessions.size()];
        int i = 0;
        Iterator it = sessions.values().iterator();
        while (it.hasNext()) {
            array[i++] = new SessionBean((Session)it.next());
        }
        return array;
    }

    public INode registerUser(String username, String password) {
        if (username == null || password == null || "".equals(username.trim()) || "".equals(password.trim())) {
            return null;
        }
        return this.app.registerUser(username, password);
    }

    public INode getUser(String username) {
        if (username == null || "".equals(username.trim())) {
            return null;
        }
        return this.app.getUserNode(username);
    }

    public INode[] getActiveUsers() {
        List activeUsers = this.app.getActiveUsers();
        return activeUsers.toArray(new INode[0]);
    }

    public INode[] getRegisteredUsers() {
        List registeredUsers = this.app.getRegisteredUsers();
        return registeredUsers.toArray(new INode[0]);
    }

    public SessionBean[] getSessionsForUser(INode usernode) {
        if (usernode == null) {
            return new SessionBean[0];
        }
        return this.getSessionsForUser(usernode.getName());
    }

    public SessionBean[] getSessionsForUser(String username) {
        if (username == null || "".equals(username.trim())) {
            return new SessionBean[0];
        }
        List userSessions = this.app.getSessionsForUsername(username);
        return userSessions.toArray(new SessionBean[0]);
    }

    public void addCronJob(String functionName) {
        CronJob job = new CronJob(functionName);
        job.setFunction(functionName);
        this.app.customCronJobs.put(functionName, job);
    }

    public void addCronJob(String functionName, String year, String month, String day, String weekday, String hour, String minute) {
        CronJob job = CronJob.newJob(functionName, year, month, day, weekday, hour, minute);
        this.app.customCronJobs.put(functionName, job);
    }

    public void removeCronJob(String functionName) {
        this.app.customCronJobs.remove(functionName);
    }

    public Map getCronJobs() {
        return new WrappedMap(this.app.customCronJobs, true);
    }

    public int getCacheusage() {
        return this.app.getCacheUsage();
    }

    public INode getData() {
        return this.app.getCacheNode();
    }

    public Map getModules() {
        return this.app.modules;
    }

    public String getDir() {
        return this.app.getAppDir().getAbsolutePath();
    }

    public String getName() {
        return this.app.getName();
    }

    public Date getUpSince() {
        return new Date(this.app.starttime);
    }

    public long getRequestCount() {
        return this.app.getRequestCount();
    }

    public long getXmlrpcCount() {
        return this.app.getXmlrpcCount();
    }

    public long getErrorCount() {
        return this.app.getErrorCount();
    }

    public Application get__app__() {
        return this.app;
    }

    public Map getProperties() {
        if (this.properties == null) {
            this.properties = new WrappedMap(this.app.getProperties(), true);
        }
        return this.properties;
    }

    public Map getDbProperties() {
        return new WrappedMap(this.app.getDbProperties(), true);
    }

    public DbSource getDbSource(String name) {
        return this.app.getDbSource(name);
    }

    public Map getAppsProperties() {
        Server server = Server.getServer();
        if (server == null) {
            return new SystemMap();
        }
        return new WrappedMap(server.getAppsProperties(this.app.getName()), true);
    }

    public Prototype[] getPrototypes() {
        return this.app.getPrototypes().toArray(new Prototype[0]);
    }

    public Prototype getPrototype(String name) {
        return this.app.getPrototypeByName(name);
    }

    public int getFreeThreads() {
        return this.app.countFreeEvaluators();
    }

    public int getActiveThreads() {
        return this.app.countActiveEvaluators();
    }

    public int getMaxThreads() {
        return this.app.countEvaluators();
    }

    public void setMaxThreads(int n) {
        this.app.setNumberOfEvaluators(n + 1);
    }

    public Skin getSkin(String protoname, String skinname, Object[] skinpath) {
        try {
            return this.app.getSkin(protoname, skinname, skinpath);
        }
        catch (Exception x) {
            return null;
        }
    }

    public Map getSkinfiles() {
        SystemMap skinz = new SystemMap();
        Iterator it = this.app.getPrototypes().iterator();
        while (it.hasNext()) {
            Prototype p = (Prototype)it.next();
            Map skinmap = p.getScriptableSkinMap();
            skinz.put(p.getName(), skinmap);
            skinz.put(p.getLowerCaseName(), skinmap);
        }
        return skinz;
    }

    public Map getSkinfilesInPath(Object[] skinpath) {
        SystemMap skinz = new SystemMap();
        Iterator it = this.app.getPrototypes().iterator();
        while (it.hasNext()) {
            Prototype p = (Prototype)it.next();
            Map skinmap = p.getScriptableSkinMap(skinpath);
            skinz.put(p.getName(), skinmap);
            skinz.put(p.getLowerCaseName(), skinmap);
        }
        return skinz;
    }

    public String getAppDir() {
        return this.app.getAppDir().getAbsolutePath();
    }

    public String getServerDir() {
        File f = this.app.getServerDir();
        if (f == null) {
            return this.app.getAppDir().getAbsolutePath();
        }
        return f.getAbsolutePath();
    }

    public String getCharset() {
        return this.app.getCharset();
    }

    public void setGlobalMacroPath(String[] path) {
        this.app.globalMacroPath = path;
    }

    public String[] getGlobalMacroPath() {
        return this.app.globalMacroPath;
    }

    public Object invoke(Object thisObject, Object function, Object[] args) throws Exception {
        return this.invoke(thisObject, function, args, 30000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(Object thisObject, Object function, Object[] args, long timeout) throws Exception {
        RequestEvaluator reval = this.app.getEvaluator();
        try {
            Object object = reval.invokeInternal(thisObject, function, args, timeout);
            return object;
        }
        finally {
            this.app.releaseEvaluator(reval);
        }
    }

    public FutureResult invokeAsync(Object thisObject, Object function, Object[] args) {
        return new AsyncInvoker(thisObject, function, args, 900000L);
    }

    public FutureResult invokeAsync(Object thisObject, Object function, Object[] args, long timeout) {
        return new AsyncInvoker(thisObject, function, args, timeout);
    }

    public String toString() {
        return "[Application " + this.app.getName() + "]";
    }

    class AsyncInvoker
    extends Thread
    implements FutureResult {
        private Object thisObject;
        private Object function;
        private Object[] args;
        private long timeout;
        private Object result;
        private Exception exception;
        private boolean running = true;

        private AsyncInvoker(Object thisObj, Object func, Object[] args, long timeout) {
            this.thisObject = thisObj;
            this.function = func;
            this.args = args;
            this.timeout = timeout;
            this.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            RequestEvaluator reval = null;
            try {
                reval = ApplicationBean.this.app.getEvaluator();
                this.setResult(reval.invokeInternal(this.thisObject, this.function, this.args, this.timeout));
            }
            catch (Exception x) {
                this.setException(x);
            }
            finally {
                this.running = false;
                ApplicationBean.this.app.releaseEvaluator(reval);
            }
        }

        public synchronized boolean getRunning() {
            return this.running;
        }

        private synchronized void setResult(Object obj) {
            this.result = obj;
            this.running = false;
            this.notifyAll();
        }

        public synchronized Object getResult() {
            return this.result;
        }

        public synchronized Object waitForResult() throws InterruptedException {
            if (!this.running) {
                return this.result;
            }
            this.wait();
            return this.result;
        }

        public synchronized Object waitForResult(long timeout) throws InterruptedException {
            if (!this.running) {
                return this.result;
            }
            this.wait(timeout);
            return this.result;
        }

        private synchronized void setException(Exception x) {
            this.exception = x;
            this.running = false;
            this.notifyAll();
        }

        public synchronized Exception getException() {
            return this.exception;
        }

        public String toString() {
            return "AsyncInvokeThread{running: " + this.running + ", result: " + this.result + ", exception: " + this.exception + "}";
        }
    }
}

