/*
 * Decompiled with CFR 0.152.
 */
package helma.framework.core;

import helma.doc.DocApplication;
import helma.extensions.ConfigurationException;
import helma.extensions.HelmaExtension;
import helma.framework.ApplicationStoppedException;
import helma.framework.IPathElement;
import helma.framework.RequestTrans;
import helma.framework.ResponseTrans;
import helma.framework.UploadStatus;
import helma.framework.core.Prototype;
import helma.framework.core.RequestEvaluator;
import helma.framework.core.Session;
import helma.framework.core.SessionManager;
import helma.framework.core.Skin;
import helma.framework.core.SkinManager;
import helma.framework.core.TypeManager;
import helma.framework.repository.FileRepository;
import helma.framework.repository.FileResource;
import helma.framework.repository.Repository;
import helma.framework.repository.Resource;
import helma.framework.repository.ResourceComparator;
import helma.main.Server;
import helma.objectmodel.DatabaseException;
import helma.objectmodel.INode;
import helma.objectmodel.TransientNode;
import helma.objectmodel.db.DbMapping;
import helma.objectmodel.db.DbSource;
import helma.objectmodel.db.Node;
import helma.objectmodel.db.NodeHandle;
import helma.objectmodel.db.NodeManager;
import helma.objectmodel.db.WrappedNodeManager;
import helma.util.CronJob;
import helma.util.CryptResource;
import helma.util.Logger;
import helma.util.Logging;
import helma.util.ResourceProperties;
import helma.util.SystemMap;
import helma.util.UrlEncoded;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Method;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EmptyStackException;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class Application
implements Runnable {
    private String name;
    ArrayList repositories;
    ResourceProperties props;
    ResourceProperties dbProps;
    File appDir;
    File hopHome;
    File dbDir;
    protected NodeManager nmgr;
    Object rootObject = null;
    String rootObjectClass;
    SessionManager sessionMgr;
    public TypeManager typemgr;
    protected SkinManager skinmgr;
    protected Stack freeThreads;
    protected Vector allThreads;
    boolean running = false;
    boolean debug;
    long starttime;
    Hashtable dbSources;
    Map modules;
    Thread worker;
    long requestTimeout = 60000L;
    ThreadGroup threadgroup;
    ThreadLocal currentEvaluator = new ThreadLocal();
    Hashtable activeRequests;
    String logDir;
    Log eventLog;
    Log accessLog;
    String eventLogName;
    String accessLogName;
    protected INode cachenode;
    protected volatile long requestCount = 0L;
    protected volatile long xmlrpcCount = 0L;
    protected volatile long errorCount = 0L;
    private String baseURI;
    private String hrefRootPrototype;
    String rootId = "0";
    private DbMapping rootMapping;
    private DbMapping userRootMapping;
    private DbMapping userMapping;
    String charset;
    private CryptResource pwfile;
    ResourceProperties classMapping;
    Properties skinExtensions;
    private long lastPropertyRead = -1L;
    private HashSet xmlrpcAccess;
    private String xmlrpcHandlerName;
    Hashtable activeCronJobs = null;
    Hashtable customCronJobs = null;
    private ResourceComparator resourceComparator;
    private Resource currentCodeResource;
    private static final String CLASS_NOT_MAPPED = "(unmapped)";
    String[] globalMacroPath = null;

    public Application(String name) {
        this.name = name;
    }

    public Application(String name, Repository[] repositories, File dbDir) throws RemoteException, IllegalArgumentException {
        this(name, null, repositories, null, dbDir);
    }

    public Application(String name, Server server) throws RemoteException, IllegalArgumentException {
        this(name, server, new Repository[0], null, null);
    }

    public Application(String name, Server server, Repository[] repositories, File customAppDir, File customDbDir) throws RemoteException, IllegalArgumentException {
        if (name == null || name.trim().length() == 0) {
            throw new IllegalArgumentException("Invalid application name: " + name);
        }
        if (repositories.length == 0) {
            throw new IllegalArgumentException("No sources defined for application: " + name);
        }
        this.name = name;
        this.repositories = new ArrayList();
        this.repositories.addAll(Arrays.asList(repositories));
        this.resourceComparator = new ResourceComparator(this);
        this.appDir = customAppDir;
        this.dbDir = customDbDir;
        ResourceProperties sysDbProps = null;
        ResourceProperties sysProps = null;
        this.hopHome = null;
        if (server != null) {
            this.hopHome = server.getHopHome();
            if (this.dbDir == null) {
                this.dbDir = new File(server.getDbHome(), name);
            }
            sysProps = server.getProperties();
            sysDbProps = server.getDbProperties();
        }
        if (!this.dbDir.exists()) {
            this.dbDir.mkdirs();
        }
        if (this.appDir == null) {
            for (int i = repositories.length - 1; i >= 0; --i) {
                if (!(repositories[i] instanceof FileRepository)) continue;
                this.appDir = new File(repositories[i].getName());
                break;
            }
        }
        this.threadgroup = new ThreadGroup("TX-" + name);
        this.props = new ResourceProperties(this, "app.properties", sysProps);
        this.accessLogName = this.props.getProperty("accessLog", "helma." + name + ".access");
        this.eventLogName = this.props.getProperty("eventLog", "helma." + name + ".event");
        this.dbProps = new ResourceProperties(this, "db.properties", sysDbProps, false);
        CryptResource parentpwfile = null;
        if (this.hopHome != null) {
            parentpwfile = new CryptResource(new FileResource(new File(this.hopHome, "passwd")), null);
        }
        this.pwfile = new CryptResource(repositories[0].getResource("passwd"), parentpwfile);
        this.classMapping = new ResourceProperties(this, "class.properties");
        this.classMapping.setIgnoreCase(false);
        this.rootObjectClass = this.classMapping.getProperty("root");
        this.updateProperties();
        this.dbSources = new Hashtable();
        this.modules = new SystemMap();
        this.cachenode = new TransientNode("app");
    }

    public synchronized void init() throws DatabaseException, IllegalAccessException, InstantiationException, ClassNotFoundException {
        this.init(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void init(String ignoreDirs) throws DatabaseException, IllegalAccessException, InstantiationException, ClassNotFoundException {
        String usernameField;
        this.running = true;
        this.typemgr = new TypeManager(this, ignoreDirs);
        Thread.currentThread().setContextClassLoader(this.typemgr.getClassLoader());
        try {
            this.typemgr.createPrototypes();
        }
        catch (Exception x) {
            this.logError("Error creating prototypes", x);
        }
        if (Server.getServer() != null) {
            Vector extensions = Server.getServer().getExtensions();
            for (int i = 0; i < extensions.size(); ++i) {
                HelmaExtension ext = (HelmaExtension)extensions.get(i);
                try {
                    ext.applicationStarted(this);
                    continue;
                }
                catch (ConfigurationException e) {
                    this.logEvent("couldn't init extension " + ext.getName() + ": " + e.toString());
                }
            }
        }
        this.freeThreads = new Stack();
        this.allThreads = new Vector();
        int minThreads = 0;
        try {
            minThreads = Integer.parseInt(this.props.getProperty("minThreads"));
        }
        catch (Exception ignore) {
            // empty catch block
        }
        if (minThreads > 0) {
            this.logEvent("Starting " + minThreads + " evaluator(s) for " + this.name);
        }
        for (int i = 0; i < minThreads; ++i) {
            RequestEvaluator ev = new RequestEvaluator(this);
            if (i == 0) {
                ev.initScriptingEngine();
            }
            this.freeThreads.push(ev);
            this.allThreads.addElement(ev);
        }
        this.activeRequests = new Hashtable();
        this.activeCronJobs = new Hashtable();
        this.customCronJobs = new Hashtable();
        this.skinmgr = new SkinManager(this);
        this.rootId = this.props.getProperty("rootid", "0");
        String rootPrototype = this.props.getProperty("rootprototype", "root");
        String userPrototype = this.props.getProperty("userprototype", "user");
        this.rootMapping = this.getDbMapping(rootPrototype);
        if (this.rootMapping == null) {
            throw new RuntimeException("rootPrototype does not exist: " + rootPrototype);
        }
        this.userMapping = this.getDbMapping(userPrototype);
        if (this.userMapping == null) {
            throw new RuntimeException("userPrototype does not exist: " + userPrototype);
        }
        ResourceProperties p = new ResourceProperties();
        String string = usernameField = this.userMapping != null ? this.userMapping.getNameField() : null;
        if (usernameField == null) {
            usernameField = "name";
        }
        p.put("_children", "collection(" + userPrototype + ")");
        p.put("_children.accessname", usernameField);
        this.userRootMapping = new DbMapping(this, "__userroot__", p);
        this.userRootMapping.update();
        this.nmgr = new NodeManager(this);
        this.nmgr.init(this.dbDir.getAbsoluteFile(), this.props);
        String sessionMgrImpl = this.props.getProperty("sessionManagerImpl", "helma.framework.core.SessionManager");
        this.sessionMgr = (SessionManager)Class.forName(sessionMgrImpl).newInstance();
        this.logEvent("Using session manager class " + sessionMgrImpl);
        this.sessionMgr.init(this);
        if ("true".equalsIgnoreCase(this.getProperty("persistentSessions"))) {
            RequestEvaluator ev = this.getEvaluator();
            try {
                ev.initScriptingEngine();
                this.sessionMgr.loadSessionData(null, ev.scriptingEngine);
            }
            finally {
                this.releaseEvaluator(ev);
            }
        }
        Thread.currentThread().setContextClassLoader(this.typemgr.getClassLoader().getParent());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void start() {
        this.starttime = System.currentTimeMillis();
        RequestEvaluator eval = null;
        try {
            eval = this.getEvaluator();
            eval.invokeInternal(null, "onStart", RequestEvaluator.EMPTY_ARGS);
        }
        catch (Exception xcept) {
            this.logError("Error in " + this.name + ".onStart()", xcept);
        }
        finally {
            this.releaseEvaluator(eval);
        }
        this.worker = new Thread((Runnable)this, "Worker-" + this.name);
        this.worker.setPriority(6);
        this.worker.start();
    }

    public synchronized void stop() {
        RequestEvaluator eval = null;
        try {
            eval = this.getEvaluator();
            eval.invokeInternal(null, "onStop", RequestEvaluator.EMPTY_ARGS);
        }
        catch (Exception x) {
            this.logError("Error in " + this.name + ".onStop()", x);
        }
        this.running = false;
        if (this.worker != null) {
            this.worker.interrupt();
        }
        this.worker = null;
        if (this.allThreads != null) {
            Enumeration e = this.allThreads.elements();
            while (e.hasMoreElements()) {
                RequestEvaluator ev = (RequestEvaluator)e.nextElement();
                ev.stopTransactor();
            }
        }
        this.allThreads.removeAllElements();
        this.freeThreads.clear();
        try {
            this.nmgr.shutdown();
        }
        catch (DatabaseException dbx) {
            System.err.println("Error shutting down embedded db: " + dbx);
        }
        if (Server.getServer() != null) {
            Vector extensions = Server.getServer().getExtensions();
            for (int i = 0; i < extensions.size(); ++i) {
                HelmaExtension ext = (HelmaExtension)extensions.get(i);
                ext.applicationStopped(this);
            }
        }
        if ("true".equalsIgnoreCase(this.getProperty("persistentSessions"))) {
            this.sessionMgr.storeSessionData(null, eval.scriptingEngine);
        }
        this.sessionMgr.shutdown();
    }

    public boolean isRunning() {
        return this.running;
    }

    public File getAppDir() {
        return this.appDir;
    }

    public ResourceComparator getResourceComparator() {
        return this.resourceComparator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RequestEvaluator getEvaluator() {
        if (!this.running) {
            throw new ApplicationStoppedException();
        }
        try {
            return (RequestEvaluator)this.freeThreads.pop();
        }
        catch (EmptyStackException nothreads) {
            int maxThreads = 50;
            String maxThreadsProp = this.props.getProperty("maxThreads");
            if (maxThreadsProp != null) {
                try {
                    maxThreads = Integer.parseInt(maxThreadsProp);
                }
                catch (Exception ignore) {
                    this.logEvent("Couldn't parse maxThreads property: " + maxThreadsProp);
                }
            }
            Application application = this;
            synchronized (application) {
                if (this.allThreads.size() < maxThreads) {
                    this.logEvent("Starting engine " + (this.allThreads.size() + 1) + " for " + this.name);
                    RequestEvaluator ev = new RequestEvaluator(this);
                    this.allThreads.addElement(ev);
                    return ev;
                }
            }
            for (int i = 0; i < 4; ++i) {
                try {
                    Thread.sleep(3000L);
                    return (RequestEvaluator)this.freeThreads.pop();
                }
                catch (EmptyStackException nothreads2) {
                    continue;
                }
                catch (InterruptedException inter) {
                    throw new RuntimeException("Thread interrupted.");
                }
            }
            throw new RuntimeException("Maximum Thread count reached.");
        }
    }

    public void releaseEvaluator(RequestEvaluator ev) {
        if (ev != null) {
            ev.recycle();
            this.freeThreads.push(ev);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setNumberOfEvaluators(int n) {
        if (n < 2 || n > 511) {
            return false;
        }
        int current = this.allThreads.size();
        Vector vector = this.allThreads;
        synchronized (vector) {
            if (n > current) {
                int toBeCreated = n - current;
                for (int i = 0; i < toBeCreated; ++i) {
                    RequestEvaluator ev = new RequestEvaluator(this);
                    this.freeThreads.push(ev);
                    this.allThreads.addElement(ev);
                }
            } else if (n < current) {
                int toBeDestroyed = current - n;
                for (int i = 0; i < toBeDestroyed; ++i) {
                    try {
                        RequestEvaluator re = (RequestEvaluator)this.freeThreads.pop();
                        this.allThreads.removeElement(re);
                        re.stopTransactor();
                        continue;
                    }
                    catch (EmptyStackException empty) {
                        return false;
                    }
                }
            }
        }
        return true;
    }

    public int getActiveThreads() {
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResponseTrans execute(RequestTrans req) {
        ++this.requestCount;
        Session session = this.createSession(req.getSession());
        session.touch();
        ResponseTrans res = null;
        RequestEvaluator ev = null;
        boolean primaryRequest = false;
        try {
            ev = (RequestEvaluator)this.activeRequests.get(req);
            if (ev != null) {
                res = ev.attachHttpRequest(req);
            }
            if (res == null) {
                primaryRequest = true;
                this.updateProperties();
                ev = this.getEvaluator();
                res = ev.invokeHttp(req, session);
            }
        }
        catch (ApplicationStoppedException stopped) {
            throw stopped;
        }
        catch (Exception x) {
            ++this.errorCount;
            res = new ResponseTrans(this, req);
            res.reportError(this.name, x.getMessage());
        }
        finally {
            if (primaryRequest) {
                this.activeRequests.remove(req);
                this.releaseEvaluator(ev);
                try {
                    res.close(this.charset);
                }
                catch (UnsupportedEncodingException uee) {
                    this.logError("Unsupported response encoding", uee);
                }
            } else {
                res.waitForClose();
            }
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object executeXmlRpc(String method, Vector args) throws Exception {
        ++this.xmlrpcCount;
        Object retval = null;
        RequestEvaluator ev = null;
        try {
            this.updateProperties();
            ev = this.getEvaluator();
            retval = ev.invokeXmlRpc(method, args.toArray());
        }
        finally {
            this.releaseEvaluator(ev);
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object executeExternal(String method, Vector args) throws Exception {
        Object retval = null;
        RequestEvaluator ev = null;
        try {
            this.updateProperties();
            ev = this.getEvaluator();
            retval = ev.invokeExternal(method, args.toArray());
        }
        finally {
            this.releaseEvaluator(ev);
        }
        return retval;
    }

    public void clearCache() {
        this.nmgr.clearCache();
    }

    public int getCacheUsage() {
        return this.nmgr.countCacheEntries();
    }

    public void setDataRoot(Object root) {
        this.rootObject = root;
    }

    public Object getDataRoot() {
        if (this.rootObjectClass != null) {
            if (this.rootObject == null) {
                try {
                    if (this.classMapping.containsKey("root.factory.class") && this.classMapping.containsKey("root.factory.method")) {
                        String rootFactory = this.classMapping.getProperty("root.factory.class");
                        Class<?> c = this.typemgr.getClassLoader().loadClass(rootFactory);
                        Method m = c.getMethod(this.classMapping.getProperty("root.factory.method"), null);
                        this.rootObject = m.invoke(c, (Object[])null);
                    } else {
                        String rootClass = this.classMapping.getProperty("root");
                        Class<?> c = this.typemgr.getClassLoader().loadClass(rootClass);
                        this.rootObject = c.newInstance();
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException("Error creating root object: " + e.toString());
                }
            }
            return this.rootObject;
        }
        return this.nmgr.safe.getRootNode();
    }

    public DbMapping getRootMapping() {
        return this.rootMapping;
    }

    public String getRootId() {
        return this.rootId;
    }

    public INode getUserRoot() {
        Node users = this.nmgr.safe.getNode("1", this.userRootMapping);
        users.setDbMapping(this.userRootMapping);
        return users;
    }

    public NodeManager getNodeManager() {
        return this.nmgr;
    }

    public WrappedNodeManager getWrappedNodeManager() {
        return this.nmgr.safe;
    }

    public SessionManager getSessionManager() {
        return this.sessionMgr;
    }

    public INode getCacheNode() {
        return this.cachenode;
    }

    public INode getUserNode(String uid) {
        try {
            INode users = this.getUserRoot();
            return (INode)users.getChildElement(uid);
        }
        catch (Exception x) {
            return null;
        }
    }

    public Prototype getPrototype(Object obj) {
        String protoname = this.getPrototypeName(obj);
        if (protoname == null) {
            return this.typemgr.getPrototype("hopobject");
        }
        Prototype p = this.typemgr.getPrototype(protoname);
        if (p == null) {
            p = this.typemgr.getPrototype("hopobject");
        }
        return p;
    }

    public Prototype getPrototypeByName(String name) {
        return this.typemgr.getPrototype(name);
    }

    public Collection getPrototypes() {
        return this.typemgr.getPrototypes();
    }

    public Skin getSkin(String protoname, String skinname, Object[] skinpath) throws IOException {
        Prototype proto = this.getPrototypeByName(protoname);
        if (proto == null) {
            return null;
        }
        return this.skinmgr.getSkin(proto, skinname, skinpath);
    }

    public Session createSession(String sessionId) {
        return this.sessionMgr.createSession(sessionId);
    }

    public List getActiveUsers() {
        return this.sessionMgr.getActiveUsers();
    }

    public List getRegisteredUsers() {
        ArrayList list = new ArrayList();
        INode users = this.getUserRoot();
        Enumeration e = users.getSubnodes();
        while (e.hasMoreElements()) {
            list.add(e.nextElement());
        }
        if (list.size() == 0) {
            e = users.properties();
            while (e.hasMoreElements()) {
                list.add(users.getNode((String)e.nextElement()));
            }
        }
        return list;
    }

    public List getSessionsForUsername(String username) {
        return this.sessionMgr.getSessionsForUsername(username);
    }

    public Session getSession(String sessionId) {
        return this.sessionMgr.getSession(sessionId);
    }

    public Map getSessions() {
        return this.sessionMgr.getSessions();
    }

    public int countSessions() {
        return this.sessionMgr.countSessions();
    }

    public INode registerUser(String uname, String password) {
        if (uname == null) {
            return null;
        }
        if ("".equals(uname = uname.toLowerCase().trim())) {
            return null;
        }
        try {
            INode users = this.getUserRoot();
            INode unode = (INode)users.getChildElement(uname);
            if (unode != null) {
                return null;
            }
            unode = new Node(uname, "user", this.nmgr.safe);
            String usernameField = this.userMapping != null ? this.userMapping.getNameField() : null;
            String usernameProp = null;
            if (usernameField != null) {
                usernameProp = this.userMapping.columnNameToProperty(usernameField);
            }
            if (usernameProp == null) {
                usernameProp = "name";
            }
            unode.setName(uname);
            unode.setString(usernameProp, uname);
            unode.setString("password", password);
            return users.addNode(unode);
        }
        catch (Exception x) {
            this.logEvent("Error registering User: " + x);
            return null;
        }
    }

    public boolean loginSession(String uname, String password, Session session) {
        if (uname == null) {
            return false;
        }
        if ("".equals(uname = uname.toLowerCase().trim())) {
            return false;
        }
        try {
            INode users = this.getUserRoot();
            Node unode = (Node)users.getChildElement(uname);
            if (unode == null) {
                return false;
            }
            String pw = unode.getString("password");
            if (pw != null && pw.equals(password)) {
                session.logout();
                session.login(unode);
                return true;
            }
        }
        catch (Exception x) {
            return false;
        }
        return false;
    }

    public void logoutSession(Session session) {
        session.logout();
    }

    public boolean authenticate(String uname, String password) {
        if (uname == null || password == null) {
            return false;
        }
        return this.pwfile.authenticate(uname, password);
    }

    public String getRootHref() throws UnsupportedEncodingException {
        return this.getNodeHref(this.getDataRoot(), null);
    }

    public String getNodeHref(Object elem, String actionName) throws UnsupportedEncodingException {
        StringBuffer b = new StringBuffer(this.baseURI);
        this.composeHref(elem, b, 0);
        if (actionName != null) {
            b.append(UrlEncoded.encode(actionName, this.charset));
        }
        return b.toString();
    }

    private void composeHref(Object elem, StringBuffer b, int pathCount) throws UnsupportedEncodingException {
        if (elem == null || pathCount > 50) {
            return;
        }
        if (this.hrefRootPrototype != null && this.hrefRootPrototype.equals(this.getPrototypeName(elem))) {
            return;
        }
        Object parent = this.getParentElement(elem);
        if (parent == null) {
            return;
        }
        this.composeHref(this.getParentElement(elem), b, ++pathCount);
        String ename = this.getElementName(elem);
        if (ename != null) {
            b.append(UrlEncoded.encode(ename, this.charset));
            b.append("/");
        }
    }

    public String getBaseURI() {
        return this.baseURI;
    }

    public void setBaseURI(String uri) {
        this.baseURI = uri == null ? "/" : (!uri.endsWith("/") ? uri + "/" : uri);
    }

    public boolean hasExplicitBaseURI() {
        return this.props.containsKey("baseuri");
    }

    public String getHrefRootPrototype() {
        return this.hrefRootPrototype;
    }

    public boolean debug() {
        return this.debug;
    }

    public RequestEvaluator getCurrentRequestEvaluator() {
        return (RequestEvaluator)this.currentEvaluator.get();
    }

    protected void setCurrentRequestEvaluator(RequestEvaluator eval) {
        this.currentEvaluator.set(eval);
    }

    private Object invokeFunction(Object obj, String func, Object[] args) {
        block4: {
            RequestEvaluator reval = this.getCurrentRequestEvaluator();
            if (reval != null) {
                if (args == null) {
                    args = RequestEvaluator.EMPTY_ARGS;
                }
                try {
                    return reval.invokeDirectFunction(obj, func, args);
                }
                catch (Exception x) {
                    if (!this.debug) break block4;
                    System.err.println("Error in Application.invokeFunction (" + func + "): " + x);
                }
            }
        }
        return null;
    }

    public ClassLoader getClassLoader() {
        return this.typemgr.getClassLoader();
    }

    public String getElementName(Object obj) {
        if (obj instanceof IPathElement) {
            return ((IPathElement)obj).getElementName();
        }
        Object retval = this.invokeFunction(obj, "getElementName", RequestEvaluator.EMPTY_ARGS);
        if (retval != null) {
            return retval.toString();
        }
        return null;
    }

    public Object getChildElement(Object obj, String name) {
        if (obj instanceof IPathElement) {
            return ((IPathElement)obj).getChildElement(name);
        }
        Object[] arg = new Object[]{name};
        return this.invokeFunction(obj, "getChildElement", arg);
    }

    public Object getParentElement(Object obj) {
        if (obj instanceof IPathElement) {
            return ((IPathElement)obj).getParentElement();
        }
        return this.invokeFunction(obj, "getParentElement", RequestEvaluator.EMPTY_ARGS);
    }

    public String getPrototypeName(Object obj) {
        if (obj == null) {
            return "global";
        }
        if (obj instanceof IPathElement) {
            return ((IPathElement)obj).getPrototype();
        }
        Class<?> clazz = obj.getClass();
        String className = clazz.getName();
        String protoName = this.classMapping.getProperty(className);
        if (protoName != null) {
            return protoName == CLASS_NOT_MAPPED ? null : protoName;
        }
        while ((clazz = clazz.getSuperclass()) != null) {
            protoName = this.classMapping.getProperty(clazz.getName());
            if (protoName == null) continue;
            this.classMapping.setProperty(className, protoName);
            return protoName;
        }
        Class<?>[] classes = obj.getClass().getInterfaces();
        for (int i = 0; i < classes.length; ++i) {
            protoName = this.classMapping.getProperty(classes[i].getName());
            if (protoName == null) continue;
            this.classMapping.setProperty(className, protoName);
            return protoName;
        }
        this.classMapping.setProperty(className, CLASS_NOT_MAPPED);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DocApplication getDoc() {
        RequestEvaluator eval = null;
        try {
            eval = this.getEvaluator();
            DocApplication docApplication = eval.scriptingEngine.getDoc();
            return docApplication;
        }
        catch (Exception xcept) {
            this.logError("Error in getDoc() for " + this.name, xcept);
            DocApplication docApplication = null;
            return docApplication;
        }
        finally {
            this.releaseEvaluator(eval);
        }
    }

    public void logError(String msg, Throwable error) {
        if (this.eventLog == null) {
            this.eventLog = this.getLogger(this.eventLogName);
        }
        this.eventLog.error((Object)msg, error);
    }

    public void logError(String msg) {
        if (this.eventLog == null) {
            this.eventLog = this.getLogger(this.eventLogName);
        }
        this.eventLog.error((Object)msg);
    }

    public void logEvent(String msg) {
        this.getEventLog().info((Object)msg);
    }

    public void logAccess(String msg) {
        this.getAccessLog().info((Object)msg);
    }

    Log getEventLog() {
        if (this.eventLog == null) {
            this.eventLog = this.getLogger(this.eventLogName);
            if (this.eventLog instanceof Logger) {
                ((Logger)this.eventLog).setLogLevel(this.debug ? 2 : 3);
            }
        }
        return this.eventLog;
    }

    Log getAccessLog() {
        if (this.accessLog == null) {
            this.accessLog = this.getLogger(this.accessLogName);
        }
        return this.accessLog;
    }

    public Log getLogger(String logname) {
        if ("console".equals(this.logDir) || "console".equals(logname)) {
            return Logging.getConsoleLog();
        }
        return LogFactory.getLog((String)logname);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        long lastSessionCleanup = System.currentTimeMillis();
        while (Thread.currentThread() == this.worker) {
            try {
                long sleepInterval = 60000L;
                try {
                    String sleepProp = this.props.getProperty("schedulerInterval");
                    sleepInterval = sleepProp != null ? (long)Math.max(1000, Integer.parseInt(sleepProp) * 1000) : CronJob.millisToNextFullMinute();
                }
                catch (Exception ignore) {
                    // empty catch block
                }
                try {
                    Thread.sleep(sleepInterval);
                }
                catch (InterruptedException x) {
                    this.worker = null;
                    break;
                }
                try {
                    lastSessionCleanup = this.cleanupSessions(lastSessionCleanup);
                }
                catch (Exception x) {
                    this.logError("Error in session cleanup: " + x, x);
                }
                catch (LinkageError x) {
                    this.logError("Error in session cleanup: " + x, x);
                }
                try {
                    this.executeCronJobs();
                }
                catch (Exception x) {
                    this.logError("Error in cron job execution: " + x, x);
                }
                catch (LinkageError x) {
                    this.logError("Error in cron job execution: " + x, x);
                }
            }
            catch (VirtualMachineError error) {
                this.logError("Error in scheduler loop: " + error, error);
            }
        }
        Hashtable hashtable = this.activeCronJobs;
        synchronized (hashtable) {
            Iterator i = this.activeCronJobs.values().iterator();
            while (i.hasNext()) {
                ((CronRunner)i.next()).interrupt();
                i.remove();
            }
        }
        this.logEvent("Scheduler for " + this.name + " exiting");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long cleanupSessions(long lastSessionCleanup) {
        long sessionCleanupInterval;
        long now = System.currentTimeMillis();
        if (now - lastSessionCleanup > (sessionCleanupInterval = 60000L)) {
            int sessionTimeout = 30;
            try {
                sessionTimeout = Math.max(0, Integer.parseInt(this.props.getProperty("sessionTimeout", "30")));
            }
            catch (NumberFormatException nfe) {
                this.logEvent("Invalid sessionTimeout setting: " + this.props.getProperty("sessionTimeout"));
            }
            RequestEvaluator thisEvaluator = null;
            try {
                thisEvaluator = this.getEvaluator();
                Map sessions = this.sessionMgr.getSessions();
                Iterator it = sessions.values().iterator();
                while (it.hasNext()) {
                    Session session = (Session)it.next();
                    session.pruneUploads();
                    if (now - session.lastTouched() <= (long)(sessionTimeout * 60000)) continue;
                    NodeHandle userhandle = session.userHandle;
                    if (userhandle != null) {
                        try {
                            Object[] param = new Object[]{session.getSessionId()};
                            thisEvaluator.invokeInternal(userhandle, "onLogout", param);
                        }
                        catch (Exception x) {
                            this.logError("Error in onLogout", x);
                        }
                    }
                    this.sessionMgr.discardSession(session);
                }
            }
            catch (Exception cx) {
                this.logEvent("Error cleaning up sessions: " + cx);
                cx.printStackTrace();
            }
            finally {
                if (thisEvaluator != null) {
                    this.releaseEvaluator(thisEvaluator);
                }
            }
            return now;
        }
        return lastSessionCleanup;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeCronJobs() {
        List jobs = CronJob.parse(this.props);
        Date date = new Date();
        jobs.addAll(this.customCronJobs.values());
        CronJob.sort(jobs);
        if (this.debug) {
            this.logEvent("Running cron jobs: " + jobs);
        }
        if (!this.activeCronJobs.isEmpty()) {
            this.logEvent("Cron jobs still running from last minute: " + this.activeCronJobs);
        }
        Iterator i = jobs.iterator();
        while (i.hasNext()) {
            RequestEvaluator evaluator;
            CronJob job = (CronJob)i.next();
            if (!job.appliesToDate(date)) continue;
            if (this.activeCronJobs.containsKey(job.getName())) {
                this.logEvent(job + " is still active, skipped in this minute");
                continue;
            }
            try {
                evaluator = this.getEvaluator();
            }
            catch (RuntimeException rt) {
                if (!this.running) break;
                this.logEvent("couldn't execute " + job + ", maximum thread count reached");
                continue;
            }
            if (job.getTimeout() > 20000L || CronJob.millisToNextFullMinute() < 30000L) {
                CronRunner runner = new CronRunner(evaluator, job);
                this.activeCronJobs.put(job.getName(), runner);
                runner.start();
                continue;
            }
            try {
                evaluator.invokeInternal(null, job.getFunction(), RequestEvaluator.EMPTY_ARGS, job.getTimeout());
            }
            catch (Exception ex) {
                this.logEvent("error running " + job + ": " + ex);
            }
            finally {
                this.releaseEvaluator(evaluator);
            }
        }
    }

    public boolean isJavaPrototype(String typename) {
        return this.classMapping.contains(typename);
    }

    public String getJavaClassForPrototype(String typename) {
        Iterator<Map.Entry<Object, Object>> it = this.classMapping.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<Object, Object> entry = it.next();
            if (!typename.equals(entry.getValue())) continue;
            return (String)entry.getKey();
        }
        return null;
    }

    public DbSource getDbSource(String name) {
        String dbSrcName = name.toLowerCase();
        DbSource dbs = (DbSource)this.dbSources.get(dbSrcName);
        if (dbs != null) {
            return dbs;
        }
        try {
            dbs = new DbSource(name, this.dbProps);
            this.dbSources.put(dbSrcName, dbs);
        }
        catch (Exception problem) {
            this.logEvent("Error creating DbSource " + name + ": ");
            this.logEvent(problem.toString());
        }
        return dbs;
    }

    public String getName() {
        return this.name;
    }

    public boolean addRepository(Repository rep) {
        if (rep != null && !this.repositories.contains(rep)) {
            int idx;
            Repository parent = rep.getParentRepository();
            if (parent != null && (idx = this.repositories.indexOf(parent)) > -1) {
                this.repositories.add(idx, rep);
                return true;
            }
            this.repositories.add(rep);
            return true;
        }
        return false;
    }

    public int getRepositoryIndex(Repository rep) {
        return this.repositories.indexOf(rep);
    }

    public List getRepositories() {
        return Collections.unmodifiableList(this.repositories);
    }

    public void setCurrentCodeResource(Resource resource) {
        this.currentCodeResource = resource;
    }

    public Resource getCurrentCodeResource() {
        return this.currentCodeResource;
    }

    public File getServerDir() {
        return this.hopHome;
    }

    public DbMapping getDbMapping(String typename) {
        Prototype proto = this.typemgr.getPrototype(typename);
        if (proto == null) {
            return null;
        }
        return proto.getDbMapping();
    }

    public UploadStatus getUploadStatus(RequestTrans req) {
        String uploadId = (String)req.get("upload_id");
        if (uploadId == null) {
            return null;
        }
        String sessionId = req.getSession();
        Session session = this.getSession(sessionId);
        if (session == null) {
            return null;
        }
        return session.createUpload(uploadId);
    }

    private synchronized void updateProperties() {
        if (this.props.lastModified() > this.lastPropertyRead) {
            this.props.update();
            this.charset = this.props.getProperty("charset", "ISO-8859-1");
            this.debug = "true".equalsIgnoreCase(this.props.getProperty("debug"));
            String defaultReqTimeout = "true".equalsIgnoreCase(this.props.getProperty("rhino.debug")) ? "600" : "60";
            String reqTimeout = this.props.getProperty("requesttimeout", defaultReqTimeout);
            try {
                this.requestTimeout = Long.parseLong(reqTimeout) * 1000L;
            }
            catch (Exception ignore) {
                this.requestTimeout = 60000L;
            }
            String base = this.props.getProperty("baseuri");
            if (base != null) {
                this.setBaseURI(base);
            } else if (this.baseURI == null) {
                this.baseURI = "/";
            }
            this.hrefRootPrototype = this.props.getProperty("hrefrootprototype");
            String xmlrpcAccessProp = this.props.getProperty("xmlrpcaccess");
            HashSet<String> xra = new HashSet<String>();
            if (xmlrpcAccessProp != null) {
                StringTokenizer st = new StringTokenizer(xmlrpcAccessProp, ",; ");
                while (st.hasMoreTokens()) {
                    String token = st.nextToken().trim();
                    xra.add(token.toLowerCase());
                }
            }
            this.xmlrpcAccess = xra;
            if (this.nmgr != null) {
                this.nmgr.updateProperties(this.props);
            }
            if (Server.getServer() != null) {
                Vector extensions = Server.getServer().getExtensions();
                for (int i = 0; i < extensions.size(); ++i) {
                    HelmaExtension ext = (HelmaExtension)extensions.get(i);
                    try {
                        ext.applicationUpdated(this);
                        continue;
                    }
                    catch (ConfigurationException e) {
                        this.logEvent("Error updating extension " + ext + ": " + e);
                    }
                }
            }
            this.logDir = this.props.getProperty("logdir", "log");
            if (System.getProperty("helma.logdir") == null) {
                File dir = new File(this.logDir);
                System.setProperty("helma.logdir", dir.getAbsolutePath());
            }
            if (this.eventLog instanceof Logger) {
                ((Logger)this.eventLog).setLogLevel(this.debug ? 2 : 3);
            }
            this.lastPropertyRead = this.props.lastModified();
        }
    }

    public long getChecksum() {
        return this.starttime + this.typemgr.getLastCodeUpdate() + this.props.getChecksum();
    }

    public String getProperty(String propname) {
        return this.props.getProperty(propname);
    }

    public String getProperty(String propname, String defvalue) {
        return this.props.getProperty(propname, defvalue);
    }

    public ResourceProperties getProperties() {
        return this.props;
    }

    public ResourceProperties getDbProperties() {
        return this.dbProps;
    }

    public String getXmlRpcHandlerName() {
        if (this.xmlrpcHandlerName == null) {
            this.xmlrpcHandlerName = this.props.getProperty("xmlrpcHandlerName", this.name);
        }
        return this.xmlrpcHandlerName;
    }

    public String toString() {
        return "[Application " + this.name + "]";
    }

    public int countThreads() {
        return this.threadgroup.activeCount();
    }

    public int countEvaluators() {
        return this.allThreads.size();
    }

    public int countFreeEvaluators() {
        return this.freeThreads.size();
    }

    public int countActiveEvaluators() {
        return this.allThreads.size() - this.freeThreads.size();
    }

    public int countMaxActiveEvaluators() {
        return -1;
    }

    public long getRequestCount() {
        return this.requestCount;
    }

    public long getXmlrpcCount() {
        return this.xmlrpcCount;
    }

    public long getErrorCount() {
        return this.errorCount;
    }

    public long getStarttime() {
        return this.starttime;
    }

    public String getCharset() {
        return this.charset;
    }

    public void printThreadStats() {
        this.logEvent("Thread Stats for " + this.name + ": " + this.threadgroup.activeCount() + " active");
        Runtime rt = Runtime.getRuntime();
        long free = rt.freeMemory();
        long total = rt.totalMemory();
        this.logEvent("Free memory: " + free / 1024L + " kB");
        this.logEvent("Total memory: " + total / 1024L + " kB");
    }

    protected void checkXmlRpcAccess(String proto, String method) throws Exception {
        String key = proto + "." + method;
        if (!this.xmlrpcAccess.contains(key.toLowerCase())) {
            throw new Exception("Method " + key + " is not callable via XML-RPC");
        }
    }

    class CronRunner
    extends Thread {
        RequestEvaluator thisEvaluator;
        CronJob job;

        public CronRunner(RequestEvaluator thisEvaluator, CronJob job) {
            this.thisEvaluator = thisEvaluator;
            this.job = job;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                this.thisEvaluator.invokeInternal(null, this.job.getFunction(), RequestEvaluator.EMPTY_ARGS, this.job.getTimeout());
            }
            catch (Exception ex) {
                Application.this.logEvent("error running " + this.job + ": " + ex);
            }
            finally {
                Application.this.releaseEvaluator(this.thisEvaluator);
                this.thisEvaluator = null;
                Application.this.activeCronJobs.remove(this.job.getName());
            }
        }

        public String toString() {
            return "CronRunner[" + this.job + "]";
        }
    }
}

