/*
 * Decompiled with CFR 0.152.
 */
package helma.framework;

import java.io.Serializable;

public class UploadStatus
implements Serializable {
    long current = 0L;
    long total = 0L;
    int itemsRead = 0;
    String error = null;
    long lastModified = System.currentTimeMillis();

    public void update(long bytesRead, long contentLength, int itemsRead) {
        this.current = bytesRead;
        this.total = contentLength;
        this.itemsRead = itemsRead;
        this.lastModified = System.currentTimeMillis();
    }

    public void setError(String error) {
        this.error = error;
        this.lastModified = System.currentTimeMillis();
    }

    public String getError() {
        return this.error;
    }

    public long getCurrent() {
        return this.current;
    }

    public long getTotal() {
        return this.total;
    }

    public int getItemsRead() {
        return this.itemsRead;
    }

    public boolean isDisposable() {
        return System.currentTimeMillis() - this.lastModified > 60000L;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer("{current: ").append(this.current).append(", total: ").append(this.total).append(", itemsRead: ").append(this.itemsRead).append(", error: ");
        if (this.error == null) {
            buffer.append("null");
        } else {
            buffer.append("\"");
            buffer.append(this.error.replaceAll("\"", "\\\\\""));
            buffer.append("\"");
        }
        return buffer.append("}").toString();
    }
}

