/*
 * Decompiled with CFR 0.152.
 */
package helma.framework;

import helma.framework.CookieTrans;
import helma.framework.RedirectException;
import helma.framework.RequestTrans;
import helma.framework.core.Application;
import helma.framework.core.Skin;
import helma.util.Base64;
import helma.util.HtmlEncoder;
import helma.util.MD5Encoder;
import helma.util.SystemMap;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import javax.servlet.http.HttpServletResponse;
import org.apache.xmlrpc.XmlRpcResponseProcessor;

public final class ResponseTrans
extends Writer
implements Serializable {
    static final long serialVersionUID = -8627370766119740844L;
    static final int INITIAL_BUFFER_SIZE = 2048;
    static final String newLine = System.getProperty("line.separator");
    private String contentType = "text/html";
    private String charset;
    private boolean cacheable = true;
    private int status = 200;
    private String realm;
    private byte[] response = null;
    private String redir = null;
    private String forward = null;
    private long lastModified = -1L;
    private boolean notModified = false;
    private String etag = null;
    Map cookies;
    private transient StringBuffer buffer = null;
    private transient StringBuffer cachedBuffer = null;
    private transient Stack buffers;
    private transient Object[] skinpath = null;
    private transient HashMap skincache;
    private transient StringBuffer debugBuffer;
    private transient String message;
    private transient String error;
    private transient Map values = new SystemMap();
    private transient Map handlers = new SystemMap();
    private transient Map meta = new SystemMap();
    private transient RequestTrans reqtrans;
    private transient MessageDigest digest;
    private volatile transient Skin activeSkin;
    Application app;

    public ResponseTrans(Application app, RequestTrans req) {
        this.app = app;
        this.reqtrans = req;
    }

    public Object get(String name) {
        try {
            return this.values.get(name);
        }
        catch (Exception x) {
            return null;
        }
    }

    public Map getResponseData() {
        return this.values;
    }

    public Map getMacroHandlers() {
        return this.handlers;
    }

    public Map getMetaData() {
        return this.meta;
    }

    public HttpServletResponse getServletResponse() {
        return this.reqtrans.getServletResponse();
    }

    public synchronized void reset() {
        if (this.buffer != null) {
            this.buffer.setLength(0);
        }
        this.buffers = null;
        this.response = null;
        this.cacheable = true;
        this.error = null;
        this.message = null;
        this.forward = null;
        this.redir = null;
        this.charset = null;
        this.realm = null;
        this.etag = null;
        this.contentType = "text/html";
        this.values.clear();
        this.handlers.clear();
        this.meta.clear();
        this.lastModified = -1L;
        this.notModified = false;
        this.skinpath = null;
        this.skincache = null;
        this.cookies = null;
        if (this.digest != null) {
            this.digest.reset();
        }
    }

    public synchronized StringBuffer pushBuffer(StringBuffer buf) {
        if (this.buffers == null) {
            this.buffers = new Stack();
        }
        if (this.buffer != null) {
            this.buffers.push(this.buffer);
        }
        if (buf != null) {
            this.buffer = buf;
        } else if (this.cachedBuffer != null) {
            this.buffer = this.cachedBuffer;
            this.cachedBuffer = null;
        } else {
            this.buffer = new StringBuffer(64);
        }
        return this.buffer;
    }

    public synchronized String popString() {
        StringBuffer buf = this.popBuffer();
        String str = buf.toString();
        buf.setLength(0);
        this.cachedBuffer = buf;
        return str;
    }

    public synchronized StringBuffer popBuffer() {
        if (this.buffer == null) {
            throw new RuntimeException("Can't pop string buffer: buffer is null");
        }
        if (this.buffers == null) {
            throw new RuntimeException("Can't pop string buffer: buffer stack is empty");
        }
        StringBuffer buf = this.buffer;
        this.buffer = this.buffers.empty() ? null : (StringBuffer)this.buffers.pop();
        return buf;
    }

    public synchronized StringBuffer getBuffer() {
        if (this.buffer == null) {
            this.buffer = new StringBuffer(2048);
        }
        return this.buffer;
    }

    public synchronized void write(String str) {
        if (str != null) {
            if (this.buffer == null) {
                this.buffer = new StringBuffer(Math.max(str.length() + 100, 2048));
            }
            this.buffer.append(str);
        }
    }

    public void write(Object what) {
        if (what != null) {
            this.write(what.toString());
        }
    }

    public synchronized void write(char[] chars, int offset, int length) {
        if (this.buffer == null) {
            this.buffer = new StringBuffer(Math.max(length + 100, 2048));
        }
        this.buffer.append(chars, offset, length);
    }

    public void write(char[] chars) {
        this.write(chars, 0, chars.length);
    }

    public synchronized void write(int c) {
        if (this.buffer == null) {
            this.buffer = new StringBuffer(2048);
        }
        this.buffer.append((char)c);
    }

    public void write(String str, int offset, int length) {
        char[] cbuf = new char[length];
        str.getChars(offset, offset + length, cbuf, 0);
        this.write(cbuf, 0, length);
    }

    public synchronized void writeln(Object what) {
        if (what != null) {
            this.write(what.toString());
        } else if (this.buffer == null) {
            this.buffer = new StringBuffer(2048);
        }
        this.buffer.append(newLine);
    }

    public synchronized void writeln() {
        if (this.buffer == null) {
            this.buffer = new StringBuffer(2048);
        }
        this.buffer.append(newLine);
    }

    public void debug(Object message) {
        if (this.debugBuffer == null) {
            this.debugBuffer = new StringBuffer();
        }
        String str = message == null ? "null" : message.toString();
        this.debugBuffer.append("<p><span style=\"background: yellow; color: black\">");
        this.debugBuffer.append(str);
        this.debugBuffer.append("</span></p>");
    }

    public synchronized void encode(Object what) {
        if (what != null) {
            String str = what.toString();
            if (this.buffer == null) {
                this.buffer = new StringBuffer(Math.max(str.length() + 100, 2048));
            }
            HtmlEncoder.encodeAll(str, this.buffer);
        }
    }

    public synchronized void format(Object what) {
        if (what != null) {
            String str = what.toString();
            if (this.buffer == null) {
                this.buffer = new StringBuffer(Math.max(str.length() + 100, 2048));
            }
            HtmlEncoder.encode(str, this.buffer);
        }
    }

    public synchronized void encodeXml(Object what) {
        if (what != null) {
            String str = what.toString();
            if (this.buffer == null) {
                this.buffer = new StringBuffer(Math.max(str.length() + 100, 2048));
            }
            HtmlEncoder.encodeXml(str, this.buffer);
        }
    }

    public synchronized void encodeForm(Object what) {
        if (what != null) {
            String str = what.toString();
            if (this.buffer == null) {
                this.buffer = new StringBuffer(Math.max(str.length() + 100, 2048));
            }
            HtmlEncoder.encodeAll(str, this.buffer, false);
        }
    }

    public void redirect(String url) throws RedirectException {
        this.redir = url;
        throw new RedirectException(url);
    }

    public String getRedirect() {
        return this.redir;
    }

    public void forward(String url) throws RedirectException {
        this.forward = url;
        throw new RedirectException(url);
    }

    public String getForward() {
        return this.forward;
    }

    public void writeBinary(byte[] what) {
        this.response = what;
    }

    public void addHeader(String name, String value) {
        HttpServletResponse res = this.getServletResponse();
        if (res != null) {
            res.addHeader(name, value);
        }
    }

    public void addDateHeader(String name, Date value) {
        HttpServletResponse res = this.getServletResponse();
        if (res != null) {
            res.addDateHeader(name, value.getTime());
        }
    }

    public void setHeader(String name, String value) {
        HttpServletResponse res = this.getServletResponse();
        if (res != null) {
            res.setHeader(name, value);
        }
    }

    public void setDateHeader(String name, Date value) {
        HttpServletResponse res = this.getServletResponse();
        if (res != null) {
            res.setDateHeader(name, value.getTime());
        }
    }

    public void reportError(String appName, String message) {
        if (this.reqtrans.isXmlRpc()) {
            this.writeXmlRpcError(new RuntimeException(message));
        } else {
            this.status = 500;
            this.write("<html><body><h3>");
            this.write("Error in application ");
            this.write(appName);
            this.write("</h3>");
            this.write(message);
            this.write("</body></html>");
        }
    }

    public void writeXmlRpcResponse(Object result) {
        try {
            this.reset();
            this.contentType = "text/xml";
            if (this.charset == null) {
                this.charset = "UTF-8";
            }
            XmlRpcResponseProcessor xresproc = new XmlRpcResponseProcessor();
            this.writeBinary(xresproc.encodeResponse(result, this.charset));
        }
        catch (Exception x) {
            this.writeXmlRpcError(x);
        }
    }

    public void writeXmlRpcError(Exception x) {
        this.contentType = "text/xml";
        if (this.charset == null) {
            this.charset = "UTF-8";
        }
        XmlRpcResponseProcessor xresproc = new XmlRpcResponseProcessor();
        this.writeBinary(xresproc.encodeException(x, this.charset));
    }

    public void flush() {
    }

    public void close() throws UnsupportedEncodingException {
        this.close(null);
    }

    public synchronized void close(String cset) throws UnsupportedEncodingException {
        boolean autoETags;
        HttpServletResponse res = this.reqtrans.getServletResponse();
        if (res != null && res.isCommitted()) {
            return;
        }
        if (this.charset == null) {
            this.charset = cset;
        }
        if (this.charset == null) {
            this.charset = "ISO-8859-1";
        }
        boolean encodingError = false;
        if (this.response == null) {
            if (this.debugBuffer != null) {
                if (this.buffer == null) {
                    this.buffer = this.debugBuffer;
                } else {
                    this.buffer.append(this.debugBuffer);
                }
            }
            if (this.buffer != null) {
                try {
                    this.response = this.buffer.toString().getBytes(this.charset);
                }
                catch (UnsupportedEncodingException uee) {
                    encodingError = true;
                    this.response = this.buffer.toString().getBytes();
                }
                this.buffer = null;
            } else {
                this.response = new byte[0];
            }
        }
        if ((autoETags = "true".equals(this.app.getProperty("autoETags", "true"))) && this.etag == null && this.lastModified == -1L && this.status == 200 && this.redir == null) {
            try {
                this.digest = MessageDigest.getInstance("MD5");
                byte[] b = this.digest.digest(this.response);
                this.etag = "\"" + new String(Base64.encode(b)) + "\"";
                if (this.reqtrans.hasETag(this.etag) && this.countCookies() == 0) {
                    this.response = new byte[0];
                    this.notModified = true;
                }
            }
            catch (Exception ignore) {
                // empty catch block
            }
        }
        this.notifyAll();
        if (encodingError) {
            throw new UnsupportedEncodingException(this.charset);
        }
    }

    public synchronized void waitForClose() {
        try {
            if (this.response == null) {
                this.wait(10000L);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public byte[] getContent() {
        return this.response == null ? new byte[]{} : this.response;
    }

    public int getContentLength() {
        if (this.response != null) {
            return this.response.length;
        }
        return 0;
    }

    public String getContentType() {
        if (this.charset != null) {
            return this.contentType + "; charset=" + this.charset;
        }
        return this.contentType;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public void setLastModified(long modified) {
        this.lastModified = modified / 1000L * 1000L;
        if (this.reqtrans.getIfModifiedSince() == this.lastModified) {
            this.notModified = true;
            throw new RedirectException(null);
        }
    }

    public long getLastModified() {
        return this.lastModified;
    }

    public void setETag(String value) {
        String string = this.etag = value == null ? null : "\"" + value + "\"";
        if (this.etag != null && this.reqtrans.hasETag(this.etag)) {
            this.notModified = true;
            throw new RedirectException(null);
        }
    }

    public String getETag() {
        return this.etag;
    }

    public boolean getNotModified() {
        return this.notModified;
    }

    public void dependsOn(Object what) {
        if (this.digest == null) {
            try {
                this.digest = MessageDigest.getInstance("MD5");
            }
            catch (NoSuchAlgorithmException nsa) {
                // empty catch block
            }
        }
        if (what == null) {
            this.digest.update(new byte[0]);
        } else if (what instanceof Date) {
            this.digest.update(MD5Encoder.toBytes(((Date)what).getTime()));
        } else if (what instanceof byte[]) {
            this.digest.update((byte[])what);
        } else {
            String str = what.toString();
            if (str != null) {
                this.digest.update(str.getBytes());
            } else {
                this.digest.update(new byte[0]);
            }
        }
    }

    public void digestDependencies() {
        if (this.digest == null) {
            return;
        }
        byte[] b = this.digest.digest(MD5Encoder.toBytes(this.app.getChecksum()));
        this.setETag(new String(Base64.encode(b)));
    }

    public void setSkinpath(Object[] arr) {
        this.skinpath = arr;
        this.skincache = null;
    }

    public Object[] getSkinpath() {
        if (this.skinpath == null) {
            this.skinpath = new Object[0];
        }
        return this.skinpath;
    }

    public Skin getCachedSkin(Object id) {
        if (this.skincache == null) {
            return null;
        }
        return (Skin)this.skincache.get(id);
    }

    public void cacheSkin(Object id, Skin skin) {
        if (this.skincache == null) {
            this.skincache = new HashMap();
        }
        this.skincache.put(id, skin);
    }

    public Skin switchActiveSkin(Skin skin) {
        Skin previousSkin = this.activeSkin;
        this.activeSkin = skin;
        return previousSkin;
    }

    public Skin getActiveSkin() {
        return this.activeSkin;
    }

    public void setCookie(String key, String value, int days, String path, String domain) {
        CookieTrans c = null;
        if (this.cookies == null) {
            this.cookies = new HashMap();
        } else {
            c = (CookieTrans)this.cookies.get(key);
        }
        if (c == null) {
            c = new CookieTrans(key, value);
            this.cookies.put(key, c);
        } else {
            c.setValue(value);
        }
        c.setDays(days);
        c.setPath(path);
        c.setDomain(domain);
    }

    public void resetCookies() {
        if (this.cookies != null) {
            this.cookies.clear();
        }
    }

    public int countCookies() {
        if (this.cookies != null) {
            return this.cookies.size();
        }
        return 0;
    }

    public CookieTrans[] getCookies() {
        if (this.cookies == null) {
            return new CookieTrans[0];
        }
        CookieTrans[] c = new CookieTrans[this.cookies.size()];
        this.cookies.values().toArray(c);
        return c;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String getError() {
        return this.error;
    }

    public void setError(String error) {
        this.error = error;
    }

    public StringBuffer getDebugBuffer() {
        return this.debugBuffer;
    }

    public void setDebugBuffer(StringBuffer debugBuffer) {
        this.debugBuffer = debugBuffer;
    }

    public String getCharset() {
        return this.charset;
    }

    public void setCharset(String charset) {
        this.charset = charset;
    }

    public boolean isCacheable() {
        return this.cacheable;
    }

    public void setCacheable(boolean cache) {
        this.cacheable = cache;
    }

    public int getStatus() {
        return this.status;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public String getRealm() {
        return this.realm;
    }

    public void setRealm(String realm) {
        this.realm = realm;
    }
}

