/*
 * Decompiled with CFR 0.152.
 */
package helma.framework;

import helma.framework.AbortException;
import helma.framework.RedirectException;
import helma.framework.ResponseTrans;
import helma.objectmodel.db.Transactor;
import java.io.Serializable;
import java.util.Date;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;

public class ResponseBean
implements Serializable {
    ResponseTrans res;

    public ResponseBean(ResponseTrans res) {
        this.res = res;
    }

    public void encode(Object obj) {
        this.res.encode(obj);
    }

    public void encodeXml(Object obj) {
        this.res.encodeXml(obj);
    }

    public void encodeForm(Object obj) {
        this.res.encodeForm(obj);
    }

    public void format(Object obj) {
        this.res.format(obj);
    }

    public void redirect(String url) throws RedirectException {
        this.res.redirect(url);
    }

    public void forward(String url) throws RedirectException {
        this.res.forward(url);
    }

    public void stop() throws RedirectException {
        this.res.redirect(null);
    }

    public void reset() {
        this.res.reset();
    }

    public HttpServletResponse getServletResponse() {
        return this.res.getServletResponse();
    }

    public void setCookie(String key, String value) {
        this.res.setCookie(key, value, -1, null, null);
    }

    public void setCookie(String key, String value, int days) {
        this.res.setCookie(key, value, days, null, null);
    }

    public void setCookie(String key, String value, int days, String path) {
        this.res.setCookie(key, value, days, path, null);
    }

    public void setCookie(String key, String value, int days, String path, String domain) {
        this.res.setCookie(key, value, days, path, domain);
    }

    public void unsetCookie(String key) {
        this.res.setCookie(key, "", 0, null, null);
    }

    public void write(String str) {
        this.res.write(str);
    }

    public void writeln(String str) {
        this.res.writeln(str);
    }

    public void writeln() {
        this.res.writeln();
    }

    public void writeBinary(byte[] bytes) {
        this.res.writeBinary(bytes);
    }

    public void debug(String message) {
        this.res.debug(message);
    }

    public String toString() {
        return "[Response]";
    }

    public boolean getCache() {
        return this.res.isCacheable();
    }

    public void setCache(boolean cache) {
        this.res.setCacheable(cache);
    }

    public String getCharset() {
        return this.res.getCharset();
    }

    public void setCharset(String charset) {
        this.res.setCharset(charset);
    }

    public String getContentType() {
        return this.res.getContentType();
    }

    public void setContentType(String contentType) {
        this.res.setContentType(contentType);
    }

    public void addHeader(String name, String value) {
        this.res.addHeader(name, value);
    }

    public void addDateHeader(String name, Date value) {
        this.res.addDateHeader(name, value);
    }

    public void setHeader(String name, String value) {
        this.res.setHeader(name, value);
    }

    public void setDateHeader(String name, Date value) {
        this.res.setDateHeader(name, value);
    }

    public Map getData() {
        return this.res.getResponseData();
    }

    public Map getHandlers() {
        return this.res.getMacroHandlers();
    }

    public Map getMeta() {
        return this.res.getMetaData();
    }

    public String getError() {
        return this.res.getError();
    }

    public String getMessage() {
        return this.res.getMessage();
    }

    public void setMessage(String message) {
        this.res.setMessage(message);
    }

    public String getRealm() {
        return this.res.getRealm();
    }

    public void setRealm(String realm) {
        this.res.setRealm(realm);
    }

    public void setSkinpath(Object[] arr) {
        this.res.setSkinpath(arr);
    }

    public Object[] getSkinpath() {
        return this.res.getSkinpath();
    }

    public int getStatus() {
        return this.res.getStatus();
    }

    public void setStatus(int status) {
        this.res.setStatus(status);
    }

    public Date getLastModified() {
        long modified = this.res.getLastModified();
        if (modified > -1L) {
            return new Date(modified);
        }
        return null;
    }

    public void setLastModified(Date date) {
        if (date == null) {
            this.res.setLastModified(-1L);
        } else {
            this.res.setLastModified(date.getTime());
        }
    }

    public String getETag() {
        return this.res.getETag();
    }

    public void setETag(String etag) {
        this.res.setETag(etag);
    }

    public void dependsOn(String what) {
        this.res.dependsOn(what);
    }

    public void digest() {
        this.res.digestDependencies();
    }

    public void push() {
        this.res.pushBuffer(null);
    }

    public String pop() {
        return this.res.popString();
    }

    public void pushStringBuffer() {
        this.res.pushBuffer(null);
    }

    public String popStringBuffer() {
        return this.res.popString();
    }

    public StringBuffer pushBuffer(StringBuffer buffer) {
        return this.res.pushBuffer(buffer);
    }

    public StringBuffer pushBuffer() {
        return this.res.pushBuffer(null);
    }

    public StringBuffer popBuffer() {
        return this.res.popBuffer();
    }

    public String getBuffer() {
        return this.res.getBuffer().toString();
    }

    public void commit() throws Exception {
        if (Thread.currentThread() instanceof Transactor) {
            Transactor tx = (Transactor)Thread.currentThread();
            String tname = tx.getTransactionName();
            tx.commit();
            tx.begin(tname);
        }
    }

    public void rollback() throws Exception {
        if (Thread.currentThread() instanceof Transactor) {
            Transactor tx = (Transactor)Thread.currentThread();
            String tname = tx.getTransactionName();
            tx.abort();
            tx.begin(tname);
        }
    }

    public void abort() throws AbortException {
        throw new AbortException();
    }
}

