/*
 * Decompiled with CFR 0.152.
 */
package helma.framework;

import helma.util.Base64;
import helma.util.StringUtils;
import helma.util.SystemMap;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class RequestTrans
implements Serializable {
    static final long serialVersionUID = 5398880083482000580L;
    public static final String GET = "GET";
    public static final String POST = "POST";
    public static final String DELETE = "DELETE";
    public static final String HEAD = "HEAD";
    public static final String OPTIONS = "OPTIONS";
    public static final String PUT = "PUT";
    public static final String TRACE = "TRACE";
    public static final String XMLRPC = "XMLRPC";
    public static final String EXTERNAL = "EXTERNAL";
    public static final String INTERNAL = "INTERNAL";
    final HttpServletRequest request;
    final HttpServletResponse response;
    private final String path;
    private String session;
    private final Map values = new DataComboMap();
    private Map params;
    private Map queryParams;
    private Map postParams;
    private Map cookies;
    private String method;
    private long ifModifiedSince = -1L;
    private final Set etags = new HashSet();
    private final long startTime;
    private String action;
    private String httpUsername;
    private String httpPassword;
    private static final Pattern paramPattern = Pattern.compile("\\[(.+?)\\]");

    public RequestTrans(String method, String path) {
        this.method = method;
        this.path = path;
        this.request = null;
        this.response = null;
        this.startTime = System.currentTimeMillis();
    }

    public RequestTrans(HttpServletRequest request, HttpServletResponse response, String path) {
        this.method = request.getMethod();
        this.request = request;
        this.response = response;
        this.path = path;
        this.startTime = System.currentTimeMillis();
        String header = request.getHeader("Host");
        if (header != null) {
            this.values.put("http_host", header.toLowerCase());
        }
        if ((header = request.getHeader("Referer")) != null) {
            this.values.put("http_referer", header);
        }
        try {
            long ifModifiedSince = request.getDateHeader("If-Modified-Since");
            if (ifModifiedSince > -1L) {
                this.setIfModifiedSince(ifModifiedSince);
            }
        }
        catch (IllegalArgumentException ignore) {
            // empty catch block
        }
        header = request.getHeader("If-None-Match");
        if (header != null) {
            this.setETags(header);
        }
        if ((header = request.getRemoteAddr()) != null) {
            this.values.put("http_remotehost", header);
        }
        if ((header = request.getHeader("User-Agent")) != null) {
            this.values.put("http_browser", header);
        }
        if ((header = request.getHeader("Accept-Language")) != null) {
            this.values.put("http_language", header);
        }
        if ((header = request.getHeader("authorization")) != null) {
            this.values.put("authorization", header);
        }
    }

    public synchronized boolean checkXmlRpc() {
        return POST.equals(this.method) && "text/xml".equals(this.request.getContentType());
    }

    public synchronized boolean isXmlRpc() {
        return XMLRPC.equals(this.method);
    }

    public void setCookie(String name, Cookie cookie) {
        if (this.cookies == null) {
            this.cookies = new ParameterMap();
        }
        this.cookies.put(name, cookie);
    }

    public Map getCookies() {
        if (this.cookies == null) {
            this.cookies = new ParameterMap();
        }
        return this.cookies;
    }

    public Map getParams() {
        if (this.params == null) {
            this.params = new ParamComboMap();
        }
        return this.params;
    }

    public Map getQueryParams() {
        if (this.queryParams == null) {
            this.queryParams = new ParameterMap();
        }
        return this.queryParams;
    }

    public Map getPostParams() {
        if (this.postParams == null) {
            this.postParams = new ParameterMap();
        }
        return this.postParams;
    }

    public void setParameters(Map parameters, boolean isPost) {
        if (isPost) {
            this.postParams = new ParameterMap(parameters);
        } else {
            this.queryParams = new ParameterMap(parameters);
        }
    }

    public void addPostParam(String name, Object value) {
        Object previous;
        if (this.postParams == null) {
            this.postParams = new ParameterMap();
        }
        if ((previous = this.postParams.get(name)) instanceof Object[]) {
            Object[] array = (Object[])previous;
            Object[] values = new Object[array.length + 1];
            System.arraycopy(array, 0, values, 0, array.length);
            values[array.length] = value;
            this.postParams.put(name, values);
        } else if (previous == null) {
            this.postParams.put(name, new Object[]{value});
        }
    }

    public void set(String name, Object value) {
        this.values.put(name, value);
    }

    public Object get(String name) {
        try {
            return this.values.get(name);
        }
        catch (Exception x) {
            return null;
        }
    }

    public Map getRequestData() {
        return this.values;
    }

    public HttpServletRequest getServletRequest() {
        return this.request;
    }

    public String getHeader(String name) {
        return this.request == null ? null : this.request.getHeader(name);
    }

    public String[] getHeaders(String name) {
        return this.request == null ? null : StringUtils.collect(this.request.getHeaders(name));
    }

    public int getIntHeader(String name) {
        try {
            return this.request == null ? -1 : this.getIntHeader(name);
        }
        catch (NumberFormatException nfe) {
            return -1;
        }
    }

    public long getDateHeader(String name) {
        try {
            return this.request == null ? -1L : this.getDateHeader(name);
        }
        catch (NumberFormatException nfe) {
            return -1L;
        }
    }

    public HttpServletResponse getServletResponse() {
        return this.response;
    }

    public int hashCode() {
        if (this.session == null || this.path == null) {
            return super.hashCode();
        }
        return 17 + 37 * this.session.hashCode() + 37 * this.path.hashCode();
    }

    public boolean equals(Object what) {
        if (what instanceof RequestTrans) {
            if (this.session == null || this.path == null) {
                return super.equals(what);
            }
            RequestTrans other = (RequestTrans)what;
            return this.session.equals(other.session) && this.path.equalsIgnoreCase(other.path) && ((Object)this.values).equals(other.values) && this.ifModifiedSince == other.ifModifiedSince && ((Object)this.etags).equals(other.etags);
        }
        return false;
    }

    public synchronized String getMethod() {
        return this.method;
    }

    public synchronized void setMethod(String method) {
        this.method = method;
    }

    public boolean isGet() {
        return GET.equalsIgnoreCase(this.method);
    }

    public boolean isPost() {
        return POST.equalsIgnoreCase(this.method);
    }

    public String getSession() {
        return this.session;
    }

    public void setSession(String session) {
        this.session = session;
    }

    public String getPath() {
        return this.path;
    }

    public String getAction() {
        return this.action;
    }

    public void setAction(String action) {
        this.action = action.substring(0, action.lastIndexOf("_action"));
    }

    public long getStartTime() {
        return this.startTime;
    }

    public void setIfModifiedSince(long since) {
        this.ifModifiedSince = since;
    }

    public long getIfModifiedSince() {
        return this.ifModifiedSince;
    }

    public void setETags(String etagHeader) {
        if (etagHeader.indexOf(",") > -1) {
            StringTokenizer st = new StringTokenizer(etagHeader, ", \r\n");
            while (st.hasMoreTokens()) {
                this.etags.add(st.nextToken());
            }
        } else {
            this.etags.add(etagHeader);
        }
    }

    public Set getETags() {
        return this.etags;
    }

    public boolean hasETag(String etag) {
        if (this.etags == null || etag == null) {
            return false;
        }
        return this.etags.contains(etag);
    }

    public String getUsername() {
        if (this.httpUsername != null) {
            return this.httpUsername;
        }
        String auth = (String)this.get("authorization");
        if (auth == null || "".equals(auth)) {
            return null;
        }
        this.decodeHttpAuth(auth);
        return this.httpUsername;
    }

    public String getPassword() {
        if (this.httpPassword != null) {
            return this.httpPassword;
        }
        String auth = (String)this.get("authorization");
        if (auth == null || "".equals(auth)) {
            return null;
        }
        this.decodeHttpAuth(auth);
        return this.httpPassword;
    }

    private void decodeHttpAuth(String auth) {
        if (auth == null) {
            return;
        }
        StringTokenizer tok = auth.startsWith("Basic ") ? new StringTokenizer(new String(Base64.decode(auth.substring(6).toCharArray())), ":") : new StringTokenizer(new String(Base64.decode(auth.toCharArray())), ":");
        try {
            this.httpUsername = tok.nextToken();
        }
        catch (NoSuchElementException e) {
            this.httpUsername = null;
        }
        try {
            this.httpPassword = tok.nextToken();
        }
        catch (NoSuchElementException e) {
            this.httpPassword = null;
        }
    }

    class ParamComboMap
    extends SystemMap {
        ParamComboMap() {
        }

        public Object get(Object key) {
            Object value;
            if (RequestTrans.this.postParams != null && (value = RequestTrans.this.postParams.get(key)) != null) {
                return value;
            }
            if (RequestTrans.this.queryParams != null && (value = RequestTrans.this.queryParams.get(key)) != null) {
                return value;
            }
            return null;
        }

        public boolean containsKey(Object key) {
            return this.get(key) != null;
        }

        public Set entrySet() {
            HashSet entries = new HashSet();
            if (RequestTrans.this.postParams != null) {
                entries.addAll(RequestTrans.this.postParams.entrySet());
            }
            if (RequestTrans.this.queryParams != null) {
                entries.addAll(RequestTrans.this.queryParams.entrySet());
            }
            return entries;
        }

        public Set keySet() {
            HashSet keys = new HashSet();
            if (RequestTrans.this.postParams != null) {
                keys.addAll(RequestTrans.this.postParams.keySet());
            }
            if (RequestTrans.this.queryParams != null) {
                keys.addAll(RequestTrans.this.queryParams.keySet());
            }
            return keys;
        }
    }

    class DataComboMap
    extends SystemMap {
        DataComboMap() {
        }

        public Object get(Object key) {
            Object value = super.get(key);
            if (value != null) {
                return value;
            }
            if (RequestTrans.this.postParams != null && (value = RequestTrans.this.postParams.get(key)) != null) {
                return value;
            }
            if (RequestTrans.this.queryParams != null && (value = RequestTrans.this.queryParams.get(key)) != null) {
                return value;
            }
            if (RequestTrans.this.cookies != null && (value = RequestTrans.this.cookies.get(key)) != null) {
                return value;
            }
            return null;
        }

        public boolean containsKey(Object key) {
            return this.get(key) != null;
        }

        public Set entrySet() {
            HashSet entries = new HashSet(super.entrySet());
            if (RequestTrans.this.postParams != null) {
                entries.addAll(RequestTrans.this.postParams.entrySet());
            }
            if (RequestTrans.this.queryParams != null) {
                entries.addAll(RequestTrans.this.queryParams.entrySet());
            }
            if (RequestTrans.this.cookies != null) {
                entries.addAll(RequestTrans.this.cookies.entrySet());
            }
            return entries;
        }

        public Set keySet() {
            HashSet keys = new HashSet(super.keySet());
            if (RequestTrans.this.postParams != null) {
                keys.addAll(RequestTrans.this.postParams.keySet());
            }
            if (RequestTrans.this.queryParams != null) {
                keys.addAll(RequestTrans.this.queryParams.keySet());
            }
            if (RequestTrans.this.cookies != null) {
                keys.addAll(RequestTrans.this.cookies.keySet());
            }
            return keys;
        }
    }

    class ParameterMap
    extends SystemMap {
        public ParameterMap() {
        }

        public ParameterMap(Map map) {
            super((int)((float)map.size() / 0.75f) + 1);
            Iterator i = map.entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry e = i.next();
                this.put(e.getKey(), e.getValue());
            }
        }

        public Object put(Object key, Object value) {
            String name;
            int bracket;
            if (key instanceof String && (bracket = (name = (String)key).indexOf(91)) > -1 && name.endsWith("]")) {
                Matcher matcher = paramPattern.matcher(name);
                String partName = name.substring(0, bracket);
                return this.putInternal(partName, matcher, value);
            }
            Object previous = super.get(key);
            if (!(previous == null || previous instanceof Object[] && value instanceof Object[])) {
                throw new RuntimeException("Conflicting HTTP Parameters for '" + key + "'");
            }
            return super.put(key, value);
        }

        private Object putInternal(String name, Matcher matcher, Object value) {
            Object previous = super.get(name);
            if (matcher.find()) {
                ParameterMap map = null;
                if (previous instanceof ParameterMap) {
                    map = (ParameterMap)previous;
                } else if (previous == null) {
                    map = new ParameterMap();
                    super.put(name, map);
                } else {
                    throw new RuntimeException("Conflicting HTTP Parameters for '" + name + "'");
                }
                String partName = matcher.group(1);
                return map.putInternal(partName, matcher, value);
            }
            if (!(previous == null || previous instanceof Object[] && value instanceof Object[])) {
                throw new RuntimeException("Conflicting HTTP Parameters for '" + name + "'");
            }
            return super.put(name, value);
        }

        public Object get(Object key) {
            if (key instanceof String) {
                Object value = super.get(key);
                String name = (String)key;
                if (name.endsWith("_array") && value == null) {
                    value = super.get(name.substring(0, name.length() - 6));
                    return value instanceof Object[] ? value : null;
                }
                if (name.endsWith("_cookie") && value == null) {
                    System.err.println(" *** *** *** " + name.substring(0, name.length() - 7));
                    value = super.get(name.substring(0, name.length() - 7));
                    return value instanceof Cookie ? value : null;
                }
                if (value instanceof Object[]) {
                    Object[] values = (Object[])value;
                    return values.length > 0 ? values[0] : null;
                }
                if (value instanceof Cookie) {
                    Cookie cookie = (Cookie)value;
                    return cookie.getValue();
                }
            }
            return super.get(key);
        }
    }
}

