/*
 * Decompiled with CFR 0.152.
 */
package helma.framework;

import java.io.Serializable;
import javax.servlet.http.Cookie;

public final class CookieTrans
implements Serializable {
    String name;
    String value;
    String path;
    String domain;
    int days = -1;

    CookieTrans(String name, String value) {
        this.name = name;
        this.value = value;
    }

    void setValue(String value) {
        this.value = value;
    }

    void setDays(int days) {
        this.days = days;
    }

    void setPath(String path) {
        this.path = path;
    }

    void setDomain(String domain) {
        this.domain = domain;
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return this.value;
    }

    public int getDays() {
        return this.days;
    }

    public String getPath() {
        return this.path;
    }

    public String getDomain() {
        return this.domain;
    }

    public Cookie getCookie(String defaultPath, String defaultDomain) {
        Cookie c = new Cookie(this.name, this.value);
        if (this.days > -1) {
            c.setMaxAge(this.days * 60 * 60 * 24);
        }
        if (this.path != null) {
            c.setPath(this.path);
        } else if (defaultPath != null) {
            c.setPath(defaultPath);
        }
        if (this.domain != null) {
            c.setDomain(this.domain);
        } else if (defaultDomain != null) {
            c.setDomain(defaultDomain);
        }
        return c;
    }
}

