/*
 * Decompiled with CFR 0.152.
 */
package helma.doc;

import java.awt.Point;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;

public final class Util {
    public static String chopDelimiters(String line) {
        if ((line = line.trim()) == null) {
            return null;
        }
        if (line.endsWith("*/")) {
            line = line.substring(0, line.length() - 2);
        }
        if (line.startsWith("/**")) {
            line = line.substring(3).trim();
        } else if (line.startsWith("/*")) {
            line = line.substring(2).trim();
        } else if (line.startsWith("*")) {
            line = line.substring(1).trim();
        } else if (line.startsWith("//")) {
            line = line.substring(2).trim();
        }
        return line;
    }

    public static String chopComment(String comment) {
        int idx = comment.indexOf("*/");
        if (idx > 0) {
            return comment.substring(0, idx + 2);
        }
        return comment;
    }

    public static String extractString(String[] lines, Point start, Point end) {
        StringBuffer buf = new StringBuffer();
        int to = Math.min(end.y + 1, lines.length);
        for (int i = start.y; i < to; ++i) {
            int from;
            int n = from = i == start.y ? start.x : 0;
            if (from < 0 || from > lines[i].length()) {
                System.err.println("Start index " + from + " out of range [0.." + lines[i].length() + "]");
                from = 0;
            }
            if (i == end.y && end.x < lines[i].length()) {
                buf.append(lines[i].substring(from, end.x));
            } else {
                buf.append(lines[i].substring(from));
            }
            buf.append("\n");
        }
        return buf.toString().trim();
    }

    public static String extractString(String[] lines, int start, int end) {
        StringBuffer buf = new StringBuffer();
        int to = Math.min(end + 1, lines.length);
        for (int i = start; i < to; ++i) {
            buf.append(lines[i]);
            buf.append("\n");
        }
        return buf.toString().trim();
    }

    public static void debugLineFromFile(File sourceFile, Point p, String debugStr) {
        try {
            BufferedReader in = new BufferedReader(new FileReader(sourceFile));
            String line = "";
            int ct = 0;
            while (line != null) {
                line = in.readLine();
                if (line == null) {
                    System.out.println("eof reached");
                    break;
                }
                if (ct == p.y) {
                    System.out.println(debugStr + ": " + line);
                    for (int i = 0; i < debugStr.length() + 1 + p.x; ++i) {
                        System.out.print(" ");
                    }
                    System.out.println("^");
                    break;
                }
                ++ct;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println(e.getMessage());
        }
    }
}

