/*
 * Decompiled with CFR 0.152.
 */
package helma.doc;

import helma.doc.DocException;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;

public final class DocTag {
    private String type;
    private String name;
    private String text;

    private DocTag(String type, String name, String text) {
        this.type = type;
        this.name = name != null ? name.trim() : "";
        this.text = text != null ? text.trim() : "";
    }

    public static DocTag parse(String rawTag) throws DocException {
        StringTokenizer tok = new StringTokenizer(rawTag.trim());
        String name = "";
        String type = "";
        StringBuffer comment = new StringBuffer();
        try {
            type = DocTag.matchTagName(tok.nextToken().substring(1));
        }
        catch (NoSuchElementException nsee) {
            throw new DocException("invalid tag: " + rawTag);
        }
        try {
            if (DocTag.isTagWithName(type)) {
                name = tok.nextToken();
            }
            while (tok.hasMoreTokens()) {
                comment.append(" ").append(tok.nextToken());
            }
        }
        catch (NoSuchElementException nsee) {
            // empty catch block
        }
        return new DocTag(type, name, comment.toString());
    }

    public static boolean isTagStart(String rawTag) {
        return rawTag.trim().startsWith("@");
    }

    public static String matchTagName(String tagName) {
        if ("returns".equals(tagName)) {
            return "return";
        }
        if ("arg".equals(tagName)) {
            return "param";
        }
        return tagName;
    }

    public static boolean isTagWithName(String tagName) {
        return "param".equals(tagName);
    }

    public String getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public String getText() {
        return this.text;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer("[@" + this.type);
        if (this.name != null && !"".equals(this.name)) {
            buf.append(" ").append(this.name);
        }
        if (this.text != null && !"".equals(this.text)) {
            buf.append(" ").append(this.text);
        }
        return buf.toString() + "]";
    }
}

