/*
 * Decompiled with CFR 0.152.
 */
package helma.doc;

import helma.doc.DocElement;
import helma.doc.DocResourceElement;
import helma.framework.repository.Resource;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;

public class DocSkin
extends DocResourceElement {
    protected DocSkin(String name, Resource res, DocElement parent) throws IOException {
        super(name, res, 6);
        this.parent = parent;
        this.content = res.getContent();
        this.parseHandlers();
    }

    public static DocSkin newInstance(Resource res) throws IOException {
        return DocSkin.newInstance(res, null);
    }

    public static DocSkin newInstance(Resource res, DocElement parent) throws IOException {
        String skinname = res.getBaseName();
        return new DocSkin(skinname, res, parent);
    }

    private void parseHandlers() {
        ArrayList<String> partBuffer = new ArrayList<String>();
        char[] source = this.content.toCharArray();
        int sourceLength = source.length;
        for (int i = 0; i < sourceLength - 1; ++i) {
            int j;
            if (source[i] != '<' || source[i + 1] != '%') continue;
            for (j = i + 2; j < sourceLength - 1 && (source[j] != '%' || source[j + 1] != '>'); ++j) {
            }
            if (j > i + 2) {
                String str = new String(source, i + 2, j - i).trim();
                if (str.endsWith("%>")) {
                    str = str.substring(0, str.length() - 2);
                }
                if (str.startsWith("//")) {
                    this.parseComment(str);
                } else {
                    if (str.indexOf(" ") > -1) {
                        str = str.substring(0, str.indexOf(" "));
                    }
                    if (str.indexOf(".") > -1 && (str.startsWith("param.") || str.startsWith("response.") || str.startsWith("request.") || str.startsWith("session.")) && !partBuffer.contains(str)) {
                        partBuffer.add(str);
                    }
                }
            }
            i = j + 1;
        }
        Object[] strArr = partBuffer.toArray(new String[0]);
        Arrays.sort(strArr);
        for (int i = 0; i < strArr.length; ++i) {
            this.addParameter((String)strArr[i]);
        }
    }

    public String getPrototype() {
        return "docfunction";
    }
}

