/*
 * Decompiled with CFR 0.152.
 */
package helma.doc;

import helma.doc.DocElement;
import helma.framework.repository.Repository;
import helma.framework.repository.Resource;
import java.io.IOException;

public abstract class DocRepositoryElement
extends DocElement {
    protected Repository repos;
    public static final String[] DOCFILES = new String[]{"doc.html", "doc.htm", "app.html", "app.htm", "prototype.html", "prototype.htm", "index.html", "index.htm"};

    protected DocRepositoryElement(String name, Repository repos, int type) throws IOException {
        super(name, type);
        this.repos = repos;
        this.checkCommentFiles();
    }

    public String toString() {
        return this.repos.getName();
    }

    public Repository getRepository() {
        return this.repos;
    }

    private void checkCommentFiles() throws IOException {
        if (this.repos == null) {
            return;
        }
        for (int i = 0; i < DOCFILES.length; ++i) {
            Resource res = this.repos.getResource(DOCFILES[i]);
            if (!res.exists()) continue;
            String rawComment = res.getContent();
            this.parseComment(rawComment);
            return;
        }
    }
}

