/*
 * Decompiled with CFR 0.152.
 */
package helma.doc;

import helma.doc.DocElement;
import helma.doc.DocFunction;
import helma.doc.DocProperties;
import helma.doc.DocSkin;
import helma.framework.core.Prototype;
import helma.framework.repository.Resource;
import helma.util.ResourceProperties;
import java.io.IOException;
import java.util.Iterator;

public class DocPrototype
extends DocElement {
    DocPrototype parentPrototype = null;
    Prototype proto;

    protected DocPrototype(Prototype proto, DocElement parent) {
        super(proto.getName(), 1);
        this.parent = parent;
        this.proto = proto;
    }

    public void checkInheritance() {
        if (this.name.equals("hopobject")) {
            return;
        }
        String ext = this.proto.getTypeProperties().getProperty("_extends");
        if (ext != null && this.parent != null) {
            this.parentPrototype = (DocPrototype)this.parent.getChildElement("prototype_" + ext);
        }
        if (this.parentPrototype == null && this.parent != null && !this.name.equals("global")) {
            this.parentPrototype = (DocPrototype)this.parent.getChildElement("prototype_hopobject");
        }
    }

    public DocPrototype getParentPrototype() {
        return this.parentPrototype;
    }

    public void readFiles() throws IOException {
        String name;
        Resource res;
        this.children.clear();
        Iterator it = this.proto.getCodeResources();
        while (it.hasNext()) {
            res = (Resource)it.next();
            name = res.getShortName();
            if (this.getDocApplication().isExcluded(name)) continue;
            try {
                if (name.endsWith(".hac")) {
                    this.addChild(DocFunction.newAction(res, this));
                    continue;
                }
                if (!name.endsWith(".js")) continue;
                DocFunction[] elements = DocFunction.newFunctions(res, this);
                for (int j = 0; j < elements.length; ++j) {
                    this.addChild(elements[j]);
                }
            }
            catch (Throwable err) {
                this.proto.getApplication().logError("Couldn't parse file " + res, err);
            }
        }
        it = this.proto.getSkinResources();
        while (it.hasNext()) {
            res = (Resource)it.next();
            name = res.getShortName();
            if (this.getDocApplication().isExcluded(name)) continue;
            this.addChild(DocSkin.newInstance(res, this));
        }
        ResourceProperties props = this.proto.getTypeProperties();
        it = props.getResources();
        int index = 0;
        while (it.hasNext()) {
            Resource res2 = (Resource)it.next();
            if (!res2.exists()) continue;
            this.addChild(new DocProperties(res2, props, index++, this));
        }
    }
}

